/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import com.google.common.collect.BiMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.octagon.OctElement;
import org.sosy_lab.cpachecker.util.octagon.Octagon;
import org.sosy_lab.cpachecker.util.octagon.OctagonManager;

class OctDomain
implements AbstractDomain {
    static long totaltime = 0L;

    OctDomain() {
    }

    @Override
    public boolean isLessOrEqual(AbstractElement element1, AbstractElement element2) {
        HashMap covers = new HashMap();
        long start = System.currentTimeMillis();
        OctElement octElement1 = (OctElement)element1;
        OctElement octElement2 = (OctElement)element2;
        if (covers.containsKey(octElement2) && ((HashSet)covers.get(octElement2)).contains(octElement1)) {
            return true;
        }
        int result = OctagonManager.isIncludedInLazy(octElement1.getOctagon(), octElement2.getOctagon());
        if (result == 1) {
            totaltime += System.currentTimeMillis() - start;
            return true;
        }
        if (result == 2) {
            totaltime += System.currentTimeMillis() - start;
            return false;
        }
        assert (result == 3);
        boolean included = OctagonManager.isIncludedIn(octElement1.getOctagon(), octElement2.getOctagon());
        if (included) {
            Set s = covers.containsKey(octElement2) ? (Set)covers.get(octElement2) : new HashSet();
            s.add(octElement1);
            covers.put(octElement2, s);
        }
        totaltime += System.currentTimeMillis() - start;
        return included;
    }

    @Override
    public AbstractElement join(AbstractElement element1, AbstractElement element2) {
        OctElement octEl1 = (OctElement)element1;
        OctElement octEl2 = (OctElement)element2;
        Octagon newOctagon = OctagonManager.union(octEl1.getOctagon(), octEl2.getOctagon());
        BiMap<String, Integer> newMap = octEl1.sizeOfVariables() > octEl2.sizeOfVariables() ? octEl1.getVariableToIndexMap() : octEl2.getVariableToIndexMap();
        return new OctElement(newOctagon, newMap, null);
    }
}

