/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.util.octagon.NumArray;
import org.sosy_lab.cpachecker.util.octagon.Octagon;
import org.sosy_lab.cpachecker.util.octagon.OctagonManager;

class OctElement
implements AbstractElement {
    private Octagon octagon;
    private BiMap<String, Integer> variableToIndexMap;
    private OctElement previousElement;

    public OctElement() {
        this.octagon = OctagonManager.universe(0);
        this.variableToIndexMap = HashBiMap.create();
        this.previousElement = null;
    }

    public OctElement(Octagon oct, BiMap<String, Integer> map, OctElement previousElement) {
        this.octagon = oct;
        this.variableToIndexMap = map;
        this.previousElement = previousElement;
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof OctElement)) {
            return false;
        }
        OctElement otherOct = (OctElement)pObj;
        return this.octagon.equals(otherOct.octagon);
    }

    public int hashCode() {
        return this.octagon.hashCode();
    }

    public void printOctagon() {
        OctagonManager.print(this.octagon);
    }

    public String toString() {
        return this.variableToIndexMap + " [octagon]: " + this.octagon;
    }

    public Octagon getOctagon() {
        return this.octagon;
    }

    public int sizeOfVariables() {
        return this.variableToIndexMap.size();
    }

    public OctElement getPreviousElement() {
        return this.previousElement;
    }

    public void setPreviousElement(OctElement pPreviousElement) {
        this.previousElement = pPreviousElement;
    }

    public BiMap<String, Integer> getVariableToIndexMap() {
        return this.variableToIndexMap;
    }

    public void addVariable(String pVarName, boolean pIsGlobal, String pFunctionName) {
        if (this.sizeOfVariables() == 0) {
            // empty if block
        }
    }

    protected OctElement clone() {
        Octagon newOct = OctagonManager.full_copy(this.octagon);
        HashBiMap newMap = HashBiMap.create();
        for (Map.Entry e : this.variableToIndexMap.entrySet()) {
            newMap.put(e.getKey(), e.getValue());
        }
        return new OctElement(newOct, (BiMap<String, Integer>)newMap, this.previousElement);
    }

    public boolean addVar(String pVarName, String pFunctionName, boolean pIsGlobal) {
        String varName;
        String string = varName = pIsGlobal ? pVarName : pFunctionName + "::" + pVarName;
        if (!this.variableToIndexMap.containsKey((Object)pVarName)) {
            int sizeOfMap = this.variableToIndexMap.size();
            this.variableToIndexMap.put((Object)varName, (Object)sizeOfMap);
        }
        return false;
    }

    public void forget(String pVariableName) {
        OctagonManager.forget(this.octagon, this.getVariableIndexFor(pVariableName));
    }

    public void assignConstant(String pVariableName, long pLongValue) {
        if (pVariableName.contains("NONDET") || pVariableName.contains("NONDET")) {
            this.forget(pVariableName);
        } else {
            NumArray arr = this.getArrayForLiteral(pLongValue);
            this.octagon = OctagonManager.assingVar(this.octagon, this.getVariableIndexFor(pVariableName), arr);
            OctagonManager.num_clear_n(arr, this.size() + 1);
        }
    }

    protected int getVariableIndexFor(String pVariableName) {
        return (Integer)this.variableToIndexMap.get((Object)pVariableName);
    }

    public void declareVariable(String pVariableName) {
        assert (!this.variableToIndexMap.containsKey((Object)pVariableName));
        this.variableToIndexMap.put((Object)pVariableName, (Object)this.size());
        this.octagon = OctagonManager.addDimensionAndEmbed(this.octagon, 1);
    }

    private NumArray getArrayForLiteral(long pLongValue) {
        NumArray arr = OctagonManager.init_num_t(this.size() + 1);
        for (int i = 0; i < this.variableToIndexMap.size(); ++i) {
            OctagonManager.num_set_int(arr, i, 0);
        }
        OctagonManager.num_set_int(arr, this.size(), (int)pLongValue);
        return arr;
    }

    public int size() {
        return this.variableToIndexMap.size();
    }

    public void addConstraint(int pType, int pLVarIdx, int pRVarIdx, int pConstant) {
        NumArray arr = OctagonManager.init_num_t(4);
        OctagonManager.num_set_int(arr, 0, pType);
        OctagonManager.num_set_int(arr, 1, pLVarIdx);
        OctagonManager.num_set_int(arr, 2, pRVarIdx);
        OctagonManager.num_set_int(arr, 3, pConstant);
        this.octagon = OctagonManager.addBinConstraint(this.octagon, 1, arr);
        OctagonManager.num_clear_n(arr, 4);
    }

    public void assignVariable(String pLeftVarName, String pRightVarName, int coef) {
        if (pLeftVarName.contains("NONDET") || pRightVarName.contains("NONDET")) {
            this.forget(pLeftVarName);
        } else {
            NumArray arr = this.getArrayForVariable(this.getVariableIndexFor(pRightVarName), coef);
            this.octagon = OctagonManager.assingVar(this.octagon, this.getVariableIndexFor(pLeftVarName), arr);
            OctagonManager.num_clear_n(arr, this.size() + 1);
        }
    }

    private NumArray getArrayForVariable(int pVariableIndexFor, int coef) {
        NumArray arr = OctagonManager.init_num_t(this.size() + 1);
        for (int i = 0; i < this.variableToIndexMap.size(); ++i) {
            if (i == pVariableIndexFor) {
                OctagonManager.num_set_int(arr, i, coef);
                continue;
            }
            OctagonManager.num_set_int(arr, i, 0);
        }
        OctagonManager.num_set_int(arr, this.size(), 0);
        return arr;
    }

    public void assignmentOfBinaryExp(String pAssignedVar, String pLeftVarName, int pLeftVarCoef, String pRightVarName, int pRightVarCoef, int pConstVal) {
        if (pAssignedVar.contains("NONDET") || pLeftVarName != null && pLeftVarName.contains("NONDET") || pRightVarName != null && pRightVarName.contains("NONDET")) {
            this.forget(pAssignedVar);
        } else {
            int rightVarCoef;
            int rightVarIdx;
            int leftVarCoef;
            int leftVarIdx;
            if (pLeftVarName == null) {
                leftVarIdx = -1;
                leftVarCoef = 0;
            } else {
                leftVarIdx = this.getVariableIndexFor(pLeftVarName);
                leftVarCoef = pLeftVarCoef;
            }
            if (pRightVarName == null) {
                rightVarIdx = -1;
                rightVarCoef = 0;
            } else {
                rightVarIdx = this.getVariableIndexFor(pRightVarName);
                rightVarCoef = pRightVarCoef;
            }
            int idxForAssignedVar = this.getVariableIndexFor(pAssignedVar);
            NumArray arr = this.getArrayForVariableAndConstant(leftVarIdx, leftVarCoef, rightVarIdx, rightVarCoef, pConstVal);
            this.octagon = OctagonManager.assingVar(this.octagon, idxForAssignedVar, arr);
            OctagonManager.num_clear_n(arr, this.size() + 1);
        }
    }

    private NumArray getArrayForVariableAndConstant(int pLeftVarIdx, int pLeftVarCoef, int pRightVarIdx, int pRightVarCoef, int pConstVal) {
        NumArray arr = OctagonManager.init_num_t(this.size() + 1);
        for (int i = 0; i < this.variableToIndexMap.size(); ++i) {
            if (i == pLeftVarIdx) {
                OctagonManager.num_set_int(arr, i, pLeftVarCoef);
                continue;
            }
            if (i == pRightVarIdx) {
                OctagonManager.num_set_int(arr, i, pRightVarCoef);
                continue;
            }
            OctagonManager.num_set_int(arr, i, 0);
        }
        OctagonManager.num_set_int(arr, this.size(), pConstVal);
        return arr;
    }

    public boolean isEmpty() {
        return OctagonManager.isEmpty(this.octagon);
    }

    public void removeLocalVariables(OctElement pPreviousElem, int noOfGlobalVars) {
        int noOfLocalVars = this.size() - pPreviousElem.size();
        for (int i = this.size(); i > pPreviousElem.size(); --i) {
            String s = (String)this.variableToIndexMap.inverse().get((Object)(i - 1));
            this.variableToIndexMap.remove((Object)s);
        }
        this.octagon = OctagonManager.removeDimension(this.octagon, noOfLocalVars);
        assert (OctagonManager.dimension(this.octagon) == this.size());
    }
}

