/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializer;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTPointerTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageElement;
import org.sosy_lab.cpachecker.cpa.octagon.OctElement;
import org.sosy_lab.cpachecker.cpa.pointer.PointerElement;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

class OctTransferRelation
implements TransferRelation {
    private List<String> globalVars = new ArrayList<String>();

    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement element, Precision prec, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        OctElement octElement = null;
        OctElement prevElement = (OctElement)element;
        octElement = ((OctElement)element).clone();
        assert (octElement != null);
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                StatementEdge statementEdge = (StatementEdge)cfaEdge;
                IASTStatement expression = statementEdge.getStatement();
                octElement = this.handleStatement(octElement, expression, cfaEdge);
                break;
            }
            case ReturnStatementEdge: {
                ReturnStatementEdge statementEdge = (ReturnStatementEdge)cfaEdge;
                octElement = this.handleExitFromFunction(octElement, statementEdge.getExpression(), statementEdge);
                break;
            }
            case DeclarationEdge: {
                DeclarationEdge declarationEdge = (DeclarationEdge)cfaEdge;
                octElement = this.handleDeclaration(octElement, declarationEdge);
                break;
            }
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)cfaEdge;
                IASTExpression expression = assumeEdge.getExpression();
                octElement = (OctElement)this.handleAssumption(octElement, expression, cfaEdge, assumeEdge.getTruthAssumption());
                break;
            }
            case BlankEdge: {
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)cfaEdge;
                octElement = this.handleFunctionCall(octElement, prevElement, functionCallEdge, cfaEdge);
                break;
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge functionReturnEdge = (FunctionReturnEdge)cfaEdge;
                octElement = this.handleFunctionReturn(octElement, functionReturnEdge);
                break;
            }
            case CallToReturnEdge: {
                assert (false);
                break;
            }
        }
        if (octElement == null || octElement.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(octElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OctElement handleFunctionReturn(OctElement element, FunctionReturnEdge functionReturnEdge) throws UnrecognizedCCodeException {
        CallToReturnEdge summaryEdge = functionReturnEdge.getSuccessor().getEnteringSummaryEdge();
        IASTFunctionCall exprOnSummary = summaryEdge.getExpression();
        OctElement previousElem = element.getPreviousElement();
        String callerFunctionName = functionReturnEdge.getSuccessor().getFunctionName();
        String calledFunctionName = functionReturnEdge.getPredecessor().getFunctionName();
        if (exprOnSummary instanceof IASTFunctionCallAssignmentStatement) {
            IASTFunctionCallAssignmentStatement binExp = (IASTFunctionCallAssignmentStatement)exprOnSummary;
            IASTExpression op1 = binExp.getLeftHandSide();
            if (!(op1 instanceof IASTIdExpression) && !(op1 instanceof IASTFieldReference)) throw new UnrecognizedCCodeException("on function return", summaryEdge, op1);
            String varName = op1.toASTString();
            String returnVarName = calledFunctionName + "::" + "___cpa_temp_result_var_";
            String assignedVarName = this.getvarName(varName, callerFunctionName);
            this.assignVariable(element, assignedVarName, returnVarName, 1);
        } else if (!(exprOnSummary instanceof IASTFunctionCallStatement)) {
            throw new UnrecognizedCCodeException("on function return", summaryEdge, exprOnSummary.asStatement());
        }
        element.removeLocalVariables(previousElem, this.globalVars.size());
        return element;
    }

    private OctElement handleExitFromFunction(OctElement element, IASTExpression expression, ReturnStatementEdge returnEdge) throws UnrecognizedCCodeException {
        String tempVarName = this.getvarName("___cpa_temp_result_var_", returnEdge.getSuccessor().getFunctionName());
        element.declareVariable(tempVarName);
        return this.handleAssignmentToVariable(element, "___cpa_temp_result_var_", expression, returnEdge);
    }

    private OctElement handleFunctionCall(OctElement octagonElement, OctElement pPrevElement, FunctionCallEdge callEdge, CFAEdge edge) throws UnrecognizedCCodeException {
        octagonElement.setPreviousElement(pPrevElement);
        FunctionDefinitionNode functionEntryNode = callEdge.getSuccessor();
        String calledFunctionName = functionEntryNode.getFunctionName();
        String callerFunctionName = callEdge.getPredecessor().getFunctionName();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        List<IASTExpression> arguments = callEdge.getArguments();
        assert (paramNames.size() == arguments.size());
        for (int i = 0; i < arguments.size(); ++i) {
            IASTExpression arg = arguments.get(i);
            if (arg instanceof IASTCastExpression) {
                arg = ((IASTCastExpression)arg).getOperand();
            }
            String nameOfParam = paramNames.get(i);
            String formalParamName = this.getvarName(nameOfParam, calledFunctionName);
            this.declareVariable(octagonElement, formalParamName);
            if (arg instanceof IASTIdExpression) {
                IASTIdExpression idExp = (IASTIdExpression)arg;
                String nameOfArg = idExp.getName();
                String actualParamName = this.getvarName(nameOfArg, callerFunctionName);
                this.assignVariable(octagonElement, formalParamName, actualParamName, 1);
                continue;
            }
            if (arg instanceof IASTLiteralExpression) {
                Long val = this.parseLiteral((IASTLiteralExpression)arg, edge);
                if (val == null) continue;
                octagonElement.assignConstant(formalParamName, val);
                continue;
            }
            if (arg instanceof IASTTypeIdExpression) continue;
            if (arg instanceof IASTUnaryExpression) {
                IASTUnaryExpression unaryExp = (IASTUnaryExpression)arg;
                assert (unaryExp.getOperator() == IASTUnaryExpression.UnaryOperator.STAR || unaryExp.getOperator() == IASTUnaryExpression.UnaryOperator.AMPER);
                continue;
            }
            if (!(arg instanceof IASTFieldReference)) continue;
        }
        return octagonElement;
    }

    private AbstractElement handleAssumption(OctElement pElement, IASTExpression expression, CFAEdge cfaEdge, boolean truthValue) throws UnrecognizedCCodeException {
        String functionName = cfaEdge.getPredecessor().getFunctionName();
        if (expression instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)expression;
            IASTBinaryExpression.BinaryOperator opType = binExp.getOperator();
            IASTExpression op1 = binExp.getOperand1();
            IASTExpression op2 = binExp.getOperand2();
            return this.propagateBooleanExpression(pElement, opType, op1, op2, functionName, truthValue, cfaEdge);
        }
        if (expression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExp = (IASTUnaryExpression)expression;
            if (unaryExp.getOperator() == IASTUnaryExpression.UnaryOperator.NOT) {
                IASTExpression exp1 = unaryExp.getOperand();
                return this.handleAssumption(pElement, exp1, cfaEdge, !truthValue);
            }
            throw new UnrecognizedCCodeException("Unknown unary operator in assumption", cfaEdge, expression);
        }
        if (expression instanceof IASTIdExpression || expression instanceof IASTFieldReference) {
            return this.propagateBooleanExpression(pElement, null, expression, null, functionName, truthValue, cfaEdge);
        }
        if (expression instanceof IASTCastExpression) {
            return this.handleAssumption(pElement, ((IASTCastExpression)expression).getOperand(), cfaEdge, truthValue);
        }
        throw new UnrecognizedCCodeException("Unknown expression type in assumption", cfaEdge, expression);
    }

    private AbstractElement propagateBooleanExpression(OctElement pElement, IASTBinaryExpression.BinaryOperator opType, IASTExpression op1, IASTExpression op2, String functionName, boolean truthValue, CFAEdge edge) throws UnrecognizedCCodeException {
        if (op1 instanceof IASTIdExpression || op1 instanceof IASTFieldReference || op1 instanceof IASTArraySubscriptExpression) {
            if (op2 == null && opType == null) {
                String varName = op1.toASTString();
                if (truthValue) {
                    String variableName = this.getvarName(varName, functionName);
                    return this.addIneqConstraint(pElement, variableName, 0L);
                }
                String variableName = this.getvarName(varName, functionName);
                return this.addEqConstraint(pElement, variableName, 0L);
            }
            if (op2 instanceof IASTLiteralExpression) {
                IASTLiteralExpression literalExp = (IASTLiteralExpression)op2;
                String varName = op1.toASTString();
                String variableName = this.getvarName(varName, functionName);
                if (literalExp instanceof IASTIntegerLiteralExpression || literalExp instanceof IASTCharLiteralExpression) {
                    long valueOfLiteral = this.parseLiteral(literalExp, edge);
                    if (opType == IASTBinaryExpression.BinaryOperator.EQUALS) {
                        if (truthValue) {
                            return this.addEqConstraint(pElement, variableName, valueOfLiteral);
                        }
                        return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.NOT_EQUALS, op1, op2, functionName, !truthValue, edge);
                    }
                    if (opType == IASTBinaryExpression.BinaryOperator.NOT_EQUALS) {
                        if (truthValue) {
                            return this.addIneqConstraint(pElement, variableName, valueOfLiteral);
                        }
                        return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.EQUALS, op1, op2, functionName, !truthValue, edge);
                    }
                    if (opType == IASTBinaryExpression.BinaryOperator.GREATER_THAN) {
                        if (truthValue) {
                            return this.addGreaterConstraint(pElement, variableName, valueOfLiteral);
                        }
                        return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.LESS_EQUAL, op1, op2, functionName, !truthValue, edge);
                    }
                    if (opType == IASTBinaryExpression.BinaryOperator.GREATER_EQUAL) {
                        if (truthValue) {
                            return this.addGreaterEqConstraint(pElement, variableName, valueOfLiteral);
                        }
                        return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.LESS_THAN, op1, op2, functionName, !truthValue, edge);
                    }
                    if (opType == IASTBinaryExpression.BinaryOperator.LESS_THAN) {
                        if (truthValue) {
                            return this.addSmallerConstraint(pElement, variableName, valueOfLiteral);
                        }
                        return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.GREATER_EQUAL, op1, op2, functionName, !truthValue, edge);
                    }
                    if (opType == IASTBinaryExpression.BinaryOperator.LESS_EQUAL) {
                        if (truthValue) {
                            return this.addSmallerEqConstraint(pElement, variableName, valueOfLiteral);
                        }
                        return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.GREATER_THAN, op1, op2, functionName, !truthValue, edge);
                    }
                    if (opType == IASTBinaryExpression.BinaryOperator.MINUS) {
                        if (truthValue) {
                            return this.addIneqConstraint(pElement, variableName, valueOfLiteral);
                        }
                        return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.EQUALS, op1, op2, functionName, !truthValue, edge);
                    }
                    if (opType == IASTBinaryExpression.BinaryOperator.PLUS) {
                        valueOfLiteral = this.parseLiteralWithOppositeSign(literalExp, edge);
                        if (truthValue) {
                            return this.addIneqConstraint(pElement, variableName, valueOfLiteral);
                        }
                        valueOfLiteral = this.parseLiteralWithOppositeSign(literalExp, edge);
                        return this.addEqConstraint(pElement, variableName, valueOfLiteral);
                    }
                    if (opType == IASTBinaryExpression.BinaryOperator.BINARY_AND || opType == IASTBinaryExpression.BinaryOperator.BINARY_OR || opType == IASTBinaryExpression.BinaryOperator.BINARY_XOR) {
                        return pElement;
                    }
                    throw new UnrecognizedCCodeException("Unhandled case ", edge);
                }
                throw new UnrecognizedCCodeException("Unhandled case ", edge);
            }
            if (op2 instanceof IASTIdExpression || op2 instanceof IASTUnaryExpression && (((IASTUnaryExpression)op2).getOperator() == IASTUnaryExpression.UnaryOperator.AMPER || ((IASTUnaryExpression)op2).getOperator() == IASTUnaryExpression.UnaryOperator.STAR)) {
                String leftVarName = op1.toASTString();
                String rightVarName = op2.toASTString();
                String leftVariableName = this.getvarName(leftVarName, functionName);
                String rightVariableName = this.getvarName(rightVarName, functionName);
                if (opType == IASTBinaryExpression.BinaryOperator.EQUALS) {
                    if (truthValue) {
                        return this.addEqConstraint(pElement, rightVariableName, leftVariableName);
                    }
                    return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.NOT_EQUALS, op1, op2, functionName, !truthValue, edge);
                }
                if (opType == IASTBinaryExpression.BinaryOperator.NOT_EQUALS) {
                    if (truthValue) {
                        return this.addIneqConstraint(pElement, rightVariableName, leftVariableName);
                    }
                    return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.EQUALS, op1, op2, functionName, !truthValue, edge);
                }
                if (opType == IASTBinaryExpression.BinaryOperator.GREATER_THAN) {
                    if (truthValue) {
                        return this.addGreaterConstraint(pElement, rightVariableName, leftVariableName);
                    }
                    return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.LESS_EQUAL, op1, op2, functionName, !truthValue, edge);
                }
                if (opType == IASTBinaryExpression.BinaryOperator.GREATER_EQUAL) {
                    if (truthValue) {
                        return this.addGreaterEqConstraint(pElement, rightVariableName, leftVariableName);
                    }
                    return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.LESS_THAN, op1, op2, functionName, !truthValue, edge);
                }
                if (opType == IASTBinaryExpression.BinaryOperator.LESS_THAN) {
                    if (truthValue) {
                        return this.addSmallerConstraint(pElement, rightVariableName, leftVariableName);
                    }
                    return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.GREATER_EQUAL, op1, op2, functionName, !truthValue, edge);
                }
                if (opType == IASTBinaryExpression.BinaryOperator.LESS_EQUAL) {
                    if (truthValue) {
                        return this.addSmallerEqConstraint(pElement, rightVariableName, leftVariableName);
                    }
                    return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.GREATER_THAN, op1, op2, functionName, !truthValue, edge);
                }
                throw new UnrecognizedCCodeException("Unhandled case ", edge);
            }
            if (op2 instanceof IASTUnaryExpression) {
                String varName = op1.toASTString();
                IASTUnaryExpression unaryExp = (IASTUnaryExpression)op2;
                IASTExpression unaryExpOp = unaryExp.getOperand();
                IASTUnaryExpression.UnaryOperator operatorType = unaryExp.getOperator();
                if (operatorType == IASTUnaryExpression.UnaryOperator.MINUS) {
                    if (unaryExpOp instanceof IASTLiteralExpression) {
                        IASTLiteralExpression literalExp = (IASTLiteralExpression)unaryExpOp;
                        if (literalExp instanceof IASTIntegerLiteralExpression || literalExp instanceof IASTCharLiteralExpression) {
                            long valueOfLiteral = this.parseLiteralWithOppositeSign(literalExp, edge);
                            String variableName = this.getvarName(varName, functionName);
                            if (opType == IASTBinaryExpression.BinaryOperator.EQUALS) {
                                if (truthValue) {
                                    return this.addEqConstraint(pElement, variableName, valueOfLiteral);
                                }
                                return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.NOT_EQUALS, op1, op2, functionName, !truthValue, edge);
                            }
                            if (opType == IASTBinaryExpression.BinaryOperator.NOT_EQUALS) {
                                if (truthValue) {
                                    return this.addIneqConstraint(pElement, variableName, valueOfLiteral);
                                }
                                return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.EQUALS, op1, op2, functionName, !truthValue, edge);
                            }
                            if (opType == IASTBinaryExpression.BinaryOperator.GREATER_THAN) {
                                if (truthValue) {
                                    return this.addGreaterConstraint(pElement, variableName, valueOfLiteral);
                                }
                                return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.LESS_EQUAL, op1, op2, functionName, !truthValue, edge);
                            }
                            if (opType == IASTBinaryExpression.BinaryOperator.GREATER_EQUAL) {
                                if (truthValue) {
                                    return this.addGreaterEqConstraint(pElement, variableName, valueOfLiteral);
                                }
                                return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.LESS_THAN, op1, op2, functionName, !truthValue, edge);
                            }
                            if (opType == IASTBinaryExpression.BinaryOperator.LESS_THAN) {
                                if (truthValue) {
                                    return this.addSmallerConstraint(pElement, variableName, valueOfLiteral);
                                }
                                return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.GREATER_EQUAL, op1, op2, functionName, !truthValue, edge);
                            }
                            if (opType == IASTBinaryExpression.BinaryOperator.LESS_EQUAL) {
                                if (truthValue) {
                                    return this.addSmallerEqConstraint(pElement, variableName, valueOfLiteral);
                                }
                                return this.propagateBooleanExpression(pElement, IASTBinaryExpression.BinaryOperator.GREATER_THAN, op1, op2, functionName, !truthValue, edge);
                            }
                            throw new UnrecognizedCCodeException("Unhandled case ", edge);
                        }
                        throw new UnrecognizedCCodeException("Unhandled case ", edge);
                    }
                    throw new UnrecognizedCCodeException("Unhandled case ", edge);
                }
                throw new UnrecognizedCCodeException("Unhandled case ", edge);
            }
            if (op2 instanceof IASTBinaryExpression) {
                String varName = op1.toASTString();
                String variableName = this.getvarName(varName, functionName);
                return this.forgetElement(pElement, variableName);
            }
            if (op2 instanceof IASTCastExpression) {
                IASTCastExpression castExp = (IASTCastExpression)op2;
                IASTExpression exprInCastOp = castExp.getOperand();
                return this.propagateBooleanExpression(pElement, opType, op1, exprInCastOp, functionName, truthValue, edge);
            }
            String varName = op1.toASTString();
            String variableName = this.getvarName(varName, functionName);
            return this.forgetElement(pElement, variableName);
        }
        if (op1 instanceof IASTCastExpression) {
            IASTCastExpression castExp = (IASTCastExpression)op1;
            IASTExpression castOperand = castExp.getOperand();
            return this.propagateBooleanExpression(pElement, opType, castOperand, op2, functionName, truthValue, edge);
        }
        String varName = op1.toASTString();
        String variableName = this.getvarName(varName, functionName);
        return this.forgetElement(pElement, variableName);
    }

    private AbstractElement forgetElement(OctElement pElement, String pVariableName) {
        pElement.forget(pVariableName);
        return pElement;
    }

    private AbstractElement addSmallerEqConstraint(OctElement pElement, String pRightVariableName, String pLeftVariableName) {
        int rVarIdx = pElement.getVariableIndexFor(pRightVariableName);
        int lVarIdx = pElement.getVariableIndexFor(pLeftVariableName);
        pElement.addConstraint(3, lVarIdx, rVarIdx, 0);
        return pElement;
    }

    private AbstractElement addSmallerConstraint(OctElement pElement, String pRightVariableName, String pLeftVariableName) {
        int rVarIdx = pElement.getVariableIndexFor(pRightVariableName);
        int lVarIdx = pElement.getVariableIndexFor(pLeftVariableName);
        pElement.addConstraint(3, lVarIdx, rVarIdx, -1);
        return pElement;
    }

    private AbstractElement addGreaterEqConstraint(OctElement pElement, String pRightVariableName, String pLeftVariableName) {
        int rVarIdx = pElement.getVariableIndexFor(pRightVariableName);
        int lVarIdx = pElement.getVariableIndexFor(pLeftVariableName);
        pElement.addConstraint(4, lVarIdx, rVarIdx, 0);
        return pElement;
    }

    private AbstractElement addGreaterConstraint(OctElement pElement, String pRightVariableName, String pLeftVariableName) {
        int rVarIdx = pElement.getVariableIndexFor(pRightVariableName);
        int lVarIdx = pElement.getVariableIndexFor(pLeftVariableName);
        pElement.addConstraint(4, lVarIdx, rVarIdx, -1);
        return pElement;
    }

    private AbstractElement addIneqConstraint(OctElement pElement, String pRightVariableName, String pLeftVariableName) {
        OctElement newElem1 = null;
        newElem1 = pElement.clone();
        this.addEqConstraint(newElem1, pLeftVariableName, pRightVariableName);
        if (!newElem1.isEmpty()) {
            return null;
        }
        return pElement;
    }

    private AbstractElement addEqConstraint(OctElement pElement, String pRightVariableName, String pLeftVariableName) {
        OctElement newElem1 = null;
        newElem1 = pElement.clone();
        this.addSmallerEqConstraint(pElement, pRightVariableName, pLeftVariableName);
        this.addGreaterEqConstraint(pElement, pRightVariableName, pLeftVariableName);
        if (newElem1.isEmpty()) {
            return null;
        }
        return this.assignVariable(pElement, pLeftVariableName, pRightVariableName, 1);
    }

    private AbstractElement addSmallerEqConstraint(OctElement pElement, String pVariableName, long pValueOfLiteral) {
        int varIdx = pElement.getVariableIndexFor(pVariableName);
        pElement.addConstraint(0, varIdx, 0, (int)pValueOfLiteral);
        return pElement;
    }

    private AbstractElement addSmallerConstraint(OctElement pElement, String pVariableName, long pValueOfLiteral) {
        int varIdx = pElement.getVariableIndexFor(pVariableName);
        pElement.addConstraint(0, varIdx, -1, (int)pValueOfLiteral - 1);
        return pElement;
    }

    private AbstractElement addGreaterEqConstraint(OctElement pElement, String pVariableName, long pValueOfLiteral) {
        int varIdx = pElement.getVariableIndexFor(pVariableName);
        pElement.addConstraint(1, varIdx, 0, 0 - (int)pValueOfLiteral);
        return pElement;
    }

    private AbstractElement addGreaterConstraint(OctElement pElement, String pVariableName, long pValueOfLiteral) {
        int varIdx = pElement.getVariableIndexFor(pVariableName);
        pElement.addConstraint(1, varIdx, 0, -1 - (int)pValueOfLiteral);
        return pElement;
    }

    private AbstractElement addEqConstraint(OctElement pElement, String pVariableName, long pI) {
        OctElement newElem1 = null;
        newElem1 = pElement.clone();
        this.addSmallerEqConstraint(pElement, pVariableName, pI);
        this.addGreaterEqConstraint(pElement, pVariableName, pI);
        if (newElem1.isEmpty()) {
            return null;
        }
        return this.assignConstant(pElement, pVariableName, pI);
    }

    private AbstractElement addIneqConstraint(OctElement pElement, String pVariableName, long pI) {
        OctElement newElem1 = null;
        newElem1 = pElement.clone();
        this.addEqConstraint(newElem1, pVariableName, pI);
        if (!newElem1.isEmpty()) {
            return pElement;
        }
        return pElement;
    }

    private OctElement handleDeclaration(OctElement pElement, DeclarationEdge declarationEdge) throws UnrecognizedCCodeException {
        if (declarationEdge.getDeclaration() instanceof IASTVariableDeclaration) {
            IASTVariableDeclaration decl = (IASTVariableDeclaration)declarationEdge.getDeclaration();
            String varName = decl.getName();
            if (decl.getDeclSpecifier() instanceof IASTPointerTypeSpecifier) {
                return pElement;
            }
            if (decl.isGlobal()) {
                Long v;
                this.globalVars.add(varName);
                IASTInitializer init = decl.getInitializer();
                if (init != null) {
                    if (init instanceof IASTInitializerExpression) {
                        IASTExpression exp = ((IASTInitializerExpression)init).getExpression();
                        v = this.getExpressionValue(pElement, exp, varName, declarationEdge);
                    } else {
                        v = null;
                    }
                } else {
                    v = 0L;
                }
                String variableName = this.getvarName(varName, declarationEdge.getPredecessor().getFunctionName());
                this.declareVariable(pElement, variableName);
                if (v != null) {
                    return this.assignConstant(pElement, variableName, v);
                }
            } else {
                String variableName = this.getvarName(varName, declarationEdge.getPredecessor().getFunctionName());
                return this.declareVariable(pElement, variableName);
            }
        }
        assert (false);
        return null;
    }

    private OctElement declareVariable(OctElement pElement, String pVariableName) {
        pElement.declareVariable(pVariableName);
        return pElement;
    }

    private OctElement assignConstant(OctElement pElement, String pVarName, long pLongValue) {
        pElement.assignConstant(pVarName, pLongValue);
        return pElement;
    }

    private OctElement handleStatement(OctElement pElement, IASTStatement expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression instanceof IASTAssignment) {
            return this.handleAssignment(pElement, (IASTAssignment)((Object)expression), cfaEdge);
        }
        if (!(expression instanceof IASTFunctionCallStatement) && !(expression instanceof IASTExpressionStatement)) {
            throw new UnrecognizedCCodeException(cfaEdge, expression);
        }
        assert (false);
        return null;
    }

    private OctElement handleAssignment(OctElement pElement, IASTAssignment assignExpression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        IASTExpression op1 = assignExpression.getLeftHandSide();
        IASTRightHandSide op2 = assignExpression.getRightHandSide();
        if (op1 instanceof IASTIdExpression) {
            return this.handleAssignmentToVariable(pElement, ((IASTIdExpression)op1).getName(), op2, cfaEdge);
        }
        if (op1 instanceof IASTUnaryExpression && ((IASTUnaryExpression)op1).getOperator() == IASTUnaryExpression.UnaryOperator.STAR) {
            if ((op1 = ((IASTUnaryExpression)op1).getOperand()) instanceof IASTCastExpression) {
                op1 = ((IASTCastExpression)op1).getOperand();
            }
            if (!(op1 instanceof IASTIdExpression)) {
                throw new UnrecognizedCCodeException("left operand of assignment has to be a variable", cfaEdge, op1);
            }
            return pElement;
        }
        if (op1 instanceof IASTFieldReference) {
            return pElement;
        }
        if (op1 instanceof IASTArraySubscriptExpression) {
            return pElement;
        }
        throw new UnrecognizedCCodeException("left operand of assignment has to be a variable", cfaEdge, op1);
    }

    private OctElement handleAssignmentToVariable(OctElement pElement, String lParam, IASTRightHandSide rightExp, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        String functionName = cfaEdge.getPredecessor().getFunctionName();
        if (rightExp == null || rightExp instanceof IASTLiteralExpression) {
            return this.handleAssignmentOfLiteral(pElement, lParam, (IASTLiteralExpression)rightExp, functionName, cfaEdge);
        }
        if (rightExp instanceof IASTIdExpression) {
            return this.handleAssignmentOfVariable(pElement, lParam, (IASTIdExpression)rightExp, functionName, 1);
        }
        if (rightExp instanceof IASTCastExpression) {
            return this.handleAssignmentOfCast(pElement, lParam, (IASTCastExpression)rightExp, cfaEdge);
        }
        if (rightExp instanceof IASTUnaryExpression) {
            return this.handleAssignmentOfUnaryExp(pElement, lParam, (IASTUnaryExpression)rightExp, cfaEdge);
        }
        if (rightExp instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)rightExp;
            return this.handleAssignmentOfBinaryExp(pElement, lParam, binExp.getOperand1(), binExp.getOperand2(), binExp.getOperator(), cfaEdge);
        }
        if (rightExp instanceof IASTFunctionCallExpression || rightExp instanceof IASTFieldReference) {
            String lvarName = this.getvarName(lParam, functionName);
            return this.forget(pElement, lvarName);
        }
        throw new UnrecognizedCCodeException(cfaEdge, rightExp);
    }

    private OctElement forget(OctElement pElement, String pLvarName) {
        pElement.forget(pLvarName);
        return pElement;
    }

    private OctElement handleAssignmentOfCast(OctElement pElement, String lParam, IASTCastExpression castExp, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        IASTExpression castOperand = castExp.getOperand();
        return this.handleAssignmentToVariable(pElement, lParam, castOperand, cfaEdge);
    }

    private OctElement handleAssignmentOfUnaryExp(OctElement pElement, String lParam, IASTUnaryExpression unaryExp, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        String functionName = cfaEdge.getPredecessor().getFunctionName();
        String assignedVar = this.getvarName(lParam, functionName);
        IASTExpression unaryOperand = unaryExp.getOperand();
        IASTUnaryExpression.UnaryOperator unaryOperator = unaryExp.getOperator();
        if (unaryOperator == IASTUnaryExpression.UnaryOperator.STAR) {
            if (unaryOperand instanceof IASTCastExpression) {
                unaryOperand = ((IASTCastExpression)unaryOperand).getOperand();
            }
            if (!(unaryOperand instanceof IASTIdExpression)) {
                throw new UnrecognizedCCodeException(cfaEdge, unaryOperand);
            }
        } else {
            Long value = this.getExpressionValue(pElement, unaryExp, functionName, cfaEdge);
            if (value != null) {
                return this.assignConstant(pElement, assignedVar, value);
            }
            String rVarName = unaryOperand.toASTString();
            return this.assignVariable(pElement, assignedVar, rVarName, -1);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OctElement handleAssignmentOfBinaryExp(OctElement pElement, String lParam, IASTExpression lVarInBinaryExp, IASTExpression rVarInBinaryExp, IASTBinaryExpression.BinaryOperator binaryOperator, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        String functionName = cfaEdge.getPredecessor().getFunctionName();
        String assignedVar = this.getvarName(lParam, functionName);
        switch (binaryOperator) {
            case DIVIDE: 
            case MODULO: 
            case LESS_EQUAL: 
            case GREATER_EQUAL: 
            case BINARY_AND: 
            case BINARY_OR: {
                return this.forget(pElement, assignedVar);
            }
            case PLUS: 
            case MINUS: 
            case MULTIPLY: {
                Long val1 = this.getExpressionValue(pElement, lVarInBinaryExp, functionName, cfaEdge);
                Long val2 = this.getExpressionValue(pElement, rVarInBinaryExp, functionName, cfaEdge);
                if (val1 != null && val2 != null) {
                    switch (binaryOperator) {
                        case PLUS: {
                            long value = val1 + val2;
                            return this.assignConstant(pElement, assignedVar, value);
                        }
                        case MINUS: {
                            long value = val1 - val2;
                            return this.assignConstant(pElement, assignedVar, value);
                        }
                        case MULTIPLY: {
                            long value = val1 * val2;
                            return this.assignConstant(pElement, assignedVar, value);
                        }
                        default: {
                            throw new UnrecognizedCCodeException("unkown binary operator", cfaEdge);
                        }
                    }
                }
                int lVarCoef = 0;
                int rVarCoef = 0;
                int constVal = 0;
                String lVarName = null;
                String rVarName = null;
                if (val1 == null && val2 != null) {
                    if (!(lVarInBinaryExp instanceof IASTIdExpression)) throw new UnrecognizedCCodeException("unkown binary operator", cfaEdge);
                    lVarName = ((IASTIdExpression)lVarInBinaryExp).getName();
                    switch (binaryOperator) {
                        case PLUS: {
                            constVal = val2.intValue();
                            lVarCoef = 1;
                            rVarCoef = 0;
                            return this.assignmentOfBinaryExp(pElement, assignedVar, this.getvarName(lVarName, functionName), lVarCoef, this.getvarName(rVarName, functionName), rVarCoef, constVal);
                        }
                        case MINUS: {
                            constVal = 0 - val2.intValue();
                            lVarCoef = 1;
                            rVarCoef = 0;
                            return this.assignmentOfBinaryExp(pElement, assignedVar, this.getvarName(lVarName, functionName), lVarCoef, this.getvarName(rVarName, functionName), rVarCoef, constVal);
                        }
                        case MULTIPLY: {
                            lVarCoef = val2.intValue();
                            rVarCoef = 0;
                            constVal = 0;
                            return this.assignmentOfBinaryExp(pElement, assignedVar, this.getvarName(lVarName, functionName), lVarCoef, this.getvarName(rVarName, functionName), rVarCoef, constVal);
                        }
                        default: {
                            throw new UnrecognizedCCodeException("unkown binary operator", cfaEdge);
                        }
                    }
                }
                if (val1 != null && val2 == null) {
                    if (!(lVarInBinaryExp instanceof IASTIdExpression)) throw new UnrecognizedCCodeException("unkown binary operator", cfaEdge);
                    rVarName = ((IASTIdExpression)rVarInBinaryExp).getName();
                    switch (binaryOperator) {
                        case PLUS: {
                            constVal = val1.intValue();
                            lVarCoef = 0;
                            rVarCoef = 1;
                            return this.assignmentOfBinaryExp(pElement, assignedVar, this.getvarName(lVarName, functionName), lVarCoef, this.getvarName(rVarName, functionName), rVarCoef, constVal);
                        }
                        case MINUS: {
                            constVal = val1.intValue();
                            lVarCoef = 0;
                            rVarCoef = -1;
                            return this.assignmentOfBinaryExp(pElement, assignedVar, this.getvarName(lVarName, functionName), lVarCoef, this.getvarName(rVarName, functionName), rVarCoef, constVal);
                        }
                        case MULTIPLY: {
                            rVarCoef = val1.intValue();
                            lVarCoef = 0;
                            constVal = 0;
                            return this.assignmentOfBinaryExp(pElement, assignedVar, this.getvarName(lVarName, functionName), lVarCoef, this.getvarName(rVarName, functionName), rVarCoef, constVal);
                        }
                        default: {
                            throw new UnrecognizedCCodeException("unkown binary operator", cfaEdge);
                        }
                    }
                }
                if (val1 != null || val2 != null) return this.assignmentOfBinaryExp(pElement, assignedVar, this.getvarName(lVarName, functionName), lVarCoef, this.getvarName(rVarName, functionName), rVarCoef, constVal);
                if (!(lVarInBinaryExp instanceof IASTIdExpression)) throw new UnrecognizedCCodeException("unkown binary operator", cfaEdge);
                lVarName = ((IASTIdExpression)lVarInBinaryExp).getName();
                rVarName = ((IASTIdExpression)rVarInBinaryExp).getName();
                switch (binaryOperator) {
                    case PLUS: {
                        lVarCoef = 1;
                        rVarCoef = 1;
                        return this.assignmentOfBinaryExp(pElement, assignedVar, this.getvarName(lVarName, functionName), lVarCoef, this.getvarName(rVarName, functionName), rVarCoef, constVal);
                    }
                    case MINUS: {
                        lVarCoef = 1;
                        rVarCoef = -1;
                        return this.assignmentOfBinaryExp(pElement, assignedVar, this.getvarName(lVarName, functionName), lVarCoef, this.getvarName(rVarName, functionName), rVarCoef, constVal);
                    }
                    case MULTIPLY: {
                        return this.forget(pElement, assignedVar);
                    }
                    default: {
                        throw new UnrecognizedCCodeException("unkown binary operator", cfaEdge);
                    }
                }
            }
            case EQUALS: 
            case NOT_EQUALS: {
                Long lVal = this.getExpressionValue(pElement, lVarInBinaryExp, functionName, cfaEdge);
                Long rVal = this.getExpressionValue(pElement, rVarInBinaryExp, functionName, cfaEdge);
                if (lVal == null || rVal == null) {
                    return this.forget(pElement, assignedVar);
                }
                long result = lVal.equals(rVal) ? 1 : 0;
                if (binaryOperator != IASTBinaryExpression.BinaryOperator.NOT_EQUALS) return this.assignConstant(pElement, assignedVar, result);
                result = 1L - result;
                return this.assignConstant(pElement, assignedVar, result);
            }
        }
        return this.forget(pElement, assignedVar);
    }

    private Long getExpressionValue(OctElement pElement, IASTRightHandSide expression, String functionName, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression instanceof IASTLiteralExpression) {
            return this.parseLiteral((IASTLiteralExpression)expression, cfaEdge);
        }
        if (expression instanceof IASTIdExpression) {
            return null;
        }
        if (expression instanceof IASTCastExpression) {
            return this.getExpressionValue(pElement, ((IASTCastExpression)expression).getOperand(), functionName, cfaEdge);
        }
        if (expression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
            IASTUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            IASTExpression unaryOperand = unaryExpression.getOperand();
            switch (unaryOperator) {
                case MINUS: {
                    Long val = this.getExpressionValue(pElement, unaryOperand, functionName, cfaEdge);
                    return val != null ? Long.valueOf(-val.longValue()) : null;
                }
                case AMPER: {
                    return null;
                }
            }
            throw new UnrecognizedCCodeException("unknown unary operator", cfaEdge, unaryExpression);
        }
        throw new UnrecognizedCCodeException(cfaEdge, expression);
    }

    private OctElement assignmentOfBinaryExp(OctElement pElement, String pAssignedVar, String pLeftVarName, int pLeftVarCoef, String pRightVarName, int pRightVarCoef, int pConstVal) {
        pElement.assignmentOfBinaryExp(pAssignedVar, pLeftVarName, pLeftVarCoef, pRightVarName, pRightVarCoef, pConstVal);
        return pElement;
    }

    private OctElement handleAssignmentOfVariable(OctElement pElement, String lParam, IASTExpression op2, String functionName, int coef) {
        String rParam = op2.toASTString();
        String leftVarName = this.getvarName(lParam, functionName);
        String rightVarName = this.getvarName(rParam, functionName);
        return this.assignVariable(pElement, leftVarName, rightVarName, coef);
    }

    private OctElement assignVariable(OctElement pElement, String pLeftVarName, String pRightVarName, int coef) {
        pElement.assignVariable(pLeftVarName, pRightVarName, coef);
        return pElement;
    }

    private OctElement handleAssignmentOfLiteral(OctElement pElement, String lParam, IASTLiteralExpression op2, String functionName, CFAEdge edge) throws UnrecognizedCCodeException {
        Long val = op2 == null ? Long.valueOf(0L) : this.parseLiteral(op2, edge);
        String assignedVar = this.getvarName(lParam, functionName);
        if (val != null) {
            return this.assignConstant(pElement, assignedVar, val);
        }
        return this.forget(pElement, assignedVar);
    }

    private Long parseLiteral(IASTLiteralExpression expression, CFAEdge edge) throws UnrecognizedCCodeException {
        if (expression instanceof IASTIntegerLiteralExpression) {
            return ((IASTIntegerLiteralExpression)expression).asLong();
        }
        if (expression instanceof IASTFloatLiteralExpression) {
            return null;
        }
        if (expression instanceof IASTCharLiteralExpression) {
            return ((IASTCharLiteralExpression)expression).getCharacter();
        }
        if (expression instanceof IASTStringLiteralExpression) {
            return null;
        }
        throw new UnrecognizedCCodeException("unknown literal", edge, expression);
    }

    private Long parseLiteralWithOppositeSign(IASTLiteralExpression expression, CFAEdge edge) throws UnrecognizedCCodeException {
        Long value = this.parseLiteral(expression, edge);
        if (value != null) {
            value = -value.longValue();
        }
        return value;
    }

    public String getvarName(String variableName, String functionName) {
        if (variableName == null) {
            return null;
        }
        if (this.globalVars.contains(variableName)) {
            return variableName;
        }
        return functionName + "::" + variableName;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> otherElements, CFAEdge cfaEdge, Precision precision) {
        assert (element instanceof OctElement);
        OctElement octagonElement = (OctElement)element;
        for (AbstractElement ae : otherElements) {
            if (ae instanceof PointerElement) {
                return this.strengthen(octagonElement, (PointerElement)ae, cfaEdge, precision);
            }
            if (!(ae instanceof AssumptionStorageElement)) continue;
            return this.strengthen(octagonElement, (AssumptionStorageElement)ae, cfaEdge, precision);
        }
        return null;
    }

    private Collection<? extends AbstractElement> strengthen(OctElement pOctagonElement, AssumptionStorageElement pAe, CFAEdge pCfaEdge, Precision pPrecision) {
        return null;
    }

    private Collection<? extends AbstractElement> strengthen(OctElement pOctagonElement, PointerElement pAe, CFAEdge pCfaEdge, Precision pPrecision) {
        return null;
    }
}

