/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import java.util.HashMap;
import org.sosy_lab.cpachecker.cpa.location.LocationElement;

class OctWideningControl {
    HashMap<Integer, LoopNode> loopNodeList = new HashMap();

    OctWideningControl() {
    }

    public boolean isWideningUsed(LocationElement le) {
        Integer nodeId = le.getLocationNode().getNodeNumber();
        if (this.loopNodeList.containsKey(nodeId)) {
            LoopNode ln = this.loopNodeList.get(nodeId);
            return ln.isWideningUsed();
        }
        LoopNode ln = new LoopNode(nodeId);
        this.loopNodeList.put(nodeId, ln);
        return ln.isWideningUsed();
    }

    static class LoopNode {
        private int nodeId;
        private int iterationCount = 0;
        private boolean isWideningUsed = false;

        public LoopNode(int id) {
            this.nodeId = id;
        }

        public void incrementIteration() {
            ++this.iterationCount;
        }

        public boolean exceedThreshold() {
            return this.iterationCount > 2;
        }

        public boolean isWideningUsed() {
            if (this.isWideningUsed) {
                return true;
            }
            this.incrementIteration();
            if (this.exceedThreshold()) {
                this.switchToWideningUsed();
            }
            return this.isWideningUsed;
        }

        public void switchToWideningUsed() {
            this.isWideningUsed = true;
        }
    }
}

