/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.octagon.OctDomain;
import org.sosy_lab.cpachecker.cpa.octagon.OctElement;
import org.sosy_lab.cpachecker.cpa.octagon.OctTransferRelation;
import org.sosy_lab.cpachecker.util.octagon.OctagonManager;

@Options(prefix="cpa.octagon")
public class OctagonCPA
implements ConfigurableProgramAnalysis {
    @Option(name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which merge operator to use for OctagonCPA?")
    private String mergeType = "SEP";
    private final AbstractDomain abstractDomain;
    private final TransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final PrecisionAdjustment precisionAdjustment;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(OctagonCPA.class);
    }

    private OctagonCPA(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        OctDomain octagonDomain = new OctDomain();
        this.transferRelation = new OctTransferRelation();
        MergeOperator octagonMergeOp = null;
        octagonMergeOp = this.mergeType.equals("sep") ? MergeSepOperator.getInstance() : (this.mergeType.equals("join") ? new MergeJoinOperator(octagonDomain) : MergeSepOperator.getInstance());
        StopSepOperator octagonStopOp = new StopSepOperator(octagonDomain);
        this.abstractDomain = octagonDomain;
        this.mergeOperator = octagonMergeOp;
        this.stopOperator = octagonStopOp;
        this.precisionAdjustment = StaticPrecisionAdjustment.getInstance();
        assert (OctagonManager.init());
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public AbstractElement getInitialElement(CFANode node) {
        return new OctElement();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return SingletonPrecision.getInstance();
    }
}

