/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer;

import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cpa.pointer.Pointer;

public interface Memory {
    public static final PointerTarget NULL_POINTER = new PointerTarget(){

        @Override
        public PointerTarget addOffset(long shift) throws InvalidPointerException {
            if (shift == 0L) {
                return this;
            }
            throw new InvalidPointerException("Pointer arithmetics on null pointer!");
        }

        @Override
        public PointerTarget addUnknownOffset() throws InvalidPointerException {
            throw new InvalidPointerException("Pointer arithmetics on null pointer!");
        }

        @Override
        public boolean isNull() {
            return true;
        }

        public String toString() {
            return "NULL";
        }
    };
    public static final PointerTarget INVALID_POINTER = new PointerTarget(){

        @Override
        public PointerTarget addOffset(long shift) throws InvalidPointerException {
            return this;
        }

        @Override
        public PointerTarget addUnknownOffset() throws InvalidPointerException {
            return this;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        public String toString() {
            return "INVALID";
        }
    };
    public static final PointerTarget UNINITIALIZED_POINTER = new PointerTarget(){

        @Override
        public PointerTarget addOffset(long shift) throws InvalidPointerException {
            if (shift == 0L) {
                return this;
            }
            throw new InvalidPointerException("Pointer arithmetics on uninitialized pointer!");
        }

        @Override
        public PointerTarget addUnknownOffset() throws InvalidPointerException {
            throw new InvalidPointerException("Pointer arithmetics on uninitialized pointer!");
        }

        @Override
        public boolean isNull() {
            return false;
        }

        public String toString() {
            return "UNINITIALIZED";
        }
    };
    public static final PointerTarget UNKNOWN_POINTER = new PointerTarget(){

        @Override
        public PointerTarget addOffset(long shift) throws InvalidPointerException {
            return this;
        }

        @Override
        public PointerTarget addUnknownOffset() throws InvalidPointerException {
            return this;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        public String toString() {
            return "UNKNOWN";
        }
    };

    public void addNewGlobalPointer(String var1, Pointer var2);

    public Pointer lookupPointer(String var1);

    public Variable lookupVariable(String var1);

    public void writeOnHeap(MemoryAddress var1, Pointer var2);

    public Pointer getPointer(LocalVariable var1);

    public void addNewLocalPointer(String var1, Pointer var2);

    public Pointer getPointer(GlobalVariable var1);

    public Pointer getPointer(MemoryAddress var1);

    public boolean areAliases(Pointer var1, Pointer var2);

    public void makeAlias(PointerLocation var1, PointerLocation var2);

    public MemoryAddress malloc();

    public void free(MemoryRegion var1) throws InvalidPointerException;

    public Pointer deref(Pointer var1, PointerTarget var2);

    public Collection<MemoryRegion> checkMemoryLeak();

    public CFAEdge getCurrentEdge();

    public static interface PointerLocation {
        public Pointer getPointer(Memory var1);
    }

    public static class StackArrayCell
    extends LocalVariable {
        private final StackArray array;
        private final long offset;

        private StackArrayCell(String function, StackArray array, boolean unknownOffset) {
            super(function, array.name);
            this.array = array;
            if (!unknownOffset) {
                throw new IllegalArgumentException("Only use this constructor with unknownOffset = true");
            }
            this.offset = -1L;
        }

        public StackArrayCell(String function, StackArray array) {
            super(function, array.name);
            this.array = array;
            this.offset = 0L;
        }

        private StackArrayCell(String function, StackArray array, long offset) throws InvalidPointerException {
            super(function, array.name);
            if (offset < 0L || offset >= array.getLength()) {
                throw new InvalidPointerException("Invalid offset " + offset + " for stack array " + array + "!");
            }
            this.array = array;
            this.offset = offset;
        }

        @Override
        public StackArrayCell addOffset(long shiftBytes) throws InvalidPointerException {
            if (this.offset == -1L) {
                if (Math.abs(shiftBytes) >= this.array.getLength()) {
                    throw new InvalidPointerException("Invalid shift " + shiftBytes + " for stack array " + this.array + "!");
                }
                return this;
            }
            return shiftBytes == 0L ? this : new StackArrayCell(this.getFunctionName(), this.array, this.offset + shiftBytes);
        }

        @Override
        public StackArrayCell addUnknownOffset() {
            if (this.offset == -1L) {
                return this;
            }
            return new StackArrayCell(this.getFunctionName(), this.array, true);
        }

        @Override
        public Pointer getPointer(Memory memory) {
            if (this.offset != -1L) {
                return null;
            }
            return super.getPointer(memory);
        }

        @Override
        public String getVarName() {
            return "__cpa_stack_array__" + super.getVarName() + "__" + this.offset;
        }

        @Override
        public boolean equals(Object other) {
            if (other == null || !(other instanceof StackArrayCell)) {
                return false;
            }
            StackArrayCell otherCell = (StackArrayCell)other;
            return this.offset != -1L && this.array.equals(otherCell.array) && this.offset == otherCell.offset;
        }

        @Override
        public String toString() {
            return this.array + (this.offset == -1L ? "[?]" : "[" + this.offset + "]");
        }
    }

    public static final class StackArray {
        private final String name;
        private final long length;

        public StackArray(String name, long length) {
            if (name == null || length < 0L) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.length = length;
        }

        public long getLength() {
            return this.length;
        }

        public String toString() {
            return this.name + "(" + this.length + ")";
        }
    }

    public static class GlobalVariable
    extends Variable {
        public GlobalVariable(String name) {
            super(name);
        }

        @Override
        public Pointer getPointer(Memory memory) {
            return memory.getPointer(this);
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof GlobalVariable && super.equals(other);
        }
    }

    public static class LocalVariable
    extends Variable {
        private String function;

        public LocalVariable(String function, String name) {
            super(name);
            assert (function != null);
            this.function = function;
        }

        @Override
        public Pointer getPointer(Memory memory) {
            return memory.getPointer(this);
        }

        public String getFunctionName() {
            return this.function;
        }

        @Override
        public String toString() {
            return this.function + ":" + super.toString();
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof LocalVariable && super.equals(other) && this.function.equals(((LocalVariable)other).function);
        }
    }

    public static abstract class Variable
    implements PointerTarget,
    PointerLocation {
        private final String name;

        public Variable(String name) {
            assert (name != null);
            this.name = name;
        }

        @Override
        public PointerTarget addOffset(long shiftBytes) throws InvalidPointerException {
            if (shiftBytes != 0L) {
                throw new InvalidPointerException("Pointer calculcations for simple variable " + this);
            }
            return this;
        }

        @Override
        public PointerTarget addUnknownOffset() throws InvalidPointerException {
            throw new InvalidPointerException("Pointer calculcations for simple variable " + this);
        }

        @Override
        public boolean isNull() {
            return false;
        }

        public String getVarName() {
            return this.name;
        }

        public boolean equals(Object other) {
            return other != null && other instanceof Variable && this.getVarName().equals(((Variable)other).getVarName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class MemoryAddress
    implements PointerTarget,
    PointerLocation {
        private final MemoryRegion region;
        private final long offset;

        private MemoryAddress(MemoryRegion region, boolean unknownOffset) {
            assert (region != null);
            this.region = region;
            if (!unknownOffset) {
                throw new IllegalArgumentException("Only use this constructor with unknownOffset = true");
            }
            this.offset = -1L;
        }

        public MemoryAddress(MemoryRegion region) {
            assert (region != null);
            this.region = region;
            this.offset = 0L;
        }

        private MemoryAddress(MemoryRegion region, long offset) throws InvalidPointerException {
            if (region == null) {
                throw new IllegalArgumentException("MemoryAddress needs a MemoryRegion");
            }
            if (offset < 0L || region.hasLength() && offset >= region.getLength()) {
                throw new InvalidPointerException("Invalid offset " + offset + " for memory region " + region + "!");
            }
            this.region = region;
            this.offset = offset;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public MemoryAddress addOffset(long shiftBytes) throws InvalidPointerException {
            if (!this.hasOffset()) {
                if (this.region.hasLength() && Math.abs(shiftBytes) >= this.region.getLength()) {
                    throw new InvalidPointerException("Invalid shift " + shiftBytes + " for memory address " + this);
                }
                return this;
            }
            return shiftBytes == 0L ? this : new MemoryAddress(this.region, this.offset + shiftBytes);
        }

        @Override
        public MemoryAddress addUnknownOffset() {
            return this.hasOffset() ? new MemoryAddress(this.region, true) : this;
        }

        public boolean hasOffset() {
            return this.offset != -1L;
        }

        @Override
        public Pointer getPointer(Memory memory) {
            return memory.getPointer(this);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof MemoryAddress)) {
                return false;
            }
            MemoryAddress otherAddress = (MemoryAddress)other;
            return this.hasOffset() && this.region.equals(otherAddress.region) && this.offset == otherAddress.offset;
        }

        public int hashCode() {
            return this.region.hashCode() + 17 * (int)this.offset;
        }

        public String toString() {
            return this.region + (this.hasOffset() ? "[" + this.offset + "]" : "[?]");
        }

        public MemoryRegion getRegion() {
            return this.region;
        }

        public long getOffset() {
            return this.offset;
        }
    }

    public static interface PointerTarget {
        public PointerTarget addOffset(long var1) throws InvalidPointerException;

        public PointerTarget addUnknownOffset() throws InvalidPointerException;

        public boolean isNull();
    }

    public static final class MemoryRegion {
        private static int idCounter = 0;
        private final int id;
        private long length = -1L;
        private boolean isValid;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MemoryRegion() {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.id = idCounter++;
            }
        }

        public boolean hasLength() {
            return this.length != -1L;
        }

        public long getLength() {
            return this.length;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public void setValid(boolean pIsValid) {
            this.isValid = pIsValid;
        }

        public void setLength(long length) {
            if (this.hasLength() && this.length != length) {
                throw new IllegalArgumentException("Trying to alter size of memory region " + this);
            }
            if (length < 0L) {
                throw new IllegalArgumentException("Invalid size " + length + " for memory region " + this);
            }
            this.length = length;
        }

        public String toString() {
            return "Mem[" + (this.isValid() ? "VALID" : "INVALID") + "]" + (this.length > 0L ? "(" + this.length + ")[" : "[") + this.id + "]";
        }
    }

    public static class InvalidPointerException
    extends Exception {
        private static final long serialVersionUID = 5559627789061016553L;

        public InvalidPointerException(String msg) {
            super(msg);
        }
    }
}

