/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.pointer.Memory;
import org.sosy_lab.cpachecker.cpa.pointer.PointerTransferRelation;

public class Pointer
implements Cloneable {
    private int sizeOfTarget;
    private Set<Memory.PointerTarget> targets;
    private int levelOfIndirection;
    private Memory.PointerLocation location;
    private boolean actualPointer;

    public Pointer() {
        this(0);
    }

    public Pointer(Memory.PointerTarget target) {
        this();
        if (target == null) {
            throw new IllegalArgumentException("Pointer must have a target!");
        }
        this.targets.clear();
        this.targets.add(target);
    }

    public Pointer(int levelOfIndirection) {
        this(-1, levelOfIndirection, new HashSet<Memory.PointerTarget>(), null);
        this.targets.add(Memory.NULL_POINTER);
    }

    private Pointer(int sizeOfTarget, int levelOfIndirection, Set<Memory.PointerTarget> targets, Memory.PointerLocation location) {
        this.sizeOfTarget = sizeOfTarget;
        this.levelOfIndirection = levelOfIndirection;
        this.targets = new HashSet<Memory.PointerTarget>(targets);
        this.location = location;
    }

    private void join(Pointer p) {
        assert (p != null);
        this.targets.addAll(p.targets);
        if (this.targets.size() <= 1) {
            this.sizeOfTarget = p.getSizeOfTarget();
        }
    }

    public boolean isDereferencable() {
        for (Memory.PointerTarget target : this.targets) {
            if (target != Memory.UNKNOWN_POINTER && !(target instanceof Memory.Variable) && !(target instanceof Memory.MemoryAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean isSafe() {
        return !this.targets.contains(Memory.NULL_POINTER) && !this.targets.contains(Memory.INVALID_POINTER) && !this.targets.contains(Memory.UNKNOWN_POINTER) || this.targets.contains(Memory.UNINITIALIZED_POINTER);
    }

    public boolean isSubsetOf(Pointer other) {
        assert (other != null);
        return this == other || other.targets.containsAll(this.targets);
    }

    public boolean isDifferentFrom(Pointer other) {
        assert (other != null);
        return !this.isSubsetOf(other) && !other.isSubsetOf(this) && (!this.targets.contains(Memory.INVALID_POINTER) || !other.targets.contains(Memory.INVALID_POINTER)) && !this.targets.contains(Memory.UNKNOWN_POINTER) && !other.targets.contains(Memory.UNKNOWN_POINTER) && !this.targets.contains(Memory.UNINITIALIZED_POINTER) && !other.targets.contains(Memory.UNINITIALIZED_POINTER);
    }

    public boolean contains(Memory.PointerTarget target) {
        assert (target != null);
        return this.targets.contains(target);
    }

    private void addOffset(long shift, boolean keepOldTargets, Memory memory) {
        if (!this.hasSizeOfTarget()) {
            this.addUnknownOffset(keepOldTargets, memory);
        } else {
            HashSet<Memory.PointerTarget> newTargets = new HashSet<Memory.PointerTarget>();
            long byteShift = shift * (long)this.sizeOfTarget;
            for (Memory.PointerTarget target : this.targets) {
                try {
                    newTargets.add(target.addOffset(byteShift));
                }
                catch (Memory.InvalidPointerException e) {
                    PointerTransferRelation.addWarning(e.getMessage(), memory.getCurrentEdge(), target.toString());
                    newTargets.add(Memory.INVALID_POINTER);
                }
            }
            assert (newTargets.size() >= 1);
            if (keepOldTargets) {
                this.targets.addAll(newTargets);
            } else {
                this.targets = newTargets;
            }
        }
    }

    private void addUnknownOffset(boolean keepOldTargets, Memory memory) {
        HashSet<Memory.PointerTarget> newTargets = new HashSet<Memory.PointerTarget>();
        for (Memory.PointerTarget target : this.targets) {
            try {
                newTargets.add(target.addUnknownOffset());
            }
            catch (Memory.InvalidPointerException e) {
                PointerTransferRelation.addWarning(e.getMessage(), memory.getCurrentEdge(), target.toString());
                newTargets.add(Memory.INVALID_POINTER);
            }
        }
        assert (newTargets.size() >= 1);
        if (keepOldTargets) {
            this.targets.addAll(newTargets);
        } else {
            this.targets = newTargets;
        }
    }

    public int getNumberOfTargets() {
        return this.targets.size();
    }

    public Set<Memory.PointerTarget> getTargets() {
        return Collections.unmodifiableSet(this.targets);
    }

    public Memory.PointerTarget getFirstTarget() {
        if (this.getNumberOfTargets() >= 1) {
            return this.targets.iterator().next();
        }
        return null;
    }

    public boolean hasSizeOfTarget() {
        return this.sizeOfTarget != -1;
    }

    public int getSizeOfTarget() {
        return this.sizeOfTarget;
    }

    public void setSizeOfTarget(int sizeOfTarget) {
        if (this.hasSizeOfTarget() && this.sizeOfTarget != sizeOfTarget) {
            throw new IllegalArgumentException();
        }
        if (sizeOfTarget <= 0) {
            throw new IllegalArgumentException();
        }
        this.sizeOfTarget = sizeOfTarget;
    }

    public boolean isPointerToPointer() {
        return this.levelOfIndirection > 1;
    }

    public int getLevelOfIndirection() {
        return this.levelOfIndirection;
    }

    public Memory.PointerLocation getLocation() {
        return this.location;
    }

    public void setLocation(Memory.PointerLocation location) {
        if (this.location != null) {
            throw new IllegalStateException("May not overwrite pointer location!");
        }
        this.location = location;
    }

    public boolean isActualPointer() {
        return this.actualPointer;
    }

    public void setActualPointer(boolean actualPointer) {
        this.actualPointer = actualPointer;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Pointer)) {
            return false;
        }
        return this.location.equals(((Pointer)other).location) && ((Object)this.targets).equals(((Pointer)other).targets);
    }

    public int hashCode() {
        return ((Object)this.targets).hashCode();
    }

    public Pointer clone() {
        return new Pointer(this.sizeOfTarget, this.levelOfIndirection, this.targets, this.location);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.levelOfIndirection; ++i) {
            sb.append('*');
        }
        sb.append('(');
        for (Memory.PointerTarget target : this.targets) {
            sb.append(' ');
            if (target instanceof Memory.Variable) {
                sb.append('&');
            }
            sb.append(target);
            sb.append(' ');
        }
        sb.append(')');
        return sb.toString();
    }

    public static class AssumeInequality
    implements PointerOperation {
        private final Memory.PointerTarget removeTarget;

        public Memory.PointerTarget getRemoveTarget() {
            return this.removeTarget;
        }

        public AssumeInequality(Memory.PointerTarget removeTarget) {
            this.removeTarget = removeTarget;
        }

        @Override
        public void doOperation(Memory memory, Pointer pointer, boolean keepOldTargets) {
            pointer.targets.remove(this.removeTarget);
            if (pointer.getNumberOfTargets() == 0) {
                throw new IllegalStateException("Pointer without target must not exist!");
            }
        }
    }

    public static class MallocAndAssign
    implements PointerOperation {
        private Memory.MemoryAddress memAddress = null;

        @Override
        public void doOperation(Memory memory, Pointer pointer, boolean keepOldTargets) {
            if (!keepOldTargets) {
                pointer.targets.clear();
            }
            if (this.memAddress == null) {
                this.memAddress = memory.malloc();
            }
            pointer.targets.add(Memory.NULL_POINTER);
            pointer.targets.add(this.memAddress);
        }

        public Memory.MemoryAddress getMallocResult() {
            return this.memAddress;
        }
    }

    public static class DerefAndAssign
    implements PointerOperation {
        private final Pointer assignValue;

        public DerefAndAssign(Pointer assignValue) {
            this.assignValue = assignValue;
            if (!assignValue.isPointerToPointer()) {
                throw new IllegalArgumentException("Pointers which do not point to other pointers cannot be dereferenced in this analysis!");
            }
            if (!assignValue.isDereferencable()) {
                throw new IllegalArgumentException("Unsafe deref of pointer " + assignValue.getLocation() + " = " + assignValue);
            }
        }

        @Override
        public void doOperation(Memory memory, Pointer pointer, boolean keepOldTargets) {
            if (!keepOldTargets) {
                pointer.targets.clear();
            }
            for (Memory.PointerTarget assignTarget : this.assignValue.getTargets()) {
                Pointer actualAssignValue = memory.deref(this.assignValue, assignTarget);
                if (actualAssignValue == null) continue;
                pointer.join(actualAssignValue);
                if (keepOldTargets || this.assignValue.getNumberOfTargets() != 1) continue;
                memory.makeAlias(actualAssignValue.getLocation(), pointer.getLocation());
            }
        }
    }

    public static class AddUnknownOffsetAndAssign
    implements PointerOperation {
        private final Pointer assignValue;

        public AddUnknownOffsetAndAssign(Pointer assignValue) {
            this.assignValue = assignValue;
        }

        @Override
        public void doOperation(Memory memory, Pointer pointer, boolean keepOldTargets) {
            Pointer shiftedAssignValue = this.assignValue.clone();
            if (!keepOldTargets) {
                pointer.targets.clear();
            }
            shiftedAssignValue.addUnknownOffset(false, memory);
            pointer.join(shiftedAssignValue);
        }
    }

    public static class AddOffsetAndAssign
    implements PointerOperation {
        private final Pointer assignValue;
        private final long shift;

        public AddOffsetAndAssign(Pointer assignValue, long shift) {
            this.assignValue = assignValue;
            this.shift = shift;
        }

        @Override
        public void doOperation(Memory memory, Pointer pointer, boolean keepOldTargets) {
            Pointer shiftedAssignValue = this.assignValue.clone();
            if (!keepOldTargets) {
                pointer.targets.clear();
            }
            shiftedAssignValue.addOffset(this.shift, false, memory);
            pointer.join(shiftedAssignValue);
        }
    }

    public static class AssignListOfTargets
    implements PointerOperation {
        private final Collection<Memory.PointerTarget> assignValues;

        public AssignListOfTargets(Collection<Memory.PointerTarget> assignValues) {
            if (assignValues.isEmpty()) {
                throw new IllegalArgumentException("No targets for assignment!");
            }
            this.assignValues = assignValues;
        }

        @Override
        public void doOperation(Memory memory, Pointer pointer, boolean keepOldTargets) {
            if (!keepOldTargets) {
                pointer.targets.clear();
            }
            pointer.targets.addAll(this.assignValues);
        }
    }

    public static class Assign
    implements PointerOperation {
        private final Memory.PointerTarget assignValueTarget;
        private final Pointer assignValuePointer;

        public Assign(Memory.PointerTarget assignValue) {
            this.assignValueTarget = assignValue;
            this.assignValuePointer = null;
        }

        public Assign(Pointer assignValue) {
            this.assignValueTarget = null;
            this.assignValuePointer = assignValue;
        }

        @Override
        public void doOperation(Memory memory, Pointer pointer, boolean keepOldTargets) {
            if (!keepOldTargets) {
                pointer.targets.clear();
            }
            if (this.assignValueTarget != null) {
                pointer.targets.add(this.assignValueTarget);
            } else {
                pointer.join(this.assignValuePointer);
                if (!keepOldTargets && this.assignValuePointer.getLocation() != null) {
                    memory.makeAlias(this.assignValuePointer.getLocation(), pointer.getLocation());
                }
            }
        }
    }

    public static class AddUnknownOffset
    implements PointerOperation {
        @Override
        public void doOperation(Memory memory, Pointer pointer, boolean keepOldTargets) {
            pointer.addUnknownOffset(keepOldTargets, memory);
        }
    }

    public static class AddOffset
    implements PointerOperation {
        private final long shift;

        public AddOffset(long shift) {
            this.shift = shift;
        }

        @Override
        public void doOperation(Memory memory, Pointer pointer, boolean keepOldTargets) {
            pointer.addOffset(this.shift, keepOldTargets, memory);
        }
    }

    public static interface PointerOperation {
        public void doOperation(Memory var1, Pointer var2, boolean var3);
    }
}

