/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer;

import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.pointer.PointerDomain;
import org.sosy_lab.cpachecker.cpa.pointer.PointerElement;
import org.sosy_lab.cpachecker.cpa.pointer.PointerTransferRelation;

@Options(prefix="cpa.pointer")
public class PointerCPA
implements ConfigurableProgramAnalysis {
    @Option(name="merge", values={"sep", "join"}, description="which merge operator to use for PointerCPA?")
    private String mergeType = "sep";
    @Option(description="print warnings during analysis when unsafe pointer operations are found")
    private boolean printWarnings = true;
    private final AbstractDomain abstractDomain;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final TransferRelation transferRelation;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(PointerCPA.class);
    }

    private PointerCPA(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        PointerDomain domain = new PointerDomain();
        MergeOperator mergeOp = null;
        if (this.mergeType.equals("sep")) {
            mergeOp = MergeSepOperator.getInstance();
        }
        if (this.mergeType.equals("join")) {
            mergeOp = new MergeJoinOperator(domain);
        }
        this.abstractDomain = domain;
        this.mergeOperator = mergeOp;
        this.stopOperator = new StopSepOperator(domain);
        this.transferRelation = new PointerTransferRelation(this.printWarnings, logger);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public AbstractElement getInitialElement(CFANode pNode) {
        if (pNode instanceof FunctionDefinitionNode) {
            ((PointerTransferRelation)this.getTransferRelation()).setEntryFunctionDefinitionNode((FunctionDefinitionNode)pNode);
        }
        return new PointerElement();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }
}

