/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableElement;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.pointer.Memory;
import org.sosy_lab.cpachecker.cpa.pointer.Pointer;
import org.sosy_lab.cpachecker.cpa.pointer.PointerTransferRelation;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

public class PointerElement
implements AbstractQueryableElement,
Memory,
Cloneable,
Targetable {
    private static final char FUNCTION_NAME_SEPARATOR = ':';
    private CFAEdge currentEdge = null;
    private boolean error = false;
    private Set<ElementProperty> properties = EnumSet.noneOf(ElementProperty.class);
    private final Map<String, Map<String, Pointer>> stack = new HashMap<String, Map<String, Pointer>>();
    private String currentFunctionName = "";
    private final HashMap<Memory.MemoryAddress, Pointer> heap = new HashMap();
    private final HashSet<Memory.MemoryRegion> mallocs;
    private final HashMap<Memory.PointerTarget, Set<Memory.PointerLocation>> reverseRelation;
    private final HashMap<Memory.PointerLocation, Set<Memory.PointerLocation>> aliases;
    private final HashSet<Memory.PointerLocation> tempTracked;

    public PointerElement() {
        this.mallocs = new HashSet();
        this.reverseRelation = new HashMap();
        this.aliases = new HashMap();
        this.tempTracked = new HashSet();
        this.stack.put("", new HashMap());
    }

    private PointerElement(Map<String, Map<String, Pointer>> stack, Map<Memory.MemoryAddress, Pointer> heap, Set<Memory.MemoryRegion> mallocs, Map<Memory.PointerTarget, Set<Memory.PointerLocation>> reverseRelation, Map<Memory.PointerLocation, Set<Memory.PointerLocation>> aliases, Set<Memory.PointerLocation> tempTracked, String currentFunctionName, Set<ElementProperty> pProperties) {
        this.mallocs = new HashSet<Memory.MemoryRegion>(mallocs);
        this.reverseRelation = new HashMap();
        this.aliases = new HashMap();
        this.currentFunctionName = currentFunctionName;
        this.tempTracked = new HashSet<Memory.PointerLocation>(tempTracked);
        this.properties.addAll(pProperties);
        for (Map.Entry<String, Map<String, Pointer>> entry : stack.entrySet()) {
            Map<String, Pointer> oldPointers = entry.getValue();
            HashMap<String, Pointer> newPointers = new HashMap<String, Pointer>();
            for (Map.Entry<String, Pointer> var : oldPointers.entrySet()) {
                Pointer oldPointer = var.getValue();
                newPointers.put(var.getKey(), oldPointer == null ? null : oldPointer.clone());
            }
            this.stack.put(entry.getKey(), newPointers);
        }
        for (Map.Entry<Object, Object> entry : heap.entrySet()) {
            this.heap.put((Memory.MemoryAddress)entry.getKey(), ((Pointer)entry.getValue()).clone());
        }
        for (Map.Entry<Object, Object> entry : reverseRelation.entrySet()) {
            this.reverseRelation.put((Memory.PointerTarget)entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        for (Set set : aliases.values()) {
            HashSet newAliasSet = new HashSet(set);
            for (Memory.PointerLocation location : newAliasSet) {
                this.aliases.put(location, newAliasSet);
            }
        }
        this.sanityCheck();
    }

    private void sanityCheck() throws IllegalStateException {
        for (Set<Memory.PointerLocation> set : this.aliases.values()) {
            for (Memory.PointerLocation loc : set) {
                if (this.aliases.get(loc) == set) continue;
                throw new IllegalStateException("Aliases wrong");
            }
        }
        for (Memory.PointerTarget pointerTarget : this.reverseRelation.keySet()) {
            for (Memory.PointerLocation loc : this.reverseRelation.get(pointerTarget)) {
                Pointer p = this.getPointer(loc);
                if (p == null) {
                    throw new IllegalStateException("Reverse relation " + loc + " <- " + pointerTarget + " but there is no pointer!");
                }
                if (p.contains(pointerTarget)) continue;
                throw new IllegalStateException("Reverse relation " + loc + " <- " + pointerTarget + " without forward relation!");
            }
        }
        for (Map map : this.stack.values()) {
            for (Pointer p : map.values()) {
                if (p == null) continue;
                if (p.getNumberOfTargets() == 0) {
                    throw new IllegalStateException("Pointer " + p.getLocation() + " has no targets!");
                }
                for (Memory.PointerTarget target : p.getTargets()) {
                    if (target == UNKNOWN_POINTER || target == INVALID_POINTER || target == UNINITIALIZED_POINTER) continue;
                    if (this.reverseRelation.get(target) == null) {
                        throw new IllegalStateException("Target " + target + " without reverse relations!");
                    }
                    if (this.reverseRelation.get(target).contains(p.getLocation())) continue;
                    throw new IllegalStateException("Forward relation " + p.getLocation() + " -> " + target + " without reverse relation!");
                }
                Memory.PointerLocation loc = p.getLocation();
                if (loc instanceof Memory.LocalVariable || this.getPointer(loc) == p) continue;
                throw new IllegalStateException("Pointer in invalid location!");
            }
        }
        for (Pointer pointer : this.heap.values()) {
            if (pointer.getNumberOfTargets() == 0) {
                throw new IllegalStateException("Pointer " + pointer.getLocation() + " has no targets!");
            }
            for (Memory.PointerTarget target : pointer.getTargets()) {
                if (target == UNKNOWN_POINTER || target == INVALID_POINTER || target == UNINITIALIZED_POINTER) continue;
                if (this.reverseRelation.get(target) == null) {
                    throw new IllegalStateException("Target without reverse relations");
                }
                if (this.reverseRelation.get(target).contains(pointer.getLocation())) continue;
                throw new IllegalStateException("Forward relation " + pointer.getLocation() + " -> " + target + " without reverse relation!");
            }
            Memory.PointerLocation loc = pointer.getLocation();
            Pointer a_tmp = this.getPointer(loc);
            if (loc instanceof Memory.MemoryAddress || a_tmp.equals(pointer)) continue;
            throw new IllegalStateException("Pointer in invalid location!");
        }
        for (Memory.PointerLocation pointerLocation : this.tempTracked) {
            if (pointerLocation.getPointer(this) != null) continue;
            throw new IllegalStateException("Temporarily tracked non-pointer variable " + pointerLocation + " without content!");
        }
    }

    void addProperty(ElementProperty pProp) {
        this.properties.add(pProp);
    }

    Set<ElementProperty> getProperties() {
        return this.properties;
    }

    void clearProperties() {
        this.properties.clear();
    }

    private Map<String, Pointer> getGlobalPointers() {
        return this.stack.get("");
    }

    private Map<String, Pointer> getLocalPointers() {
        return this.stack.get(this.currentFunctionName);
    }

    private void registerPointer(Pointer p, Memory.PointerLocation loc) {
        assert (p != null && loc != null);
        p.setLocation(loc);
        this.addAllReverseRelations(p);
        this.findAndMergePossibleAliases(p);
    }

    @Override
    public void addNewGlobalPointer(String name, Pointer p) {
        assert (name != null);
        this.getGlobalPointers().put(name, p);
        if (p != null) {
            this.registerPointer(p, new Memory.GlobalVariable(name));
        }
    }

    @Override
    public void addNewLocalPointer(String name, Pointer p) {
        assert (name != null);
        this.getLocalPointers().put(name, p);
        if (p != null) {
            this.registerPointer(p, new Memory.LocalVariable(this.getCurrentFunctionName(), name));
        }
    }

    public void addTemporaryTracking(String var, Pointer content) {
        Memory.Variable loc = this.lookupVariable(var);
        if (this.tempTracked.contains(loc)) {
            this.pointerOp(new Pointer.Assign(content), this.getPointer(loc));
        } else {
            this.tempTracked.add(loc);
            Pointer p = new Pointer(content.getLevelOfIndirection());
            if (loc instanceof Memory.LocalVariable) {
                this.getLocalPointers().put(var, p);
            } else if (loc instanceof Memory.GlobalVariable) {
                this.getGlobalPointers().put(var, p);
            } else {
                throw new IllegalStateException();
            }
            p.setLocation(loc);
            this.addAllReverseRelations(p);
            this.pointerOp(new Pointer.Assign(content), p);
        }
    }

    public void removeTemporaryTracking(Memory.PointerLocation loc) {
        if (!this.tempTracked.contains(loc)) {
            throw new IllegalStateException("Variable " + loc + " does not contain a pointer!");
        }
        this.tempTracked.remove(loc);
        Pointer p = this.getPointer(loc);
        this.removeAllAliases(loc);
        this.removeAllReverseRelations(p);
        if (loc instanceof Memory.LocalVariable) {
            this.getLocalPointers().remove(((Memory.LocalVariable)loc).getVarName());
        } else if (loc instanceof Memory.GlobalVariable) {
            this.getGlobalPointers().remove(((Memory.GlobalVariable)loc).getVarName());
        } else {
            throw new IllegalStateException();
        }
    }

    public boolean isPointerVariable(Memory.PointerLocation loc) {
        return !this.tempTracked.contains(loc) && this.getPointer(loc) != null;
    }

    @Override
    public Pointer lookupPointer(String name) {
        Pointer result = this.getGlobalPointers().get(name);
        if (result == null) {
            result = this.getLocalPointers().get(name);
        }
        return result;
    }

    @Override
    public Memory.Variable lookupVariable(String name) {
        if (this.getLocalPointers().containsKey(name)) {
            return new Memory.LocalVariable(this.getCurrentFunctionName(), name);
        }
        if (this.getGlobalPointers().containsKey(name)) {
            return new Memory.GlobalVariable(name);
        }
        throw new IllegalStateException("Unknown variable " + name);
    }

    @Override
    public Pointer getPointer(Memory.LocalVariable var) {
        Map<String, Pointer> stackframe = this.stack.get(var.getFunctionName());
        assert (stackframe != null);
        return stackframe.get(var.getVarName());
    }

    @Override
    public Pointer getPointer(Memory.GlobalVariable var) {
        return this.getGlobalPointers().get(var.getVarName());
    }

    @Override
    public Pointer getPointer(Memory.MemoryAddress memAddress) {
        return this.heap.get(memAddress);
    }

    private Pointer getPointer(Memory.PointerLocation location) {
        return location.getPointer(this);
    }

    @Override
    public void writeOnHeap(Memory.MemoryAddress memAddress, Pointer p) {
        assert (memAddress != null && p != null);
        this.heap.put(memAddress, p);
        this.registerPointer(p, memAddress);
    }

    private void addAllReverseRelations(Pointer pointer) {
        Memory.PointerLocation location = pointer.getLocation();
        for (Memory.PointerTarget target : pointer.getTargets()) {
            if (target == INVALID_POINTER || target == UNKNOWN_POINTER || target == UNINITIALIZED_POINTER) continue;
            Set<Memory.PointerLocation> locs = this.reverseRelation.get(target);
            if (locs == null) {
                locs = new HashSet<Memory.PointerLocation>();
                this.reverseRelation.put(target, locs);
            }
            locs.add(location);
        }
    }

    private void removeAllReverseRelations(Pointer pointer) {
        Memory.PointerLocation location = pointer.getLocation();
        for (Memory.PointerTarget target : pointer.getTargets()) {
            if (target == INVALID_POINTER || target == UNKNOWN_POINTER || target == UNINITIALIZED_POINTER) continue;
            Set<Memory.PointerLocation> locs = this.reverseRelation.get(target);
            if (locs == null || !locs.contains(location)) {
                throw new IllegalStateException("Trying to remove reverse reference to location " + location + " from target " + target + ", but it's not there");
            }
            locs.remove(location);
        }
    }

    @Override
    public void makeAlias(Memory.PointerLocation firstPointer, Memory.PointerLocation secondPointer) {
        Set<Memory.PointerLocation> oldAliases;
        Set<Memory.PointerLocation> newAliases = this.aliases.get(firstPointer);
        if (newAliases == null) {
            newAliases = new HashSet<Memory.PointerLocation>();
            newAliases.add(firstPointer);
            this.aliases.put(firstPointer, newAliases);
        }
        if ((oldAliases = this.aliases.get(secondPointer)) != null) {
            oldAliases.remove(secondPointer);
        }
        newAliases.add(secondPointer);
        this.aliases.put(secondPointer, newAliases);
    }

    private void mergeAliases(Memory.PointerLocation firstPointer, Memory.PointerLocation secondPointer) {
        Set<Memory.PointerLocation> firstAliases = this.aliases.get(firstPointer);
        if (firstAliases == null || firstAliases.size() == 1) {
            this.makeAlias(secondPointer, firstPointer);
        } else {
            Set<Memory.PointerLocation> secondAliases = this.aliases.get(secondPointer);
            if (firstAliases != secondAliases) {
                if (secondAliases == null || secondAliases.size() == 1) {
                    this.makeAlias(firstPointer, secondPointer);
                } else {
                    for (Memory.PointerLocation p : secondAliases) {
                        firstAliases.add(p);
                        this.aliases.put(p, firstAliases);
                    }
                    secondAliases.clear();
                }
            }
        }
    }

    private void removeAllAliases(Memory.PointerLocation pointer) {
        Set<Memory.PointerLocation> pointerAliases = this.aliases.get(pointer);
        if (pointerAliases != null && pointerAliases.size() > 1) {
            pointerAliases.remove(pointer);
            this.aliases.remove(pointer);
        }
    }

    private Set<Memory.PointerLocation> getAliases(Memory.PointerLocation pointer) {
        Set<Memory.PointerLocation> pointerAliases = this.aliases.get(pointer);
        if (pointerAliases == null) {
            pointerAliases = new HashSet<Memory.PointerLocation>();
            pointerAliases.add(pointer);
            this.aliases.put(pointer, pointerAliases);
        } else assert (pointerAliases.contains(pointer));
        return Collections.unmodifiableSet(pointerAliases);
    }

    @Override
    public boolean areAliases(Pointer p1, Pointer p2) {
        Memory.PointerTarget target;
        if (this.getAliases(p1.getLocation()).contains(p2.getLocation())) {
            return true;
        }
        if (p1.getNumberOfTargets() == 1 && p2.getNumberOfTargets() == 1 && (target = p1.getFirstTarget()).equals(p2.getFirstTarget()) && target != INVALID_POINTER && target != UNKNOWN_POINTER && target != UNINITIALIZED_POINTER) {
            this.mergeAliases(p1.getLocation(), p2.getLocation());
            return true;
        }
        return false;
    }

    private void findAndMergePossibleAliases(Pointer p) {
        if (p.getNumberOfTargets() != 1) {
            return;
        }
        Memory.PointerLocation loc = p.getLocation();
        Memory.PointerTarget target = p.getFirstTarget();
        if (target == INVALID_POINTER || target == UNKNOWN_POINTER || target == UNINITIALIZED_POINTER) {
            return;
        }
        Set<Memory.PointerLocation> aliasesOfP = this.getAliases(loc);
        if (!this.reverseRelation.containsKey(target)) {
            throw new IllegalStateException("Target " + target + " has no set of locations!");
        }
        for (Memory.PointerLocation candidateLoc : this.reverseRelation.get(target)) {
            Pointer candidatePointer;
            if (aliasesOfP.contains(candidateLoc) || (candidatePointer = this.getPointer(candidateLoc)).getNumberOfTargets() != 1) continue;
            assert (((Object)candidatePointer.getTargets()).equals(p.getTargets()));
            this.mergeAliases(loc, candidateLoc);
            aliasesOfP = this.getAliases(loc);
        }
    }

    @Override
    public Memory.MemoryAddress malloc() {
        Memory.MemoryRegion mem = new Memory.MemoryRegion();
        mem.setValid(true);
        this.mallocs.add(mem);
        return new Memory.MemoryAddress(mem);
    }

    @Override
    public void free(Memory.MemoryRegion mem) throws Memory.InvalidPointerException {
        if (this.mallocs.contains(mem) && !mem.isValid()) {
            throw new Memory.InvalidPointerException("Double free of region " + mem);
        }
        this.mallocs.remove(mem);
        mem.setValid(false);
        this.mallocs.add(mem);
        Iterator<Memory.MemoryAddress> heapIt = this.heap.keySet().iterator();
        while (heapIt.hasNext()) {
            Memory.MemoryAddress memAddress = heapIt.next();
            if (!memAddress.getRegion().equals(mem)) continue;
            Pointer p = this.heap.get(memAddress);
            this.removeAllAliases(memAddress);
            this.removeAllReverseRelations(p);
            heapIt.remove();
        }
    }

    @Override
    public Pointer deref(Pointer pointer, Memory.PointerTarget target) {
        assert (pointer.isPointerToPointer());
        assert (pointer.contains(target));
        if (target instanceof Memory.PointerLocation) {
            Pointer result = ((Memory.PointerLocation)((Object)target)).getPointer(this);
            if (result == null) {
                if (target instanceof Memory.MemoryAddress) {
                    result = new Pointer(pointer.getLevelOfIndirection() - 1);
                    this.writeOnHeap((Memory.MemoryAddress)target, result);
                } else {
                    throw new IllegalStateException("Trying to dereference target " + target + ", but it does not contain a pointer!");
                }
            }
            return result;
        }
        if (target == UNKNOWN_POINTER) {
            Pointer.Assign op = new Pointer.Assign(UNKNOWN_POINTER);
            op.doOperation(null, pointer, false);
            return pointer;
        }
        if (target == NULL_POINTER || target == INVALID_POINTER || target == UNINITIALIZED_POINTER) {
            return null;
        }
        throw new UnsupportedOperationException("Missing implementation to dereference the target " + target);
    }

    public void pointerOp(Pointer.PointerOperation op, Pointer pointer) {
        this.pointerOpNoDereference(op, pointer, false);
    }

    public void pointerOp(Pointer.PointerOperation op, Pointer pointer, boolean dereferenceFirst) {
        if (pointer == null) {
            return;
        }
        if (dereferenceFirst) {
            boolean keepOldTargets;
            boolean bl = keepOldTargets = pointer.getNumberOfTargets() != 1;
            if (!pointer.isPointerToPointer()) {
                throw new IllegalArgumentException("Pointers which do not point to other pointers cannot be dereferenced in this analysis!");
            }
            if (!pointer.isDereferencable()) {
                throw new IllegalArgumentException("Unsafe deref of pointer " + pointer.getLocation() + " = " + pointer);
            }
            for (Memory.PointerTarget target : pointer.getTargets()) {
                Pointer actualPointer = this.deref(pointer, target);
                this.pointerOpNoDereference(op, actualPointer, keepOldTargets);
            }
        } else {
            this.pointerOpNoDereference(op, pointer, false);
        }
    }

    private void pointerOpNoDereference(Pointer.PointerOperation op, Pointer pointer, boolean keepOldTargets) {
        if (pointer == null) {
            return;
        }
        Memory.PointerLocation location = pointer.getLocation();
        this.removeAllReverseRelations(pointer);
        this.removeAllAliases(location);
        op.doOperation(this, pointer, keepOldTargets);
        this.addAllReverseRelations(pointer);
        this.findAndMergePossibleAliases(pointer);
    }

    public void pointerOpForAllAliases(Pointer.PointerOperation op, Pointer pointer, boolean keepOldTargets) {
        for (Memory.PointerLocation aliasLoc : this.getAliases(pointer.getLocation())) {
            Pointer aliasPointer = this.getPointer(aliasLoc);
            this.removeAllReverseRelations(aliasPointer);
            op.doOperation(this, aliasPointer, keepOldTargets);
            this.addAllReverseRelations(aliasPointer);
            if (!(op instanceof Pointer.AssumeInequality)) continue;
            Pointer.AssumeInequality assumeIneqOp = (Pointer.AssumeInequality)op;
            for (Memory.PointerTarget target : this.reverseRelation.keySet()) {
                if (!this.reverseRelation.get(target).contains(assumeIneqOp.getRemoveTarget()) || this.reverseRelation.get(target).size() != 1) continue;
                this.reverseRelation.remove(target);
            }
        }
    }

    public void pointerOpAssumeEquality(Pointer firstPointer, Pointer secondPointer) {
        if (this.areAliases(firstPointer, secondPointer)) {
            return;
        }
        ArrayList<Memory.PointerTarget> intersection = new ArrayList<Memory.PointerTarget>();
        Set<Memory.PointerTarget> firstTargets = firstPointer.getTargets();
        Set<Memory.PointerTarget> secondTargets = secondPointer.getTargets();
        if (firstTargets.contains(Memory.UNKNOWN_POINTER)) {
            intersection.addAll(secondTargets);
        }
        if (secondTargets.contains(Memory.UNKNOWN_POINTER)) {
            intersection.addAll(firstTargets);
        }
        for (Memory.PointerTarget target : firstTargets) {
            if (!secondTargets.contains(target)) continue;
            intersection.add(target);
        }
        Pointer.AssignListOfTargets op = new Pointer.AssignListOfTargets(intersection);
        this.pointerOpForAllAliases(op, firstPointer, false);
        this.pointerOpForAllAliases(op, secondPointer, false);
        this.mergeAliases(firstPointer.getLocation(), secondPointer.getLocation());
    }

    public void pointerOpAssumeEquality(Pointer pointer, Memory.PointerTarget target) {
        if (pointer.getNumberOfTargets() != 1 || !pointer.contains(target)) {
            this.pointerOpForAllAliases(new Pointer.Assign(target), pointer, false);
            this.findAndMergePossibleAliases(pointer);
        }
    }

    public void pointerOpAssumeInequality(Pointer firstPointer, Pointer secondPointer) {
        if (this.areAliases(firstPointer, secondPointer)) {
            throw new IllegalStateException("Aliased pointers cannot be inequal.");
        }
        if (firstPointer.getNumberOfTargets() == 1) {
            this.pointerOpAssumeInequality(secondPointer, firstPointer.getFirstTarget());
        } else if (secondPointer.getNumberOfTargets() == 1) {
            this.pointerOpAssumeInequality(firstPointer, secondPointer.getFirstTarget());
        }
    }

    public void pointerOpAssumeInequality(Pointer pointer, Memory.PointerTarget target) {
        if (target != INVALID_POINTER && target != UNKNOWN_POINTER && target != UNINITIALIZED_POINTER && pointer.contains(target)) {
            this.pointerOpForAllAliases(new Pointer.AssumeInequality(target), pointer, true);
            this.findAndMergePossibleAliases(pointer);
        }
    }

    public Set<Memory.MemoryRegion> checkMemoryLeak() {
        HashSet<Memory.MemoryRegion> unmarkedRegions = new HashSet<Memory.MemoryRegion>(this.mallocs);
        HashSet<Memory.MemoryRegion> unreferencedRegions = new HashSet<Memory.MemoryRegion>();
        if (unmarkedRegions.isEmpty()) {
            return unreferencedRegions;
        }
        for (Memory.PointerTarget memAddress : this.reverseRelation.keySet()) {
            Set<Memory.PointerLocation> pointersToMem;
            if (!(memAddress instanceof Memory.MemoryAddress) || !(pointersToMem = this.reverseRelation.get(memAddress)).isEmpty()) continue;
            unreferencedRegions.add(((Memory.MemoryAddress)memAddress).getRegion());
        }
        return unreferencedRegions;
    }

    private boolean checkMemoryLeak(Set<Memory.MemoryRegion> unmarkedRegions, Pointer p) {
        for (Memory.PointerTarget target : p.getTargets()) {
            Memory.MemoryRegion memRegion;
            boolean unmarked;
            if (target == Memory.UNKNOWN_POINTER) {
                return true;
            }
            if (!(target instanceof Memory.MemoryAddress) || !(unmarked = unmarkedRegions.contains(memRegion = ((Memory.MemoryAddress)target).getRegion()))) continue;
            unmarkedRegions.remove(memRegion);
            for (Memory.MemoryAddress heapMem : this.heap.keySet()) {
                if (!unmarkedRegions.contains(heapMem.getRegion()) || heapMem.getRegion() != memRegion) continue;
                this.checkMemoryLeak(unmarkedRegions, this.heap.get(heapMem));
            }
        }
        return false;
    }

    public void callFunction(String functionName) {
        this.currentFunctionName = this.currentFunctionName.equals("") ? functionName : this.currentFunctionName + ':' + functionName;
        this.stack.put(this.currentFunctionName, new HashMap());
    }

    public void returnFromFunction() {
        assert (this.currentFunctionName != "" && this.currentFunctionName.contains(":")) : "Cannot return from global context or main function!";
        String oldFunctionName = this.currentFunctionName;
        this.currentFunctionName = this.currentFunctionName.substring(0, this.currentFunctionName.lastIndexOf(58));
        Iterator<Memory.PointerLocation> tempIt = this.tempTracked.iterator();
        while (tempIt.hasNext()) {
            Memory.PointerLocation loc = tempIt.next();
            if (!(loc instanceof Memory.LocalVariable) || !oldFunctionName.equals(((Memory.LocalVariable)loc).getFunctionName())) continue;
            tempIt.remove();
        }
        Iterator<Memory.PointerLocation> aliasIt = this.aliases.keySet().iterator();
        while (aliasIt.hasNext()) {
            Memory.PointerLocation loc = aliasIt.next();
            if (!(loc instanceof Memory.LocalVariable) || !oldFunctionName.equals(((Memory.LocalVariable)loc).getFunctionName())) continue;
            this.aliases.get(loc).remove(loc);
            aliasIt.remove();
        }
        Iterator<Memory.PointerTarget> reverseIt = this.reverseRelation.keySet().iterator();
        while (reverseIt.hasNext()) {
            Memory.PointerLocation loc;
            Memory.PointerTarget target = reverseIt.next();
            Set<Memory.PointerLocation> locations = this.reverseRelation.get(target);
            Iterator<Memory.PointerLocation> itLocations = locations.iterator();
            while (itLocations.hasNext()) {
                loc = itLocations.next();
                if (!(loc instanceof Memory.LocalVariable) || !oldFunctionName.equals(((Memory.LocalVariable)loc).getFunctionName())) continue;
                itLocations.remove();
            }
            if (!(target instanceof Memory.LocalVariable) || !oldFunctionName.equals(((Memory.LocalVariable)target).getFunctionName())) continue;
            while (!locations.isEmpty()) {
                loc = locations.toArray(new Memory.PointerLocation[locations.size()])[0];
                Pointer p = loc.getPointer(this);
                PointerTransferRelation.addWarning("After returning from " + oldFunctionName + ", a reference to a local variable remains in the pointers " + this.getAliases(loc) + " = " + p, this.getCurrentEdge(), loc.toString());
                this.pointerOpForAllAliases(new Pointer.Assign(INVALID_POINTER), p, true);
                this.pointerOpAssumeInequality(p, target);
            }
            reverseIt.remove();
        }
        this.stack.remove(oldFunctionName);
    }

    public boolean isSubsetOf(PointerElement other) {
        assert (other.currentFunctionName.matches("^" + this.currentFunctionName + "(" + ':' + ".*)?$"));
        for (Map<String, Pointer> stackframe : this.stack.values()) {
            for (Pointer p : stackframe.values()) {
                Pointer otherPointer;
                if (p == null || (otherPointer = other.getPointer(p.getLocation())) != null && p.isSubsetOf(otherPointer)) continue;
                return false;
            }
        }
        for (Pointer p : this.heap.values()) {
            Pointer otherPointer;
            if (p == null || (otherPointer = other.getPointer(p.getLocation())) != null && p.isSubsetOf(otherPointer)) continue;
            return false;
        }
        return true;
    }

    public String getCurrentFunctionName() {
        return this.currentFunctionName;
    }

    public void setCurrentEdge(CFAEdge currentEdge) {
        this.currentEdge = currentEdge;
    }

    @Override
    public CFAEdge getCurrentEdge() {
        return this.currentEdge;
    }

    @Override
    public boolean isTarget() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof PointerElement)) {
            return false;
        }
        PointerElement otherElement = (PointerElement)other;
        return this.currentFunctionName.equals(otherElement.currentFunctionName) && ((Object)this.stack).equals(otherElement.stack) && this.heap.equals(otherElement.heap) && this.reverseRelation.equals(otherElement.reverseRelation) && this.aliases.equals(otherElement.aliases) && this.tempTracked.equals(otherElement.tempTracked);
    }

    public int hashCode() {
        return ((Object)this.stack).hashCode();
    }

    public PointerElement clone() {
        return new PointerElement(this.stack, this.heap, this.mallocs, this.reverseRelation, this.aliases, this.tempTracked, this.currentFunctionName, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[<global:");
        for (String var : this.getGlobalPointers().keySet()) {
            sb.append(" " + var + "=" + this.getGlobalPointers().get(var) + " ");
        }
        for (String function : this.stack.keySet()) {
            if (function.equals("")) continue;
            sb.append("> <" + function + ":");
            Map<String, Pointer> pointers = this.stack.get(function);
            for (Map.Entry<String, Pointer> var : pointers.entrySet()) {
                sb.append(" " + var.getKey() + "=" + var.getValue() + " ");
            }
        }
        sb.append("> <heap:");
        for (Memory.MemoryAddress memAddress : this.heap.keySet()) {
            sb.append(" " + memAddress + "=" + this.heap.get(memAddress));
        }
        sb.append(">]");
        return sb.toString();
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        ElementProperty prop;
        if (pProperty.toLowerCase().equals("memoryleak")) {
            boolean leak;
            if (this.properties.contains((Object)ElementProperty.MEMORY_LEAK)) {
                return true;
            }
            if (this.properties.contains((Object)ElementProperty.NO_MEMORY_LEAK)) {
                return false;
            }
            boolean bl = leak = !this.checkMemoryLeak().isEmpty();
            if (leak) {
                this.properties.add(ElementProperty.MEMORY_LEAK);
            } else {
                this.properties.add(ElementProperty.NO_MEMORY_LEAK);
            }
            return leak;
        }
        try {
            prop = ElementProperty.valueOf(pProperty);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is not defined for this CPA (\"" + this.getCPAName() + "\"");
        }
        return this.properties.contains((Object)prop);
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        throw new InvalidQueryException("The Pointer CPA does not support modification.");
    }

    @Override
    public Boolean evaluateProperty(String pProperty) throws InvalidQueryException {
        return this.checkProperty(pProperty);
    }

    @Override
    public String getCPAName() {
        return "PointerAnalysis";
    }

    void setError(boolean pError) {
        this.error = pError;
    }

    static enum ElementProperty {
        DOUBLE_FREE,
        NO_MEMORY_LEAK,
        MEMORY_LEAK,
        UNSAFE_DEREFERENCE,
        POTENTIALLY_UNSAFE_DEREFERENCE,
        INVALID_FREE;

    }
}

