/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.IASTArrayTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCompositeTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTElaboratedTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTEnumerationSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTPointerTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.explicit.ExplicitElement;
import org.sosy_lab.cpachecker.cpa.pointer.Memory;
import org.sosy_lab.cpachecker.cpa.pointer.Pointer;
import org.sosy_lab.cpachecker.cpa.pointer.PointerElement;
import org.sosy_lab.cpachecker.cpa.types.Type;
import org.sosy_lab.cpachecker.cpa.types.TypesElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;

public class PointerTransferRelation
implements TransferRelation {
    private static final String RETURN_VALUE_VARIABLE = "___cpa_temp_result_var_";
    private MissingInformation missing = null;
    private static boolean printWarnings = false;
    private static Set<Pair<Integer, String>> warnings = null;
    private static LogManager logger = null;
    private static LinkedList<Memory.MemoryRegion> memoryLeakWarnings = null;
    private FunctionDefinitionNode entryFunctionDefinitionNode = null;
    private boolean entryFunctionProcessed = false;

    public PointerTransferRelation(boolean pPrintWarnings, LogManager pLogger) {
        printWarnings = pPrintWarnings;
        warnings = printWarnings ? new HashSet() : null;
        logger = pLogger;
        memoryLeakWarnings = printWarnings ? new LinkedList() : null;
    }

    public static void addWarning(String message, CFAEdge edge, String variable) {
        if (printWarnings) {
            Pair warningIndex;
            Integer lineNumber = null;
            if (edge != null) {
                lineNumber = edge.getLineNumber();
            }
            if (!warnings.contains(warningIndex = Pair.of(lineNumber, (Object)variable))) {
                warnings.add((Pair<Integer, String>)warningIndex);
                if (lineNumber != null) {
                    logger.log(Level.WARNING, new Object[]{"Warning: " + message + " in line " + lineNumber + ": " + edge.getDescription()});
                } else {
                    logger.log(Level.WARNING, new Object[]{"Warning: " + message});
                }
            }
        }
    }

    public static void addMemoryLeakWarning(String message, CFAEdge edge, Memory.MemoryRegion memoryRegion) {
        if (printWarnings) {
            Memory.MemoryRegion warningIndex;
            Integer lineNumber = null;
            if (edge != null) {
                lineNumber = edge.getLineNumber();
            }
            if (!memoryLeakWarnings.contains(warningIndex = memoryRegion)) {
                memoryLeakWarnings.add(warningIndex);
                if (lineNumber != null) {
                    logger.log(Level.WARNING, new Object[]{"Warning: " + message + " in line " + lineNumber + ": " + edge.getDescription()});
                } else {
                    logger.log(Level.WARNING, new Object[]{"Warning: " + message});
                }
            }
        }
    }

    private static void addError(String message, CFAEdge edge) {
        if (printWarnings) {
            int lineNumber = edge.getLineNumber();
            logger.log(Level.WARNING, new Object[]{"ERROR: " + message + " in line " + lineNumber + ": " + edge.getDescription()});
        }
    }

    public Collection<PointerElement> getAbstractSuccessors(AbstractElement element, Precision precision, CFAEdge cfaEdge) throws CPATransferException {
        PointerElement successor = ((PointerElement)element).clone();
        if (successor.isTarget()) {
            return Collections.emptySet();
        }
        successor.setCurrentEdge(cfaEdge);
        successor.clearProperties();
        try {
            switch (cfaEdge.getEdgeType()) {
                case DeclarationEdge: {
                    DeclarationEdge declEdge = (DeclarationEdge)cfaEdge;
                    if (declEdge.getDeclaration() instanceof IASTVariableDeclaration) {
                        IASTVariableDeclaration decl = (IASTVariableDeclaration)declEdge.getDeclaration();
                        this.handleDeclaration(successor, cfaEdge, decl.isGlobal(), decl.getName(), decl.getDeclSpecifier());
                    }
                    break;
                }
                case StatementEdge: {
                    this.handleStatement(successor, ((StatementEdge)cfaEdge).getStatement(), (StatementEdge)cfaEdge);
                    break;
                }
                case ReturnStatementEdge: {
                    Pointer resultPointer;
                    IASTExpression expression = ((ReturnStatementEdge)cfaEdge).getExpression();
                    if (expression != null && (resultPointer = successor.lookupPointer(RETURN_VALUE_VARIABLE)) != null) {
                        this.handleAssignment(successor, RETURN_VALUE_VARIABLE, resultPointer, false, expression, cfaEdge);
                    }
                    break;
                }
                case AssumeEdge: {
                    AssumeEdge assumeEdge = (AssumeEdge)cfaEdge;
                    this.handleAssume(successor, assumeEdge.getExpression(), assumeEdge.getTruthAssumption(), assumeEdge);
                    break;
                }
                case FunctionCallEdge: {
                    this.handleFunctionCall(successor, cfaEdge);
                    break;
                }
                case FunctionReturnEdge: {
                    FunctionReturnEdge returnEdge = (FunctionReturnEdge)cfaEdge;
                    CallToReturnEdge ctrEdge = returnEdge.getSuccessor().getEnteringSummaryEdge();
                    this.handleReturnFromFunction(successor, ctrEdge.getExpression(), ctrEdge);
                    break;
                }
                case BlankEdge: {
                    if (!this.entryFunctionProcessed && cfaEdge.getPredecessor() instanceof CFAFunctionDefinitionNode) {
                        successor.callFunction(this.entryFunctionDefinitionNode.getFunctionName());
                        List<IASTParameterDeclaration> l = this.entryFunctionDefinitionNode.getFunctionParameters();
                        for (IASTParameterDeclaration dec : l) {
                            IType declSpecifier = dec.getDeclSpecifier();
                            this.handleDeclaration(successor, cfaEdge, false, dec.getName(), declSpecifier);
                        }
                        this.entryFunctionProcessed = true;
                    }
                    break;
                }
                default: {
                    throw new UnrecognizedCFAEdgeException(cfaEdge);
                }
            }
        }
        catch (Memory.InvalidPointerException e) {
            PointerTransferRelation.addError(e.getMessage(), cfaEdge);
            if (successor.getProperties().isEmpty()) {
                logger.log(Level.WARNING, new Object[]{"InvalidPointerException thrown but no Flag set"});
            }
            return Collections.singleton(successor);
        }
        catch (UnreachableStateException e) {
            return Collections.emptySet();
        }
        Collection lostRegions = successor.checkMemoryLeak();
        if (!lostRegions.isEmpty()) {
            for (Memory.MemoryRegion lostRegion : lostRegions) {
                PointerTransferRelation.addMemoryLeakWarning("Memory leak: " + lostRegion + " is not freed and has no known pointer towards it", cfaEdge, lostRegion);
            }
        }
        return Collections.singleton(successor);
    }

    private void handleDeclaration(PointerElement element, CFAEdge edge, boolean global, String name, IType specifier) throws CPATransferException {
        if (name == null) {
            throw new UnrecognizedCCodeException("not expected in CIL", edge);
        }
        if (specifier instanceof IASTCompositeTypeSpecifier || specifier instanceof IASTElaboratedTypeSpecifier || specifier instanceof IASTEnumerationSpecifier) {
            return;
        }
        String varName = name;
        if (specifier instanceof IASTArrayTypeSpecifier) {
            Pointer p = new Pointer(1);
            if (global) {
                element.addNewGlobalPointer(varName, p);
            } else {
                element.addNewLocalPointer(varName, p);
            }
            IType nestedSpecifier = ((IASTArrayTypeSpecifier)specifier).getType();
            if (!(nestedSpecifier instanceof IASTSimpleDeclSpecifier)) {
                throw new UnrecognizedCCodeException("unsupported array declaration", edge);
            }
            IASTExpression lengthExpression = ((IASTArrayTypeSpecifier)specifier).getLength();
            if (!(lengthExpression instanceof IASTLiteralExpression)) {
                throw new UnrecognizedCCodeException("variable sized stack arrays are not supported", edge);
            }
            long length = this.parseIntegerLiteral((IASTLiteralExpression)lengthExpression, edge);
            Memory.StackArrayCell array = new Memory.StackArrayCell(element.getCurrentFunctionName(), new Memory.StackArray(varName, length));
            element.pointerOp(new Pointer.Assign(array), p);
            this.missing = new MissingInformation();
            this.missing.typeInformationPointer = p;
            this.missing.typeInformationEdge = edge;
            this.missing.typeInformationName = name;
        } else if (specifier instanceof IASTPointerTypeSpecifier) {
            int depth = 0;
            IType nestedSpecifier = specifier;
            do {
                nestedSpecifier = ((IASTPointerTypeSpecifier)nestedSpecifier).getType();
                ++depth;
            } while (nestedSpecifier instanceof IASTPointerTypeSpecifier);
            if (nestedSpecifier instanceof IASTElaboratedTypeSpecifier) {
                Pointer ptr = new Pointer(depth);
                if (global) {
                    element.addNewGlobalPointer(varName, ptr);
                    element.pointerOp(new Pointer.Assign(Memory.UNINITIALIZED_POINTER), ptr);
                } else {
                    element.addNewLocalPointer(varName, ptr);
                    if (this.entryFunctionProcessed) {
                        element.pointerOp(new Pointer.Assign(Memory.UNINITIALIZED_POINTER), ptr);
                    } else {
                        element.pointerOp(new Pointer.Assign(Memory.UNKNOWN_POINTER), ptr);
                    }
                }
                this.missing = new MissingInformation();
                this.missing.typeInformationPointer = ptr;
                this.missing.typeInformationEdge = edge;
                this.missing.typeInformationName = name;
            } else {
                Pointer p = new Pointer(depth);
                if (global) {
                    element.addNewGlobalPointer(varName, p);
                    element.pointerOp(new Pointer.Assign(Memory.UNINITIALIZED_POINTER), p);
                } else {
                    element.addNewLocalPointer(varName, p);
                    Memory.PointerTarget pTarg = !this.entryFunctionProcessed ? Memory.UNKNOWN_POINTER : Memory.UNINITIALIZED_POINTER;
                    element.pointerOp(new Pointer.Assign(pTarg), p);
                }
                this.missing = new MissingInformation();
                this.missing.typeInformationPointer = p;
                this.missing.typeInformationEdge = edge;
                this.missing.typeInformationName = name;
            }
        } else if (global) {
            element.addNewGlobalPointer(varName, null);
        } else {
            element.addNewLocalPointer(varName, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAssume(PointerElement element, IASTExpression expression, boolean isTrueBranch, AssumeEdge assumeEdge) throws UnrecognizedCCodeException, UnreachableStateException, Memory.InvalidPointerException {
        if (expression instanceof IASTBinaryExpression) {
            IASTBinaryExpression binaryExpression = (IASTBinaryExpression)expression;
            if (binaryExpression.getOperator() == IASTBinaryExpression.BinaryOperator.EQUALS) {
                this.handleBinaryAssume(element, binaryExpression, isTrueBranch, assumeEdge);
                return;
            } else {
                if (binaryExpression.getOperator() != IASTBinaryExpression.BinaryOperator.NOT_EQUALS) return;
                this.handleBinaryAssume(element, binaryExpression, !isTrueBranch, assumeEdge);
            }
            return;
        } else if (expression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
            if (unaryExpression.getOperator() == IASTUnaryExpression.UnaryOperator.NOT) {
                this.handleAssume(element, unaryExpression.getOperand(), !isTrueBranch, assumeEdge);
                return;
            } else {
                if (unaryExpression.getOperator() != IASTUnaryExpression.UnaryOperator.STAR) throw new UnrecognizedCCodeException("not expected in CIL", assumeEdge, expression);
                String varName = expression.toASTString();
                Pointer p = element.lookupPointer(varName);
                if (p == null) {
                    throw new UnrecognizedCCodeException("Trying to dereference a non-pointer variable", assumeEdge, expression);
                }
                boolean isNull = p.contains(Memory.NULL_POINTER);
                boolean isUninitialized = p.contains(Memory.UNINITIALIZED_POINTER);
                if (isNull && p.getNumberOfTargets() == 1) {
                    PointerTransferRelation.addError("Trying to dereference a NULL pointer", assumeEdge);
                }
                if (isUninitialized && p.getNumberOfTargets() == 1) {
                    PointerTransferRelation.addWarning("Trying to dereference an uninitialized pointer", assumeEdge, varName);
                }
                if (!isTrueBranch) return;
                element.pointerOpAssumeInequality(p, Memory.NULL_POINTER);
            }
            return;
        } else if (expression instanceof IASTIdExpression) {
            String varName = ((IASTIdExpression)expression).getName();
            Pointer p = element.lookupPointer(varName);
            if (p == null) {
                return;
            }
            boolean isNull = p.contains(Memory.NULL_POINTER);
            if (isTrueBranch && isNull && p.getNumberOfTargets() == 1) {
                throw new UnreachableStateException();
            }
            if (!isTrueBranch && !isNull) {
                throw new UnreachableStateException();
            }
            if (isTrueBranch) {
                element.pointerOpAssumeInequality(p, Memory.NULL_POINTER);
                return;
            } else {
                element.pointerOpAssumeEquality(p, Memory.NULL_POINTER);
            }
            return;
        } else {
            if (!(expression instanceof IASTCastExpression)) return;
            this.handleAssume(element, ((IASTCastExpression)expression).getOperand(), isTrueBranch, assumeEdge);
        }
    }

    private void handleBinaryAssume(PointerElement element, IASTBinaryExpression expression, boolean isTrueBranch, AssumeEdge assumeEdge) throws UnrecognizedCCodeException, UnreachableStateException {
        IASTExpression leftOp = expression.getOperand1();
        IASTExpression rightOp = expression.getOperand2();
        Pointer leftPointer = element.lookupPointer(leftOp.toASTString());
        Pointer rightPointer = element.lookupPointer(rightOp.toASTString());
        if (leftPointer != null && rightPointer != null) {
            if (element.areAliases(leftPointer, rightPointer)) {
                if (!isTrueBranch) {
                    throw new UnreachableStateException();
                }
            } else if (leftPointer.isDifferentFrom(rightPointer)) {
                if (isTrueBranch) {
                    throw new UnreachableStateException();
                }
            } else if (isTrueBranch) {
                element.pointerOpAssumeEquality(leftPointer, rightPointer);
            } else {
                element.pointerOpAssumeInequality(leftPointer, rightPointer);
            }
        }
    }

    private void handleFunctionCall(PointerElement element, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        FunctionDefinitionNode funcDefNode = (FunctionDefinitionNode)cfaEdge.getSuccessor();
        String funcName = funcDefNode.getFunctionName();
        List<String> formalParameters = funcDefNode.getFunctionParameterNames();
        List<IASTExpression> actualParameters = ((FunctionCallEdge)cfaEdge).getArguments();
        if (formalParameters != null && formalParameters.size() > 0 && !actualParameters.isEmpty()) {
            int i;
            ArrayList<Pointer> actualValues = new ArrayList<Pointer>();
            assert (formalParameters.size() == actualParameters.size());
            for (i = 0; i < actualParameters.size(); ++i) {
                IASTExpression parameter = actualParameters.get(i);
                if (parameter instanceof IASTIdExpression) {
                    Pointer p = element.lookupPointer(((IASTIdExpression)parameter).getName());
                    actualValues.add(p);
                    continue;
                }
                if (parameter instanceof IASTLiteralExpression) {
                    IASTLiteralExpression literal = (IASTLiteralExpression)parameter;
                    if (literal instanceof IASTIntegerLiteralExpression && this.parseIntegerLiteral(literal, cfaEdge) == 0L) {
                        actualValues.add(new Pointer());
                        continue;
                    }
                    actualValues.add(null);
                    continue;
                }
                if (parameter instanceof IASTUnaryExpression) {
                    IASTUnaryExpression unaryExpression = (IASTUnaryExpression)parameter;
                    if (unaryExpression.getOperator() == IASTUnaryExpression.UnaryOperator.AMPER && unaryExpression.getOperand() instanceof IASTIdExpression) {
                        String varName = unaryExpression.getOperand().toASTString();
                        Memory.Variable var = element.lookupVariable(varName);
                        actualValues.add(new Pointer(var));
                        continue;
                    }
                    throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, unaryExpression);
                }
                throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, parameter);
            }
            element.callFunction(funcName);
            for (i = 0; i < actualValues.size(); ++i) {
                Pointer value = (Pointer)actualValues.get(i);
                if (value == null) continue;
                Pointer parameter = new Pointer();
                element.addNewLocalPointer(formalParameters.get(i), parameter);
                element.pointerOp(new Pointer.Assign(value), parameter);
            }
        } else {
            element.callFunction(funcName);
        }
        element.addNewLocalPointer(RETURN_VALUE_VARIABLE, null);
        element.addTemporaryTracking(RETURN_VALUE_VARIABLE, new Pointer());
        this.missing = new MissingInformation();
    }

    private long parseIntegerLiteral(IASTLiteralExpression expression, CFAEdge edge) throws UnrecognizedCCodeException {
        if (!(expression instanceof IASTIntegerLiteralExpression)) {
            throw new UnrecognizedCCodeException("integer expression expected", edge, expression);
        }
        return ((IASTIntegerLiteralExpression)expression).asLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleReturnFromFunction(PointerElement element, IASTFunctionCall expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        Pointer resultPointer = element.lookupPointer(RETURN_VALUE_VARIABLE);
        if (resultPointer != null) {
            for (Memory.PointerTarget resultTarget : resultPointer.getTargets()) {
                if (!(resultTarget instanceof Memory.LocalVariable)) continue;
                Memory.LocalVariable var = (Memory.LocalVariable)resultTarget;
                String function = element.getCurrentFunctionName();
                if (!function.equals(var.getFunctionName())) continue;
                PointerTransferRelation.addWarning("Function " + function + " returns reference to local variable '" + var.getVarName() + "'", cfaEdge, resultTarget.toString());
            }
        }
        element.returnFromFunction();
        if (expression instanceof IASTFunctionCallAssignmentStatement) {
            IASTFunctionCallAssignmentStatement assignExpression = (IASTFunctionCallAssignmentStatement)expression;
            IASTExpression leftOperand = assignExpression.getLeftHandSide();
            if (!(leftOperand instanceof IASTIdExpression)) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, assignExpression);
            Pointer leftPointer = element.lookupPointer(((IASTIdExpression)leftOperand).getName());
            if (leftPointer != null) {
                if (resultPointer == null) throw new UnrecognizedCCodeException("assigning non-pointer value to pointer variable", cfaEdge, assignExpression);
                element.pointerOp(new Pointer.AssignListOfTargets(resultPointer.getTargets()), leftPointer);
            }
        } else if (!(expression instanceof IASTFunctionCallStatement)) {
            throw new UnrecognizedCCodeException(cfaEdge, expression.asStatement());
        }
        Collection lostRegions = element.checkMemoryLeak();
        for (Memory.MemoryRegion lostRegion : lostRegions) {
            PointerTransferRelation.addMemoryLeakWarning("Memory leak: " + lostRegion + " is not freed and has no known pointer towards it", cfaEdge, lostRegion);
        }
    }

    private void handleStatement(PointerElement element, IASTStatement expression, StatementEdge cfaEdge) throws UnrecognizedCCodeException, Memory.InvalidPointerException {
        if (expression instanceof IASTFunctionCallStatement) {
            IASTFunctionCallExpression funcExpression = ((IASTFunctionCallStatement)expression).getFunctionCallExpression();
            String functionName = funcExpression.getFunctionNameExpression().toASTString();
            if (functionName.equals("free")) {
                this.handleFree(element, funcExpression, cfaEdge);
            } else if (functionName.equals("malloc")) {
                element.addProperty(PointerElement.ElementProperty.MEMORY_LEAK);
                PointerTransferRelation.addWarning("Memory leak because of calling malloc without using the return value!", cfaEdge, "");
            }
        } else if (expression instanceof IASTAssignment) {
            this.handleAssignmentStatement(element, (IASTAssignment)((Object)expression), cfaEdge);
        } else {
            throw new UnrecognizedCCodeException(cfaEdge, expression);
        }
    }

    private void handleFree(PointerElement element, IASTFunctionCallExpression expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException, Memory.InvalidPointerException {
        List<IASTExpression> parameters = expression.getParameterExpressions();
        if (parameters.size() != 1) {
            throw new UnrecognizedCCodeException("Wrong number of arguments for free", cfaEdge, expression);
        }
        IASTExpression parameter = parameters.get(0);
        if (parameter instanceof IASTIdExpression) {
            Pointer p = element.lookupPointer(((IASTIdExpression)parameter).getName());
            if (p == null) {
                throw new UnrecognizedCCodeException("freeing non-pointer pointer", cfaEdge, parameter);
            }
            ArrayList<Memory.PointerTarget> newTargets = new ArrayList<Memory.PointerTarget>();
            boolean success = false;
            Memory.MemoryAddress freeMem = null;
            for (Memory.PointerTarget target : p.getTargets()) {
                if (target instanceof Memory.MemoryAddress) {
                    freeMem = (Memory.MemoryAddress)target;
                    if (!freeMem.hasOffset()) {
                        PointerTransferRelation.addWarning("Possibly freeing pointer " + p.getLocation() + " to " + freeMem + " with unknown offset", cfaEdge, freeMem.toString());
                        newTargets.add(Memory.INVALID_POINTER);
                        success = true;
                        freeMem = null;
                        continue;
                    }
                    if (freeMem.getOffset() != 0L) {
                        PointerTransferRelation.addWarning("Possibly freeing pointer " + p.getLocation() + " to " + freeMem + " with offset != 0", cfaEdge, freeMem.toString());
                        continue;
                    }
                    newTargets.add(Memory.INVALID_POINTER);
                    success = true;
                    continue;
                }
                if (target.isNull()) {
                    success = true;
                    newTargets.add(Memory.NULL_POINTER);
                    continue;
                }
                if (target == Memory.UNKNOWN_POINTER) {
                    success = true;
                    newTargets.add(Memory.UNKNOWN_POINTER);
                    continue;
                }
                PointerTransferRelation.addWarning("Possibly freeing pointer " + p.getLocation() + " to " + target, cfaEdge, target.toString());
            }
            if (!success) {
                element.addProperty(PointerElement.ElementProperty.INVALID_FREE);
                throw new Memory.InvalidPointerException("Free of pointer " + p.getLocation() + " = " + p + " is impossible to succeed (all targets lead to errors)");
            }
            if ((p.getNumberOfTargets() == 1 || p.getNumberOfTargets() == 2 && p.contains(Memory.NULL_POINTER)) && freeMem != null) {
                try {
                    element.free(freeMem.getRegion());
                }
                catch (Memory.InvalidPointerException e) {
                    element.addProperty(PointerElement.ElementProperty.DOUBLE_FREE);
                    throw e;
                }
            }
        } else {
            throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, parameter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAssignmentStatement(PointerElement element, IASTAssignment expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException, Memory.InvalidPointerException {
        Pointer leftPointer;
        boolean leftDereference;
        IASTExpression leftExpression = expression.getLeftHandSide();
        String leftVarName = null;
        if (leftExpression instanceof IASTIdExpression) {
            leftDereference = false;
            leftVarName = ((IASTIdExpression)leftExpression).getName();
            leftPointer = element.lookupPointer(leftVarName);
        } else {
            if (!(leftExpression instanceof IASTUnaryExpression)) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, leftExpression);
            IASTUnaryExpression unaryExpression = (IASTUnaryExpression)leftExpression;
            if (unaryExpression.getOperator() != IASTUnaryExpression.UnaryOperator.STAR) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, unaryExpression);
            leftDereference = true;
            leftExpression = unaryExpression.getOperand();
            boolean leftCast = false;
            if (leftExpression instanceof IASTCastExpression) {
                leftCast = true;
                leftExpression = ((IASTCastExpression)leftExpression).getOperand();
            }
            if (!(leftExpression instanceof IASTIdExpression)) {
                throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, leftExpression);
            }
            leftPointer = element.lookupPointer(leftExpression.toASTString());
            leftVarName = leftExpression.toASTString();
            if (leftPointer == null) {
                element.addProperty(PointerElement.ElementProperty.UNSAFE_DEREFERENCE);
                if (!leftCast) {
                    throw new UnrecognizedCCodeException("dereferencing a non-pointer", cfaEdge, leftExpression);
                }
                PointerTransferRelation.addWarning("Casting non-pointer value " + leftExpression.toASTString() + " to pointer and dereferencing it", cfaEdge, leftExpression.toASTString());
            } else {
                if (!leftPointer.isDereferencable()) {
                    element.addProperty(PointerElement.ElementProperty.UNSAFE_DEREFERENCE);
                    throw new Memory.InvalidPointerException("Unsafe deref of pointer " + leftPointer.getLocation() + " = " + leftPointer);
                }
                if (!leftPointer.isSafe()) {
                    element.addProperty(PointerElement.ElementProperty.POTENTIALLY_UNSAFE_DEREFERENCE);
                    PointerTransferRelation.addWarning("Potentially unsafe deref of pointer " + leftPointer.getLocation() + " = " + leftPointer, cfaEdge, unaryExpression.toASTString());
                    element.pointerOpAssumeInequality(leftPointer, Memory.NULL_POINTER);
                    element.pointerOpAssumeInequality(leftPointer, Memory.INVALID_POINTER);
                    element.pointerOpAssumeInequality(leftPointer, Memory.UNINITIALIZED_POINTER);
                }
                if (!leftPointer.isPointerToPointer()) {
                    leftPointer = null;
                }
            }
        }
        IASTRightHandSide op2 = expression.getRightHandSide();
        this.handleAssignment(element, leftVarName, leftPointer, leftDereference, op2, cfaEdge);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAssignment(PointerElement element, String leftVarName, Pointer leftPointer, boolean leftDereference, IASTRightHandSide expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException, Memory.InvalidPointerException {
        if (expression instanceof IASTStringLiteralExpression) {
            element.pointerOp(new Pointer.Assign(Memory.UNKNOWN_POINTER), leftPointer, leftDereference);
        } else if (expression instanceof IASTLiteralExpression) {
            element.pointerOp(new Pointer.Assign(Memory.NULL_POINTER), leftPointer, leftDereference);
        } else if (expression instanceof IASTCastExpression) {
            this.handleAssignment(element, leftVarName, leftPointer, leftDereference, ((IASTCastExpression)expression).getOperand(), cfaEdge);
        } else if (expression instanceof IASTFunctionCallExpression) {
            IASTFunctionCallExpression funcExpression = (IASTFunctionCallExpression)expression;
            String functionName = funcExpression.getFunctionNameExpression().toASTString();
            if (functionName.equals("malloc")) {
                this.handleMalloc(element, leftPointer, leftDereference, funcExpression, cfaEdge);
            } else {
                element.pointerOp(new Pointer.Assign(Memory.UNKNOWN_POINTER), leftPointer, leftDereference);
            }
        } else if (expression instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExpression = (IASTBinaryExpression)expression;
            IASTBinaryExpression.BinaryOperator typeOfOperator = binExpression.getOperator();
            IASTExpression op1 = binExpression.getOperand1();
            IASTExpression op2 = binExpression.getOperand2();
            if (op1 instanceof IASTCastExpression) {
                op1 = ((IASTCastExpression)op1).getOperand();
            }
            if (op1 instanceof IASTIdExpression) {
                Pointer rightPointer = element.lookupPointer(((IASTIdExpression)op1).getName());
                if (rightPointer == null) {
                    if (leftPointer != null) {
                        if (element.isPointerVariable(leftPointer.getLocation())) {
                            PointerTransferRelation.addWarning("Assigning non-pointer value " + binExpression.toASTString() + " to pointer " + leftPointer.getLocation(), cfaEdge, binExpression.toASTString());
                            element.pointerOp(new Pointer.Assign(Memory.UNKNOWN_POINTER), leftPointer, leftDereference);
                        } else {
                            element.removeTemporaryTracking(leftPointer.getLocation());
                        }
                    }
                } else {
                    if (leftPointer == null) {
                        element.addTemporaryTracking(leftVarName, rightPointer);
                        leftPointer = element.lookupPointer(leftVarName);
                        assert (leftPointer != null);
                    }
                    if (typeOfOperator != IASTBinaryExpression.BinaryOperator.PLUS && typeOfOperator != IASTBinaryExpression.BinaryOperator.MINUS) {
                        throw new UnrecognizedCCodeException(cfaEdge, binExpression);
                    }
                    if (op2 instanceof IASTLiteralExpression) {
                        long offset = this.parseIntegerLiteral((IASTLiteralExpression)op2, cfaEdge);
                        if (typeOfOperator == IASTBinaryExpression.BinaryOperator.MINUS) {
                            offset = -offset;
                        }
                        element.pointerOp(new Pointer.AddOffsetAndAssign(rightPointer, offset), leftPointer);
                    } else {
                        if (!(op2 instanceof IASTIdExpression)) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, op2);
                        this.missing = new MissingInformation();
                        this.missing.actionLeftPointer = leftPointer;
                        this.missing.actionRightPointer = rightPointer;
                        this.missing.actionDereferenceFirst = leftDereference;
                        this.missing.actionOffsetNegative = typeOfOperator == IASTBinaryExpression.BinaryOperator.MINUS;
                        this.missing.actionASTNode = op2;
                    }
                }
            } else {
                if (!(op1 instanceof IASTLiteralExpression)) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, op1);
                if (leftPointer == null) {
                    return;
                }
                if (!(op2 instanceof IASTLiteralExpression)) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, op2);
                PointerTransferRelation.addWarning("Assigning non-pointer value " + binExpression.toASTString() + " to pointer " + leftPointer.getLocation(), cfaEdge, binExpression.toASTString());
                element.pointerOp(new Pointer.Assign(Memory.UNKNOWN_POINTER), leftPointer, leftDereference);
            }
        } else if (expression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
            IASTUnaryExpression.UnaryOperator op = unaryExpression.getOperator();
            if (op == IASTUnaryExpression.UnaryOperator.AMPER) {
                Memory.Variable var = element.lookupVariable(unaryExpression.getOperand().toASTString());
                element.pointerOp(new Pointer.Assign(var), leftPointer, leftDereference);
            } else if (op == IASTUnaryExpression.UnaryOperator.MINUS) {
                if (leftPointer != null) {
                    PointerTransferRelation.addWarning("Assigning non-pointer value " + unaryExpression.toASTString() + " to pointer " + leftPointer.getLocation(), cfaEdge, unaryExpression.toASTString());
                    element.pointerOp(new Pointer.Assign(Memory.UNKNOWN_POINTER), leftPointer, leftDereference);
                }
            } else {
                if (op != IASTUnaryExpression.UnaryOperator.STAR) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, unaryExpression);
                expression = unaryExpression.getOperand();
                boolean rightCast = false;
                if (expression instanceof IASTCastExpression) {
                    rightCast = true;
                    expression = ((IASTCastExpression)expression).getOperand();
                }
                if (!(expression instanceof IASTIdExpression)) {
                    throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, expression);
                }
                Pointer rightPointer = element.lookupPointer(expression.toASTString());
                if (rightPointer == null) {
                    if (!rightCast) {
                        throw new UnrecognizedCCodeException("dereferencing a non-pointer", cfaEdge, expression);
                    }
                    PointerTransferRelation.addWarning("Casting non-pointer value " + expression.toASTString() + " to pointer and dereferencing it", cfaEdge, expression.toASTString());
                } else {
                    if (!rightPointer.isDereferencable()) {
                        element.addProperty(PointerElement.ElementProperty.UNSAFE_DEREFERENCE);
                        throw new Memory.InvalidPointerException("Unsafe deref of pointer " + rightPointer.getLocation() + " = " + rightPointer);
                    }
                    if (!rightPointer.isSafe()) {
                        element.addProperty(PointerElement.ElementProperty.POTENTIALLY_UNSAFE_DEREFERENCE);
                        PointerTransferRelation.addWarning("Potentially unsafe deref of pointer " + rightPointer.getLocation() + " = " + rightPointer, cfaEdge, unaryExpression.toASTString());
                        element.pointerOpAssumeInequality(rightPointer, Memory.NULL_POINTER);
                        element.pointerOpAssumeInequality(rightPointer, Memory.INVALID_POINTER);
                        element.pointerOpAssumeInequality(rightPointer, Memory.UNINITIALIZED_POINTER);
                    }
                    if (leftPointer != null) {
                        if (!rightPointer.isPointerToPointer()) {
                            if (element.isPointerVariable(leftPointer.getLocation())) {
                                PointerTransferRelation.addWarning("Assigning non-pointer value " + unaryExpression.toASTString() + " to pointer " + leftPointer.getLocation(), cfaEdge, expression.toASTString());
                                element.pointerOp(new Pointer.Assign(Memory.UNKNOWN_POINTER), leftPointer, leftDereference);
                            } else {
                                element.removeTemporaryTracking(leftPointer.getLocation());
                            }
                        } else {
                            element.pointerOp(new Pointer.DerefAndAssign(rightPointer), leftPointer, leftDereference);
                        }
                    }
                }
            }
        } else {
            if (!(expression instanceof IASTIdExpression)) throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, expression);
            Pointer rightPointer = element.lookupPointer(((IASTIdExpression)expression).getName());
            if (leftPointer != null) {
                if (rightPointer == null) {
                    if (element.isPointerVariable(leftPointer.getLocation())) {
                        if (((IASTIdExpression)expression).getName().equals("NULL")) {
                            element.pointerOp(new Pointer.Assign(Memory.NULL_POINTER), leftPointer, leftDereference);
                        } else {
                            element.pointerOp(new Pointer.Assign(Memory.UNKNOWN_POINTER), leftPointer, leftDereference);
                            PointerTransferRelation.addWarning("Assigning non-pointer value " + expression.toASTString() + " to pointer " + leftPointer.getLocation(), cfaEdge, expression.toASTString());
                        }
                    } else {
                        element.removeTemporaryTracking(leftPointer.getLocation());
                    }
                } else {
                    element.pointerOp(new Pointer.Assign(rightPointer), leftPointer, leftDereference);
                }
            } else if (rightPointer != null && leftVarName != null) {
                element.addTemporaryTracking(leftVarName, rightPointer);
            }
        }
        if (leftPointer == null || !leftPointer.contains(Memory.UNINITIALIZED_POINTER)) return;
        element.pointerOpAssumeInequality(leftPointer, Memory.UNINITIALIZED_POINTER);
    }

    private void handleMalloc(PointerElement element, Pointer pointer, boolean leftDereference, IASTFunctionCallExpression expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        List<IASTExpression> parameters = expression.getParameterExpressions();
        if (parameters.size() != 1) {
            throw new UnrecognizedCCodeException("Wrong number of arguments for malloc", cfaEdge, expression);
        }
        IASTExpression parameter = parameters.get(0);
        Pointer.MallocAndAssign op = new Pointer.MallocAndAssign();
        element.pointerOp(op, pointer, leftDereference);
        Memory.MemoryAddress memAddress = op.getMallocResult();
        if (parameter instanceof IASTLiteralExpression) {
            long size = this.parseIntegerLiteral((IASTLiteralExpression)parameter, cfaEdge);
            if (size < 0L) {
                throw new UnrecognizedCCodeException("malloc with size < 0, but malloc takes unsigned parameter", cfaEdge, parameter);
            }
            if (size > Integer.MAX_VALUE) {
                PointerTransferRelation.addWarning("Possible sign error: malloc with size > 2GB", cfaEdge, "malloc");
            }
            memAddress.getRegion().setLength(size);
        } else if (parameter instanceof IASTIdExpression) {
            this.missing = new MissingInformation();
            this.missing.mallocSizeMemory = memAddress;
            this.missing.mallocSizeASTNode = parameter;
        } else {
            throw new UnrecognizedCCodeException("not expected in CIL", cfaEdge, parameter);
        }
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> elements, CFAEdge cfaEdge, Precision precision) throws CPATransferException {
        if (this.missing == null) {
            return null;
        }
        if (!(element instanceof PointerElement)) {
            return null;
        }
        PointerElement pointerElement = (PointerElement)element;
        for (AbstractElement ae : elements) {
            try {
                if (ae instanceof ExplicitElement) {
                    this.strengthen(pointerElement, (ExplicitElement)ae, cfaEdge, precision);
                    continue;
                }
                if (!(ae instanceof TypesElement)) continue;
                this.strengthen(pointerElement, (TypesElement)ae, cfaEdge, precision);
            }
            catch (UnrecognizedCCodeException e) {
                PointerTransferRelation.addError(e.getMessage(), cfaEdge);
                return new ArrayList();
            }
            catch (Memory.InvalidPointerException e) {
                PointerTransferRelation.addError(e.getMessage(), cfaEdge);
                return new ArrayList();
            }
        }
        if (this.missing != null && this.missing.actionLeftPointer != null) {
            Pointer.PointerOperation op = this.missing.actionRightPointer != null ? new Pointer.AddUnknownOffsetAndAssign(this.missing.actionRightPointer) : new Pointer.AddUnknownOffset();
            pointerElement.pointerOp(op, this.missing.actionLeftPointer, this.missing.actionDereferenceFirst);
        }
        this.missing = null;
        return null;
    }

    private void strengthen(PointerElement pointerElement, ExplicitElement explicitElement, CFAEdge cfaEdge, Precision precision) throws Memory.InvalidPointerException, UnrecognizedCCodeException {
        Long value;
        if (this.missing.mallocSizeMemory != null && (value = this.getVariableContent(this.missing.mallocSizeASTNode, explicitElement, cfaEdge)) != null) {
            if (value < 0L) {
                throw new UnrecognizedCCodeException("malloc with size < 0, but malloc takes unsigned parameter", cfaEdge);
            }
            if (value > Integer.MAX_VALUE) {
                PointerTransferRelation.addWarning("Possible sign error: malloc with size > 2GB", cfaEdge, "malloc");
            }
            this.missing.mallocSizeMemory.getRegion().setLength(value);
        }
        if (this.missing.actionLeftPointer != null && (value = this.getVariableContent(this.missing.actionASTNode, explicitElement, cfaEdge)) != null) {
            long val = value;
            if (this.missing.actionOffsetNegative) {
                val = -val;
            }
            Pointer.PointerOperation op = this.missing.actionRightPointer != null ? new Pointer.AddOffsetAndAssign(this.missing.actionRightPointer, val) : new Pointer.AddOffset(val);
            pointerElement.pointerOp(op, this.missing.actionLeftPointer, this.missing.actionDereferenceFirst);
            this.missing.actionLeftPointer = null;
        }
    }

    private Long getVariableContent(IASTNode variable, ExplicitElement explicitElement, CFAEdge cfaEdge) {
        String varName = variable.toASTString();
        if (!explicitElement.contains(varName)) {
            varName = cfaEdge.getPredecessor().getFunctionName() + "::" + varName;
        }
        if (explicitElement.contains(varName)) {
            return explicitElement.getValueFor(varName);
        }
        return null;
    }

    private void strengthen(PointerElement pointerElement, TypesElement typesElement, CFAEdge cfaEdge, Precision precision) throws UnrecognizedCCodeException {
        if (cfaEdge instanceof FunctionCallEdge) {
            FunctionDefinitionNode funcDefNode = (FunctionDefinitionNode)cfaEdge.getSuccessor();
            String funcName = funcDefNode.getFunctionName();
            Type.FunctionType function = typesElement.getFunction(funcName);
            for (String paramName : function.getParameters()) {
                Pointer pointer = pointerElement.lookupPointer(paramName);
                if (pointer == null) continue;
                Type type = function.getParameterType(paramName);
                this.setSizeOfTarget(pointer, type);
            }
            if (function.getReturnType().getTypeClass() != Type.TypeClass.POINTER) {
                pointerElement.removeTemporaryTracking(pointerElement.lookupVariable(RETURN_VALUE_VARIABLE));
            }
        } else {
            if (this.missing.typeInformationPointer == null) {
                return;
            }
            String functionName = cfaEdge.getSuccessor().getFunctionName();
            if (this.missing.typeInformationEdge instanceof DeclarationEdge && ((DeclarationEdge)this.missing.typeInformationEdge).getDeclaration().isGlobal()) {
                functionName = null;
            }
            String varName = this.missing.typeInformationName;
            Type type = typesElement.getVariableType(functionName, varName);
            this.setSizeOfTarget(this.missing.typeInformationPointer, type);
        }
    }

    private void handleStructDeclaration(PointerElement element, TypesElement typeElem, Type.CompositeType structType, String varName, String recursiveVarName) {
        Set<String> members = structType.getMembers();
        for (String member : members) {
            Type t = structType.getMemberType(member);
            if (t == null || t.getTypeClass() != Type.TypeClass.STRUCT) continue;
            this.handleStructDeclaration(element, typeElem, (Type.CompositeType)t, member, recursiveVarName + "." + member);
        }
    }

    private Type findType(TypesElement typeElem, CFAEdge cfaEdge, String varName) {
        Type t = null;
        t = typeElem.getTypedef(varName);
        if (t == null) {
            t = typeElem.getFunction(varName);
        }
        if (t == null) {
            t = typeElem.getVariableType(null, varName);
        }
        try {
            if (t == null) {
                t = typeElem.getVariableType(cfaEdge.getSuccessor().getFunctionName(), varName);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return t;
    }

    private Type checkForFieldReferenceType(IASTExpression exp, TypesElement typeElem, CFAEdge cfaEdge) {
        String name = exp.toASTString();
        Type t = null;
        if (exp instanceof IASTFieldReference) {
            String[] s = name.split("[.]");
            t = this.findType(typeElem, cfaEdge, s[0]);
            for (int i = 1; t != null && t.getTypeClass() == Type.TypeClass.STRUCT && i < s.length; ++i) {
                t = ((Type.CompositeType)t).getMemberType(s[i]);
            }
        } else {
            t = this.findType(typeElem, cfaEdge, name);
        }
        return t;
    }

    private void checkFields(PointerElement element, CFAEdge cfaEdge, IASTExpression exp, TypesElement typeElem, Type.CompositeType structType, String leftName, String rightName, String recursiveLeftName, String recursiveRightName) {
        Set<String> members = structType.getMembers();
        for (String member : members) {
            Type t = structType.getMemberType(member);
            if (t == null || t.getTypeClass() != Type.TypeClass.STRUCT) continue;
            this.checkFields(element, cfaEdge, exp, typeElem, (Type.CompositeType)t, member, member, recursiveLeftName + "." + member, recursiveRightName + "." + member);
        }
    }

    private void setSizeOfTarget(Pointer pointer, Type type) {
        switch (type.getTypeClass()) {
            case POINTER: {
                Type targetType = ((Type.PointerType)type).getTargetType();
                if (targetType.getTypeClass() == Type.TypeClass.STRUCT) {
                    pointer.setSizeOfTarget(1);
                    break;
                }
                pointer.setSizeOfTarget(targetType.sizeOf());
                break;
            }
            case ARRAY: {
                pointer.setSizeOfTarget(((Type.ArrayType)type).getType().sizeOf());
                break;
            }
            default: {
                PointerTransferRelation.addWarning("Types determined by TypesCPA und PointerCPA differ!", null, pointer.getLocation().toString());
            }
        }
    }

    public void setEntryFunctionDefinitionNode(FunctionDefinitionNode pEntryFunctionDefNode) {
        this.entryFunctionDefinitionNode = pEntryFunctionDefNode;
    }

    private static class MissingInformation {
        private Pointer typeInformationPointer = null;
        private CFAEdge typeInformationEdge = null;
        private String typeInformationName = null;
        private Pointer actionLeftPointer = null;
        private Pointer actionRightPointer = null;
        private boolean actionDereferenceFirst = false;
        private boolean actionOffsetNegative = false;
        private IASTNode actionASTNode = null;
        private Memory.MemoryAddress mallocSizeMemory = null;
        private IASTNode mallocSizeASTNode = null;

        private MissingInformation() {
        }
    }

    private static class UnreachableStateException
    extends Exception {
        private static final long serialVersionUID = -3075945291940304272L;

        private UnreachableStateException() {
        }
    }
}

