/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cpa.predicate.BlockOperator;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;

@Options
public class ABMBlockOperator
extends BlockOperator {
    private BlockPartitioning partitioning = null;

    void setPartitioning(BlockPartitioning pPartitioning) {
        Preconditions.checkState((this.partitioning == null ? 1 : 0) != 0);
        this.partitioning = pPartitioning;
    }

    @Override
    public boolean isBlockEnd(CFAEdge pEdge, PathFormula pPf) {
        CFANode succLoc = pEdge.getSuccessor();
        return super.isBlockEnd(pEdge, pPf) || this.partitioning.isCallNode(succLoc) || this.partitioning.isReturnNode(succLoc);
    }

    public BlockPartitioning getPartitioning() {
        Preconditions.checkState((this.partitioning != null ? 1 : 0) != 0);
        return this.partitioning;
    }
}

