/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.Collection;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithABM;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.cpa.predicate.ABMBlockOperator;
import org.sosy_lab.cpachecker.cpa.predicate.ABMPredicateCPAStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.ABMPredicateReducer;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.AuxiliaryComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.CachingRelevantPredicatesComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RefineableOccurrenceComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RelevantPredicatesComputer;

@Options(prefix="cpa.predicate.abm")
public class ABMPredicateCPA
extends PredicateCPA
implements ConfigurableProgramAnalysisWithABM {
    private final ABMPredicateReducer reducer;
    private final ABMBlockOperator blk;
    private final ABMPredicateCPAStatistics stats;
    private final RelevantPredicatesComputer relevantPredicatesComputer;
    @Option(description="whether to use auxiliary predidates for reduction")
    private boolean auxiliaryPredicateComputer = true;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ABMPredicateCPA.class).withOptions(ABMBlockOperator.class);
    }

    private ABMPredicateCPA(Configuration config, LogManager logger, ABMBlockOperator pBlk, CFA pCfa) throws InvalidConfigurationException {
        super(config, logger, pBlk, pCfa);
        config.inject((Object)this, ABMPredicateCPA.class);
        RelevantPredicatesComputer relevantPredicatesComputer = this.auxiliaryPredicateComputer ? new AuxiliaryComputer() : new RefineableOccurrenceComputer();
        relevantPredicatesComputer = new CachingRelevantPredicatesComputer(relevantPredicatesComputer);
        this.relevantPredicatesComputer = relevantPredicatesComputer;
        this.reducer = new ABMPredicateReducer(this, relevantPredicatesComputer);
        this.blk = pBlk;
        this.stats = new ABMPredicateCPAStatistics();
    }

    RelevantPredicatesComputer getRelevantPredicatesComputer() {
        return this.relevantPredicatesComputer;
    }

    BlockPartitioning getPartitioning() {
        return this.blk.getPartitioning();
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    public void setPartitioning(BlockPartitioning partitioning) {
        this.blk.setPartitioning(partitioning);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        super.collectStatistics(pStatsCollection);
        pStatsCollection.add(this.stats);
    }

    ABMPredicateCPAStatistics getABMStats() {
        return this.stats;
    }
}

