/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.predicate.ABMPredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RelevantPredicatesComputer;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;

public class ABMPredicateReducer
implements Reducer {
    static final Timer reduceTimer = new Timer();
    static final Timer expandTimer = new Timer();
    static final Timer extractTimer = new Timer();
    private final PathFormulaManager pmgr;
    private final PredicateAbstractionManager pamgr;
    private final RelevantPredicatesComputer relevantComputer;
    private final LogManager logger;
    private Map<Pair<Integer, Block>, Precision> reduceCache = new HashMap<Pair<Integer, Block>, Precision>();

    public ABMPredicateReducer(ABMPredicateCPA cpa, RelevantPredicatesComputer pRelevantPredicatesComputer) {
        this.pmgr = cpa.getPathFormulaManager();
        this.pamgr = cpa.getPredicateManager();
        this.logger = cpa.getLogger();
        this.relevantComputer = pRelevantPredicatesComputer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractElement getVariableReducedElement(AbstractElement pExpandedElement, Block pContext, CFANode pLocation) {
        PredicateAbstractElement predicateElement = (PredicateAbstractElement)pExpandedElement;
        if (!predicateElement.isAbstractionElement()) {
            return predicateElement;
        }
        reduceTimer.start();
        try {
            AbstractionFormula oldAbstraction = predicateElement.getAbstractionFormula();
            Region oldRegion = oldAbstraction.asRegion();
            Collection<AbstractionPredicate> predicates = this.extractPredicates(oldRegion);
            Set<AbstractionPredicate> removePredicates = this.relevantComputer.getIrrelevantPredicates(pContext, predicates);
            PathFormula pathFormula = predicateElement.getPathFormula();
            assert (pathFormula.getFormula().isTrue());
            AbstractionFormula newAbstraction = this.pamgr.reduce(oldAbstraction, removePredicates, pathFormula.getSsa());
            PredicateAbstractElement predicateAbstractElement = PredicateAbstractElement.abstractionElement(pathFormula, newAbstraction);
            return predicateAbstractElement;
        }
        finally {
            reduceTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractElement getVariableExpandedElement(AbstractElement pRootElement, Block pReducedContext, AbstractElement pReducedElement) {
        PredicateAbstractElement rootElement = (PredicateAbstractElement)pRootElement;
        PredicateAbstractElement reducedElement = (PredicateAbstractElement)pReducedElement;
        if (!reducedElement.isAbstractionElement()) {
            return reducedElement;
        }
        expandTimer.start();
        try {
            AbstractionFormula rootAbstraction = rootElement.getAbstractionFormula();
            AbstractionFormula reducedAbstraction = reducedElement.getAbstractionFormula();
            Collection<AbstractionPredicate> rootPredicates = this.extractPredicates(rootAbstraction.asRegion());
            Set<AbstractionPredicate> relevantRootPredicates = this.relevantComputer.getRelevantPredicates(pReducedContext, rootPredicates);
            PathFormula oldPathFormula = reducedElement.getPathFormula();
            assert (oldPathFormula.getFormula().isTrue());
            SSAMap oldSSA = oldPathFormula.getSsa();
            SSAMap.SSAMapBuilder builder = oldSSA.builder();
            SSAMap rootSSA = rootElement.getPathFormula().getSsa();
            for (String var : rootSSA.allVariables()) {
                if (oldSSA.getIndex(var) != -1) continue;
                builder.setIndex(var, rootSSA.getIndex(var));
            }
            SSAMap newSSA = builder.build();
            PathFormula newPathFormula = this.pmgr.makeNewPathFormula(oldPathFormula, newSSA);
            AbstractionFormula newAbstractionFormula = this.pamgr.expand(reducedAbstraction, rootAbstraction, relevantRootPredicates, newSSA);
            PredicateAbstractElement predicateAbstractElement = PredicateAbstractElement.abstractionElement(newPathFormula, newAbstractionFormula);
            return predicateAbstractElement;
        }
        finally {
            expandTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractionPredicate> extractPredicates(Region pRegion) {
        extractTimer.start();
        try {
            Collection<AbstractionPredicate> collection = this.pamgr.extractPredicates(pRegion);
            return collection;
        }
        finally {
            extractTimer.stop();
        }
    }

    @Override
    public Object getHashCodeForElement(AbstractElement pElementKey, Precision pPrecisionKey) {
        PredicateAbstractElement element = (PredicateAbstractElement)pElementKey;
        PredicatePrecision precision = (PredicatePrecision)pPrecisionKey;
        return Pair.of((Object)element.getAbstractionFormula().asRegion(), (Object)precision);
    }

    public void clearCaches() {
        this.reduceCache.clear();
    }

    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        PredicatePrecision precision = (PredicatePrecision)pPrecision;
        Pair key = Pair.of((Object)precision.getId(), (Object)pContext);
        Precision result = this.reduceCache.get(key);
        if (result != null) {
            return result;
        }
        result = new ReducedPredicatePrecision(precision, pContext);
        this.reduceCache.put((Pair<Integer, Block>)key, result);
        return result;
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision pRootPrecision, Block pRootContext, Precision pReducedPrecision) {
        PredicatePrecision derivedToplevelPrecision;
        PredicatePrecision rootPrecision;
        PredicatePrecision toplevelPrecision = rootPrecision = (PredicatePrecision)pRootPrecision;
        if (rootPrecision instanceof ReducedPredicatePrecision) {
            toplevelPrecision = ((ReducedPredicatePrecision)rootPrecision).getRootPredicatePrecision();
        }
        if ((derivedToplevelPrecision = ((ReducedPredicatePrecision)pReducedPrecision).getRootPredicatePrecision()) == toplevelPrecision) {
            return pRootPrecision;
        }
        PredicatePrecision mergedToplevelPrecision = this.mergePrecisions(toplevelPrecision, derivedToplevelPrecision);
        return this.getVariableReducedPrecision(mergedToplevelPrecision, pRootContext);
    }

    private PredicatePrecision mergePrecisions(PredicatePrecision lhs, PredicatePrecision rhs) {
        HashSet<AbstractionPredicate> globalPredicates = new HashSet<AbstractionPredicate>();
        globalPredicates.addAll(rhs.getGlobalPredicates());
        globalPredicates.addAll(lhs.getGlobalPredicates());
        ImmutableSetMultimap.Builder pmapBuilder = ImmutableSetMultimap.builder();
        pmapBuilder.putAll(rhs.getPredicateMap());
        pmapBuilder.putAll(lhs.getPredicateMap());
        return new PredicatePrecision((ImmutableSetMultimap<CFANode, AbstractionPredicate>)pmapBuilder.build(), globalPredicates);
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        PredicatePrecision precision = (PredicatePrecision)pPrecision;
        PredicatePrecision otherPrecision = (PredicatePrecision)pOtherPrecision;
        int distance = 0;
        for (AbstractionPredicate p : precision.getGlobalPredicates()) {
            if (otherPrecision.getGlobalPredicates().contains(p)) continue;
            ++distance;
        }
        for (CFANode node : precision.getPredicateMap().keySet()) {
            for (AbstractionPredicate p : precision.getPredicateMap().get((Object)node)) {
                if (otherPrecision.getPredicateMap().get((Object)node).contains(p)) continue;
                ++distance;
            }
        }
        return distance;
    }

    private class ReducedPredicatePrecision
    extends PredicatePrecision {
        private final PredicatePrecision rootPredicatePrecision;
        private final PredicatePrecision expandedPredicatePrecision;
        private final Block context;
        private ImmutableSetMultimap<CFANode, AbstractionPredicate> evaluatedPredicateMap;
        private ImmutableSet<AbstractionPredicate> evaluatedGlobalPredicates;

        public ReducedPredicatePrecision(PredicatePrecision expandedPredicatePrecision, Block context) {
            super(null);
            this.expandedPredicatePrecision = expandedPredicatePrecision;
            this.context = context;
            this.rootPredicatePrecision = expandedPredicatePrecision instanceof ReducedPredicatePrecision ? ((ReducedPredicatePrecision)expandedPredicatePrecision).getRootPredicatePrecision() : expandedPredicatePrecision;
            assert (!(this.rootPredicatePrecision instanceof ReducedPredicatePrecision));
            this.evaluatedPredicateMap = null;
            this.evaluatedGlobalPredicates = null;
        }

        public PredicatePrecision getRootPredicatePrecision() {
            return this.rootPredicatePrecision;
        }

        private void computeView() {
            if (this.evaluatedPredicateMap == null) {
                ReducedPredicatePrecision lExpandedPredicatePrecision = null;
                if (this.expandedPredicatePrecision instanceof ReducedPredicatePrecision) {
                    lExpandedPredicatePrecision = (ReducedPredicatePrecision)this.expandedPredicatePrecision;
                }
                this.evaluatedGlobalPredicates = ImmutableSet.copyOf(ABMPredicateReducer.this.relevantComputer.getRelevantPredicates(this.context, this.rootPredicatePrecision.getGlobalPredicates()));
                ImmutableSetMultimap.Builder pmapBuilder = ImmutableSetMultimap.builder();
                Set keySet = lExpandedPredicatePrecision == null ? this.rootPredicatePrecision.getPredicateMap().keySet() : lExpandedPredicatePrecision.approximatePredicateMap().keySet();
                for (CFANode node : keySet) {
                    if (!this.context.getNodes().contains(node)) continue;
                    Set<AbstractionPredicate> set = ABMPredicateReducer.this.relevantComputer.getRelevantPredicates(this.context, this.rootPredicatePrecision.getPredicates(node));
                    pmapBuilder.putAll((Object)node, set);
                }
                this.evaluatedPredicateMap = pmapBuilder.build();
            }
        }

        private SetMultimap<CFANode, AbstractionPredicate> approximatePredicateMap() {
            if (this.evaluatedPredicateMap == null) {
                return this.rootPredicatePrecision.getPredicateMap();
            }
            return this.evaluatedPredicateMap;
        }

        @Override
        public SetMultimap<CFANode, AbstractionPredicate> getPredicateMap() {
            this.computeView();
            return this.evaluatedPredicateMap;
        }

        @Override
        public Set<AbstractionPredicate> getGlobalPredicates() {
            if (this.evaluatedGlobalPredicates != null) {
                return this.evaluatedGlobalPredicates;
            }
            return ABMPredicateReducer.this.relevantComputer.getRelevantPredicates(this.context, this.rootPredicatePrecision.getGlobalPredicates());
        }

        @Override
        public Set<AbstractionPredicate> getPredicates(CFANode loc) {
            if (!this.context.getNodes().contains(loc)) {
                ABMPredicateReducer.this.logger.log(Level.WARNING, new Object[]{this.context, "was left in an unexpected way. Analysis might be unsound."});
            }
            if (this.evaluatedPredicateMap != null) {
                ImmutableSet<AbstractionPredicate> result = this.evaluatedPredicateMap.get((Object)loc);
                if (result.isEmpty()) {
                    result = this.evaluatedGlobalPredicates;
                }
                return result;
            }
            Set<AbstractionPredicate> result = ABMPredicateReducer.this.relevantComputer.getRelevantPredicates(this.context, this.rootPredicatePrecision.getPredicates(loc));
            if (result.isEmpty()) {
                result = ABMPredicateReducer.this.relevantComputer.getRelevantPredicates(this.context, this.rootPredicatePrecision.getGlobalPredicates());
            }
            return result;
        }

        @Override
        public boolean equals(Object pObj) {
            if (pObj == this) {
                return true;
            }
            if (!(pObj instanceof ReducedPredicatePrecision)) {
                return false;
            }
            this.computeView();
            return this.evaluatedPredicateMap.equals(((ReducedPredicatePrecision)pObj).evaluatedPredicateMap);
        }

        @Override
        public int hashCode() {
            this.computeView();
            return this.evaluatedPredicateMap.hashCode();
        }

        @Override
        public String toString() {
            if (this.evaluatedPredicateMap != null) {
                return this.evaluatedPredicateMap.toString();
            }
            return "ReducedPredicatePrecision (view not computed yet)";
        }
    }
}

