/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.abm.AbstractABMBasedRefiner;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.cpa.predicate.ABMPredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.ABMPredicateReducer;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateRefinementManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RefineableRelevantPredicatesComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RelevantPredicatesComputer;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

public final class ABMPredicateRefiner
extends AbstractABMBasedRefiner
implements StatisticsProvider {
    private final ExtendedPredicateRefiner refiner;

    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        return new ABMPredicateRefiner(pCpa);
    }

    public ABMPredicateRefiner(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        super(pCpa);
        if (!(pCpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException(ABMPredicateRefiner.class.getSimpleName() + " could not find the PredicateCPA");
        }
        ABMPredicateCPA predicateCpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(ABMPredicateCPA.class);
        if (predicateCpa == null) {
            throw new InvalidConfigurationException(ABMPredicateRefiner.class.getSimpleName() + " needs an ABMPredicateCPA");
        }
        LogManager logger = predicateCpa.getLogger();
        PredicateRefinementManager manager = new PredicateRefinementManager(predicateCpa.getFormulaManager(), predicateCpa.getPathFormulaManager(), predicateCpa.getSolver(), predicateCpa.getAbstractionManager(), predicateCpa.getFormulaManagerFactory(), predicateCpa.getConfiguration(), logger);
        this.refiner = new ExtendedPredicateRefiner(predicateCpa.getConfiguration(), logger, pCpa, predicateCpa, manager);
    }

    @Override
    protected final CounterexampleInfo performRefinement0(ARTReachedSet pReached, Path pPath) throws CPAException, InterruptedException {
        return this.refiner.performRefinement(pReached, pPath);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        this.refiner.collectStatistics(pStatsCollection);
    }

    static final class ExtendedPredicateRefiner
    extends PredicateRefiner {
        final Timer ssaRenamingTimer = new Timer();
        private final PathFormulaManager pfmgr;
        private final RefineableRelevantPredicatesComputer relevantPredicatesComputer;
        private final ABMPredicateCPA predicateCpa;
        private List<Region> lastAbstractions = null;
        private boolean refinedLastRelevantPredicatesComputer = false;
        private static final Function<PredicateAbstractElement, Region> GET_REGION = new Function<PredicateAbstractElement, Region>(){

            public Region apply(PredicateAbstractElement e) {
                assert (e.isAbstractionElement());
                return e.getAbstractionFormula().asRegion();
            }
        };

        private ExtendedPredicateRefiner(Configuration config, LogManager logger, ConfigurableProgramAnalysis pCpa, ABMPredicateCPA predicateCpa, PredicateRefinementManager pInterpolationManager) throws CPAException, InvalidConfigurationException {
            super(config, logger, pCpa, pInterpolationManager);
            this.pfmgr = predicateCpa.getPathFormulaManager();
            RelevantPredicatesComputer relevantPredicatesComputer = predicateCpa.getRelevantPredicatesComputer();
            this.relevantPredicatesComputer = relevantPredicatesComputer instanceof RefineableRelevantPredicatesComputer ? (RefineableRelevantPredicatesComputer)relevantPredicatesComputer : null;
            this.predicateCpa = predicateCpa;
            predicateCpa.getABMStats().addRefiner(this);
        }

        @Override
        protected final CounterexampleInfo performRefinement(ARTReachedSet pReached, Path pPath) throws CPAException, InterruptedException {
            return super.performRefinement(pReached, pPath);
        }

        private List<Region> getRegionsForPath(List<Pair<ARTElement, CFANode>> path) throws CPATransferException {
            return Lists.transform(path, (Function)Functions.compose(GET_REGION, (Function)Functions.compose(AbstractElements.extractElementByTypeFunction(PredicateAbstractElement.class), (Function)Pair.getProjectionToFirst())));
        }

        @Override
        protected void performRefinement(ARTReachedSet pReached, List<Pair<ARTElement, CFANode>> pPath, CounterexampleTraceInfo<Collection<AbstractionPredicate>> pCounterexample, boolean pRepeatedCounterexample) throws CPAException {
            boolean refinedRelevantPredicatesComputer = false;
            if (pRepeatedCounterexample && (pRepeatedCounterexample = ((Object)this.getRegionsForPath(pPath)).equals(this.lastAbstractions)) && !this.refinedLastRelevantPredicatesComputer && this.relevantPredicatesComputer != null) {
                this.refineRelevantPredicatesComputer(pPath, pReached);
                pRepeatedCounterexample = false;
                refinedRelevantPredicatesComputer = true;
            }
            this.lastAbstractions = this.getRegionsForPath(pPath);
            this.refinedLastRelevantPredicatesComputer = refinedRelevantPredicatesComputer;
            super.performRefinement(pReached, pPath, pCounterexample, pRepeatedCounterexample);
        }

        private void refineRelevantPredicatesComputer(List<Pair<ARTElement, CFANode>> pPath, ARTReachedSet pReached) {
            ReachedSet reached = pReached.asReachedSet();
            Precision oldPrecision = reached.getPrecision(reached.getLastElement());
            PredicatePrecision oldPredicatePrecision = Precisions.extractPrecisionByType(oldPrecision, PredicatePrecision.class);
            BlockPartitioning partitioning = this.predicateCpa.getPartitioning();
            ArrayDeque<Block> openBlocks = new ArrayDeque<Block>();
            openBlocks.push(partitioning.getMainBlock());
            for (Pair<ARTElement, CFANode> pathElement : pPath) {
                CFANode currentNode = (CFANode)pathElement.getSecond();
                if (partitioning.isCallNode(currentNode)) {
                    openBlocks.push(partitioning.getBlockForCallNode(currentNode));
                }
                Set<AbstractionPredicate> localPreds = oldPredicatePrecision.getPredicates(currentNode);
                for (Block block : openBlocks) {
                    for (AbstractionPredicate pred : localPreds) {
                        this.relevantPredicatesComputer.considerPredicateAsRelevant(block, pred);
                    }
                }
                while (((Block)openBlocks.peek()).isReturnNode(currentNode)) {
                    openBlocks.pop();
                }
            }
            ((ABMPredicateReducer)this.predicateCpa.getReducer()).clearCaches();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final List<Formula> getFormulasForPath(List<Pair<ARTElement, CFANode>> pPath, ARTElement initialElement) throws CPATransferException {
            this.ssaRenamingTimer.start();
            try {
                List<Formula> list = this.computeBlockFormulas(initialElement);
                return list;
            }
            finally {
                this.ssaRenamingTimer.stop();
            }
        }

        private List<Formula> computeBlockFormulas(ARTElement pRoot) throws CPATransferException {
            HashMap<ARTElement, PathFormula> formulas = new HashMap<ARTElement, PathFormula>();
            ArrayList abstractionFormulas = Lists.newArrayList();
            ArrayDeque<ARTElement> todo = new ArrayDeque<ARTElement>();
            assert (pRoot.getParents().isEmpty());
            formulas.put(pRoot, this.pfmgr.makeEmptyPathFormula());
            todo.addAll(pRoot.getChildren());
            block0: while (!todo.isEmpty()) {
                ARTElement currentElement = (ARTElement)todo.pollFirst();
                if (formulas.containsKey(currentElement)) continue;
                ArrayList currentFormulas = Lists.newArrayListWithExpectedSize((int)currentElement.getParents().size());
                for (ARTElement parentElement : currentElement.getParents()) {
                    PathFormula parentFormula = (PathFormula)formulas.get(parentElement);
                    if (parentFormula == null) {
                        todo.addLast(currentElement);
                        continue block0;
                    }
                    CFAEdge edge = parentElement.getEdgeToChild(currentElement);
                    PathFormula currentFormula = this.pfmgr.makeAnd(parentFormula, edge);
                    currentFormulas.add(currentFormula);
                }
                assert (currentFormulas.size() >= 1);
                PredicateAbstractElement predicateElement = AbstractElements.extractElementByType(currentElement, PredicateAbstractElement.class);
                if (predicateElement.isAbstractionElement()) {
                    PathFormula currentFormula = (PathFormula)Iterables.getOnlyElement((Iterable)currentFormulas);
                    abstractionFormulas.add(currentFormula.getFormula());
                    assert (todo.isEmpty()) : "todo should be empty because of the special ART structure";
                    formulas.clear();
                    formulas.put(currentElement, this.pfmgr.makeEmptyPathFormula(currentFormula));
                } else {
                    Iterator it = currentFormulas.iterator();
                    PathFormula currentFormula = (PathFormula)it.next();
                    while (it.hasNext()) {
                        currentFormula = this.pfmgr.makeOr(currentFormula, (PathFormula)it.next());
                    }
                    formulas.put(currentElement, currentFormula);
                }
                todo.addAll(currentElement.getChildren());
            }
            return abstractionFormulas;
        }
    }
}

