/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.ImmutableSet;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;

@Options(prefix="cpa.predicate.blk")
public class BlockOperator {
    @Option(description="maximum blocksize before abstraction is forced\n(non-negative number, special values: 0 = don't check threshold, 1 = SBE)")
    private int threshold = 0;
    @Option(name="functions", description="abstractions at function calls/returns if threshold has been reached (no effect if threshold = 0)")
    private boolean absOnFunction = false;
    @Option(name="loops", description="abstractions at loop heads if threshold has been reached (no effect if threshold = 0)")
    private boolean absOnLoop = false;
    @Option(description="force abstractions immediately after threshold is reached (no effect if threshold = 0)")
    private boolean alwaysAfterThreshold = true;
    @Option(description="force abstractions at loop heads, regardless of threshold")
    private boolean alwaysAtLoops = true;
    @Option(description="force abstractions at each function calls/returns, regardless of threshold")
    private boolean alwaysAtFunctions = true;
    @Option(description="abstraction always and only on explicitly computed abstraction nodes.")
    private boolean alwaysAndOnlyAtExplicitNodes = false;
    private ImmutableSet<CFANode> explicitAbstractionNodes = null;
    int numBlkFunctions = 0;
    int numBlkLoops = 0;
    int numBlkThreshold = 0;

    public boolean isBlockEnd(CFAEdge cfaEdge, PathFormula pf) {
        CFANode succLoc = cfaEdge.getSuccessor();
        CFANode predLoc = cfaEdge.getPredecessor();
        if (this.alwaysAndOnlyAtExplicitNodes) {
            assert (this.explicitAbstractionNodes != null);
            return this.explicitAbstractionNodes.contains((Object)predLoc);
        }
        if (this.alwaysAtFunctions && this.isFunctionCall(succLoc)) {
            ++this.numBlkFunctions;
            return true;
        }
        if (this.alwaysAtLoops && this.isLoopHead(succLoc)) {
            ++this.numBlkLoops;
            return true;
        }
        if (this.threshold > 0) {
            if (this.threshold == 1) {
                return true;
            }
            if (this.isThresholdFulfilled(pf)) {
                if (this.alwaysAfterThreshold) {
                    ++this.numBlkThreshold;
                    return true;
                }
                if (this.absOnFunction && this.isFunctionCall(succLoc)) {
                    ++this.numBlkThreshold;
                    ++this.numBlkFunctions;
                    return true;
                }
                if (this.absOnLoop && this.isLoopHead(succLoc)) {
                    ++this.numBlkThreshold;
                    ++this.numBlkLoops;
                    return true;
                }
            }
        } else {
            assert (this.threshold == 0);
            if (this.absOnFunction && this.isFunctionCall(succLoc)) {
                ++this.numBlkFunctions;
                return true;
            }
            if (this.absOnLoop && this.isLoopHead(succLoc)) {
                ++this.numBlkLoops;
                return true;
            }
        }
        return false;
    }

    protected boolean isThresholdFulfilled(PathFormula pf) {
        return pf.getLength() >= this.threshold;
    }

    protected boolean isLoopHead(CFANode succLoc) {
        return succLoc.isLoopStart();
    }

    protected boolean isFunctionCall(CFANode succLoc) {
        return succLoc instanceof CFAFunctionDefinitionNode || succLoc.getEnteringSummaryEdge() != null;
    }

    public void setExplicitAbstractionNodes(ImmutableSet<CFANode> pNodes) {
        this.explicitAbstractionNodes = pNodes;
    }
}

