/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.SymbolicRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.interpolation.UninstantiatingInterpolationManager;

public class ImpactRefiner
extends org.sosy_lab.cpachecker.cpa.impact.ImpactRefiner {
    public static ImpactRefiner create(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        PredicateCPA predicateCpa = (PredicateCPA)Iterables.getFirst((Iterable)Iterables.filter(CPAs.asIterable(pCpa), PredicateCPA.class), null);
        if (predicateCpa == null) {
            throw new InvalidConfigurationException(ImpactRefiner.class.getSimpleName() + " needs a PredicateCPA");
        }
        Region initialRegion = predicateCpa.getInitialElement(null).getAbstractionFormula().asRegion();
        if (!(initialRegion instanceof SymbolicRegionManager.SymbolicRegion)) {
            throw new InvalidConfigurationException(ImpactRefiner.class.getSimpleName() + " works only with a PredicateCPA configured to store abstractions as formulas (cpa.predicate.abstraction.type=FORMULA)");
        }
        Configuration config = predicateCpa.getConfiguration();
        LogManager logger = predicateCpa.getLogger();
        ExtendedFormulaManager fmgr = predicateCpa.getFormulaManager();
        Solver solver = predicateCpa.getSolver();
        UninstantiatingInterpolationManager manager = new UninstantiatingInterpolationManager(fmgr, predicateCpa.getPathFormulaManager(), solver, predicateCpa.getFormulaManagerFactory(), config, logger);
        return new ImpactRefiner(config, logger, pCpa, manager, fmgr, solver);
    }

    private ImpactRefiner(Configuration config, LogManager logger, ConfigurableProgramAnalysis pCpa, InterpolationManager<Formula> pInterpolationManager, ExtendedFormulaManager pFmgr, Solver pSolver) throws InvalidConfigurationException, CPAException {
        super(config, logger, pCpa, pInterpolationManager, pFmgr, pSolver);
    }

    @Override
    protected List<ARTElement> transformPath(Path pPath) {
        ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.skip((Iterable)pPath, (int)1), (Function)Pair.getProjectionToFirst()), (Predicate)new Predicate<ARTElement>(){

            public boolean apply(ARTElement pInput) {
                return AbstractElements.extractElementByType(pInput, PredicateAbstractElement.class).isAbstractionElement();
            }
        }));
        assert (((Pair)pPath.getLast()).getFirst() == result.get(result.size() - 1));
        return result;
    }

    @Override
    protected List<Formula> getFormulasForPath(List<ARTElement> pPath, ARTElement pInitialElement) {
        return Lists.transform(pPath, (Function)new Function<ARTElement, Formula>(){

            public Formula apply(ARTElement e) {
                return AbstractElements.extractElementByType(e, PredicateAbstractElement.class).getAbstractionFormula().getBlockFormula();
            }
        });
    }

    @Override
    protected void addFormulaToState(Formula f, ARTElement e) {
        PredicateAbstractElement predElement = AbstractElements.extractElementByType(e, PredicateAbstractElement.class);
        AbstractionFormula af = predElement.getAbstractionFormula();
        Formula newFormula = this.fmgr.makeAnd(f, af.asFormula());
        AbstractionFormula newAF = new AbstractionFormula(new SymbolicRegionManager.SymbolicRegion(newFormula), newFormula, af.getBlockFormula());
        predElement.setAbstraction(newAF);
    }

    @Override
    protected Formula getStateFormula(ARTElement pARTElement) {
        return AbstractElements.extractElementByType(pARTElement, PredicateAbstractElement.class).getAbstractionFormula().asFormula();
    }
}

