/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.art.AbstractARTBasedRefiner;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateRefiner;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.invariants.Farkas;
import org.sosy_lab.cpachecker.util.invariants.balancer.MatrixBalancer;
import org.sosy_lab.cpachecker.util.invariants.balancer.SingleLoopNetworkBuilder;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateNetwork;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConstraint;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormulaManager;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

@Options(prefix="cpa.predicate.refinement")
public class InvariantRefiner
extends AbstractARTBasedRefiner {
    @Option(description="split arithmetic equalities when extracting predicates from interpolants")
    private boolean splitItpAtoms = false;
    private final PredicateRefiner predicateRefiner;
    private final PredicateCPA predicateCpa;
    private final Configuration config;
    private final LogManager logger;
    private final AbstractionManager amgr;
    private final ExtendedFormulaManager emgr;
    private final TemplateFormulaManager tmgr;
    final Timer totalRefinement = new Timer();
    final Timer balancing = new Timer();
    final Timer refuting = new Timer();

    public InvariantRefiner(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        super(pCpa);
        this.predicateRefiner = PredicateRefiner.create(pCpa);
        this.predicateCpa = this.getArtCpa().retrieveWrappedCpa(PredicateCPA.class);
        if (this.predicateCpa == null) {
            throw new InvalidConfigurationException(this.getClass().getSimpleName() + " needs a PredicateCPA");
        }
        this.config = this.predicateCpa.getConfiguration();
        this.config.inject((Object)this, InvariantRefiner.class);
        this.logger = this.predicateCpa.getLogger();
        this.amgr = this.predicateCpa.getAbstractionManager();
        this.emgr = this.predicateCpa.getFormulaManager();
        this.tmgr = new TemplateFormulaManager();
    }

    public static InvariantRefiner create(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        return new InvariantRefiner(pCpa);
    }

    @Override
    protected CounterexampleInfo performRefinement(ARTReachedSet pReached, Path pPath) throws CPAException, InterruptedException {
        this.totalRefinement.start();
        CounterexampleTraceInfo<Collection<AbstractionPredicate>> counterexample = this.buildCounterexampleTrace(pPath);
        if (counterexample != null) {
            this.logger.log(Level.FINEST, new Object[]{"Error trace is spurious, refining the abstraction"});
            List<Pair<ARTElement, CFANode>> path = this.transformPath(pPath);
            this.predicateRefiner.performRefinement(pReached, path, counterexample, false);
            this.totalRefinement.stop();
            return CounterexampleInfo.spurious();
        }
        this.totalRefinement.stop();
        throw new RefinementFailedException(RefinementFailedException.Reason.InvariantRefinementFailed, pPath);
    }

    private CounterexampleTraceInfo<Collection<AbstractionPredicate>> buildCounterexampleTrace(Path pPath) throws CPAException {
        CounterexampleTraceInfo<Collection<AbstractionPredicate>> ceti = null;
        SingleLoopNetworkBuilder nbuilder = null;
        nbuilder = new SingleLoopNetworkBuilder(pPath, this.logger);
        TemplateNetwork tnet = nbuilder.nextNetwork();
        MatrixBalancer balancer = new MatrixBalancer(this.logger);
        while (tnet != null) {
            Farkas.resetConstantIndices();
            TemplateTerm.resetParameterIndices();
            this.balancing.start();
            boolean balanced = balancer.balance(tnet);
            this.balancing.stop();
            this.logger.log(Level.FINEST, new Object[]{"Balancer took", this.balancing.getSumTime(), "miliseconds."});
            if (balanced) {
                this.logger.log(Level.FINEST, new Object[]{"Invariants refuted counterexample path."});
                this.logger.log(Level.ALL, new Object[]{"Invariants:\n", tnet.dumpTemplates()});
                ceti = new CounterexampleTraceInfo<Collection<AbstractionPredicate>>();
                this.addPredicates(ceti, tnet, pPath);
                break;
            }
            this.logger.log(Level.FINEST, new Object[]{"Could not balance template network."});
            tnet = nbuilder.nextNetwork();
            if (tnet != null) continue;
            throw new RefinementFailedException(RefinementFailedException.Reason.InvariantRefinementFailed, pPath);
        }
        return ceti;
    }

    private void addPredicates(CounterexampleTraceInfo<Collection<AbstractionPredicate>> ceti, TemplateNetwork tnet, Path pPath) throws CPAException {
        Vector<AbstractionPredicate> trueFormula = new Vector<AbstractionPredicate>();
        trueFormula.add(this.amgr.makePredicate(this.emgr.makeTrue()));
        Vector<AbstractionPredicate> falseFormula = new Vector<AbstractionPredicate>();
        falseFormula.add(this.amgr.makePredicate(this.emgr.makeFalse()));
        List<Pair<ARTElement, CFANode>> path = this.transformPath(pPath);
        int N = path.size() - 1;
        for (int i = 0; i < N; ++i) {
            Pair<ARTElement, CFANode> pair = path.get(i);
            CFANode loc = (CFANode)pair.getSecond();
            TemplateFormula phi = tnet.getTemplate(loc).getTemplateFormula();
            if (phi != null) {
                Collection<AbstractionPredicate> phiPreds = this.makeAbstractionPredicates(phi);
                ceti.addPredicatesForRefinement(phiPreds);
                continue;
            }
            ceti.addPredicatesForRefinement(trueFormula);
        }
    }

    private Collection<AbstractionPredicate> makeAbstractionPredicates(TemplateFormula invariant) {
        Collection<Formula> atoms = this.tmgr.extractAtoms(invariant, this.splitItpAtoms, false);
        Vector<AbstractionPredicate> preds = new Vector<AbstractionPredicate>();
        for (Formula atom : atoms) {
            try {
                TemplateConstraint tc = (TemplateConstraint)atom;
                Formula formula = tc.translate(this.emgr.getDelegate());
                preds.add(this.amgr.makePredicate(formula));
            }
            catch (ClassCastException e) {
                this.logger.log(Level.ALL, new Object[]{"Refinement atom was not in the form of a constraint.", atom});
            }
        }
        return preds;
    }

    private List<Pair<ARTElement, CFANode>> transformPath(Path pPath) {
        ArrayList result = Lists.newArrayList();
        for (ARTElement ae : Iterables.skip((Iterable)Lists.transform((List)pPath, (Function)Pair.getProjectionToFirst()), (int)1)) {
            PredicateAbstractElement pe = AbstractElements.extractElementByType(ae, PredicateAbstractElement.class);
            if (!pe.isAbstractionElement()) continue;
            CFANode loc = AbstractElements.extractLocation(ae);
            result.add(Pair.of((Object)ae, (Object)loc));
        }
        assert (((Pair)pPath.getLast()).getFirst() == ((Pair)result.get(result.size() - 1)).getFirst());
        return result;
    }
}

