/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="cpa.predicate")
public class PredicateAbstractDomain
implements AbstractDomain {
    @Option(description="whether to include the symbolic path formula in the coverage checks or do only the fast abstract checks")
    private boolean symbolicCoverageCheck = false;
    public final Timer coverageCheckTimer = new Timer();
    public final Timer bddCoverageCheckTimer = new Timer();
    public final Timer symbolicCoverageCheckTimer = new Timer();
    private final PredicateAbstractionManager mgr;

    public PredicateAbstractDomain(PredicateCPA pCpa) throws InvalidConfigurationException {
        pCpa.getConfiguration().inject((Object)this, PredicateAbstractDomain.class);
        this.mgr = pCpa.getPredicateManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLessOrEqual(AbstractElement element1, AbstractElement element2) throws CPAException {
        this.coverageCheckTimer.start();
        try {
            PredicateAbstractElement e1 = (PredicateAbstractElement)element1;
            PredicateAbstractElement e2 = (PredicateAbstractElement)element2;
            if (e1.isAbstractionElement() && e2.isAbstractionElement()) {
                this.bddCoverageCheckTimer.start();
                boolean result = this.mgr.checkCoverage(e1.getAbstractionFormula(), e2.getAbstractionFormula());
                this.bddCoverageCheckTimer.stop();
                boolean bl = result;
                return bl;
            }
            if (e2.isAbstractionElement()) {
                if (this.symbolicCoverageCheck) {
                    this.symbolicCoverageCheckTimer.start();
                    boolean result = this.mgr.checkCoverage(e1.getAbstractionFormula(), e1.getPathFormula(), e2.getAbstractionFormula());
                    this.symbolicCoverageCheckTimer.stop();
                    boolean bl = result;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (e1.isAbstractionElement()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = e1.getMergedInto() == e2;
            return bl;
        }
        finally {
            this.coverageCheckTimer.stop();
        }
    }

    boolean formulaBasedIsLessOrEqual(AbstractElement element1, AbstractElement element2) throws CPAException {
        PredicateAbstractElement e1 = (PredicateAbstractElement)element1;
        PredicateAbstractElement e2 = (PredicateAbstractElement)element2;
        if (e1.isAbstractionElement() && e2.isAbstractionElement()) {
            boolean result = this.mgr.checkCoverage(e1.getAbstractionFormula(), e1.getPathFormula(), e2.getAbstractionFormula());
            return result;
        }
        if (e2.isAbstractionElement()) {
            if (this.symbolicCoverageCheck) {
                boolean result = this.mgr.checkCoverage(e1.getAbstractionFormula(), e1.getPathFormula(), e2.getAbstractionFormula());
                return result;
            }
            return false;
        }
        if (e1.isAbstractionElement()) {
            return false;
        }
        return false;
    }

    @Override
    public AbstractElement join(AbstractElement pElement1, AbstractElement pElement2) throws CPAException {
        throw new UnsupportedOperationException();
    }
}

