/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingElement;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public abstract class PredicateAbstractElement
implements AbstractElement,
Partitionable,
FormulaReportingElement,
Serializable {
    private static final long serialVersionUID = -265763837277453447L;
    public static final Predicate<PredicateAbstractElement> FILTER_ABSTRACTION_ELEMENTS = new Predicate<PredicateAbstractElement>(){

        public boolean apply(PredicateAbstractElement ae) {
            return ae.isAbstractionElement();
        }
    };
    private final PathFormula pathFormula;
    private AbstractionFormula abstractionFormula;

    static PredicateAbstractElement abstractionElement(PathFormula pF, AbstractionFormula pA) {
        return new AbstractionElement(pF, pA);
    }

    static PredicateAbstractElement nonAbstractionElement(PathFormula pF, AbstractionFormula pA) {
        return new NonAbstractionElement(pF, pA);
    }

    private PredicateAbstractElement(PathFormula pf, AbstractionFormula a) {
        this.pathFormula = pf;
        this.abstractionFormula = a;
    }

    public abstract boolean isAbstractionElement();

    PredicateAbstractElement getMergedInto() {
        throw new UnsupportedOperationException("Assuming wrong PredicateAbstractElements were merged!");
    }

    void setMergedInto(PredicateAbstractElement pMergedInto) {
        throw new UnsupportedOperationException("Merging wrong PredicateAbstractElements!");
    }

    public AbstractionFormula getAbstractionFormula() {
        return this.abstractionFormula;
    }

    void setAbstraction(AbstractionFormula pAbstractionFormula) {
        if (!this.isAbstractionElement()) {
            throw new UnsupportedOperationException("Changing abstraction formula is only supported for abstraction elements");
        }
        this.abstractionFormula = (AbstractionFormula)Preconditions.checkNotNull((Object)pAbstractionFormula);
    }

    public PathFormula getPathFormula() {
        return this.pathFormula;
    }

    @Override
    public Formula getFormulaApproximation(FormulaManager manager) {
        return this.getAbstractionFormula().asFormula();
    }

    static class ComputeAbstractionElement
    extends PredicateAbstractElement {
        private static final long serialVersionUID = -3961784113582993743L;
        private final transient CFANode location;

        public ComputeAbstractionElement(PathFormula pf, AbstractionFormula pA, CFANode pLoc) {
            super(pf, pA);
            this.location = pLoc;
        }

        @Override
        public boolean isAbstractionElement() {
            return false;
        }

        @Override
        public Object getPartitionKey() {
            return this;
        }

        public String toString() {
            return "Abstraction location: true, Abstraction: <TO COMPUTE>";
        }

        public CFANode getLocation() {
            return this.location;
        }
    }

    private static class NonAbstractionElement
    extends PredicateAbstractElement {
        private static final long serialVersionUID = -6912172362012773999L;
        private transient PredicateAbstractElement mergedInto = null;

        private NonAbstractionElement(PathFormula pF, AbstractionFormula pA) {
            super(pF, pA);
        }

        @Override
        public boolean isAbstractionElement() {
            return false;
        }

        @Override
        PredicateAbstractElement getMergedInto() {
            return this.mergedInto;
        }

        @Override
        void setMergedInto(PredicateAbstractElement pMergedInto) {
            Preconditions.checkNotNull((Object)pMergedInto);
            this.mergedInto = pMergedInto;
        }

        @Override
        public Object getPartitionKey() {
            return this.getAbstractionFormula();
        }

        public String toString() {
            return "Abstraction location: false";
        }
    }

    private static class AbstractionElement
    extends PredicateAbstractElement {
        private static final long serialVersionUID = 8341054099315063986L;

        private AbstractionElement(PathFormula pf, AbstractionFormula pA) {
            super(pf, pA);
            Preconditions.checkArgument((boolean)pf.getFormula().isTrue());
        }

        @Override
        public Object getPartitionKey() {
            if (((PredicateAbstractElement)this).abstractionFormula.asFormula().isFalse()) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public boolean isAbstractionElement() {
            return true;
        }

        public String toString() {
            return "Abstraction location: true, Abstraction: " + ((PredicateAbstractElement)this).abstractionFormula;
        }
    }
}

