/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.NestedTimer;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;

@Options(prefix="cpa.predicate")
public class PredicateAbstractionManager {
    final Stats stats;
    private final LogManager logger;
    private final ExtendedFormulaManager fmgr;
    private final AbstractionManager amgr;
    private final Solver solver;
    @Option(name="abstraction.cartesian", description="whether to use Boolean (false) or Cartesian (true) abstraction")
    private boolean cartesianAbstraction = false;
    @Option(name="abstraction.dumpHardQueries", description="dump the abstraction formulas if they took to long")
    private boolean dumpHardAbstractions = false;
    @Option(name="abs.useCache", description="use caching of abstractions")
    private boolean useCache = true;
    private final Map<Pair<Formula, Collection<AbstractionPredicate>>, AbstractionFormula> abstractionCache;
    private final Map<Pair<Formula, AbstractionPredicate>, Byte> cartesianAbstractionCache;
    private final Map<Formula, Boolean> feasibilityCache;

    public PredicateAbstractionManager(AbstractionManager pAmgr, ExtendedFormulaManager pFmgr, Solver pSolver, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this, PredicateAbstractionManager.class);
        this.stats = new Stats();
        this.logger = pLogger;
        this.fmgr = pFmgr;
        this.amgr = pAmgr;
        this.solver = pSolver;
        this.abstractionCache = this.useCache ? new HashMap<Pair<Formula, Collection<AbstractionPredicate>>, AbstractionFormula>() : null;
        if (this.useCache && this.cartesianAbstraction) {
            this.cartesianAbstractionCache = new HashMap<Pair<Formula, AbstractionPredicate>, Byte>();
            this.feasibilityCache = new HashMap<Formula, Boolean>();
        } else {
            this.cartesianAbstractionCache = null;
            this.feasibilityCache = null;
        }
    }

    public AbstractionFormula buildAbstraction(AbstractionFormula abstractionFormula, PathFormula pathFormula, Collection<AbstractionPredicate> predicates) {
        AbstractionFormula result;
        ++this.stats.numCallsAbstraction;
        if (predicates.isEmpty()) {
            ++this.stats.numSymbolicAbstractions;
            return this.makeTrueAbstractionFormula(pathFormula.getFormula());
        }
        this.logger.log(Level.ALL, new Object[]{"Old abstraction:", abstractionFormula});
        this.logger.log(Level.ALL, new Object[]{"Path formula:", pathFormula});
        this.logger.log(Level.ALL, new Object[]{"Predicates:", predicates});
        Formula absFormula = abstractionFormula.asFormula();
        Formula symbFormula = this.buildFormula(pathFormula.getFormula());
        Formula f = this.fmgr.makeAnd(absFormula, symbFormula);
        Pair absKey = null;
        if (this.useCache && (result = this.abstractionCache.get(absKey = Pair.of((Object)f, predicates))) != null) {
            result = new AbstractionFormula(result.asRegion(), result.asFormula(), pathFormula.getFormula());
            this.logger.log(Level.ALL, new Object[]{"Abstraction was cached, result is", result});
            ++this.stats.numCallsAbstractionCached;
            return result;
        }
        Region abs = this.cartesianAbstraction ? this.buildCartesianAbstraction(f, pathFormula.getSsa(), predicates) : this.buildBooleanAbstraction(f, pathFormula.getSsa(), predicates);
        Formula symbolicAbs = this.toConcrete(abs, pathFormula.getSsa());
        AbstractionFormula result2 = new AbstractionFormula(abs, symbolicAbs, pathFormula.getFormula());
        if (this.useCache) {
            this.abstractionCache.put((Pair<Formula, Collection<AbstractionPredicate>>)absKey, result2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region buildCartesianAbstraction(Formula f, SSAMap ssa, Collection<AbstractionPredicate> predicates) {
        AbstractionManager.RegionCreator rmgr = this.amgr.getRegionCreator();
        this.stats.abstractionTime.startOuter();
        TheoremProver thmProver = this.solver.getTheoremProver();
        thmProver.init();
        try {
            boolean feasibility;
            thmProver.push(f);
            if (this.useCache && this.feasibilityCache.containsKey(f)) {
                feasibility = this.feasibilityCache.get(f);
            } else {
                boolean bl = feasibility = !thmProver.isUnsat();
                if (this.useCache) {
                    this.feasibilityCache.put(f, feasibility);
                }
            }
            if (!feasibility) {
                Region region = rmgr.makeFalse();
                return region;
            }
            try {
                Region absbdd = rmgr.makeTrue();
                for (AbstractionPredicate p : predicates) {
                    Pair cacheKey = Pair.of((Object)f, (Object)p);
                    if (this.useCache && this.cartesianAbstractionCache.containsKey(cacheKey)) {
                        byte predVal = this.cartesianAbstractionCache.get(cacheKey);
                        this.stats.abstractionTime.getInnerTimer().start();
                        Region v = p.getAbstractVariable();
                        if (predVal == -1) {
                            v = rmgr.makeNot(v);
                            absbdd = rmgr.makeAnd(absbdd, v);
                        } else if (predVal == 1) {
                            absbdd = rmgr.makeAnd(absbdd, v);
                        } else assert (predVal == 0) : "predicate value is neither false, true, nor unknown";
                        this.stats.abstractionTime.getInnerTimer().stop();
                        continue;
                    }
                    this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "CHECKING VALUE OF PREDICATE: ", p.getSymbolicAtom()});
                    Formula predTrue = this.fmgr.instantiate(p.getSymbolicAtom(), ssa);
                    Formula predFalse = this.fmgr.makeNot(predTrue);
                    int predVal = 0;
                    thmProver.push(predFalse);
                    boolean isTrue = thmProver.isUnsat();
                    thmProver.pop();
                    if (isTrue) {
                        this.stats.abstractionTime.getInnerTimer().start();
                        Region v = p.getAbstractVariable();
                        absbdd = rmgr.makeAnd(absbdd, v);
                        this.stats.abstractionTime.getInnerTimer().stop();
                        predVal = 1;
                    } else {
                        thmProver.push(predTrue);
                        boolean isFalse = thmProver.isUnsat();
                        thmProver.pop();
                        if (isFalse) {
                            this.stats.abstractionTime.getInnerTimer().start();
                            Region v = p.getAbstractVariable();
                            v = rmgr.makeNot(v);
                            absbdd = rmgr.makeAnd(absbdd, v);
                            this.stats.abstractionTime.getInnerTimer().stop();
                            predVal = -1;
                        }
                    }
                    if (!this.useCache) continue;
                    this.cartesianAbstractionCache.put((Pair<Formula, AbstractionPredicate>)cacheKey, (byte)predVal);
                }
                Region region = absbdd;
                thmProver.pop();
                return region;
            }
            catch (Throwable throwable) {
                thmProver.pop();
                throw throwable;
            }
        }
        finally {
            thmProver.reset();
            this.stats.abstractionTime.stopOuter();
        }
    }

    private Formula buildFormula(Formula symbFormula) {
        Formula bitwiseAxioms;
        if (this.fmgr.useBitwiseAxioms() && !(bitwiseAxioms = this.fmgr.getBitwiseAxioms(symbFormula)).isTrue()) {
            symbFormula = this.fmgr.makeAnd(symbFormula, bitwiseAxioms);
            this.logger.log(Level.ALL, new Object[]{"DEBUG_3", "ADDED BITWISE AXIOMS:", bitwiseAxioms});
        }
        return symbFormula;
    }

    private Region buildBooleanAbstraction(Formula f, SSAMap ssa, Collection<AbstractionPredicate> predicates) {
        Region result;
        Formula predDef = this.fmgr.makeTrue();
        ArrayList<Formula> predVars = new ArrayList<Formula>(predicates.size());
        for (AbstractionPredicate p : predicates) {
            Formula var = p.getSymbolicVariable();
            Formula def = p.getSymbolicAtom();
            if (def.isFalse()) continue;
            def = this.fmgr.instantiate(def, ssa);
            Formula equiv = this.fmgr.makeEquivalence(var, def);
            predDef = this.fmgr.makeAnd(predDef, equiv);
            predVars.add(var);
        }
        Formula fm = this.fmgr.makeAnd(f, predDef);
        this.stats.abstractionTime.startOuter();
        if (predVars.isEmpty()) {
            ++this.stats.numSatCheckAbstractions;
            boolean satResult = !this.solver.isUnsat(fm);
            AbstractionManager.RegionCreator rmgr = this.amgr.getRegionCreator();
            result = satResult ? rmgr.makeTrue() : rmgr.makeFalse();
        } else {
            this.logger.log(Level.ALL, new Object[]{"COMPUTING ALL-SMT ON FORMULA: ", fm});
            TheoremProver thmProver = this.solver.getTheoremProver();
            TheoremProver.AllSatResult allSatResult = thmProver.allSat(fm, predVars, this.amgr.getRegionCreator(), this.stats.abstractionTime.getInnerTimer());
            result = allSatResult.getResult();
            int numModels = allSatResult.getCount();
            if (numModels < Integer.MAX_VALUE) {
                this.stats.maxAllSatCount = Math.max(numModels, this.stats.maxAllSatCount);
                this.stats.allSatCount += (long)numModels;
            }
        }
        long solveTime = this.stats.abstractionTime.stopOuter();
        if (solveTime > 10000L && this.dumpHardAbstractions) {
            File dumpFile = this.fmgr.formatFormulaOutputFile("abstraction", this.stats.numCallsAbstraction, "input", 0);
            this.fmgr.dumpFormulaToFile(f, dumpFile);
            dumpFile = this.fmgr.formatFormulaOutputFile("abstraction", this.stats.numCallsAbstraction, "predDef", 0);
            this.fmgr.dumpFormulaToFile(predDef, dumpFile);
            dumpFile = this.fmgr.formatFormulaOutputFile("abstraction", this.stats.numCallsAbstraction, "predVars", 0);
            this.fmgr.printFormulasToFile(predVars, dumpFile);
        }
        this.logger.log(Level.ALL, new Object[]{"Abstraction computed, result is", result});
        return result;
    }

    public boolean checkCoverage(AbstractionFormula a1, AbstractionFormula a2) {
        return this.amgr.entails(a1.asRegion(), a2.asRegion());
    }

    public boolean checkCoverage(AbstractionFormula a1, PathFormula p1, AbstractionFormula a2) {
        Formula absFormula = a1.asFormula();
        Formula symbFormula = this.buildFormula(p1.getFormula());
        Formula a = this.fmgr.makeAnd(absFormula, symbFormula);
        Formula b = this.fmgr.instantiate(this.fmgr.uninstantiate(a2.asFormula()), p1.getSsa());
        return this.solver.implies(a, b);
    }

    public boolean checkCoverage(PathFormula a1, PathFormula a2, PathFormulaManager pfmgr) {
        Formula rightFormula;
        ++this.stats.numPathFormulaCoverageChecks;
        if (a1.equals(a2)) {
            ++this.stats.numEqualPathFormulae;
            return true;
        }
        SSAMap map1 = a1.getSsa();
        SSAMap map2 = a2.getSsa();
        for (String var : map1.allVariables()) {
            if (map2.getIndex(var) >= map1.getIndex(var)) continue;
            return false;
        }
        PathFormula mergedPathFormulae = pfmgr.makeOr(a1, a2);
        Formula leftFormula = this.fmgr.getArguments(mergedPathFormulae.getFormula())[0];
        if (this.fmgr.checkSyntacticEntails(leftFormula, rightFormula = a2.getFormula())) {
            ++this.stats.numSyntacticEntailedPathFormulae;
            return true;
        }
        if (!this.solver.implies(mergedPathFormulae.getFormula(), a2.getFormula())) {
            return false;
        }
        ++this.stats.numSemanticEntailedPathFormulae;
        return true;
    }

    public boolean unsat(AbstractionFormula abstractionFormula, PathFormula pathFormula) {
        Formula absFormula = abstractionFormula.asFormula();
        Formula symbFormula = this.buildFormula(pathFormula.getFormula());
        Formula f = this.fmgr.makeAnd(absFormula, symbFormula);
        this.logger.log(Level.ALL, new Object[]{"Checking satisfiability of formula", f});
        return this.solver.isUnsat(f);
    }

    public AbstractionFormula makeTrueAbstractionFormula(Formula pPreviousBlockFormula) {
        if (pPreviousBlockFormula == null) {
            pPreviousBlockFormula = this.fmgr.makeTrue();
        }
        return new AbstractionFormula(this.amgr.getRegionCreator().makeTrue(), this.fmgr.makeTrue(), pPreviousBlockFormula);
    }

    private Formula toConcrete(Region pRegion, SSAMap ssa) {
        return this.fmgr.instantiate(this.amgr.toConcrete(pRegion), ssa);
    }

    public AbstractionFormula reduce(AbstractionFormula oldAbstraction, Collection<AbstractionPredicate> removePredicates, SSAMap ssaMap) {
        AbstractionManager.RegionCreator rmgr = this.amgr.getRegionCreator();
        Region newRegion = oldAbstraction.asRegion();
        for (AbstractionPredicate predicate : removePredicates) {
            newRegion = rmgr.makeExists(newRegion, predicate.getAbstractVariable());
        }
        Formula newFormula = this.toConcrete(newRegion, ssaMap);
        AbstractionFormula newAbstraction = new AbstractionFormula(newRegion, newFormula, oldAbstraction.getBlockFormula());
        return newAbstraction;
    }

    public AbstractionFormula expand(AbstractionFormula reducedAbstraction, AbstractionFormula sourceAbstraction, Collection<AbstractionPredicate> relevantPredicates, SSAMap newSSA) {
        AbstractionManager.RegionCreator rmgr = this.amgr.getRegionCreator();
        Region removedInformationRegion = sourceAbstraction.asRegion();
        for (AbstractionPredicate predicate : relevantPredicates) {
            removedInformationRegion = rmgr.makeExists(removedInformationRegion, predicate.getAbstractVariable());
        }
        Region expandedRegion = rmgr.makeAnd(reducedAbstraction.asRegion(), removedInformationRegion);
        Formula newFormula = this.toConcrete(expandedRegion, newSSA);
        Formula blockFormula = reducedAbstraction.getBlockFormula();
        AbstractionFormula newAbstractionFormula = new AbstractionFormula(expandedRegion, newFormula, blockFormula);
        return newAbstractionFormula;
    }

    public Collection<AbstractionPredicate> extractPredicates(Region pRegion) {
        return this.amgr.extractPredicates(pRegion);
    }

    static class Stats {
        public int numCallsAbstraction = 0;
        public int numSymbolicAbstractions = 0;
        public int numSatCheckAbstractions = 0;
        public int numCallsAbstractionCached = 0;
        public final NestedTimer abstractionTime = new NestedTimer();
        public long allSatCount = 0L;
        public int maxAllSatCount = 0;
        public int numPathFormulaCoverageChecks = 0;
        public int numEqualPathFormulae = 0;
        public int numSyntacticEntailedPathFormulae = 0;
        public int numSemanticEntailedPathFormulae = 0;

        Stats() {
        }
    }
}

