/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.ProofChecker;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.predicate.BlockOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractDomain;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPAStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateMergeOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.blocking.BlockedCFAReducer;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.SymbolicRegionManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;

@Options(prefix="cpa.predicate")
public class PredicateCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider,
ProofChecker {
    @Option(name="abstraction.type", toUppercase=true, values={"BDD", "FORMULA"}, description="What to use for storing abstractions")
    private String abstractionType = "BDD";
    @Option(name="abstraction.initialPredicates", description="get an initial set of predicates from a file in MSAT format")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private File predicatesFile = null;
    @Option(description="always check satisfiability at end of block, even if precision is empty")
    private boolean checkBlockFeasibility = false;
    @Option(name="blk.useCache", description="use caching of path formulas")
    private boolean useCache = true;
    @Option(name="enableBlockreducer", description="Enable the possibility to precompute explicit abstraction locations.")
    private boolean enableBlockreducer = false;
    @Option(name="merge", values={"SEP", "ABE"}, toUppercase=true, description="which merge operator to use for predicate cpa (usually ABE should be used)")
    private String mergeType = "ABE";
    private final Configuration config;
    private final LogManager logger;
    private final PredicateAbstractDomain domain;
    private final PredicateTransferRelation transfer;
    private final MergeOperator merge;
    private final PredicatePrecisionAdjustment prec;
    private final StopOperator stop;
    private final PredicatePrecision initialPrecision;
    private final ExtendedFormulaManager formulaManager;
    private final FormulaManagerFactory formulaManagerFactory;
    private final PathFormulaManager pathFormulaManager;
    private final Solver solver;
    private final AbstractionManager abstractionManager;
    private final PredicateAbstractionManager predicateManager;
    private final PredicateCPAStatistics stats;
    private final PredicateAbstractElement topElement;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(PredicateCPA.class).withOptions(BlockOperator.class);
    }

    protected PredicateCPA(Configuration config, LogManager logger, BlockOperator blk, CFA cfa) throws InvalidConfigurationException {
        RegionManager regionManager;
        config.inject((Object)this, PredicateCPA.class);
        this.config = config;
        this.logger = logger;
        if (this.enableBlockreducer) {
            BlockedCFAReducer blockComputer = new BlockedCFAReducer(config);
            blk.setExplicitAbstractionNodes(blockComputer.computeAbstractionNodes(cfa));
        }
        this.formulaManagerFactory = new FormulaManagerFactory(config, logger);
        this.formulaManager = new ExtendedFormulaManager(this.formulaManagerFactory.getFormulaManager(), config, logger);
        String libraries = this.formulaManager.getVersion();
        PathFormulaManager pfMgr = new PathFormulaManagerImpl(this.formulaManager, config, logger);
        if (this.useCache) {
            pfMgr = new CachingPathFormulaManager(pfMgr);
        }
        this.pathFormulaManager = pfMgr;
        TheoremProver theoremProver = this.formulaManagerFactory.createTheoremProver();
        this.solver = new Solver(this.formulaManager, theoremProver);
        if (this.abstractionType.equals("FORMULA")) {
            regionManager = new SymbolicRegionManager(this.formulaManager, this.solver);
        } else {
            assert (this.abstractionType.equals("BDD"));
            regionManager = BDDRegionManager.getInstance();
            libraries = libraries + " and " + ((BDDRegionManager)regionManager).getVersion();
        }
        logger.log(Level.INFO, new Object[]{"Using predicate analysis with", libraries + "."});
        this.abstractionManager = new AbstractionManager(regionManager, this.formulaManager, config, logger);
        this.predicateManager = new PredicateAbstractionManager(this.abstractionManager, this.formulaManager, this.solver, config, logger);
        this.transfer = new PredicateTransferRelation(this, blk);
        this.topElement = PredicateAbstractElement.abstractionElement(this.pathFormulaManager.makeEmptyPathFormula(), this.predicateManager.makeTrueAbstractionFormula(null));
        this.domain = new PredicateAbstractDomain(this);
        if (this.mergeType.equals("SEP")) {
            this.merge = MergeSepOperator.getInstance();
        } else if (this.mergeType.equals("ABE")) {
            this.merge = new PredicateMergeOperator(this);
        } else {
            throw new InternalError("Update list of allowed merge operators");
        }
        this.prec = new PredicatePrecisionAdjustment(this);
        this.stop = new StopSepOperator(this.domain);
        ImmutableSet predicates = this.readPredicatesFromFile();
        if (this.checkBlockFeasibility) {
            AbstractionPredicate p = this.abstractionManager.makeFalsePredicate();
            if (predicates == null) {
                predicates = ImmutableSet.of((Object)p);
            } else {
                predicates.add(p);
            }
        }
        this.initialPrecision = new PredicatePrecision((Collection<AbstractionPredicate>)predicates);
        this.stats = new PredicateCPAStatistics(this, blk);
        GlobalInfo.getInstance().storeFormulaManager(this.formulaManager);
    }

    private Collection<AbstractionPredicate> readPredicatesFromFile() {
        if (this.predicatesFile != null) {
            try {
                String fileContent = Files.toString((File)this.predicatesFile, (Charset)Charset.defaultCharset());
                Formula f = this.formulaManager.parse(fileContent);
                Collection<Formula> atoms = this.formulaManager.extractAtoms(f, false, false);
                ArrayList<AbstractionPredicate> predicates = new ArrayList<AbstractionPredicate>(atoms.size());
                for (Formula atom : atoms) {
                    predicates.add(this.abstractionManager.makePredicate(atom));
                }
                return predicates;
            }
            catch (IllegalArgumentException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not read predicates from file " + this.predicatesFile);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not read predicates from file");
            }
        }
        return null;
    }

    @Override
    public PredicateAbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public PredicateTransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.merge;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stop;
    }

    public AbstractionManager getAbstractionManager() {
        return this.abstractionManager;
    }

    public PredicateAbstractionManager getPredicateManager() {
        return this.predicateManager;
    }

    public ExtendedFormulaManager getFormulaManager() {
        return this.formulaManager;
    }

    public PathFormulaManager getPathFormulaManager() {
        return this.pathFormulaManager;
    }

    public Solver getSolver() {
        return this.solver;
    }

    Configuration getConfiguration() {
        return this.config;
    }

    LogManager getLogger() {
        return this.logger;
    }

    public FormulaManagerFactory getFormulaManagerFactory() {
        return this.formulaManagerFactory;
    }

    @Override
    public PredicateAbstractElement getInitialElement(CFANode node) {
        return this.topElement;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode) {
        return this.initialPrecision;
    }

    @Override
    public PredicatePrecisionAdjustment getPrecisionAdjustment() {
        return this.prec;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    @Override
    public boolean areAbstractSuccessors(AbstractElement pElement, CFAEdge pCfaEdge, Collection<? extends AbstractElement> pSuccessors) throws CPATransferException, InterruptedException {
        return this.getTransferRelation().areAbstractSuccessors(pElement, pCfaEdge, pSuccessors);
    }

    @Override
    public boolean isCoveredBy(AbstractElement pElement, AbstractElement pOtherElement) throws CPAException {
        return this.getAbstractDomain().formulaBasedIsLessOrEqual(pElement, pOtherElement);
    }
}

