/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.WrapperPrecision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.predicate.BlockOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractDomain;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateMergeOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateTransferRelation;
import org.sosy_lab.cpachecker.util.predicates.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.Solver;

@Options(prefix="cpa.predicate.predmap")
class PredicateCPAStatistics
implements Statistics {
    @Option(description="export final predicate map, if the error location is not reached")
    private boolean export = true;
    @Option(description="export final predicate map, if the error location is not reached")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File file = new File("predmap.txt");
    private final PredicateCPA cpa;
    private final BlockOperator blk;

    public PredicateCPAStatistics(PredicateCPA cpa, BlockOperator blk) throws InvalidConfigurationException {
        this.cpa = cpa;
        this.blk = blk;
        cpa.getConfiguration().inject((Object)this, PredicateCPAStatistics.class);
    }

    @Override
    public String getName() {
        return "PredicateCPA";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        MergeOperator merge;
        int numAbstractions;
        PredicateAbstractionManager amgr = this.cpa.getPredicateManager();
        HashMultimap predicates = HashMultimap.create();
        for (Precision precision : reached.getPrecisions()) {
            if (!(precision instanceof WrapperPrecision)) continue;
            PredicatePrecision preds = ((WrapperPrecision)precision).retrieveWrappedPrecision(PredicatePrecision.class);
            predicates.putAll(preds.getPredicateMap());
        }
        if (result != CPAcheckerResult.Result.UNSAFE && this.export && this.file != null) {
            TreeMap sortedPredicates = new TreeMap(predicates.asMap());
            StringBuilder sb = new StringBuilder();
            for (Map.Entry e : sortedPredicates.entrySet()) {
                sb.append("LOCATION: ");
                sb.append(e.getKey());
                sb.append('\n');
                Joiner.on((char)'\n').appendTo(sb, (Iterable)e.getValue());
                sb.append("\n\n");
            }
            try {
                Files.writeFile((File)this.file, (Object)sb);
            }
            catch (IOException e) {
                this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)e, "Could not write predicate map to file");
            }
        }
        int maxPredsPerLocation = 0;
        for (Collection p : predicates.asMap().values()) {
            maxPredsPerLocation = Math.max(maxPredsPerLocation, p.size());
        }
        int allLocs = predicates.keySet().size();
        int totPredsUsed = predicates.size();
        int avgPredsPerLocation = allLocs > 0 ? totPredsUsed / allLocs : 0;
        int allDistinctPreds = new HashSet(predicates.values()).size();
        PredicateAbstractionManager.Stats as = amgr.stats;
        PredicateAbstractDomain domain = this.cpa.getAbstractDomain();
        PredicateTransferRelation trans = this.cpa.getTransferRelation();
        PredicatePrecisionAdjustment prec = this.cpa.getPrecisionAdjustment();
        Solver solver = this.cpa.getSolver();
        CachingPathFormulaManager pfMgr = null;
        if (this.cpa.getPathFormulaManager() instanceof CachingPathFormulaManager) {
            pfMgr = (CachingPathFormulaManager)this.cpa.getPathFormulaManager();
        }
        out.println("Number of abstractions:            " + prec.numAbstractions + " (" + this.toPercent(prec.numAbstractions, trans.postTimer.getNumberOfIntervals()) + " of all post computations)");
        if (prec.numAbstractions > 0) {
            out.println("  Because of function entry/exit:  " + this.blk.numBlkFunctions + " (" + this.toPercent(this.blk.numBlkFunctions, prec.numAbstractions) + ")");
            out.println("  Because of loop head:            " + this.blk.numBlkLoops + " (" + this.toPercent(this.blk.numBlkLoops, prec.numAbstractions) + ")");
            out.println("  Because of threshold:            " + this.blk.numBlkThreshold + " (" + this.toPercent(this.blk.numBlkThreshold, prec.numAbstractions) + ")");
            out.println("  Times precision was empty:       " + as.numSymbolicAbstractions + " (" + this.toPercent(as.numSymbolicAbstractions, as.numCallsAbstraction) + ")");
            out.println("  Times precision was {false}:     " + as.numSatCheckAbstractions + " (" + this.toPercent(as.numSatCheckAbstractions, as.numCallsAbstraction) + ")");
            out.println("  Times result was 'false':        " + prec.numAbstractionsFalse + " (" + this.toPercent(prec.numAbstractionsFalse, prec.numAbstractions) + ")");
        }
        if (trans.satCheckTimer.getNumberOfIntervals() > 0) {
            out.println("Number of satisfiability checks:   " + trans.satCheckTimer.getNumberOfIntervals());
            out.println("  Times result was 'false':        " + trans.numSatChecksFalse + " (" + this.toPercent(trans.numSatChecksFalse, trans.satCheckTimer.getNumberOfIntervals()) + ")");
        }
        out.println("Number of strengthen sat checks:   " + trans.strengthenCheckTimer.getNumberOfIntervals());
        if (trans.strengthenCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Times result was 'false':        " + trans.numStrengthenChecksFalse + " (" + this.toPercent(trans.numStrengthenChecksFalse, trans.strengthenCheckTimer.getNumberOfIntervals()) + ")");
        }
        out.println("Number of coverage checks:         " + domain.coverageCheckTimer.getNumberOfIntervals());
        out.println("  BDD entailment checks:           " + domain.bddCoverageCheckTimer.getNumberOfIntervals());
        if (domain.symbolicCoverageCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Symbolic coverage check:         " + domain.symbolicCoverageCheckTimer.getNumberOfIntervals());
        }
        out.println("Number of implication checks:      " + solver.implicationChecks);
        out.println("  trivial:                         " + solver.trivialImplicationChecks);
        out.println("  cached:                          " + solver.cachedImplicationChecks);
        out.println();
        out.println("Max ABE block size:                       " + prec.maxBlockSize);
        out.println("Number of predicates discovered:          " + allDistinctPreds);
        if (allDistinctPreds > 0) {
            out.println("Number of abstraction locations:          " + allLocs);
            out.println("Max number of predicates per location:    " + maxPredsPerLocation);
            out.println("Avg number of predicates per location:    " + avgPredsPerLocation);
        }
        if ((numAbstractions = as.numCallsAbstraction - as.numSymbolicAbstractions) > 0) {
            out.println("Max number of predicates per abstraction: " + prec.maxPredsPerAbstraction);
            out.println("Total number of models for allsat:        " + as.allSatCount);
            out.println("Max number of models for allsat:          " + as.maxAllSatCount);
            out.println("Avg number of models for allsat:          " + as.allSatCount / (long)as.numCallsAbstraction);
        }
        out.println();
        if (pfMgr != null) {
            int pathFormulaCacheHits = pfMgr.pathFormulaCacheHits;
            int totalPathFormulaComputations = pfMgr.pathFormulaComputationTimer.getNumberOfIntervals() + pathFormulaCacheHits;
            out.println("Number of path formula cache hits:   " + pathFormulaCacheHits + " (" + this.toPercent(pathFormulaCacheHits, totalPathFormulaComputations) + ")");
        }
        if (numAbstractions > 0) {
            out.println("Number of abstraction cache hits:    " + as.numCallsAbstractionCached + " (" + this.toPercent(as.numCallsAbstractionCached, numAbstractions) + ")");
        }
        out.println();
        out.println("Time for post operator:              " + trans.postTimer);
        out.println("  Time for path formula creation:    " + trans.pathFormulaTimer);
        if (pfMgr != null) {
            out.println("    Actual computation:              " + pfMgr.pathFormulaComputationTimer);
        }
        if (trans.satCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Time for satisfiability checks:    " + trans.satCheckTimer);
        }
        out.println("Time for strengthen operator:        " + trans.strengthenTimer);
        if (trans.strengthenCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Time for satisfiability checks:    " + trans.strengthenCheckTimer);
        }
        out.println("Time for prec operator:              " + prec.totalPrecTime);
        if (prec.numAbstractions > 0) {
            out.println("  Time for abstraction:              " + prec.computingAbstractionTime + " (Max: " + prec.computingAbstractionTime.printMaxTime() + ", Count: " + prec.computingAbstractionTime.getNumberOfIntervals() + ")");
            out.println("    Solving time:                    " + as.abstractionTime.printOuterSumTime() + " (Max: " + as.abstractionTime.printOuterMaxTime() + ")");
            out.println("    Time for BDD construction:       " + as.abstractionTime.printInnerSumTime() + " (Max: " + as.abstractionTime.printInnerMaxTime() + ")");
        }
        if ((merge = this.cpa.getMergeOperator()) instanceof PredicateMergeOperator) {
            out.println("Time for merge operator:             " + ((PredicateMergeOperator)merge).totalMergeTime);
        }
        out.println("Time for coverage check:             " + domain.coverageCheckTimer);
        if (domain.bddCoverageCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Time for BDD entailment checks:    " + domain.bddCoverageCheckTimer);
        }
        if (domain.symbolicCoverageCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Time for symbolic coverage checks: " + domain.symbolicCoverageCheckTimer);
        }
        out.println("Total time for SMT solver (w/o itp): " + Timer.formatTime((long)(solver.solverTime.getSumTime() + as.abstractionTime.getOuterSumTime())));
        if (trans.pathFormulaCheckTimer.getNumberOfIntervals() > 0 || trans.abstractionCheckTimer.getNumberOfIntervals() > 0) {
            out.println("Time for abstraction checks:       " + trans.abstractionCheckTimer);
            out.println("Time for path formulae checks:     " + trans.pathFormulaCheckTimer + " (Num: " + as.numPathFormulaCoverageChecks + ", Equal: " + as.numEqualPathFormulae + ", Syn. entailed: " + as.numSyntacticEntailedPathFormulae + ", Sem. entailed: " + as.numSemanticEntailedPathFormulae + ")");
            out.println("Time for unsat checks:             " + trans.satCheckTimer + " (Calls: " + trans.satCheckTimer.getNumberOfIntervals() + ")");
        }
    }

    private String toPercent(double val, double full) {
        return String.format("%1.0f", val / full * 100.0) + "%";
    }
}

