/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;

public class PredicateMergeOperator
implements MergeOperator {
    private final LogManager logger;
    private final PathFormulaManager formulaManager;
    final Timer totalMergeTime = new Timer();

    public PredicateMergeOperator(PredicateCPA pCpa) {
        this.logger = pCpa.getLogger();
        this.formulaManager = pCpa.getPathFormulaManager();
    }

    @Override
    public AbstractElement merge(AbstractElement element1, AbstractElement element2, Precision precision) {
        PredicateAbstractElement merged;
        PredicateAbstractElement elem1 = (PredicateAbstractElement)element1;
        PredicateAbstractElement elem2 = (PredicateAbstractElement)element2;
        if (elem1.isAbstractionElement() || elem2.isAbstractionElement()) {
            merged = elem2;
        } else if (!elem1.getAbstractionFormula().equals(elem2.getAbstractionFormula())) {
            merged = elem2;
        } else {
            this.totalMergeTime.start();
            this.logger.log(Level.FINEST, new Object[]{"Merging two non-abstraction nodes."});
            PathFormula pathFormula = this.formulaManager.makeOr(elem1.getPathFormula(), elem2.getPathFormula());
            this.logger.log(Level.ALL, new Object[]{"New path formula is", pathFormula});
            merged = PredicateAbstractElement.nonAbstractionElement(pathFormula, elem1.getAbstractionFormula());
            elem1.setMergedInto(merged);
            this.totalMergeTime.stop();
        }
        return merged;
    }
}

