/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;

public class PredicatePrecision
implements Precision {
    private final ImmutableSetMultimap<CFANode, AbstractionPredicate> predicateMap;
    private final ImmutableSet<AbstractionPredicate> globalPredicates;
    private final int id = idCounter++;
    private static int idCounter = 0;

    public PredicatePrecision(ImmutableSetMultimap<CFANode, AbstractionPredicate> predicateMap, Collection<AbstractionPredicate> globalPredicates) {
        assert (predicateMap != null);
        this.predicateMap = predicateMap;
        this.globalPredicates = ImmutableSet.copyOf(globalPredicates);
    }

    public PredicatePrecision(Collection<AbstractionPredicate> globalPredicates) {
        this.predicateMap = ImmutableSetMultimap.of();
        this.globalPredicates = globalPredicates == null ? ImmutableSet.of() : ImmutableSet.copyOf(globalPredicates);
    }

    public SetMultimap<CFANode, AbstractionPredicate> getPredicateMap() {
        return this.predicateMap;
    }

    public Set<AbstractionPredicate> getGlobalPredicates() {
        return this.globalPredicates;
    }

    public Set<AbstractionPredicate> getPredicates(CFANode loc) {
        ImmutableSet<AbstractionPredicate> result = this.predicateMap.get((Object)loc);
        if (result.isEmpty()) {
            result = this.globalPredicates;
        }
        return result;
    }

    public int hashCode() {
        return this.predicateMap.hashCode();
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (!(pObj instanceof PredicatePrecision)) {
            return false;
        }
        return this.predicateMap.equals(((PredicatePrecision)pObj).predicateMap);
    }

    public String toString() {
        return this.predicateMap.toString();
    }

    public int getId() {
        return this.id;
    }
}

