/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;

public class PredicatePrecisionAdjustment
implements PrecisionAdjustment {
    final Timer totalPrecTime = new Timer();
    final Timer computingAbstractionTime = new Timer();
    int numAbstractions = 0;
    int numAbstractionsFalse = 0;
    int maxBlockSize = 0;
    int maxPredsPerAbstraction = 0;
    private final LogManager logger;
    private final PredicateAbstractionManager formulaManager;
    private final PathFormulaManager pathFormulaManager;

    public PredicatePrecisionAdjustment(PredicateCPA pCpa) {
        this.logger = pCpa.getLogger();
        this.formulaManager = pCpa.getPredicateManager();
        this.pathFormulaManager = pCpa.getPathFormulaManager();
    }

    @Override
    public Triple<AbstractElement, Precision, PrecisionAdjustment.Action> prec(AbstractElement pElement, Precision pPrecision, UnmodifiableReachedSet pElements) {
        this.totalPrecTime.start();
        if (pElement instanceof PredicateAbstractElement.ComputeAbstractionElement) {
            PredicateAbstractElement.ComputeAbstractionElement element = (PredicateAbstractElement.ComputeAbstractionElement)pElement;
            PredicatePrecision precision = (PredicatePrecision)pPrecision;
            pElement = this.computeAbstraction(element, precision);
        }
        this.totalPrecTime.stop();
        return new Triple((Object)pElement, (Object)pPrecision, (Object)PrecisionAdjustment.Action.CONTINUE);
    }

    private AbstractElement computeAbstraction(PredicateAbstractElement.ComputeAbstractionElement element, PredicatePrecision precision) {
        AbstractionFormula abstractionFormula = element.getAbstractionFormula();
        PathFormula pathFormula = element.getPathFormula();
        CFANode loc = element.getLocation();
        ++this.numAbstractions;
        this.logger.log(Level.FINEST, new Object[]{"Computing abstraction on node", loc});
        Set<AbstractionPredicate> preds = precision.getPredicates(loc);
        this.maxBlockSize = Math.max(this.maxBlockSize, pathFormula.getLength());
        this.maxPredsPerAbstraction = Math.max(this.maxPredsPerAbstraction, preds.size());
        this.computingAbstractionTime.start();
        AbstractionFormula newAbstractionFormula = this.computeAbstraction(abstractionFormula, pathFormula, preds, loc);
        this.computingAbstractionTime.stop();
        if (newAbstractionFormula.isFalse()) {
            ++this.numAbstractionsFalse;
            this.logger.log(Level.FINEST, new Object[]{"Abstraction is false, node is not reachable"});
        }
        PathFormula newPathFormula = this.pathFormulaManager.makeEmptyPathFormula(pathFormula);
        return PredicateAbstractElement.abstractionElement(newPathFormula, newAbstractionFormula);
    }

    protected AbstractionFormula computeAbstraction(AbstractionFormula pAbstractionFormula, PathFormula pPathFormula, Collection<AbstractionPredicate> pPreds, CFANode node) {
        return this.formulaManager.buildAbstraction(pAbstractionFormula, pPathFormula, pPreds);
    }

    protected LogManager getLogger() {
        return this.logger;
    }
}

