/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;

@Options(prefix="cpa.predicate.refinement")
public class PredicateRefinementManager
extends InterpolationManager<Collection<AbstractionPredicate>> {
    private final AbstractionManager amgr;
    @Option(description="only use the atoms from the interpolants as predicates, and not the whole interpolant")
    private boolean atomicPredicates = true;
    @Option(description="split arithmetic equalities when extracting predicates from interpolants")
    private boolean splitItpAtoms = false;

    public PredicateRefinementManager(ExtendedFormulaManager pFmgr, PathFormulaManager pPmgr, Solver pSolver, AbstractionManager pAmgr, FormulaManagerFactory pFmgrFactory, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        super(pFmgr, pPmgr, pSolver, pFmgrFactory, config, pLogger);
        config.inject((Object)this, PredicateRefinementManager.class);
        this.amgr = pAmgr;
    }

    @Override
    protected Collection<AbstractionPredicate> convertInterpolant(Formula interpolant, int index) {
        ImmutableSet preds = interpolant.isFalse() ? ImmutableSet.of((Object)this.amgr.makeFalsePredicate()) : this.getAtomsAsPredicates(interpolant);
        assert (!preds.isEmpty());
        this.logger.log(Level.FINEST, new Object[]{"For step", index, "got:", "predicates", preds});
        File dumpFile = this.formatFormulaOutputFile("atoms", index);
        Collection atoms = Collections2.transform((Collection)preds, (Function)new Function<AbstractionPredicate, Formula>(){

            public Formula apply(AbstractionPredicate pArg0) {
                return pArg0.getSymbolicAtom();
            }
        });
        this.fmgr.printFormulasToFile(atoms, dumpFile);
        return preds;
    }

    private List<AbstractionPredicate> getAtomsAsPredicates(Formula f) {
        Collection<Formula> atoms = this.atomicPredicates ? this.fmgr.extractAtoms(f, this.splitItpAtoms, false) : Collections.singleton(this.fmgr.uninstantiate(f));
        ArrayList<AbstractionPredicate> preds = new ArrayList<AbstractionPredicate>(atoms.size());
        for (Formula atom : atoms) {
            preds.add(this.amgr.makePredicate(atom));
        }
        return preds;
    }

    @Override
    protected Collection<AbstractionPredicate> getTrueInterpolant() {
        return Collections.emptySet();
    }
}

