/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateRefinementManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interpolation.AbstractInterpolationBasedRefiner;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

@Options(prefix="cpa.predicate.refinement")
public class PredicateRefiner
extends AbstractInterpolationBasedRefiner<Collection<AbstractionPredicate>, Pair<ARTElement, CFANode>>
implements StatisticsProvider {
    @Option(description="refinement will add all discovered predicates to all the locations in the abstract trace")
    private boolean addPredicatesGlobally = false;
    private final Timer precisionUpdate = new Timer();
    private final Timer artUpdate = new Timer();
    private static final Function<PredicateAbstractElement, Formula> GET_BLOCK_FORMULA = new Function<PredicateAbstractElement, Formula>(){

        public Formula apply(PredicateAbstractElement e) {
            assert (e.isAbstractionElement());
            return e.getAbstractionFormula().getBlockFormula();
        }
    };

    public static PredicateRefiner create(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        if (!(pCpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException(PredicateRefiner.class.getSimpleName() + " could not find the PredicateCPA");
        }
        PredicateCPA predicateCpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(PredicateCPA.class);
        if (predicateCpa == null) {
            throw new InvalidConfigurationException(PredicateRefiner.class.getSimpleName() + " needs a PredicateCPA");
        }
        LogManager logger = predicateCpa.getLogger();
        PredicateRefinementManager manager = new PredicateRefinementManager(predicateCpa.getFormulaManager(), predicateCpa.getPathFormulaManager(), predicateCpa.getSolver(), predicateCpa.getAbstractionManager(), predicateCpa.getFormulaManagerFactory(), predicateCpa.getConfiguration(), logger);
        return new PredicateRefiner(predicateCpa.getConfiguration(), logger, pCpa, manager);
    }

    protected PredicateRefiner(Configuration config, LogManager logger, ConfigurableProgramAnalysis pCpa, PredicateRefinementManager pInterpolationManager) throws CPAException, InvalidConfigurationException {
        super(config, logger, pCpa, pInterpolationManager);
        config.inject((Object)this, PredicateRefiner.class);
    }

    @Override
    protected final List<Pair<ARTElement, CFANode>> transformPath(Path pPath) {
        ArrayList result = Lists.newArrayList();
        for (ARTElement ae : Iterables.skip((Iterable)Lists.transform((List)pPath, (Function)Pair.getProjectionToFirst()), (int)1)) {
            PredicateAbstractElement pe = AbstractElements.extractElementByType(ae, PredicateAbstractElement.class);
            if (!pe.isAbstractionElement()) continue;
            CFANode loc = AbstractElements.extractLocation(ae);
            result.add(Pair.of((Object)ae, (Object)loc));
        }
        assert (((Pair)pPath.getLast()).getFirst() == ((Pair)result.get(result.size() - 1)).getFirst());
        return result;
    }

    @Override
    protected List<Formula> getFormulasForPath(List<Pair<ARTElement, CFANode>> path, ARTElement initialElement) throws CPATransferException {
        List formulas = Lists.transform(path, (Function)Functions.compose(GET_BLOCK_FORMULA, (Function)Functions.compose(AbstractElements.extractElementByTypeFunction(PredicateAbstractElement.class), (Function)Pair.getProjectionToFirst())));
        return formulas;
    }

    @Override
    protected void performRefinement(ARTReachedSet pReached, List<Pair<ARTElement, CFANode>> pPath, CounterexampleTraceInfo<Collection<AbstractionPredicate>> pCounterexample, boolean pRepeatedCounterexample) throws CPAException {
        this.precisionUpdate.start();
        ReachedSet reached = pReached.asReachedSet();
        Precision oldPrecision = reached.getPrecision(reached.getLastElement());
        PredicatePrecision oldPredicatePrecision = Precisions.extractPrecisionByType(oldPrecision, PredicatePrecision.class);
        if (oldPredicatePrecision == null) {
            throw new IllegalStateException("Could not find the PredicatePrecision for the error element");
        }
        Pair<ARTElement, PredicatePrecision> refinementResult = this.performRefinement(oldPredicatePrecision, pPath, pCounterexample, pRepeatedCounterexample);
        this.precisionUpdate.stop();
        this.artUpdate.start();
        pReached.removeSubtree((ARTElement)refinementResult.getFirst(), (Precision)refinementResult.getSecond());
        this.artUpdate.stop();
    }

    private Pair<ARTElement, PredicatePrecision> performRefinement(PredicatePrecision oldPrecision, List<Pair<ARTElement, CFANode>> pPath, CounterexampleTraceInfo<Collection<AbstractionPredicate>> pInfo, boolean pRepeatedCounterexample) throws CPAException {
        CFANode loc;
        List<Collection<AbstractionPredicate>> newPreds = pInfo.getPredicatesForRefinement();
        List<Pair<ARTElement, CFANode>> interpolationPoints = pPath.subList(0, pPath.size() - 1);
        assert (interpolationPoints.size() == newPreds.size());
        SetMultimap<CFANode, AbstractionPredicate> oldPredicateMap = oldPrecision.getPredicateMap();
        Set<AbstractionPredicate> globalPredicates = oldPrecision.getGlobalPredicates();
        boolean predicatesFound = false;
        boolean newPredicatesFound = false;
        Pair<ARTElement, CFANode> firstInterpolationPoint = null;
        ImmutableSetMultimap.Builder pmapBuilder = ImmutableSetMultimap.builder();
        pmapBuilder.putAll(oldPredicateMap);
        int i = 0;
        for (Pair<ARTElement, CFANode> interpolationPoint : interpolationPoints) {
            Collection<AbstractionPredicate> localPreds;
            if ((localPreds = newPreds.get(i++)).size() <= 0) continue;
            predicatesFound = true;
            loc = (CFANode)interpolationPoint.getSecond();
            if (firstInterpolationPoint == null) {
                firstInterpolationPoint = interpolationPoint;
            }
            if (oldPredicateMap.get((Object)loc).containsAll(localPreds)) continue;
            newPredicatesFound = true;
            pmapBuilder.putAll((Object)loc, localPreds);
            pmapBuilder.putAll((Object)loc, globalPredicates);
        }
        if (!predicatesFound) {
            throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, null);
        }
        assert (firstInterpolationPoint != null);
        ImmutableSetMultimap newPredicateMap = pmapBuilder.build();
        PredicatePrecision newPrecision = this.addPredicatesGlobally ? new PredicatePrecision((Collection<AbstractionPredicate>)newPredicateMap.values()) : new PredicatePrecision((ImmutableSetMultimap<CFANode, AbstractionPredicate>)newPredicateMap, globalPredicates);
        this.logger.log(Level.ALL, new Object[]{"Predicate map now is", newPredicateMap});
        ARTElement root = null;
        if (newPredicatesFound) {
            root = (ARTElement)firstInterpolationPoint.getFirst();
            this.logger.log(Level.FINEST, new Object[]{"Found spurious counterexample,", "trying strategy 1: remove everything below", root, "from ART."});
        } else {
            if (pRepeatedCounterexample) {
                throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, null);
            }
            loc = (CFANode)firstInterpolationPoint.getSecond();
            this.logger.log(Level.FINEST, new Object[]{"Found spurious counterexample,", "trying strategy 2: remove everything below node", loc, "from ART."});
            for (Pair<ARTElement, CFANode> abstractionPoint : pPath) {
                if (!((CFANode)abstractionPoint.getSecond()).equals(loc)) continue;
                root = (ARTElement)abstractionPoint.getFirst();
                break;
            }
            if (root == null) {
                throw new CPAException("Inconsistent ART, did not find element for " + loc);
            }
        }
        return Pair.of((Object)root, (Object)newPrecision);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Stats());
    }

    private class Stats
    implements Statistics {
        private Stats() {
        }

        @Override
        public String getName() {
            return "Predicate Abstraction Refiner";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            PredicateRefiner.this.printStatistics(out, pResult, pReached);
            out.println("  Precision update:               " + PredicateRefiner.this.precisionUpdate);
            out.println("  ART update:                     " + PredicateRefiner.this.artUpdate);
        }
    }
}

