/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.assume.ConstrainedAssumeElement;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonPredicateElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonElement;
import org.sosy_lab.cpachecker.cpa.predicate.BlockOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.fshell.fql2.translators.cfa.ToFlleShAssumeEdgeTranslator;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.ecp.ECPPredicate;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;

@Options(prefix="cpa.predicate")
public class PredicateTransferRelation
implements TransferRelation {
    @Option(name="satCheck", description="maximum blocksize before a satisfiability check is done\n(non-negative number, 0 means never, if positive should be smaller than blocksize)")
    private int satCheckBlockSize = 0;
    @Option(description="check satisfiability when a target state has been found (should be true)")
    private boolean targetStateSatCheck = true;
    final Timer postTimer = new Timer();
    final Timer satCheckTimer = new Timer();
    final Timer pathFormulaTimer = new Timer();
    final Timer strengthenTimer = new Timer();
    final Timer strengthenCheckTimer = new Timer();
    final Timer abstractionCheckTimer = new Timer();
    final Timer pathFormulaCheckTimer = new Timer();
    int numSatChecksFalse = 0;
    int numStrengthenChecksFalse = 0;
    private final LogManager logger;
    private final PredicateAbstractionManager formulaManager;
    private final PathFormulaManager pathFormulaManager;
    private final BlockOperator blk;

    public PredicateTransferRelation(PredicateCPA pCpa, BlockOperator pBlk) throws InvalidConfigurationException {
        pCpa.getConfiguration().inject((Object)this, PredicateTransferRelation.class);
        this.logger = pCpa.getLogger();
        this.formulaManager = pCpa.getPredicateManager();
        this.pathFormulaManager = pCpa.getPathFormulaManager();
        this.blk = pBlk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends AbstractElement> getAbstractSuccessors(AbstractElement pElement, Precision pPrecision, CFAEdge edge) throws CPATransferException, InterruptedException {
        this.postTimer.start();
        try {
            PredicateAbstractElement element = (PredicateAbstractElement)pElement;
            CFANode loc = edge.getSuccessor();
            if (element.getAbstractionFormula().asFormula().isFalse()) {
                Set set = Collections.emptySet();
                return set;
            }
            PathFormula pathFormula = this.convertEdgeToPathFormula(element.getPathFormula(), edge);
            this.logger.log(Level.ALL, new Object[]{"New path formula is", pathFormula});
            boolean doAbstraction = this.blk.isBlockEnd(edge, pathFormula);
            if (doAbstraction) {
                Set<PredicateAbstractElement.ComputeAbstractionElement> set = Collections.singleton(new PredicateAbstractElement.ComputeAbstractionElement(pathFormula, element.getAbstractionFormula(), loc));
                return set;
            }
            Collection<PredicateAbstractElement> collection = this.handleNonAbstractionFormulaLocation(pathFormula, element.getAbstractionFormula());
            return collection;
        }
        finally {
            this.postTimer.stop();
        }
    }

    private Collection<PredicateAbstractElement> handleNonAbstractionFormulaLocation(PathFormula pathFormula, AbstractionFormula abstractionFormula) {
        boolean satCheck = this.satCheckBlockSize > 0 && pathFormula.getLength() >= this.satCheckBlockSize;
        this.logger.log(Level.FINEST, new Object[]{"Handling non-abstraction location", satCheck ? "with satisfiability check" : ""});
        if (satCheck) {
            this.satCheckTimer.start();
            boolean unsat = this.formulaManager.unsat(abstractionFormula, pathFormula);
            this.satCheckTimer.stop();
            if (unsat) {
                ++this.numSatChecksFalse;
                this.logger.log(Level.FINEST, new Object[]{"Abstraction & PathFormula is unsatisfiable."});
                return Collections.emptySet();
            }
        }
        return Collections.singleton(PredicateAbstractElement.nonAbstractionElement(pathFormula, abstractionFormula));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathFormula convertEdgeToPathFormula(PathFormula pathFormula, CFAEdge edge) throws CPATransferException {
        this.pathFormulaTimer.start();
        try {
            PathFormula pathFormula2 = this.pathFormulaManager.makeAnd(pathFormula, edge);
            return pathFormula2;
        }
        finally {
            this.pathFormulaTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement pElement, List<AbstractElement> otherElements, CFAEdge edge, Precision pPrecision) throws CPATransferException {
        this.strengthenTimer.start();
        try {
            Set<PredicateAbstractElement> set;
            PredicateAbstractElement element = (PredicateAbstractElement)pElement;
            if (element.isAbstractionElement()) {
                Set<PredicateAbstractElement> set2 = Collections.singleton(element);
                return set2;
            }
            boolean errorFound = false;
            for (AbstractElement lElement : otherElements) {
                if (lElement instanceof AssumptionStorageElement) {
                    element = this.strengthen(element, (AssumptionStorageElement)lElement);
                }
                if (lElement instanceof GuardedEdgeAutomatonPredicateElement) {
                    element = this.strengthen(edge.getSuccessor(), element, (GuardedEdgeAutomatonPredicateElement)lElement);
                }
                if (lElement instanceof ProductAutomatonElement.PredicateElement) {
                    element = this.strengthen(edge.getSuccessor(), element, (ProductAutomatonElement.PredicateElement)lElement);
                }
                if (lElement instanceof ConstrainedAssumeElement) {
                    element = this.strengthen(edge.getSuccessor(), element, (ConstrainedAssumeElement)lElement);
                }
                if (!AbstractElements.isTargetElement(lElement)) continue;
                errorFound = true;
            }
            if (errorFound && this.targetStateSatCheck && (element = this.strengthenSatCheck(element)) == null) {
                set = Collections.emptySet();
                return set;
            }
            set = Collections.singleton(element);
            return set;
        }
        finally {
            this.strengthenTimer.stop();
        }
    }

    private PredicateAbstractElement strengthen(CFANode pNode, PredicateAbstractElement pElement, GuardedEdgeAutomatonPredicateElement pAutomatonElement) throws CPATransferException {
        PathFormula pf = pElement.getPathFormula();
        for (ECPPredicate lPredicate : pAutomatonElement) {
            AssumeEdge lEdge = ToFlleShAssumeEdgeTranslator.translate(pNode, lPredicate);
            pf = this.convertEdgeToPathFormula(pf, lEdge);
        }
        return this.replacePathFormula(pElement, pf);
    }

    private PredicateAbstractElement strengthen(CFANode pNode, PredicateAbstractElement pElement, ProductAutomatonElement.PredicateElement pAutomatonElement) throws CPATransferException {
        PathFormula pf = pElement.getPathFormula();
        for (ECPPredicate lPredicate : pAutomatonElement.getPredicates()) {
            AssumeEdge lEdge = ToFlleShAssumeEdgeTranslator.translate(pNode, lPredicate);
            pf = this.convertEdgeToPathFormula(pf, lEdge);
        }
        return this.replacePathFormula(pElement, pf);
    }

    private PredicateAbstractElement strengthen(CFANode pNode, PredicateAbstractElement pElement, ConstrainedAssumeElement pAssumeElement) throws CPATransferException {
        AssumeEdge lEdge = new AssumeEdge(pAssumeElement.getExpression().toASTString(), pNode.getLineNumber(), pNode, pNode, pAssumeElement.getExpression(), true);
        PathFormula pf = this.convertEdgeToPathFormula(pElement.getPathFormula(), lEdge);
        return this.replacePathFormula(pElement, pf);
    }

    private PredicateAbstractElement strengthen(PredicateAbstractElement pElement, AssumptionStorageElement pElement2) {
        Formula asmpt = pElement2.getAssumption();
        if (asmpt.isTrue() || asmpt.isFalse()) {
            return pElement;
        }
        PathFormula pf = this.pathFormulaManager.makeAnd(pElement.getPathFormula(), asmpt);
        return this.replacePathFormula(pElement, pf);
    }

    private PredicateAbstractElement replacePathFormula(PredicateAbstractElement oldElement, PathFormula newPathFormula) {
        if (oldElement instanceof PredicateAbstractElement.ComputeAbstractionElement) {
            CFANode loc = ((PredicateAbstractElement.ComputeAbstractionElement)oldElement).getLocation();
            return new PredicateAbstractElement.ComputeAbstractionElement(newPathFormula, oldElement.getAbstractionFormula(), loc);
        }
        assert (!oldElement.isAbstractionElement());
        return PredicateAbstractElement.nonAbstractionElement(newPathFormula, oldElement.getAbstractionFormula());
    }

    protected PredicateAbstractElement strengthenSatCheck(PredicateAbstractElement pElement) {
        this.logger.log(Level.FINEST, new Object[]{"Checking for feasibility of path because error has been found"});
        this.strengthenCheckTimer.start();
        PathFormula pathFormula = pElement.getPathFormula();
        boolean unsat = this.formulaManager.unsat(pElement.getAbstractionFormula(), pathFormula);
        this.strengthenCheckTimer.stop();
        if (unsat) {
            ++this.numStrengthenChecksFalse;
            this.logger.log(Level.FINEST, new Object[]{"Path is infeasible."});
            return null;
        }
        this.logger.log(Level.FINEST, new Object[]{"Last part of the path is not infeasible."});
        AbstractionFormula abs = this.formulaManager.makeTrueAbstractionFormula(pathFormula.getFormula());
        PathFormula newPathFormula = this.pathFormulaManager.makeEmptyPathFormula(pathFormula);
        return PredicateAbstractElement.abstractionElement(newPathFormula, abs);
    }

    boolean areAbstractSuccessors(AbstractElement pElement, CFAEdge pCfaEdge, Collection<? extends AbstractElement> pSuccessors) throws CPATransferException, InterruptedException {
        PredicateAbstractElement predicateElement = (PredicateAbstractElement)pElement;
        boolean result = true;
        if (pSuccessors.isEmpty()) {
            this.satCheckTimer.start();
            Collection<? extends AbstractElement> foundSuccessors = this.getAbstractSuccessors(pElement, null, pCfaEdge);
            for (AbstractElement abstractElement : foundSuccessors) {
                PredicateAbstractElement successor = (PredicateAbstractElement)abstractElement;
                if (this.formulaManager.unsat(successor.getAbstractionFormula(), successor.getPathFormula())) continue;
                result = false;
            }
            this.satCheckTimer.stop();
            return result;
        }
        for (AbstractElement abstractElement : pSuccessors) {
            PredicateAbstractElement predicateAbstractElement = (PredicateAbstractElement)abstractElement;
            if (predicateAbstractElement.isAbstractionElement()) {
                this.abstractionCheckTimer.start();
                if (!this.formulaManager.checkCoverage(predicateElement.getAbstractionFormula(), predicateElement.getPathFormula(), predicateAbstractElement.getAbstractionFormula())) {
                    result = false;
                }
                this.abstractionCheckTimer.stop();
                this.pathFormulaCheckTimer.start();
                if (!predicateAbstractElement.getPathFormula().equals(this.pathFormulaManager.makeEmptyPathFormula(predicateElement.getPathFormula()))) {
                    result = false;
                }
                this.pathFormulaCheckTimer.stop();
                continue;
            }
            this.abstractionCheckTimer.start();
            if (!predicateAbstractElement.getAbstractionFormula().equals(predicateElement.getAbstractionFormula())) {
                result = false;
            }
            this.abstractionCheckTimer.stop();
            this.pathFormulaCheckTimer.start();
            PathFormula successorPathFormula = predicateAbstractElement.getPathFormula();
            PathFormula computedPathFormula = this.convertEdgeToPathFormula(predicateElement.getPathFormula(), pCfaEdge);
            if (!this.formulaManager.checkCoverage(computedPathFormula, successorPathFormula, this.pathFormulaManager)) {
                result = false;
            }
            this.pathFormulaCheckTimer.stop();
        }
        return result;
    }
}

