/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.AbstractRelevantPredicatesComputer;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;

public class AuxiliaryComputer
extends AbstractRelevantPredicatesComputer<Collection<String>> {
    @Override
    protected Collection<String> precompute(Block pContext, Collection<AbstractionPredicate> pPredicates) {
        HashSet<String> relevantVars = new HashSet<String>();
        ArrayList<ReferencedVariable> unknownVars = new ArrayList<ReferencedVariable>();
        for (ReferencedVariable var : pContext.getReferencedVariables()) {
            if (var.occursInCondition()) {
                relevantVars.add(var.getName());
                continue;
            }
            if (var.occursOnLhs()) {
                if (!this.occursInPredicate(var, pPredicates)) continue;
                relevantVars.add(var.getName());
                continue;
            }
            unknownVars.add(var);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            ArrayList<ReferencedVariable> yetUnknownVars = new ArrayList<ReferencedVariable>();
            for (ReferencedVariable var : unknownVars) {
                if (relevantVars.contains(var.getLhsVariable().getName())) {
                    relevantVars.add(var.getName());
                    changed = true;
                    continue;
                }
                yetUnknownVars.add(var);
            }
            unknownVars = yetUnknownVars;
        }
        return relevantVars;
    }

    private boolean occursInPredicate(ReferencedVariable pVar, Collection<AbstractionPredicate> pPredicates) {
        for (AbstractionPredicate predicate : pPredicates) {
            if (!predicate.getSymbolicAtom().toString().contains(pVar.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isRelevant(Collection<String> relevantVariables, AbstractionPredicate predicate) {
        String predicateString = predicate.getSymbolicAtom().toString();
        for (String var : relevantVariables) {
            if (!predicateString.contains(var)) continue;
            return true;
        }
        return false;
    }
}

