/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RefineableRelevantPredicatesComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RelevantPredicatesComputer;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;

public class CachingRelevantPredicatesComputer
implements RefineableRelevantPredicatesComputer {
    private final Map<Pair<Block, ImmutableSet<AbstractionPredicate>>, ImmutableSet<AbstractionPredicate>> irrelevantCache = Maps.newHashMap();
    private final Map<Pair<Block, ImmutableSet<AbstractionPredicate>>, ImmutableSet<AbstractionPredicate>> relevantCache = Maps.newHashMap();
    private final RelevantPredicatesComputer delegate;

    public CachingRelevantPredicatesComputer(RelevantPredicatesComputer pDelegate) {
        this.delegate = (RelevantPredicatesComputer)Preconditions.checkNotNull((Object)pDelegate);
    }

    @Override
    public Set<AbstractionPredicate> getIrrelevantPredicates(Block pContext, Collection<AbstractionPredicate> pPredicates) {
        if (pPredicates.isEmpty()) {
            return Collections.emptySet();
        }
        ImmutableSet predicates = ImmutableSet.copyOf(pPredicates);
        Pair key = Pair.of((Object)pContext, (Object)predicates);
        ImmutableSet result = this.irrelevantCache.get(key);
        if (result == null) {
            result = ImmutableSet.copyOf(this.delegate.getIrrelevantPredicates(pContext, (Collection<AbstractionPredicate>)predicates));
            this.irrelevantCache.put((Pair<Block, ImmutableSet<AbstractionPredicate>>)key, (ImmutableSet<AbstractionPredicate>)result);
        }
        return result;
    }

    @Override
    public Set<AbstractionPredicate> getRelevantPredicates(Block pContext, Collection<AbstractionPredicate> pPredicates) {
        if (pPredicates.isEmpty()) {
            return Collections.emptySet();
        }
        ImmutableSet predicates = ImmutableSet.copyOf(pPredicates);
        Pair key = Pair.of((Object)pContext, (Object)predicates);
        ImmutableSet result = this.relevantCache.get(key);
        if (result == null) {
            result = ImmutableSet.copyOf(this.delegate.getRelevantPredicates(pContext, (Collection<AbstractionPredicate>)predicates));
            this.relevantCache.put((Pair<Block, ImmutableSet<AbstractionPredicate>>)key, (ImmutableSet<AbstractionPredicate>)result);
        }
        return result;
    }

    @Override
    public void considerPredicateAsRelevant(Block pBlock, AbstractionPredicate pPredicate) {
        if (this.delegate instanceof RefineableRelevantPredicatesComputer) {
            RefineableRelevantPredicatesComputer refineableDelegate = (RefineableRelevantPredicatesComputer)this.delegate;
            refineableDelegate.considerPredicateAsRelevant(pBlock, pPredicate);
            CachingRelevantPredicatesComputer.removeCacheEntriesForBlock(pBlock, this.irrelevantCache);
            CachingRelevantPredicatesComputer.removeCacheEntriesForBlock(pBlock, this.relevantCache);
        }
    }

    static <U, V> void removeCacheEntriesForBlock(Block pBlock, Map<Pair<Block, U>, V> pCache) {
        ArrayList<Pair<Block, U>> removeKeys = new ArrayList<Pair<Block, U>>();
        for (Pair<Block, U> pair : pCache.keySet()) {
            if (!((Block)pair.getFirst()).equals(pBlock)) continue;
            removeKeys.add(pair);
        }
        for (Pair pair : removeKeys) {
            pCache.remove(pair);
        }
    }
}

