/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.types;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public interface Type {
    public TypeClass getTypeClass();

    public boolean isConst();

    public int sizeOf();

    public String getDefinition();

    public static abstract class AbstractType
    implements Type {
        private final boolean constant;

        public AbstractType(boolean constant) {
            this.constant = constant;
        }

        @Override
        public boolean isConst() {
            return this.constant;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Type)) {
                return false;
            }
            return this.equals((Type)obj);
        }

        public boolean equals(Type other) {
            return other != null && this.isConst() == other.isConst();
        }

        public abstract int hashCode();

        @Override
        public String getDefinition() {
            return this.toString();
        }
    }

    public static final class FunctionType
    extends AbstractType {
        private static int uniqueNameId = 0;
        private final String name;
        private final Type returnType;
        private final LinkedHashMap<String, Type> parameters;
        private boolean hasVarArgs;

        public FunctionType(String name, Type returnType, boolean hasVarArgs) {
            super(false);
            this.name = name;
            this.returnType = returnType;
            this.parameters = new LinkedHashMap();
            this.hasVarArgs = hasVarArgs;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addParameter(String name, Type type) {
            if (type == null) {
                throw new IllegalArgumentException();
            }
            if (name == null || name.equals("")) {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    name = "__cpa_anon_param_" + uniqueNameId++;
                }
            }
            if (this.parameters.containsKey(name)) {
                throw new IllegalArgumentException("Parameter " + name + " already exists");
            }
            this.parameters.put(name, type);
        }

        public String getName() {
            return this.name;
        }

        public Type getParameterType(String name) {
            if (!this.parameters.containsKey(name)) {
                throw new IllegalArgumentException("No such parameter");
            }
            return this.parameters.get(name);
        }

        public Set<String> getParameters() {
            return this.parameters.keySet();
        }

        public boolean hasVarArgs() {
            return this.hasVarArgs;
        }

        @Override
        public TypeClass getTypeClass() {
            return TypeClass.FUNCTION;
        }

        @Override
        public int sizeOf() {
            return 1;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FunctionType)) {
                return false;
            }
            FunctionType other = (FunctionType)obj;
            return obj == this || this.name.equals(other.name) && this.returnType.equals(other.returnType) && this.parameters.equals(other.parameters) && this.hasVarArgs == other.hasVarArgs;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name + "()";
        }

        @Override
        public String getDefinition() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.returnType);
            sb.append(" ");
            sb.append(this.name);
            sb.append("(");
            if (this.parameters.size() > 0) {
                for (String parameter : this.parameters.keySet()) {
                    sb.append(this.parameters.get(parameter));
                    sb.append(" ");
                    sb.append(parameter);
                    sb.append(", ");
                }
                sb.deleteCharAt(sb.length() - 2);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static final class EnumType
    extends AbstractType {
        private final Map<String, Long> enumerators = new HashMap<String, Long>();
        private final String name;

        public EnumType(String name, boolean constant) {
            super(constant);
            this.name = name;
        }

        public void addEnumerator(String name, long pL) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            if (this.enumerators.containsKey(name)) {
                throw new IllegalArgumentException("Enumerator " + name + " exists already");
            }
            this.enumerators.put(name, pL);
        }

        public long getEnumerator(String name) {
            if (!this.enumerators.containsKey(name)) {
                throw new IllegalArgumentException("No such enumerator");
            }
            return this.enumerators.get(name);
        }

        public Set<String> getEnumerators() {
            return this.enumerators.keySet();
        }

        @Override
        public int sizeOf() {
            return 4;
        }

        @Override
        public TypeClass getTypeClass() {
            return TypeClass.ENUM;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof EnumType)) {
                return false;
            }
            EnumType other = (EnumType)obj;
            return obj == this || super.equals(other) && this.name.equals(other.name) && ((Object)this.enumerators).equals(other.enumerators);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            if (this.isConst()) {
                return "const " + this.name;
            }
            return this.name;
        }

        @Override
        public String getDefinition() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString());
            sb.append(" { ");
            long lastValue = -1L;
            for (String enumerator : this.enumerators.keySet()) {
                sb.append(enumerator);
                long currentValue = this.enumerators.get(enumerator);
                if (currentValue != lastValue + 1L) {
                    sb.append("=");
                    sb.append(currentValue);
                }
                lastValue = currentValue;
                sb.append(", ");
            }
            sb.deleteCharAt(sb.length() - 2);
            sb.append("}");
            return sb.toString();
        }
    }

    public static final class UnionType
    extends CompositeType {
        public UnionType(String name, boolean constant) {
            super(name, constant);
        }

        @Override
        public int offsetOf(String name) {
            return 0;
        }

        @Override
        public int sizeOf() {
            int result = 0;
            for (Type member : this.members.values()) {
                result += Math.max(member.sizeOf(), result);
            }
            return result;
        }

        @Override
        public TypeClass getTypeClass() {
            return TypeClass.UNION;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof UnionType && super.equals(obj);
        }
    }

    public static final class StructType
    extends CompositeType {
        public StructType(String name, boolean constant) {
            super(name, constant);
        }

        @Override
        public int offsetOf(String name) {
            String member;
            if (!this.members.containsKey(name)) {
                throw new IllegalArgumentException("No such member!");
            }
            int result = 0;
            Iterator i$ = this.members.keySet().iterator();
            while (i$.hasNext() && !(member = (String)i$.next()).equals(name)) {
                result = (int)((double)result + Math.ceil((double)((Type)this.members.get(name)).sizeOf() / 4.0) * 4.0);
            }
            return result;
        }

        @Override
        public int sizeOf() {
            int result = 0;
            for (Type member : this.members.values()) {
                result = (int)((double)result + Math.ceil((double)member.sizeOf() / 4.0) * 4.0);
            }
            return result;
        }

        @Override
        public TypeClass getTypeClass() {
            return TypeClass.STRUCT;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof StructType && super.equals(obj);
        }
    }

    public static abstract class CompositeType
    extends AbstractType {
        protected final LinkedHashMap<String, Type> members = new LinkedHashMap();
        protected final String name;

        public CompositeType(String name, boolean constant) {
            super(constant);
            this.name = name;
        }

        public abstract int offsetOf(String var1);

        protected void addMember(String name, Type type) {
            if (name == null || type == null) {
                throw new IllegalArgumentException();
            }
            if (this.members.containsKey(name)) {
                throw new IllegalArgumentException("Member " + name + " exists already in type " + name);
            }
            this.members.put(name, type);
        }

        public Type getMemberType(String name) {
            if (!this.members.containsKey(name)) {
                throw new IllegalArgumentException("No such member");
            }
            return this.members.get(name);
        }

        public Set<String> getMembers() {
            return this.members.keySet();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CompositeType)) {
                return false;
            }
            CompositeType other = (CompositeType)obj;
            return obj == this || super.equals(other) && this.name.equals(other.name) && this.members.equals(other.members);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            if (this.isConst()) {
                return "const " + this.name;
            }
            return this.name;
        }

        @Override
        public String getDefinition() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString());
            sb.append(" { ");
            for (String member : this.members.keySet()) {
                sb.append(this.members.get(member));
                sb.append(" ");
                sb.append(member);
                sb.append("; ");
            }
            sb.append("}");
            return sb.toString();
        }
    }

    public static final class ArrayType
    extends AbstractType {
        private final Type type;
        private final int length;

        public ArrayType(Type type, int length) {
            super(false);
            if (type == null) {
                throw new IllegalArgumentException();
            }
            if (length < 0) {
                throw new IllegalArgumentException();
            }
            this.type = type;
            this.length = length;
        }

        @Override
        public int sizeOf() {
            return this.type.sizeOf() * this.length;
        }

        @Override
        public TypeClass getTypeClass() {
            return TypeClass.ARRAY;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ArrayType)) {
                return false;
            }
            ArrayType other = (ArrayType)obj;
            return this == other || super.equals(other) && this.type.equals(other.type);
        }

        @Override
        public int hashCode() {
            return 255 * this.type.hashCode();
        }

        public String toString() {
            return this.type.toString() + (this.isConst() ? " const " : "") + "[" + (this.length > 0 ? Integer.valueOf(this.length) : "") + "]";
        }
    }

    public static final class PointerType
    extends AbstractType {
        private final Type targetType;
        private final int levelOfIndirection;

        public PointerType(Type targetType, boolean constant) {
            super(constant);
            if (targetType == null) {
                throw new IllegalArgumentException();
            }
            this.targetType = targetType;
            this.levelOfIndirection = targetType instanceof PointerType ? ((PointerType)targetType).levelOfIndirection + 1 : 1;
        }

        @Override
        public int sizeOf() {
            return 4;
        }

        @Override
        public TypeClass getTypeClass() {
            return TypeClass.POINTER;
        }

        public Type getTargetType() {
            return this.targetType;
        }

        public int getLevelOfIndirection() {
            return this.levelOfIndirection;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof PointerType)) {
                return false;
            }
            PointerType other = (PointerType)obj;
            return this == obj || super.equals(other) && this.targetType.equals(other.targetType);
        }

        @Override
        public int hashCode() {
            return 254 * this.targetType.hashCode();
        }

        public String toString() {
            return this.targetType.toString() + (this.isConst() ? " const " : "") + "*";
        }
    }

    public static final class PrimitiveType
    extends AbstractType {
        private final Primitive primitiveType;
        private final boolean signed;

        public PrimitiveType(Primitive primitiveType, boolean signed, boolean constant) {
            super(constant);
            this.primitiveType = primitiveType;
            switch (primitiveType) {
                case VOID: {
                    this.signed = false;
                    break;
                }
                case CHAR: 
                case SHORT: 
                case LONG: 
                case LONGLONG: {
                    this.signed = signed;
                    break;
                }
                case FLOAT: 
                case DOUBLE: 
                case LONGDOUBLE: {
                    this.signed = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Missing case clause");
                }
            }
        }

        @Override
        public int sizeOf() {
            return this.primitiveType.sizeOf();
        }

        @Override
        public TypeClass getTypeClass() {
            return TypeClass.PRIMITIVE;
        }

        public boolean isSigned() {
            return this.signed;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof PrimitiveType)) {
                return false;
            }
            PrimitiveType other = (PrimitiveType)obj;
            return this == other || this.primitiveType == other.primitiveType && this.signed == other.signed && super.equals(other);
        }

        @Override
        public int hashCode() {
            return this.primitiveType.hashCode();
        }

        public String toString() {
            String signedString = "";
            if (this.primitiveType == Primitive.CHAR || this.primitiveType == Primitive.SHORT || this.primitiveType == Primitive.LONG || this.primitiveType == Primitive.LONGLONG) {
                signedString = this.signed ? "signed " : "unsigned ";
            }
            return (this.isConst() ? "const " : "") + signedString + this.primitiveType.toString();
        }
    }

    public static enum Primitive {
        VOID(1, "void"),
        CHAR(1, "char"),
        SHORT(2, "short int"),
        LONG(4, "long int"),
        LONGLONG(8, "long long int"),
        FLOAT(4, "float"),
        DOUBLE(8, "double"),
        LONGDOUBLE(12, "long double");

        private final int sizeOf;
        private final String name;

        private Primitive(int sizeOf, String name) {
            this.sizeOf = sizeOf;
            this.name = name;
        }

        public int sizeOf() {
            return this.sizeOf;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum TypeClass {
        PRIMITIVE,
        POINTER,
        ARRAY,
        ENUM,
        STRUCT,
        UNION,
        FUNCTION;

    }
}

