/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.types.Type;

public class TypesElement
implements AbstractElement {
    private final Map<String, Type> variables;
    private final Map<String, Type> typedefs;
    private final Map<String, Type.FunctionType> functions;

    public TypesElement() {
        this.variables = new HashMap<String, Type>();
        this.typedefs = new HashMap<String, Type>();
        this.functions = new HashMap<String, Type.FunctionType>();
    }

    public TypesElement(Map<String, Type> variables, Map<String, Type> typedefs, Map<String, Type.FunctionType> functions) {
        this.variables = new HashMap<String, Type>(variables);
        this.typedefs = new HashMap<String, Type>(typedefs);
        this.functions = new HashMap<String, Type.FunctionType>(functions);
    }

    public Map<String, Type> getTypedefs() {
        return Collections.unmodifiableMap(this.typedefs);
    }

    public Map<String, Type> getVariableTypes() {
        return Collections.unmodifiableMap(this.variables);
    }

    public Map<String, Type.FunctionType> getFunctions() {
        return Collections.unmodifiableMap(this.functions);
    }

    public void addVariable(String function, String name, Type type) {
        this.variables.put(this.getFullVariableName(function, name), type);
    }

    public void addTypedef(String name, Type type) {
        if (this.variables.containsKey(name)) {
            throw new IllegalArgumentException("Redeclared type " + name);
        }
        this.typedefs.put(name, type);
    }

    public void addFunction(String name, Type.FunctionType type) {
        if (this.variables.containsKey(name)) {
            throw new IllegalArgumentException("Redeclared function " + name);
        }
        this.functions.put(name, type);
    }

    public Type getVariableType(String function, String name) {
        Type result = this.variables.get(this.getFullVariableName(function, name));
        if (result == null && function != null) {
            assert (this.functions.containsKey(function));
            result = this.functions.get(function).getParameterType(name);
        }
        return result;
    }

    public Type getTypedef(String name) {
        return this.typedefs.get(name);
    }

    public Type.FunctionType getFunction(String name) {
        return this.functions.get(name);
    }

    public void join(TypesElement other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        if (other != this) {
            this.variables.putAll(other.variables);
            this.typedefs.putAll(other.typedefs);
        }
    }

    public boolean isSubsetOf(TypesElement other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        if (this.variables.size() > other.variables.size() || this.typedefs.size() > other.typedefs.size() || this.functions.size() > other.functions.size()) {
            return false;
        }
        for (String var : this.variables.keySet()) {
            if (this.variables.get(var).equals(other.variables.get(var))) continue;
            return false;
        }
        for (String type : this.typedefs.keySet()) {
            if (this.typedefs.get(type).equals(other.typedefs.get(type))) continue;
            return false;
        }
        for (String function : this.functions.keySet()) {
            if (this.functions.get(function).equals(other.functions.get(function))) continue;
            return false;
        }
        return true;
    }

    private String getFullVariableName(String function, String variable) {
        if (function == null) {
            return variable;
        }
        return function + "::" + variable;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TypesElement)) {
            return false;
        }
        TypesElement other = (TypesElement)obj;
        return ((Object)this.variables).equals(other.variables) && ((Object)this.typedefs).equals(other.typedefs) && ((Object)this.functions).equals(other.functions);
    }

    public int hashCode() {
        return ((Object)this.variables).hashCode() * ((Object)this.typedefs).hashCode() * ((Object)this.functions).hashCode();
    }

    public String toString() {
        return this.variables.toString() + " " + this.functions.toString();
    }
}

