/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.IASTArrayTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCompositeTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTElaboratedTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTEnumerationSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTNamedTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTPointerTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.types.Type;
import org.sosy_lab.cpachecker.cpa.types.TypesElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;

public class TypesTransferRelation
implements TransferRelation {
    private FunctionDefinitionNode entryFunctionDefinitionNode = null;
    private boolean entryFunctionProcessed = false;

    public Collection<TypesElement> getAbstractSuccessors(AbstractElement element, Precision precision, CFAEdge cfaEdge) throws CPATransferException {
        TypesElement successor = (TypesElement)element;
        switch (cfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                this.handleDeclaration(successor, (DeclarationEdge)cfaEdge);
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge funcCallEdge = (FunctionCallEdge)cfaEdge;
                FunctionDefinitionNode funcDefNode = funcCallEdge.getSuccessor();
                if (successor.getFunction(funcDefNode.getFunctionName()) != null) break;
                IASTFunctionDeclaration funcDef = funcDefNode.getFunctionDefinition();
                this.handleFunctionDeclaration(successor, funcCallEdge, funcDef.getDeclSpecifier());
                break;
            }
            case AssumeEdge: 
            case StatementEdge: 
            case ReturnStatementEdge: 
            case FunctionReturnEdge: {
                break;
            }
            case BlankEdge: {
                if (this.entryFunctionProcessed || !(cfaEdge.getPredecessor() instanceof CFAFunctionDefinitionNode)) break;
                IASTFunctionDeclaration funcDef = this.entryFunctionDefinitionNode.getFunctionDefinition();
                this.handleFunctionDeclaration(successor, null, funcDef.getDeclSpecifier());
                this.entryFunctionProcessed = true;
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(cfaEdge);
            }
        }
        return Collections.singleton(successor);
    }

    private void handleDeclaration(TypesElement element, DeclarationEdge declarationEdge) throws UnrecognizedCCodeException {
        IASTDeclaration decl = declarationEdge.getDeclaration();
        IType specifier = declarationEdge.getDeclaration().getDeclSpecifier();
        if (decl instanceof IASTFunctionDeclaration) {
            this.handleFunctionDeclaration(element, declarationEdge, (IASTFunctionTypeSpecifier)specifier);
        } else {
            Type type = this.getType(element, (CFAEdge)declarationEdge, specifier);
            if (decl instanceof IASTTypeDefDeclaration) {
                element.addTypedef(decl.getName(), type);
            } else if (decl instanceof IASTVariableDeclaration) {
                String functionName = null;
                if (!decl.isGlobal()) {
                    functionName = declarationEdge.getSuccessor().getFunctionName();
                }
                element.addVariable(functionName, decl.getName(), type);
            }
        }
    }

    private void handleFunctionDeclaration(TypesElement element, CFAEdge cfaEdge, IASTFunctionTypeSpecifier funcDeclSpecifier) throws UnrecognizedCCodeException {
        Type.FunctionType function = this.getType(element, cfaEdge, funcDeclSpecifier);
        if (cfaEdge != null && cfaEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge) assert (function.getName().equals(cfaEdge.getSuccessor().getFunctionName()));
        element.addFunction(function.getName(), function);
    }

    private Type getType(TypesElement element, CFAEdge cfaEdge, IType declSpecifier) throws UnrecognizedCCodeException {
        Type type;
        boolean constant = declSpecifier.isConst();
        if (declSpecifier instanceof IASTSimpleDeclSpecifier) {
            Type.Primitive primitiveType;
            IASTSimpleDeclSpecifier simpleSpecifier = (IASTSimpleDeclSpecifier)declSpecifier;
            switch (simpleSpecifier.getType()) {
                case CHAR: {
                    primitiveType = Type.Primitive.CHAR;
                    break;
                }
                case INT: 
                case UNSPECIFIED: {
                    if (simpleSpecifier.isShort()) {
                        primitiveType = Type.Primitive.SHORT;
                        break;
                    }
                    if (simpleSpecifier.isLong()) {
                        primitiveType = Type.Primitive.LONGLONG;
                        break;
                    }
                    primitiveType = Type.Primitive.LONG;
                    break;
                }
                case FLOAT: {
                    primitiveType = Type.Primitive.SHORT;
                    break;
                }
                case DOUBLE: {
                    if (simpleSpecifier.isLong()) {
                        primitiveType = Type.Primitive.LONGDOUBLE;
                        break;
                    }
                    primitiveType = Type.Primitive.DOUBLE;
                    break;
                }
                case VOID: {
                    primitiveType = Type.Primitive.VOID;
                    break;
                }
                default: {
                    throw new UnrecognizedCCodeException("Unknown basic type", cfaEdge);
                }
            }
            boolean signed = !simpleSpecifier.isUnsigned();
            type = new Type.PrimitiveType(primitiveType, signed, constant);
        } else if (declSpecifier instanceof IASTCompositeTypeSpecifier) {
            Type.CompositeType compType;
            IASTCompositeTypeSpecifier compositeSpecifier = (IASTCompositeTypeSpecifier)declSpecifier;
            String name = compositeSpecifier.getName();
            switch (compositeSpecifier.getKey()) {
                case 1: {
                    compType = new Type.StructType(name, constant);
                    name = "struct " + name;
                    break;
                }
                case 2: {
                    compType = new Type.StructType(name, constant);
                    name = "union " + name;
                    break;
                }
                default: {
                    throw new UnrecognizedCCodeException("Unknown composite type", cfaEdge);
                }
            }
            if (element.getTypedefs().containsKey(name)) {
                compType = (Type.CompositeType)element.getTypedef(name);
                if (!compType.getMembers().isEmpty()) {
                    throw new IllegalStateException("Redeclaration of type " + name);
                }
            } else {
                element.addTypedef(name, compType);
            }
            for (IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration subDeclaration : compositeSpecifier.getMembers()) {
                Type subType = this.getType(element, cfaEdge, subDeclaration.getDeclSpecifier());
                if (subDeclaration.getName() != null) {
                    String thisSubName = subDeclaration.getName();
                    if (thisSubName.isEmpty()) continue;
                    compType.addMember(thisSubName, subType);
                    continue;
                }
                throw new UnrecognizedCCodeException(cfaEdge, subDeclaration);
            }
            type = compType;
        } else if (declSpecifier instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)declSpecifier;
            String typeStr = elaboratedTypeSpecifier.getKind().name().toLowerCase();
            String name = typeStr + " " + elaboratedTypeSpecifier.getName();
            type = element.getTypedef(name);
            if (type == null) {
                switch (elaboratedTypeSpecifier.getKind()) {
                    case ENUM: {
                        type = new Type.EnumType(name, constant);
                        break;
                    }
                    case STRUCT: {
                        type = new Type.StructType(name, constant);
                        break;
                    }
                    case UNION: {
                        type = new Type.UnionType(name, constant);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Missing case clause");
                    }
                }
                element.addTypedef(name, type);
            }
        } else if (declSpecifier instanceof IASTEnumerationSpecifier) {
            Type.EnumType enumType;
            IASTEnumerationSpecifier enumSpecifier = (IASTEnumerationSpecifier)declSpecifier;
            String name = enumSpecifier.getName();
            if (element.getTypedefs().containsKey(name)) {
                enumType = (Type.EnumType)element.getTypedef(name);
                if (!enumType.getEnumerators().isEmpty()) {
                    throw new IllegalStateException("Redeclaration of type " + name);
                }
            } else {
                enumType = new Type.EnumType(name, constant);
                element.addTypedef(name, enumType);
            }
            for (IASTEnumerationSpecifier.IASTEnumerator enumerator : enumSpecifier.getEnumerators()) {
                enumType.addEnumerator(enumerator.getName(), enumerator.getValue());
            }
            type = enumType;
        } else if (declSpecifier instanceof IASTNamedTypeSpecifier) {
            IASTNamedTypeSpecifier namedTypeSpecifier = (IASTNamedTypeSpecifier)declSpecifier;
            type = element.getTypedef(namedTypeSpecifier.getName());
            if (type == null) {
                type = element.getFunction(namedTypeSpecifier.getName());
            }
            if (type == null) {
                throw new UnrecognizedCCodeException("Undefined type " + namedTypeSpecifier.getName(), cfaEdge);
            }
        } else if (declSpecifier instanceof IASTArrayTypeSpecifier) {
            IASTArrayTypeSpecifier arraySpecifier = (IASTArrayTypeSpecifier)declSpecifier;
            type = this.getType(element, cfaEdge, arraySpecifier.getType());
            int length = 0;
            IASTExpression lengthExpression = arraySpecifier.getLength();
            if (lengthExpression != null) {
                if (lengthExpression instanceof IASTLiteralExpression) {
                    Integer value = this.parseLiteral((IASTLiteralExpression)lengthExpression, cfaEdge);
                    if (value != null) {
                        length = value;
                    }
                } else {
                    length = 0;
                }
            }
            type = new Type.ArrayType(type, length);
        } else if (declSpecifier instanceof IASTFunctionTypeSpecifier) {
            IASTFunctionTypeSpecifier funcDeclSpecifier = (IASTFunctionTypeSpecifier)declSpecifier;
            type = this.getType(element, cfaEdge, funcDeclSpecifier);
        } else if (declSpecifier instanceof IASTPointerTypeSpecifier) {
            IASTPointerTypeSpecifier pointerSpecifier = (IASTPointerTypeSpecifier)declSpecifier;
            type = this.getType(element, cfaEdge, pointerSpecifier.getType());
            type = new Type.PointerType(type, pointerSpecifier.isConst());
        } else {
            throw new UnrecognizedCCodeException("Unknown type class " + declSpecifier.getClass().getSimpleName(), cfaEdge);
        }
        return type;
    }

    private Type.FunctionType getType(TypesElement element, CFAEdge cfaEdge, IASTFunctionTypeSpecifier funcDeclSpecifier) throws UnrecognizedCCodeException {
        Type returnType = this.getType(element, cfaEdge, funcDeclSpecifier.getReturnType());
        Type.FunctionType function = new Type.FunctionType(funcDeclSpecifier.getName(), returnType, funcDeclSpecifier.takesVarArgs());
        for (IASTParameterDeclaration parameter : funcDeclSpecifier.getParameters()) {
            Type parameterType = this.getType(element, cfaEdge, parameter.getDeclSpecifier());
            String parameterName = null;
            if (parameter.getName() != null) {
                parameterName = parameter.getName();
            }
            function.addParameter(parameterName, parameterType);
        }
        return function;
    }

    private Integer parseLiteral(IASTLiteralExpression expression, CFAEdge edge) throws UnrecognizedCCodeException {
        if (expression instanceof IASTIntegerLiteralExpression) {
            return ((IASTIntegerLiteralExpression)expression).getValue().intValue();
        }
        if (expression instanceof IASTFloatLiteralExpression) {
            return null;
        }
        if (expression instanceof IASTCharLiteralExpression) {
            return ((IASTCharLiteralExpression)expression).getCharacter();
        }
        if (expression instanceof IASTStringLiteralExpression) {
            return null;
        }
        throw new UnrecognizedCCodeException("unknown literal", edge, expression);
    }

    public void setEntryFunctionDefinitionNode(FunctionDefinitionNode pEntryFunctionDefNode) {
        this.entryFunctionDefinitionNode = pEntryFunctionDefNode;
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> otherElements, CFAEdge cfaEdge, Precision precision) {
        return null;
    }
}

