/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.uninitvars;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableElement;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

public class UninitializedVariablesElement
implements AbstractQueryableElement {
    private final Collection<String> globalVars;
    private final Deque<Pair<String, Collection<String>>> localVars;
    private final Collection<Triple<Integer, String, String>> warnings;
    private Set<ElementProperty> properties = EnumSet.noneOf(ElementProperty.class);

    public UninitializedVariablesElement(String entryFunction) {
        this.globalVars = new ArrayList<String>();
        this.localVars = new LinkedList<Pair<String, Collection<String>>>();
        this.warnings = new ArrayList<Triple<Integer, String, String>>();
        this.callFunction(entryFunction);
    }

    public UninitializedVariablesElement(Collection<String> globalVars, Deque<Pair<String, Collection<String>>> localVars, Collection<Triple<Integer, String, String>> warnings) {
        this.globalVars = globalVars;
        this.localVars = localVars;
        this.warnings = warnings;
    }

    public void addGlobalVariable(String name) {
        if (!this.globalVars.contains(name)) {
            this.globalVars.add(name);
        }
    }

    public void removeGlobalVariable(String name) {
        this.globalVars.remove(name);
    }

    public Collection<String> getGlobalVariables() {
        return this.globalVars;
    }

    public void addLocalVariable(String name) {
        if (!((Collection)this.localVars.peekLast().getSecond()).contains(name)) {
            ((Collection)this.localVars.peekLast().getSecond()).add(name);
        }
    }

    public void removeLocalVariable(String name) {
        ((Collection)this.localVars.peekLast().getSecond()).remove(name);
    }

    public Collection<String> getLocalVariables() {
        return (Collection)this.localVars.peekLast().getSecond();
    }

    public Deque<Pair<String, Collection<String>>> getallLocalVariables() {
        return this.localVars;
    }

    public Collection<Triple<Integer, String, String>> getWarnings() {
        return this.warnings;
    }

    public boolean isUninitialized(String variable) {
        return this.globalVars.contains(variable) || ((Collection)this.localVars.peekLast().getSecond()).contains(variable);
    }

    public void callFunction(String functionName) {
        this.localVars.addLast((Pair<String, Collection<String>>)Pair.of((Object)functionName, new ArrayList()));
    }

    public void returnFromFunction() {
        this.localVars.pollLast();
    }

    public void addWarning(Integer lineNumber, String variable, String message) {
        Triple warning = new Triple((Object)lineNumber, (Object)variable, (Object)message);
        if (!this.warnings.contains(warning)) {
            this.warnings.add((Triple<Integer, String, String>)warning);
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof UninitializedVariablesElement)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        UninitializedVariablesElement otherElement = (UninitializedVariablesElement)o;
        return ((Object)this.globalVars).equals(otherElement.globalVars) && this.localVars.equals(otherElement.localVars);
    }

    public int hashCode() {
        return this.localVars.hashCode();
    }

    protected UninitializedVariablesElement clone() {
        LinkedList<Pair<String, Collection<String>>> newLocalVars = new LinkedList<Pair<String, Collection<String>>>();
        for (Pair<String, Collection<String>> localContext : this.localVars) {
            newLocalVars.addLast((Pair<String, Collection<String>>)Pair.of((Object)localContext.getFirst(), new ArrayList((Collection)localContext.getSecond())));
        }
        return new UninitializedVariablesElement(new ArrayList<String>(this.globalVars), newLocalVars, new ArrayList<Triple<Integer, String, String>>(this.warnings));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[<global:");
        for (String string : this.globalVars) {
            sb.append(" " + string + " ");
        }
        for (Pair pair : this.localVars) {
            sb.append("> <" + (String)pair.getFirst() + ":");
            for (String var : (Collection)pair.getSecond()) {
                sb.append(" " + var + " ");
            }
        }
        sb.append(">]");
        return sb.toString();
    }

    void addProperty(ElementProperty pProp) {
        this.properties.add(pProp);
    }

    Set<ElementProperty> getProperties() {
        return this.properties;
    }

    void clearProperties() {
        this.properties.clear();
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        ElementProperty prop;
        try {
            prop = ElementProperty.valueOf(pProperty);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is not defined for this CPA (\"" + this.getCPAName() + "\"");
        }
        return this.properties.contains((Object)prop);
    }

    @Override
    public Boolean evaluateProperty(String pProperty) throws InvalidQueryException {
        return this.checkProperty(pProperty);
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        throw new InvalidQueryException("The uninitVars CPA does not support modification.");
    }

    @Override
    public String getCPAName() {
        return "uninitVars";
    }

    static enum ElementProperty {
        UNINITIALIZED_RETURN_VALUE,
        UNINITIALIZED_VARIABLE_USED;

    }
}

