/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.uninitvars;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.uninitvars.UninitializedVariablesElement;
import org.sosy_lab.cpachecker.util.AbstractElements;

public class UninitializedVariablesStatistics
implements Statistics {
    private boolean printWarnings;

    public UninitializedVariablesStatistics(String printWarnings) {
        this.printWarnings = Boolean.parseBoolean(printWarnings);
    }

    @Override
    public String getName() {
        return "UninitializedVariablesCPA";
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        int noOfWarnings = 0;
        if (this.printWarnings) {
            HashSet<Pair> warningsDisplayed = new HashSet<Pair>();
            Iterable<UninitializedVariablesElement> projectedReached = AbstractElements.projectToType(pReached, UninitializedVariablesElement.class);
            for (UninitializedVariablesElement uninitElement : Iterables.filter(projectedReached, (Predicate)Predicates.notNull())) {
                Collection<Triple<Integer, String, String>> warnings = uninitElement.getWarnings();
                for (Triple<Integer, String, String> warning : warnings) {
                    Pair warningIndex = Pair.of((Object)warning.getFirst(), (Object)warning.getSecond());
                    if (warningsDisplayed.contains(warningIndex)) continue;
                    warningsDisplayed.add(warningIndex);
                    pOut.println((String)warning.getThird());
                    ++noOfWarnings;
                }
            }
            if (warningsDisplayed.isEmpty()) {
                pOut.println("No uninitialized variables found");
            } else {
                pOut.println("No of uninitialized vars : " + noOfWarnings);
            }
        } else {
            pOut.println("Output deactivated by configuration option");
        }
    }
}

