/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.uninitvars;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTArrayTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializer;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.StorageClass;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.types.Type;
import org.sosy_lab.cpachecker.cpa.types.TypesElement;
import org.sosy_lab.cpachecker.cpa.uninitvars.UninitializedVariablesElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;

public class UninitializedVariablesTransferRelation
implements TransferRelation {
    private Set<String> globalVars = new HashSet<String>();
    private boolean printWarnings;
    private LogManager logger;
    private String lastAdded = null;
    private boolean typesWarningAlreadyDisplayed = false;

    public UninitializedVariablesTransferRelation(String printWarnings, LogManager logger) {
        this.printWarnings = Boolean.parseBoolean(printWarnings);
        this.logger = logger;
    }

    private AbstractElement getAbstractSuccessor(AbstractElement element, CFAEdge cfaEdge, Precision precision) throws CPATransferException {
        UninitializedVariablesElement successor = ((UninitializedVariablesElement)element).clone();
        successor.clearProperties();
        switch (cfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                this.handleDeclaration(successor, (DeclarationEdge)cfaEdge);
                break;
            }
            case StatementEdge: {
                this.handleStatement(successor, ((StatementEdge)cfaEdge).getStatement(), cfaEdge);
                break;
            }
            case ReturnStatementEdge: {
                if (this.isExpressionUninitialized(successor, ((ReturnStatementEdge)cfaEdge).getExpression(), cfaEdge)) {
                    this.setUninitialized(successor, "CPAChecker_UninitVars_FunctionReturn");
                    break;
                }
                this.setInitialized(successor, "CPAChecker_UninitVars_FunctionReturn");
                break;
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge functionReturnEdge = (FunctionReturnEdge)cfaEdge;
                CallToReturnEdge ctrEdge = functionReturnEdge.getSuccessor().getEnteringSummaryEdge();
                this.handleStatement(successor, ctrEdge.getExpression().asStatement(), ctrEdge);
                break;
            }
            case AssumeEdge: {
                if (!this.printWarnings) break;
                this.isExpressionUninitialized(successor, ((AssumeEdge)cfaEdge).getExpression(), cfaEdge);
                break;
            }
            case FunctionCallEdge: {
                this.handleFunctionCall(successor, (FunctionCallEdge)cfaEdge);
                break;
            }
            case BlankEdge: {
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(cfaEdge);
            }
        }
        return successor;
    }

    private void addWarning(CFAEdge edge, String variable, IASTRightHandSide expression, UninitializedVariablesElement element) {
        if (this.printWarnings) {
            String message;
            int lineNumber = edge.getLineNumber();
            if (edge instanceof CallToReturnEdge && expression instanceof IASTFunctionCallExpression) {
                message = "uninitialized return value of function call " + variable + " in line " + lineNumber + ": " + edge.getDescription();
                element.addProperty(UninitializedVariablesElement.ElementProperty.UNINITIALIZED_RETURN_VALUE);
            } else {
                message = "uninitialized variable " + variable + " used in line " + lineNumber + ": " + edge.getDescription();
                element.addProperty(UninitializedVariablesElement.ElementProperty.UNINITIALIZED_VARIABLE_USED);
            }
            element.addWarning(lineNumber, variable, message);
        }
    }

    private void setUninitialized(UninitializedVariablesElement element, String varName) {
        if (this.globalVars.contains(varName)) {
            element.addGlobalVariable(varName);
        } else {
            element.addLocalVariable(varName);
        }
    }

    private void setInitialized(UninitializedVariablesElement element, String varName) {
        if (this.globalVars.contains(varName)) {
            element.removeGlobalVariable(varName);
        } else {
            element.removeLocalVariable(varName);
        }
    }

    private void handleDeclaration(UninitializedVariablesElement element, DeclarationEdge declarationEdge) {
        if (!(declarationEdge.getDeclaration() instanceof IASTVariableDeclaration)) {
            return;
        }
        IASTVariableDeclaration decl = (IASTVariableDeclaration)declarationEdge.getDeclaration();
        String varName = decl.getName();
        if (decl.isGlobal()) {
            this.globalVars.add(varName);
        }
        this.lastAdded = varName;
        IType specifier = decl.getDeclSpecifier();
        IASTInitializer initializer = decl.getInitializer();
        if (initializer == null && decl.getStorageClass() != StorageClass.EXTERN && !(specifier instanceof IASTArrayTypeSpecifier) && !(specifier instanceof IASTFunctionTypeSpecifier)) {
            this.setUninitialized(element, varName);
        } else {
            this.setInitialized(element, varName);
        }
    }

    private void handleFunctionCall(UninitializedVariablesElement element, FunctionCallEdge callEdge) throws UnrecognizedCCodeException {
        FunctionDefinitionNode functionEntryNode = callEdge.getSuccessor();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        List<IASTExpression> arguments = callEdge.getArguments();
        if (!arguments.isEmpty()) {
            int numOfParams = paramNames.size();
            if (numOfParams < arguments.size()) {
                for (int j = numOfParams; j < arguments.size(); ++j) {
                    this.isExpressionUninitialized(element, arguments.get(j), callEdge);
                }
            }
            LinkedList<String> uninitParameters = new LinkedList<String>();
            LinkedList<String> initParameters = new LinkedList<String>();
            for (int i = 0; i < numOfParams; ++i) {
                if (this.isExpressionUninitialized(element, arguments.get(i), callEdge)) {
                    uninitParameters.add(paramNames.get(i));
                    continue;
                }
                initParameters.add(paramNames.get(i));
            }
            element.callFunction(functionEntryNode.getFunctionName());
            for (String param : uninitParameters) {
                this.setUninitialized(element, param);
            }
            for (String param : initParameters) {
                this.setInitialized(element, param);
            }
        } else {
            element.callFunction(functionEntryNode.getFunctionName());
        }
    }

    private void handleStatement(UninitializedVariablesElement element, IASTStatement expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression instanceof IASTFunctionCallStatement) {
            if (cfaEdge instanceof CallToReturnEdge) {
                element.returnFromFunction();
            }
            if (this.printWarnings) {
                for (IASTExpression param : ((IASTFunctionCallStatement)expression).getFunctionCallExpression().getParameterExpressions()) {
                    this.isExpressionUninitialized(element, param, cfaEdge);
                }
            }
        } else if (expression instanceof IASTExpressionStatement) {
            if (this.printWarnings) {
                this.isExpressionUninitialized(element, ((IASTExpressionStatement)expression).getExpression(), cfaEdge);
            }
        } else if (expression instanceof IASTAssignment) {
            IASTAssignment assignExpression = (IASTAssignment)((Object)expression);
            this.handleAssign(element, assignExpression, cfaEdge);
        } else {
            throw new UnrecognizedCCodeException(cfaEdge, expression);
        }
    }

    private void handleAssign(UninitializedVariablesElement element, IASTAssignment expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        IASTExpression op1 = expression.getLeftHandSide();
        IASTRightHandSide op2 = expression.getRightHandSide();
        if (op1 instanceof IASTIdExpression) {
            String leftName = ((IASTIdExpression)op1).getName();
            if (this.isExpressionUninitialized(element, op2, cfaEdge)) {
                this.setUninitialized(element, leftName);
            } else {
                this.setInitialized(element, leftName);
            }
        } else if (op1 instanceof IASTFieldReference) {
            if (((IASTFieldReference)op1).isPointerDereference()) {
                if (this.printWarnings) {
                    this.isExpressionUninitialized(element, op1, cfaEdge);
                    this.isExpressionUninitialized(element, op2, cfaEdge);
                }
            } else {
                String leftName = op1.toASTString();
                if (this.isExpressionUninitialized(element, op2, cfaEdge)) {
                    this.setUninitialized(element, leftName);
                } else {
                    this.setInitialized(element, leftName);
                }
            }
        } else if (op1 instanceof IASTUnaryExpression && ((IASTUnaryExpression)op1).getOperator() == IASTUnaryExpression.UnaryOperator.STAR || op1 instanceof IASTArraySubscriptExpression) {
            if (this.printWarnings) {
                this.isExpressionUninitialized(element, op1, cfaEdge);
                this.isExpressionUninitialized(element, op2, cfaEdge);
            }
        } else {
            throw new UnrecognizedCCodeException("unknown left hand side of an assignment", cfaEdge, op1);
        }
    }

    private boolean isExpressionUninitialized(UninitializedVariablesElement element, IASTRightHandSide expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression == null) {
            return false;
        }
        if (expression instanceof IASTIdExpression) {
            String variable = ((IASTIdExpression)expression).getName();
            if (element.isUninitialized(variable)) {
                this.addWarning(cfaEdge, variable, expression, element);
                return true;
            }
            return false;
        }
        if (expression instanceof IASTTypeIdExpression) {
            return false;
        }
        if (expression instanceof IASTFieldReference) {
            IASTFieldReference e = (IASTFieldReference)expression;
            if (e.isPointerDereference()) {
                return this.isExpressionUninitialized(element, e.getFieldOwner(), cfaEdge);
            }
            String variable = expression.toASTString();
            if (element.isUninitialized(variable)) {
                this.addWarning(cfaEdge, variable, expression, element);
                return true;
            }
            return false;
        }
        if (expression instanceof IASTArraySubscriptExpression) {
            IASTArraySubscriptExpression arrayExpression = (IASTArraySubscriptExpression)expression;
            return this.isExpressionUninitialized(element, arrayExpression.getArrayExpression(), cfaEdge) | this.isExpressionUninitialized(element, arrayExpression.getSubscriptExpression(), cfaEdge);
        }
        if (expression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
            IASTUnaryExpression.UnaryOperator typeOfOperator = unaryExpression.getOperator();
            if (typeOfOperator == IASTUnaryExpression.UnaryOperator.AMPER || typeOfOperator == IASTUnaryExpression.UnaryOperator.SIZEOF) {
                return false;
            }
            return this.isExpressionUninitialized(element, unaryExpression.getOperand(), cfaEdge);
        }
        if (expression instanceof IASTBinaryExpression) {
            IASTBinaryExpression binExpression = (IASTBinaryExpression)expression;
            return this.isExpressionUninitialized(element, binExpression.getOperand1(), cfaEdge) | this.isExpressionUninitialized(element, binExpression.getOperand2(), cfaEdge);
        }
        if (expression instanceof IASTCastExpression) {
            return this.isExpressionUninitialized(element, ((IASTCastExpression)expression).getOperand(), cfaEdge);
        }
        if (expression instanceof IASTFunctionCallExpression) {
            IASTFunctionCallExpression funcExpression = (IASTFunctionCallExpression)expression;
            if (cfaEdge instanceof StatementEdge) {
                for (IASTExpression param : funcExpression.getParameterExpressions()) {
                    this.isExpressionUninitialized(element, param, cfaEdge);
                }
                return false;
            }
            boolean returnUninit = element.isUninitialized("CPAChecker_UninitVars_FunctionReturn");
            if (this.printWarnings && returnUninit) {
                this.addWarning(cfaEdge, funcExpression.toASTString(), expression, element);
            }
            if (cfaEdge instanceof CallToReturnEdge) {
                element.returnFromFunction();
            }
            return returnUninit;
        }
        if (expression instanceof IASTLiteralExpression) {
            return false;
        }
        throw new UnrecognizedCCodeException(cfaEdge, expression);
    }

    public Collection<AbstractElement> getAbstractSuccessors(AbstractElement element, Precision precision, CFAEdge cfaEdge) throws CPATransferException {
        return Collections.singleton(this.getAbstractSuccessor(element, cfaEdge, precision));
    }

    @Override
    public Collection<? extends AbstractElement> strengthen(AbstractElement element, List<AbstractElement> otherElements, CFAEdge cfaEdge, Precision precision) {
        IASTStatement exp;
        boolean typesCPAPresent = false;
        if (cfaEdge.getEdgeType() == CFAEdgeType.DeclarationEdge && this.lastAdded != null) {
            DeclarationEdge declEdge = (DeclarationEdge)cfaEdge;
            for (AbstractElement other : otherElements) {
                if (!(other instanceof TypesElement)) continue;
                typesCPAPresent = true;
                TypesElement typeElem = (TypesElement)other;
                Type t = this.findType(typeElem, cfaEdge, this.lastAdded);
                if (t == null || t.getTypeClass() != Type.TypeClass.STRUCT) continue;
                this.handleStructDeclaration((UninitializedVariablesElement)element, typeElem, (Type.CompositeType)t, this.lastAdded, this.lastAdded, declEdge.getDeclaration().isGlobal());
            }
            if (!this.typesWarningAlreadyDisplayed && !typesCPAPresent && this.lastAdded != null) {
                this.typesWarningAlreadyDisplayed = true;
                this.logger.log(Level.INFO, new Object[]{"TypesCPA not present - information about field references may be unreliable"});
            }
            this.lastAdded = null;
        }
        if (cfaEdge.getEdgeType() == CFAEdgeType.StatementEdge && (exp = ((StatementEdge)cfaEdge).getStatement()) instanceof IASTAssignment) {
            IASTExpression op1 = ((IASTAssignment)((Object)exp)).getLeftHandSide();
            IASTRightHandSide op2 = ((IASTAssignment)((Object)exp)).getRightHandSide();
            String leftName = op1.toASTString();
            String rightName = op2.toASTString();
            for (AbstractElement other : otherElements) {
                if (!(other instanceof TypesElement)) continue;
                typesCPAPresent = true;
                TypesElement typeElem = (TypesElement)other;
                Type t1 = this.checkForFieldReferenceType(op1, typeElem, cfaEdge);
                Type t2 = this.checkForFieldReferenceType(op2, typeElem, cfaEdge);
                if (t1 == null || t2 == null || t1.getTypeClass() != Type.TypeClass.STRUCT || t2.getTypeClass() != Type.TypeClass.STRUCT) continue;
                assert (t1.equals(t2));
                this.initializeFields((UninitializedVariablesElement)element, cfaEdge, op2, typeElem, (Type.CompositeType)t1, leftName, rightName, leftName, rightName);
            }
        }
        return null;
    }

    private void initializeFields(UninitializedVariablesElement element, CFAEdge cfaEdge, IASTRightHandSide exp, TypesElement typeElem, Type.CompositeType structType, String leftName, String rightName, String recursiveLeftName, String recursiveRightName) {
        Set<String> members = structType.getMembers();
        for (String member : members) {
            Type t = structType.getMemberType(member);
            if (t != null && t.getTypeClass() == Type.TypeClass.STRUCT) {
                this.initializeFields(element, cfaEdge, exp, typeElem, (Type.CompositeType)t, member, member, recursiveLeftName + "." + member, recursiveRightName + "." + member);
                continue;
            }
            if (!element.isUninitialized(recursiveRightName + "." + member)) continue;
            if (this.printWarnings) {
                this.addWarning(cfaEdge, recursiveRightName + "." + member, exp, element);
            }
            this.setUninitialized(element, recursiveLeftName + "." + member);
        }
    }

    private void handleStructDeclaration(UninitializedVariablesElement element, TypesElement typeElem, Type.CompositeType structType, String varName, String recursiveVarName, boolean isGlobalDeclaration) {
        this.setInitialized(element, recursiveVarName);
        Set<String> members = structType.getMembers();
        for (String member : members) {
            Type t = structType.getMemberType(member);
            if (t != null && t.getTypeClass() == Type.TypeClass.STRUCT) {
                this.handleStructDeclaration(element, typeElem, (Type.CompositeType)t, member, recursiveVarName + "." + member, isGlobalDeclaration);
                continue;
            }
            if (isGlobalDeclaration) {
                this.globalVars.add(recursiveVarName + "." + member);
            }
            this.setUninitialized(element, recursiveVarName + "." + member);
        }
    }

    private Type checkForFieldReferenceType(IASTRightHandSide exp, TypesElement typeElem, CFAEdge cfaEdge) {
        String name = exp.toASTString();
        Type t = null;
        if (exp instanceof IASTFieldReference) {
            String[] s = name.split("[.]");
            t = this.findType(typeElem, cfaEdge, s[0]);
            for (int i = 1; t != null && t.getTypeClass() == Type.TypeClass.STRUCT && i < s.length; ++i) {
                t = ((Type.CompositeType)t).getMemberType(s[i]);
            }
        } else {
            t = this.findType(typeElem, cfaEdge, name);
        }
        return t;
    }

    private Type findType(TypesElement typeElem, CFAEdge cfaEdge, String varName) {
        Type t = null;
        t = typeElem.getTypedef(varName);
        if (t == null) {
            t = typeElem.getFunction(varName);
        }
        if (t == null) {
            t = typeElem.getVariableType(null, varName);
        }
        try {
            if (t == null) {
                t = typeElem.getVariableType(cfaEdge.getSuccessor().getFunctionName(), varName);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return t;
    }
}

