/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.exceptions;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class RefinementFailedException
extends CPAException {
    private static final long serialVersionUID = 2353178323706458175L;
    private final Reason reason;
    private Path path;
    private final int failurePoint;

    public RefinementFailedException(Reason r, Path p, int pFailurePoint) {
        super("Refinement failed: " + Preconditions.checkNotNull((Object)((Object)r)));
        this.reason = r;
        this.path = p;
        this.failurePoint = pFailurePoint;
    }

    public RefinementFailedException(Reason r, Path p) {
        this(r, p, -1);
    }

    public Reason getReason() {
        return this.reason;
    }

    public Path getErrorPath() {
        return this.path;
    }

    public void setErrorPath(Path pPath) {
        this.path = pPath;
    }

    public int getFailurePoint() {
        return this.failurePoint;
    }

    public static enum Reason {
        InterpolationFailed("Interpolation failed"),
        InvariantRefinementFailed("Could not find invariant"),
        RepeatedCounterexample("Counterexample could not be ruled out and was found again"),
        TooMuchUnrolling("Too much unrolling"),
        InfeasibleCounterexample("External tool verified counterexample as infeasible"),
        TIMEOUT("SMT-solver timed out");

        private final String humanReableReason;

        private Reason(String pHumanReableReason) {
            this.humanReableReason = pHumanReableReason;
        }

        public String toString() {
            return this.humanReableReason;
        }
    }
}

