/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.exceptions;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class UnrecognizedCCodeException
extends CPATransferException {
    private static final String MESSAGE = "Unrecognized C code";
    private static final long serialVersionUID = -8319167530363457020L;

    protected UnrecognizedCCodeException(String msg1, String msg2, CFAEdge edge, IASTNode astNode) {
        super(UnrecognizedCCodeException.createMessage(msg1, msg2, edge, astNode));
    }

    public UnrecognizedCCodeException(String msg2, CFAEdge edge, IASTNode astNode) {
        super(UnrecognizedCCodeException.createMessage(MESSAGE, msg2, edge, astNode));
    }

    public UnrecognizedCCodeException(String msg2, CFAEdge edge) {
        super(UnrecognizedCCodeException.createMessage(MESSAGE, msg2, edge, null));
    }

    public UnrecognizedCCodeException(CFAEdge edge, IASTNode astNode) {
        super(UnrecognizedCCodeException.createMessage(MESSAGE, null, edge, astNode));
    }

    protected static String createMessage(String msg1, String msg2, CFAEdge edge, IASTNode astNode) {
        Preconditions.checkNotNull((Object)msg1);
        if (astNode == null) {
            astNode = (IASTNode)edge.getRawAST().get();
        }
        String code = astNode.toASTString();
        String rawCode = edge.getRawStatement();
        StringBuilder sb = new StringBuilder();
        sb.append(msg1);
        if (msg2 != null) {
            sb.append(" (");
            sb.append(msg2);
            sb.append(")");
        }
        sb.append(" in line ");
        sb.append(edge.getLineNumber());
        sb.append(": ");
        sb.append(code);
        String codeWithoutWhitespace = CharMatcher.WHITESPACE.removeFrom((CharSequence)code);
        String rawCodeWithoutWhitespace = CharMatcher.WHITESPACE.removeFrom((CharSequence)rawCode);
        if (!codeWithoutWhitespace.equals(rawCodeWithoutWhitespace)) {
            sb.append(" (line was originally ");
            sb.append(rawCode);
            sb.append(")");
        }
        return sb.toString();
    }
}

