/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.art.ARTCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.assume.AssumeCPA;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackCPA;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathCPA;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathStandardElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.progress.ProgressPrecision;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterCPA;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterElement;
import org.sosy_lab.cpachecker.cpa.interpreter.exceptions.MissingInputException;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateRefiner;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.fshell.testcases.PreciseInputsTestCase;
import org.sosy_lab.cpachecker.fshell.testcases.TestCase;

public class AlternatingRefiner
implements Refiner {
    private final PredicateRefiner mPredicateRefiner;
    private final Configuration mConfiguration;
    private final LogManager mLogManager;
    private final GuardedEdgeAutomatonCPA mCoverAutomatonCPA;
    private final GuardedEdgeAutomatonCPA mPassingAutomatonCPA;
    private final ProductAutomatonCPA mProductAutomatonCPA;
    private final LocationCPA mLocationCPA;
    private final CallstackCPA mCallStackCPA;
    private final AssumeCPA mAssumeCPA;
    private final CFAPathCPA mCFAPathCPA;
    private final ARTCPA mARTCPA;
    private final CFAFunctionDefinitionNode mEntryNode;
    private final CFANode mEndNode;
    private TestCase mCoveringTestCase = null;
    private Set<TestCase> mIntermediateTestSuite;
    private CFAEdge[] mExecutionPath = null;

    public AlternatingRefiner(GuardedEdgeAutomatonCPA pCoverAutomatonCPA, GuardedEdgeAutomatonCPA pPassingAutomatonCPA, LocationCPA pLocationCPA, CallstackCPA pCallStackCPA, AssumeCPA pAssumeCPA, CFAPathCPA pCFAPathCPA, ARTCPA pARTCPA, CFAFunctionDefinitionNode pEntryNode, CFANode pEndNode, PredicateRefiner pPredicateRefiner, Configuration pConfiguration, LogManager pLogManager) {
        this.mCoverAutomatonCPA = pCoverAutomatonCPA;
        this.mPassingAutomatonCPA = pPassingAutomatonCPA;
        this.mLocationCPA = pLocationCPA;
        this.mCallStackCPA = pCallStackCPA;
        this.mAssumeCPA = pAssumeCPA;
        this.mCFAPathCPA = pCFAPathCPA;
        this.mARTCPA = pARTCPA;
        this.mPredicateRefiner = pPredicateRefiner;
        this.mConfiguration = pConfiguration;
        this.mLogManager = pLogManager;
        this.mEntryNode = pEntryNode;
        this.mEndNode = pEndNode;
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (this.mPassingAutomatonCPA != null) {
            lAutomatonCPAs.add(this.mPassingAutomatonCPA);
        }
        lAutomatonCPAs.add(this.mCoverAutomatonCPA);
        this.mProductAutomatonCPA = ProductAutomatonCPA.create(lAutomatonCPAs, false);
        this.mIntermediateTestSuite = new HashSet<TestCase>();
    }

    public boolean hasCoveringTestCase() {
        return this.mCoveringTestCase != null;
    }

    public TestCase getCoveringTestCase() {
        return this.mCoveringTestCase;
    }

    public CFAEdge[] getExecutionPath() {
        return this.mExecutionPath;
    }

    public Set<TestCase> getIntermediateTestSuite() {
        return this.mIntermediateTestSuite;
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        ConfigurableProgramAnalysis lCPA;
        CounterexampleInfo lTraceInfo = this.mPredicateRefiner.performRefinementWithInfo(pReached);
        if (lTraceInfo.isSpurious()) {
            return true;
        }
        TestCase lTestCase = TestCase.fromCounterexample(lTraceInfo, this.mLogManager);
        if (!lTestCase.isPrecise()) {
            System.err.println("TEST CASE IS IMPRECISE!");
        }
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        lComponentAnalyses.add(this.mCallStackCPA);
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(lTestCase.getInputs(), true);
        int lInterpreterCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(lInterpreterCPA);
        int lProductAutomatonCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(this.mProductAutomatonCPA);
        int lCFAPathCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(this.mCFAPathCPA);
        lComponentAnalyses.add(this.mAssumeCPA);
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(this.mConfiguration);
        lCPAFactory.setLogger(this.mLogManager);
        try {
            lCPA = lCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e1) {
            throw new RuntimeException(e1);
        }
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, this.mLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(this.mEntryNode);
        Precision lInitialPrecision = lCPA.getInitialPrecision(this.mEntryNode);
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        boolean lMissesInput = false;
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (MissingInputException e) {
            lMissesInput = true;
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CompositeElement lEndNode = (CompositeElement)lReachedSet.getLastElement();
        if (!lMissesInput && lEndNode != null && ((LocationElement)lEndNode.get(0)).getLocationNode().equals(this.mEndNode)) {
            if (((ProductAutomatonElement)lEndNode.get(lProductAutomatonCPAIndex)).isFinalState()) {
                InterpreterElement lInterpreterElement = (InterpreterElement)lEndNode.get(lInterpreterCPAIndex);
                int[] lInputs = lInterpreterElement.getInputs();
                this.mCoveringTestCase = lTestCase.getInputs() == lInputs ? lTestCase : new PreciseInputsTestCase(lInputs);
                CFAPathStandardElement lPathElement = (CFAPathStandardElement)lEndNode.get(lCFAPathCPAIndex);
                this.mExecutionPath = lPathElement.toArray();
                return false;
            }
            throw new RuntimeException();
        }
        this.mIntermediateTestSuite.add(lTestCase);
        AbstractElement lLastElement = pReached.getLastElement();
        CompositePrecision lPrecision = (CompositePrecision)pReached.getPrecision(lLastElement);
        ARTElement lLastARTElement = (ARTElement)lLastElement;
        CompositeElement lWrappedElement = (CompositeElement)lLastARTElement.getWrappedElement();
        CompositePrecision lProductAutomatonPrecision = (CompositePrecision)lPrecision.get(2);
        ProgressPrecision lProgressPrecision = (ProgressPrecision)lProductAutomatonPrecision.get(0);
        HashMap<ARTElement, CompositePrecision> lRemoveElements = new HashMap<ARTElement, CompositePrecision>();
        for (ARTElement lParent : lLastARTElement.getParents()) {
            int lIndex;
            CompositePrecision lParentPrecision = (CompositePrecision)pReached.getPrecision(lParent);
            CompositePrecision lAutomatonPrecision = (CompositePrecision)lParentPrecision.get(2);
            ArrayList<Precision> lNewPrecisions = new ArrayList<Precision>(lProductAutomatonPrecision.getPrecisions().size());
            lNewPrecisions.add(lProgressPrecision);
            for (int lIndex2 = 1; lIndex2 < lProductAutomatonPrecision.getPrecisions().size(); ++lIndex2) {
                lNewPrecisions.add(lAutomatonPrecision.get(lIndex2));
            }
            CompositePrecision lNewAutomatonPrecision = new CompositePrecision(lNewPrecisions);
            ArrayList<Precision> lNewPrecisions2 = new ArrayList<Precision>(lParentPrecision.getPrecisions().size());
            for (lIndex = 0; lIndex < 2; ++lIndex) {
                lNewPrecisions2.add(lParentPrecision.get(lIndex));
            }
            lNewPrecisions2.add(lNewAutomatonPrecision);
            for (lIndex = 3; lIndex < lWrappedElement.getNumberofElements(); ++lIndex) {
                lNewPrecisions2.add(lParentPrecision.get(lIndex));
            }
            CompositePrecision lNewPrecision = new CompositePrecision(lNewPrecisions2);
            lRemoveElements.put(lParent, lNewPrecision);
        }
        ARTReachedSet lARTReached = new ARTReachedSet(pReached, this.mARTCPA);
        for (Map.Entry lEntry : lRemoveElements.entrySet()) {
            lARTReached.removeSubtree((ARTElement)lEntry.getKey(), (Precision)lEntry.getValue());
        }
        return true;
    }
}

