/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateRefiner;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.fshell.FShell3Result;
import org.sosy_lab.cpachecker.fshell.FeasibilityInformation;
import org.sosy_lab.cpachecker.fshell.IncrementalARTReusingFQLTestGenerator;
import org.sosy_lab.cpachecker.fshell.IncrementalAndAlternatingFQLTestGenerator;
import org.sosy_lab.cpachecker.fshell.IncrementalFQLTestGenerator;
import org.sosy_lab.cpachecker.fshell.LoggingFeasibilityInformation;
import org.sosy_lab.cpachecker.fshell.NonincrementalFQLTestGenerator;
import org.sosy_lab.cpachecker.fshell.StandardFQLCoverageAnalyser;
import org.sosy_lab.cpachecker.fshell.ThreeValuedAnswer;
import org.sosy_lab.cpachecker.fshell.interfaces.FQLCoverageAnalyser;
import org.sosy_lab.cpachecker.fshell.interfaces.FQLTestGenerator;
import org.sosy_lab.cpachecker.fshell.testcases.ImpreciseExecutionException;
import org.sosy_lab.cpachecker.fshell.testcases.LoggingTestSuite;
import org.sosy_lab.cpachecker.fshell.testcases.TestCase;
import org.sosy_lab.cpachecker.fshell.testcases.TestSuite;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;

public class FShell3
implements FQLTestGenerator,
FQLCoverageAnalyser {
    private final NonincrementalFQLTestGenerator mNonincrementalTestGenerator;
    private final IncrementalFQLTestGenerator mIncrementalTestGenerator;
    private final IncrementalAndAlternatingFQLTestGenerator mIncrementalAndAlternatingTestGenerator;
    private final StandardFQLCoverageAnalyser mCoverageAnalyser;
    private final IncrementalARTReusingFQLTestGenerator mIncrementalARTReusingTestGenerator;
    private String mFeasibilityInformationOutputFile = null;
    private String mFeasibilityInformationInputFile = null;
    private String mTestSuiteOutputFile = null;
    private int mMinIndex = 0;
    private int mMaxIndex = Integer.MAX_VALUE;
    private boolean mDoLogging = false;
    private boolean mDoAppendingLogging = false;
    private boolean mDoRestart = false;
    private long mRestartBound = 100000000L;

    public FShell3(String pSourceFileName, String pEntryFunction) {
        this.mNonincrementalTestGenerator = new NonincrementalFQLTestGenerator(pSourceFileName, pEntryFunction);
        this.mIncrementalTestGenerator = new IncrementalFQLTestGenerator(pSourceFileName, pEntryFunction);
        this.mIncrementalAndAlternatingTestGenerator = new IncrementalAndAlternatingFQLTestGenerator(pSourceFileName, pEntryFunction);
        this.mCoverageAnalyser = new StandardFQLCoverageAnalyser(pSourceFileName, pEntryFunction);
        this.mIncrementalARTReusingTestGenerator = new IncrementalARTReusingFQLTestGenerator(pSourceFileName, pEntryFunction);
    }

    public void doRestart() {
        this.mDoRestart = true;
    }

    public void setRestartBound(long pRestartBound) {
        this.mRestartBound = pRestartBound;
    }

    public void setFeasibilityInformationOutputFile(String pFile) {
        this.mFeasibilityInformationOutputFile = pFile;
    }

    public void setFeasibilityInformationInputFile(String pFile) {
        this.mFeasibilityInformationInputFile = pFile;
    }

    public void setTestSuiteOutputFile(String pFile) {
        this.mTestSuiteOutputFile = pFile;
    }

    public void setGoalIndices(int pMinIndex, int pMaxIndex) {
        this.setMinIndex(pMinIndex);
        this.setMaxIndex(pMaxIndex);
    }

    public void setMinIndex(int pIndex) {
        this.mMinIndex = pIndex;
    }

    public void setMaxIndex(int pIndex) {
        this.mMaxIndex = pIndex;
    }

    public void doLogging() {
        this.mDoLogging = true;
    }

    public void doAppendingLogging() {
        this.mDoAppendingLogging = true;
    }

    public void seed(Collection<TestCase> pTestSuite) throws InvalidConfigurationException, CPAException, ImpreciseExecutionException {
        this.mIncrementalARTReusingTestGenerator.seed(pTestSuite);
    }

    public FShell3Result run(String pFQLSpecification) {
        return this.run(pFQLSpecification, true, false, false, false, true, false);
    }

    @Override
    public FShell3Result run(String pFQLSpecification, boolean pApplySubsumptionCheck, boolean pApplyInfeasibilityPropagation, boolean pGenerateTestGoalAutomataInAdvance, boolean pCheckCorrectnessOfCoverageCheck, boolean pPedantic, boolean pAlternating) {
        if (pGenerateTestGoalAutomataInAdvance) {
            return this.mNonincrementalTestGenerator.run(pFQLSpecification, pApplySubsumptionCheck, pApplyInfeasibilityPropagation, pGenerateTestGoalAutomataInAdvance, pCheckCorrectnessOfCoverageCheck, pPedantic, pAlternating);
        }
        if (pAlternating) {
            return this.mIncrementalAndAlternatingTestGenerator.run(pFQLSpecification, pApplySubsumptionCheck, pApplyInfeasibilityPropagation, pGenerateTestGoalAutomataInAdvance, pCheckCorrectnessOfCoverageCheck, pPedantic, pAlternating);
        }
        if (!pAlternating) {
            TestSuite lTestSuite;
            FeasibilityInformation lFeasibilityInformation;
            this.mIncrementalARTReusingTestGenerator.setGoalIndices(this.mMinIndex, this.mMaxIndex);
            if (this.mFeasibilityInformationInputFile != null) {
                try {
                    lFeasibilityInformation = FeasibilityInformation.load(this.mFeasibilityInformationInputFile);
                    if (!lFeasibilityInformation.hasTestsuiteFilename()) {
                        throw new RuntimeException();
                    }
                    lTestSuite = TestSuite.load(lFeasibilityInformation.getTestsuiteFilename());
                    this.mIncrementalARTReusingTestGenerator.setTestSuite(lTestSuite);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                lFeasibilityInformation = new FeasibilityInformation();
                lTestSuite = new TestSuite();
            }
            if (this.mDoLogging && this.mFeasibilityInformationOutputFile != null) {
                try {
                    if (this.mTestSuiteOutputFile != null) {
                        lTestSuite = new LoggingTestSuite(lTestSuite, this.mTestSuiteOutputFile, this.mDoAppendingLogging);
                        lFeasibilityInformation.setTestsuiteFilename(this.mTestSuiteOutputFile);
                    } else {
                        File lCWD = new File(".");
                        File lTestSuiteFile = File.createTempFile("testsuite", ".tst", lCWD);
                        lTestSuite = new LoggingTestSuite(lTestSuite, lTestSuiteFile.getCanonicalPath(), this.mDoAppendingLogging);
                        lFeasibilityInformation.setTestsuiteFilename(lTestSuiteFile.getCanonicalPath());
                    }
                    lFeasibilityInformation = new LoggingFeasibilityInformation(lFeasibilityInformation, this.mFeasibilityInformationOutputFile, this.mDoAppendingLogging);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.mIncrementalARTReusingTestGenerator.setFeasibilityInformation(lFeasibilityInformation);
            try {
                this.mIncrementalARTReusingTestGenerator.setTestSuite(lTestSuite);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.mDoRestart) {
                this.mIncrementalARTReusingTestGenerator.doRestart();
                this.mIncrementalARTReusingTestGenerator.setRestartBound(this.mRestartBound);
            }
            FShell3Result lResult = this.mIncrementalARTReusingTestGenerator.run(pFQLSpecification, pApplySubsumptionCheck, pApplyInfeasibilityPropagation, pGenerateTestGoalAutomataInAdvance, pCheckCorrectnessOfCoverageCheck, pPedantic, pAlternating);
            if (this.mDoLogging) {
                ((LoggingTestSuite)lTestSuite).close();
                ((LoggingFeasibilityInformation)lFeasibilityInformation).close();
            } else if (this.mFeasibilityInformationOutputFile != null) {
                try {
                    if (this.mTestSuiteOutputFile != null) {
                        lTestSuite.write(this.mTestSuiteOutputFile);
                        lFeasibilityInformation.setTestsuiteFilename(this.mTestSuiteOutputFile);
                    } else {
                        File lCWD = new File(".");
                        File lTestSuiteFile = File.createTempFile("testsuite", ".tst", lCWD);
                        lTestSuite.write(lTestSuiteFile);
                        lFeasibilityInformation.setTestsuiteFilename(lTestSuiteFile.getCanonicalPath());
                    }
                    lFeasibilityInformation.write(this.mFeasibilityInformationOutputFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return lResult;
        }
        return this.mIncrementalTestGenerator.run(pFQLSpecification, pApplySubsumptionCheck, pApplyInfeasibilityPropagation, pGenerateTestGoalAutomataInAdvance, pCheckCorrectnessOfCoverageCheck, pPedantic, pAlternating);
    }

    @Override
    public void checkCoverage(String pFQLSpecification, Collection<TestCase> pTestSuite, boolean pPedantic) {
        this.mCoverageAnalyser.checkCoverage(pFQLSpecification, pTestSuite, pPedantic);
    }

    public static Map<String, CFAFunctionDefinitionNode> getCFAMap(String pSourceFileName, Configuration pConfiguration, LogManager pLogManager) throws InvalidConfigurationException {
        CFACreator lCFACreator = new CFACreator(pConfiguration, pLogManager);
        try {
            return lCFACreator.parseFileAndCreateCFA(pSourceFileName).getAllFunctions();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static ThreeValuedAnswer accepts(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pAutomaton, CFAEdge[] pCFAPath) {
        HashSet<NondeterministicFiniteAutomaton.State> lCurrentStates = new HashSet<NondeterministicFiniteAutomaton.State>();
        HashSet<NondeterministicFiniteAutomaton.State> lNextStates = new HashSet<NondeterministicFiniteAutomaton.State>();
        lCurrentStates.add(pAutomaton.getInitialState());
        boolean lHasPredicates = false;
        for (CFAEdge lCFAEdge : pCFAPath) {
            for (NondeterministicFiniteAutomaton.State lCurrentState : lCurrentStates) {
                if (pAutomaton.getFinalStates().contains(lCurrentState)) {
                    return ThreeValuedAnswer.ACCEPT;
                }
                for (NondeterministicFiniteAutomaton.Edge lOutgoingEdge : pAutomaton.getOutgoingEdges(lCurrentState)) {
                    GuardedEdgeLabel lLabel = (GuardedEdgeLabel)lOutgoingEdge.getLabel();
                    if (lLabel.hasGuards()) {
                        lHasPredicates = true;
                        continue;
                    }
                    if (!lLabel.contains(lCFAEdge)) continue;
                    lNextStates.add(lOutgoingEdge.getTarget());
                }
            }
            lCurrentStates.clear();
            HashSet<NondeterministicFiniteAutomaton.State> lTmp = lCurrentStates;
            lCurrentStates = lNextStates;
            lNextStates = lTmp;
        }
        for (NondeterministicFiniteAutomaton.State lCurrentState : lCurrentStates) {
            if (!pAutomaton.getFinalStates().contains(lCurrentState)) continue;
            return ThreeValuedAnswer.ACCEPT;
        }
        if (lHasPredicates) {
            return ThreeValuedAnswer.UNKNOWN;
        }
        return ThreeValuedAnswer.REJECT;
    }

    public static Configuration createConfiguration(String pSourceFile, String pEntryFunction) throws InvalidConfigurationException {
        File lPropertiesFile = FShell3.createPropertiesFile(pEntryFunction);
        return FShell3.createConfiguration(Collections.singletonList(pSourceFile), lPropertiesFile.getAbsolutePath());
    }

    private static Configuration createConfiguration(List<String> pSourceFiles, String pPropertiesFile) throws InvalidConfigurationException {
        HashMap<String, String> lCommandLineOptions = new HashMap<String, String>();
        lCommandLineOptions.put("analysis.programNames", Joiner.on((String)", ").join(pSourceFiles));
        Configuration lConfiguration = null;
        try {
            lConfiguration = Configuration.builder().loadFromFile(pPropertiesFile).setOptions(lCommandLineOptions).build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lConfiguration;
    }

    private static File createPropertiesFile(String pEntryFunction) {
        if (pEntryFunction == null) {
            throw new IllegalArgumentException("Parameter pEntryFunction is null!");
        }
        File lPropertiesFile = null;
        try {
            lPropertiesFile = File.createTempFile("fshell.", ".properties");
            lPropertiesFile.deleteOnExit();
            PrintWriter lWriter = new PrintWriter(new FileOutputStream(lPropertiesFile));
            lWriter.println("cfa.removeIrrelevantForErrorLocations = false");
            lWriter.println("analysis.traversal.order = topsort");
            lWriter.println("analysis.entryFunction = " + pEntryFunction);
            lWriter.println("analysis.useRefinement = true");
            lWriter.println("cegar.refiner = " + PredicateRefiner.class.getCanonicalName());
            lWriter.println("cpa.predicate.addBranchingInformation = false");
            lWriter.println("cpa.predicate.useNondetFlags = true");
            lWriter.println("cpa.predicate.initAllVars = false");
            lWriter.println("cpa.predicate.blk.useCache = false");
            lWriter.println("cpa.interval.merge = JOIN");
            lWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return lPropertiesFile;
    }
}

