/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.fshell.testcases.TestCase;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;

public class FShell3Result {
    private int mNumberOfFeasibleTestGoals;
    private int mNumberOfInfeasibleTestGoals;
    private int mNumberOfTestCases;
    private int mNumberOfImpreciseTestCases;
    private double mTimeForFeasibleTestGoals;
    private double mTimeForInfeasibleTestGoals;
    private double mTimeInReach;
    private double mTimeInCover;
    private boolean mFinished;

    public static Factory factory() {
        return new Factory();
    }

    private FShell3Result(int pNumberOfFeasibleTestGoals, int pNumberOfInfeasibleTestGoals, int pNumberOfTestCases, int pNumberOfImpreciseTestCases, double pTimeInReach, double pTimeInCover, double pTimeForFeasibleTestGoals, double pTimeForInfeasibleTestGoals, boolean pFinished) {
        this.mNumberOfFeasibleTestGoals = pNumberOfFeasibleTestGoals;
        this.mNumberOfInfeasibleTestGoals = pNumberOfInfeasibleTestGoals;
        this.mNumberOfTestCases = pNumberOfTestCases;
        this.mNumberOfImpreciseTestCases = pNumberOfImpreciseTestCases;
        this.mTimeForFeasibleTestGoals = pTimeForFeasibleTestGoals;
        this.mTimeForInfeasibleTestGoals = pTimeForInfeasibleTestGoals;
        this.mTimeInReach = pTimeInReach;
        this.mTimeInCover = pTimeInCover;
        this.mFinished = pFinished;
    }

    public boolean hasFinished() {
        return this.mFinished;
    }

    public int getNumberOfTestGoals() {
        return this.mNumberOfFeasibleTestGoals + this.mNumberOfInfeasibleTestGoals + this.mNumberOfImpreciseTestCases;
    }

    public int getNumberOfFeasibleTestGoals() {
        return this.mNumberOfFeasibleTestGoals;
    }

    public int getNumberOfInfeasibleTestGoals() {
        return this.mNumberOfInfeasibleTestGoals;
    }

    public int getNumberOfTestCases() {
        return this.mNumberOfTestCases;
    }

    public int getNumberOfImpreciseTestCases() {
        return this.mNumberOfImpreciseTestCases;
    }

    public double getTimeForFeasibleTestGoals() {
        return this.mTimeForFeasibleTestGoals;
    }

    public double getTimeForInfeasibleTestGoals() {
        return this.mTimeForInfeasibleTestGoals;
    }

    public double getTimeInReach() {
        return this.mTimeInReach;
    }

    public double getTimeInCover() {
        return this.mTimeInCover;
    }

    public static class Factory {
        private Set<ElementaryCoveragePattern> mFeasibleTestGoals = new HashSet<ElementaryCoveragePattern>();
        private Set<ElementaryCoveragePattern> mInfeasibleTestGoals = new HashSet<ElementaryCoveragePattern>();
        private Map<TestCase, Set<ElementaryCoveragePattern>> mTestSuite = new HashMap<TestCase, Set<ElementaryCoveragePattern>>();
        private Set<TestCase> mImpreciseTestCases = new HashSet<TestCase>();
        private boolean mFinished = true;

        private Factory() {
        }

        public void setUnfinished() {
            this.mFinished = false;
        }

        public void add(ElementaryCoveragePattern pECP, boolean pIsFeasible) {
            if (pIsFeasible) {
                this.mFeasibleTestGoals.add(pECP);
            } else {
                this.mInfeasibleTestGoals.add(pECP);
            }
        }

        public void addFeasibleTestCase(ElementaryCoveragePattern pECP, TestCase pTestCase) {
            this.mFeasibleTestGoals.add(pECP);
            Set<ElementaryCoveragePattern> lTestSuite = this.getTestSuite(pTestCase);
            lTestSuite.add(pECP);
        }

        public void addInfeasibleTestCase(ElementaryCoveragePattern pECP) {
            this.mInfeasibleTestGoals.add(pECP);
        }

        public void addImpreciseTestCase(TestCase pTestCase) {
            Preconditions.checkNotNull((Object)pTestCase);
            Preconditions.checkArgument((!pTestCase.isPrecise() ? 1 : 0) != 0);
            this.mImpreciseTestCases.add(pTestCase);
        }

        private Set<ElementaryCoveragePattern> getTestSuite(TestCase pTestCase) {
            if (this.mTestSuite.containsKey(pTestCase)) {
                return this.mTestSuite.get(pTestCase);
            }
            HashSet<ElementaryCoveragePattern> lTestSuite = new HashSet<ElementaryCoveragePattern>();
            this.mTestSuite.put(pTestCase, lTestSuite);
            return lTestSuite;
        }

        public Collection<TestCase> getTestCases() {
            HashSet<TestCase> lTestCases = new HashSet<TestCase>();
            lTestCases.addAll(this.mTestSuite.keySet());
            lTestCases.addAll(this.mImpreciseTestCases);
            return lTestCases;
        }

        public FShell3Result create(double pTimeInReach, double pTimeInCover, double pTimeForFeasibleTestGoals, double pTimeForInfeasibleTestGoals) {
            return new FShell3Result(this.mFeasibleTestGoals.size(), this.mInfeasibleTestGoals.size(), this.mTestSuite.keySet().size(), this.mImpreciseTestCases.size(), pTimeInReach, pTimeInCover, pTimeForFeasibleTestGoals, pTimeForInfeasibleTestGoals, this.mFinished);
        }
    }
}

