/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class FeasibilityInformation {
    protected static final String FEASIBLE_ABBREV = "f";
    protected static final String INFEASIBLE_ABBREV = "if";
    protected static final String IMPRECISE_ABBREV = "ip";
    private final Map<Integer, FeasibilityStatus> mFeasibilityInformation = new HashMap<Integer, FeasibilityStatus>();
    private String mTestsuiteFilename;

    public boolean hasTestsuiteFilename() {
        return this.mTestsuiteFilename != null;
    }

    public String getTestsuiteFilename() {
        return this.mTestsuiteFilename;
    }

    public void setTestsuiteFilename(String pFilename) {
        this.mTestsuiteFilename = pFilename;
    }

    public void write(String pFeasibilityFilename) throws FileNotFoundException {
        this.write(new File(pFeasibilityFilename));
    }

    public void write(File pFeasibilityFile) throws FileNotFoundException {
        PrintWriter lWriter = new PrintWriter(pFeasibilityFile);
        if (!this.hasTestsuiteFilename()) {
            throw new RuntimeException();
        }
        lWriter.println(this.mTestsuiteFilename);
        for (Map.Entry<Integer, FeasibilityStatus> lEntry : this.mFeasibilityInformation.entrySet()) {
            switch (lEntry.getValue()) {
                case FEASIBLE: {
                    lWriter.println(lEntry.getKey() + " " + FEASIBLE_ABBREV);
                    break;
                }
                case INFEASIBLE: {
                    lWriter.println(lEntry.getKey() + " " + INFEASIBLE_ABBREV);
                    break;
                }
                case IMPRECISE: {
                    lWriter.println(lEntry.getKey() + " " + IMPRECISE_ABBREV);
                }
            }
        }
        lWriter.close();
    }

    public static FeasibilityInformation load(String pFeasibilityFilename) throws NumberFormatException, IOException {
        return FeasibilityInformation.load(new File(pFeasibilityFilename));
    }

    public static FeasibilityInformation load(File pFeasibilityFile) throws NumberFormatException, IOException {
        String lLine;
        FeasibilityInformation lInformation = new FeasibilityInformation();
        BufferedReader lReader = new BufferedReader(new FileReader(pFeasibilityFile));
        boolean lIsFirstLine = true;
        while ((lLine = lReader.readLine()) != null) {
            if ((lLine = lLine.trim()).equals("")) continue;
            if (lIsFirstLine) {
                lIsFirstLine = false;
                lInformation.setTestsuiteFilename(lLine);
                continue;
            }
            String[] lParts = lLine.split(" ");
            if (lParts.length != 2) {
                throw new RuntimeException();
            }
            Integer lGoalIndex = Integer.valueOf(lParts[0]);
            if (lParts[1].toLowerCase().equals(FEASIBLE_ABBREV)) {
                lInformation.setStatus(lGoalIndex, FeasibilityStatus.FEASIBLE);
                continue;
            }
            if (lParts[1].toLowerCase().equals(INFEASIBLE_ABBREV)) {
                lInformation.setStatus(lGoalIndex, FeasibilityStatus.INFEASIBLE);
                continue;
            }
            if (lParts[1].toLowerCase().equals(IMPRECISE_ABBREV)) {
                lInformation.setStatus(lGoalIndex, FeasibilityStatus.IMPRECISE);
                continue;
            }
            throw new RuntimeException();
        }
        return lInformation;
    }

    public boolean isKnown(int pGoalIndex) {
        return this.mFeasibilityInformation.containsKey(pGoalIndex);
    }

    public boolean isUnknown(int pGoalIndex) {
        return !this.isKnown(pGoalIndex);
    }

    public void setStatus(int pGoalIndex, FeasibilityStatus pStatus) {
        if (pStatus.equals((Object)FeasibilityStatus.UNKNOWN)) {
            return;
        }
        this.mFeasibilityInformation.put(pGoalIndex, pStatus);
    }

    public FeasibilityStatus getStatus(int pGoalIndex) {
        FeasibilityStatus lStatus = this.mFeasibilityInformation.get(pGoalIndex);
        if (lStatus == null) {
            return FeasibilityStatus.UNKNOWN;
        }
        return lStatus;
    }

    static enum FeasibilityStatus {
        FEASIBLE,
        INFEASIBLE,
        IMPRECISE,
        UNKNOWN;

    }
}

