/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.TimeAccumulator;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CEGARAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.art.ARTCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTStatistics;
import org.sosy_lab.cpachecker.cpa.assume.AssumeCPA;
import org.sosy_lab.cpachecker.cpa.cache.CacheCPA;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackCPA;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathCPA;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathStandardElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonStateElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonElement;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateRefiner;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.fshell.FShell3;
import org.sosy_lab.cpachecker.fshell.FShell3Result;
import org.sosy_lab.cpachecker.fshell.FeasibilityInformation;
import org.sosy_lab.cpachecker.fshell.Goal;
import org.sosy_lab.cpachecker.fshell.ThreeValuedAnswer;
import org.sosy_lab.cpachecker.fshell.cfa.Wrapper;
import org.sosy_lab.cpachecker.fshell.fql2.ast.FQLSpecification;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.CoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.IncrementalCoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.interfaces.FQLTestGenerator;
import org.sosy_lab.cpachecker.fshell.testcases.ImpreciseExecutionException;
import org.sosy_lab.cpachecker.fshell.testcases.TestCase;
import org.sosy_lab.cpachecker.fshell.testcases.TestSuite;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.InverseGuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.ToGuardedAutomatonTranslator;

public class IncrementalARTReusingFQLTestGenerator
implements FQLTestGenerator {
    private final Configuration mConfiguration;
    private final LogManager mLogManager;
    private final Wrapper mWrapper;
    private final CoverageSpecificationTranslator mCoverageSpecificationTranslator;
    private final LocationCPA mLocationCPA;
    private final CallstackCPA mCallStackCPA;
    private final AssumeCPA mAssumeCPA;
    private final CFAPathCPA mCFAPathCPA;
    private final ConfigurableProgramAnalysis mPredicateCPA;
    private final TimeAccumulator mTimeInReach;
    private int mTimesInReach;
    private final GuardedEdgeLabel mAlphaLabel;
    private final GuardedEdgeLabel mOmegaLabel;
    private final GuardedEdgeLabel mInverseAlphaLabel;
    private final Map<TestCase, CFAEdge[]> mGeneratedTestCases;
    private int mMinIndex = 0;
    private int mMaxIndex = Integer.MAX_VALUE;
    private boolean mDoRestart = false;
    private long mRestartBound = 100000000L;
    private boolean mUseAutomatonOptimization = true;
    private boolean mUseGraphCPA = true;
    private boolean mReuseART = true;
    private FeasibilityInformation mFeasibilityInformation;
    private TestSuite mTestSuite;

    public void setGoalIndices(int pMinIndex, int pMaxIndex) {
        this.mMinIndex = pMinIndex;
        this.mMaxIndex = pMaxIndex;
    }

    public void doRestart() {
        this.mDoRestart = true;
    }

    public void setRestartBound(long pRestartBound) {
        this.mRestartBound = pRestartBound;
    }

    public void setFeasibilityInformation(FeasibilityInformation pFeasibilityInformation) {
        this.mFeasibilityInformation = pFeasibilityInformation;
    }

    public void setTestSuite(TestSuite pTestSuite) throws InvalidConfigurationException, CPAException, ImpreciseExecutionException {
        this.mTestSuite = pTestSuite;
        this.seed(pTestSuite);
    }

    public void seed(Iterable<TestCase> pTestSuite) throws InvalidConfigurationException, CPAException, ImpreciseExecutionException {
        FQLSpecification lIdStarFQLSpecification;
        try {
            lIdStarFQLSpecification = FQLSpecification.parse("COVER \"EDGES(ID)*\" PASSING EDGES(ID)*");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        ElementaryCoveragePattern lIdStarPattern = this.mCoverageSpecificationTranslator.mPathPatternTranslator.translate(lIdStarFQLSpecification.getPathPattern());
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lAutomaton = ToGuardedAutomatonTranslator.toAutomaton(lIdStarPattern, this.mAlphaLabel, this.mInverseAlphaLabel, this.mOmegaLabel);
        GuardedEdgeAutomatonCPA lIdStarCPA = new GuardedEdgeAutomatonCPA(lAutomaton);
        for (TestCase lTestCase : pTestSuite) {
            CFAEdge[] lPath = this.reconstructPath(lTestCase, this.mWrapper.getEntry(), lIdStarCPA, null, this.mWrapper.getOmegaEdge().getSuccessor());
            this.mGeneratedTestCases.put(lTestCase, lPath);
        }
    }

    public IncrementalARTReusingFQLTestGenerator(String pSourceFileName, String pEntryFunction) {
        CFAFunctionDefinitionNode lMainFunction;
        Map<String, CFAFunctionDefinitionNode> lCFAMap;
        try {
            this.mConfiguration = FShell3.createConfiguration(pSourceFileName, pEntryFunction);
            this.mLogManager = new LogManager(this.mConfiguration);
            lCFAMap = FShell3.getCFAMap(pSourceFileName, this.mConfiguration, this.mLogManager);
            lMainFunction = lCFAMap.get(pEntryFunction);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.mCoverageSpecificationTranslator = new CoverageSpecificationTranslator(lMainFunction);
        this.mWrapper = new Wrapper((FunctionDefinitionNode)lMainFunction, lCFAMap, this.mLogManager);
        try {
            this.mWrapper.toDot("output/wrapper.dot");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mAlphaLabel = new GuardedEdgeLabel(new ECPEdgeSet(this.mWrapper.getAlphaEdge()));
        this.mInverseAlphaLabel = new InverseGuardedEdgeLabel(this.mAlphaLabel);
        this.mOmegaLabel = new GuardedEdgeLabel(new ECPEdgeSet(this.mWrapper.getOmegaEdge()));
        try {
            this.mLocationCPA = (LocationCPA)LocationCPA.factory().createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCallStackCPAFactory = CallstackCPA.factory();
        try {
            this.mCallStackCPA = (CallstackCPA)lCallStackCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        this.mAssumeCPA = AssumeCPA.getCBMCAssume();
        this.mCFAPathCPA = CFAPathCPA.getInstance();
        boolean lUseCache = false;
        CPAFactory lPredicateCPAFactory = PredicateCPA.factory();
        lPredicateCPAFactory.setConfiguration(this.mConfiguration);
        lPredicateCPAFactory.setLogger(this.mLogManager);
        try {
            ConfigurableProgramAnalysis lPredicateCPA = lPredicateCPAFactory.createInstance();
            this.mPredicateCPA = lUseCache ? new CacheCPA(lPredicateCPA) : lPredicateCPA;
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        this.mTimeInReach = new TimeAccumulator();
        this.mTimesInReach = 0;
        this.mGeneratedTestCases = new HashMap<TestCase, CFAEdge[]>();
    }

    @Override
    public FShell3Result run(String pFQLSpecification, boolean pApplySubsumptionCheck, boolean pApplyInfeasibilityPropagation, boolean pGenerateTestGoalAutomataInAdvance, boolean pCheckCorrectnessOfCoverageCheck, boolean pPedantic, boolean pAlternating) {
        return this.run(pFQLSpecification, pApplySubsumptionCheck, pApplyInfeasibilityPropagation, pCheckCorrectnessOfCoverageCheck, pPedantic);
    }

    private FQLSpecification getFQLSpecification(String pFQLSpecification) {
        FQLSpecification lFQLSpecification;
        try {
            lFQLSpecification = FQLSpecification.parse(pFQLSpecification);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lFQLSpecification;
    }

    private GuardedEdgeAutomatonCPA getPassingCPA(FQLSpecification pFQLSpecification) {
        if (pFQLSpecification.hasPassingClause()) {
            System.out.println("Cache hits (1): " + this.mCoverageSpecificationTranslator.getOverallCacheHits());
            System.out.println("Cache misses (1): " + this.mCoverageSpecificationTranslator.getOverallCacheMisses());
            ElementaryCoveragePattern lPassingClause = this.mCoverageSpecificationTranslator.mPathPatternTranslator.translate(pFQLSpecification.getPathPattern());
            System.out.println("Cache hits (2): " + this.mCoverageSpecificationTranslator.getOverallCacheHits());
            System.out.println("Cache misses (2): " + this.mCoverageSpecificationTranslator.getOverallCacheMisses());
            NondeterministicFiniteAutomaton<GuardedEdgeLabel> lAutomaton1 = ToGuardedAutomatonTranslator.toAutomaton(lPassingClause, this.mAlphaLabel, this.mInverseAlphaLabel, this.mOmegaLabel);
            NondeterministicFiniteAutomaton<GuardedEdgeLabel> lAutomaton2 = this.optimizeAutomaton(lAutomaton1);
            return new GuardedEdgeAutomatonCPA(lAutomaton2);
        }
        return null;
    }

    private NondeterministicFiniteAutomaton<GuardedEdgeLabel> optimizeAutomaton(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pAutomaton) {
        if (this.mUseAutomatonOptimization) {
            NondeterministicFiniteAutomaton<GuardedEdgeLabel> lGoalAutomaton1 = ToGuardedAutomatonTranslator.removeInfeasibleTransitions(pAutomaton);
            NondeterministicFiniteAutomaton<GuardedEdgeLabel> lGoalAutomaton2 = ToGuardedAutomatonTranslator.removeDeadEnds(lGoalAutomaton1);
            NondeterministicFiniteAutomaton<GuardedEdgeLabel> lGoalAutomaton3 = ToGuardedAutomatonTranslator.reduceEdgeSets(lGoalAutomaton2);
            return lGoalAutomaton3;
        }
        return pAutomaton;
    }

    private FShell3Result run(String pFQLSpecification, boolean pApplySubsumptionCheck, boolean pApplyInfeasibilityPropagation, boolean pCheckReachWhenCovered, boolean pPedantic) {
        FQLSpecification lFQLSpecification = this.getFQLSpecification(pFQLSpecification);
        GuardedEdgeAutomatonCPA lPassingCPA = this.getPassingCPA(lFQLSpecification);
        int lFeasibleTestGoalsTimeSlot = 0;
        int lInfeasibleTestGoalsTimeSlot = 1;
        TimeAccumulator lTimeAccu = new TimeAccumulator(2);
        TimeAccumulator lTimeReach = new TimeAccumulator();
        TimeAccumulator lTimeCover = new TimeAccumulator();
        IncrementalCoverageSpecificationTranslator lTranslator = new IncrementalCoverageSpecificationTranslator(this.mCoverageSpecificationTranslator.mPathPatternTranslator);
        System.out.println("Determining the number of test goals ...");
        int lNumberOfTestGoals = lTranslator.getNumberOfTestGoals(lFQLSpecification.getCoverageSpecification());
        System.out.println("Number of test goals: " + lNumberOfTestGoals);
        Iterator<ElementaryCoveragePattern> lGoalIterator = lTranslator.translate(lFQLSpecification.getCoverageSpecification());
        int lNumberOfCFAInfeasibleGoals = 0;
        LocationMappedReachedSet lPredicateReachedSet = new LocationMappedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lPreviousGoalAutomaton = null;
        LocationMappedReachedSet lGraphReachedSet = new LocationMappedReachedSet(Waitlist.TraversalMethod.DFS);
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lPreviousGraphGoalAutomaton = null;
        FShell3Result.Factory lResultFactory = FShell3Result.factory();
        int lIndex = 0;
        boolean pHadProgress = false;
        while (lGoalIterator.hasNext()) {
            if (this.mDoRestart && pHadProgress && Runtime.getRuntime().freeMemory() < this.mRestartBound) {
                System.out.println("SHUTDOWN TEST GENERATION");
                lResultFactory.setUnfinished();
                break;
            }
            ElementaryCoveragePattern lGoalPattern = lGoalIterator.next();
            System.out.println("Processing test goal #" + ++lIndex + " of " + lNumberOfTestGoals + " test goals.");
            if (this.mMinIndex > lIndex) {
                System.out.println("Skipped.");
                continue;
            }
            if (this.mMaxIndex < lIndex) {
                System.out.println("Stop test goal enumeration.");
                break;
            }
            if (this.mFeasibilityInformation.isKnown(lIndex)) {
                System.out.println("Stored information: " + (Object)((Object)this.mFeasibilityInformation.getStatus(lIndex)));
                continue;
            }
            pHadProgress = true;
            Goal lGoal = new Goal(lGoalPattern, this.mAlphaLabel, this.mInverseAlphaLabel, this.mOmegaLabel);
            NondeterministicFiniteAutomaton<GuardedEdgeLabel> lGoalAutomaton = this.optimizeAutomaton(lGoal.getAutomaton());
            lTimeAccu.proceed();
            boolean lIsCovered = false;
            if (pApplySubsumptionCheck) {
                for (Map.Entry<TestCase, CFAEdge[]> lGeneratedTestCase : this.mGeneratedTestCases.entrySet()) {
                    TestCase lTestCase = lGeneratedTestCase.getKey();
                    if (!lTestCase.isPrecise()) continue;
                    ThreeValuedAnswer lCoverageAnswer = FShell3.accepts(lGoalAutomaton, lGeneratedTestCase.getValue());
                    if (lCoverageAnswer.equals((Object)ThreeValuedAnswer.ACCEPT)) {
                        lIsCovered = true;
                        lResultFactory.addFeasibleTestCase(lGoal.getPattern(), lTestCase);
                        break;
                    }
                    if (!lCoverageAnswer.equals((Object)ThreeValuedAnswer.UNKNOWN)) continue;
                    GuardedEdgeAutomatonCPA lAutomatonCPA = new GuardedEdgeAutomatonCPA(lGoalAutomaton);
                    try {
                        if (!this.checkCoverage(lTestCase, this.mWrapper.getEntry(), lAutomatonCPA, lPassingCPA, this.mWrapper.getOmegaEdge().getSuccessor())) continue;
                        lIsCovered = true;
                        lResultFactory.addFeasibleTestCase(lGoal.getPattern(), lTestCase);
                        break;
                    }
                    catch (InvalidConfigurationException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    catch (CPAException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    catch (ImpreciseExecutionException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            }
            if (lIsCovered) {
                System.out.println("Goal #" + lIndex + " is covered by an existing test case!");
                this.mFeasibilityInformation.setStatus(lIndex, FeasibilityInformation.FeasibilityStatus.FEASIBLE);
                if (!pCheckReachWhenCovered) {
                    lTimeAccu.pause(lFeasibleTestGoalsTimeSlot);
                    continue;
                }
            }
            GuardedEdgeAutomatonCPA lAutomatonCPA = new GuardedEdgeAutomatonCPA(lGoalAutomaton);
            lTimeReach.proceed();
            boolean lReachableViaGraphSearch = false;
            if (!lAutomatonCPA.getAutomaton().getFinalStates().isEmpty()) {
                if (this.mUseGraphCPA) {
                    lReachableViaGraphSearch = this.reachGraphSearch(lPreviousGraphGoalAutomaton, lGraphReachedSet, lAutomatonCPA, this.mWrapper.getEntry(), lPassingCPA);
                    lPreviousGraphGoalAutomaton = lAutomatonCPA.getAutomaton();
                } else {
                    lReachableViaGraphSearch = true;
                }
            }
            CounterexampleInfo lCounterexampleInfo = null;
            if (lReachableViaGraphSearch) {
                lCounterexampleInfo = this.reach(lPredicateReachedSet, lPreviousGoalAutomaton, lAutomatonCPA, this.mWrapper.getEntry(), lPassingCPA);
                lPreviousGoalAutomaton = lAutomatonCPA.getAutomaton();
            } else {
                ++lNumberOfCFAInfeasibleGoals;
            }
            lTimeReach.pause();
            if (lCounterexampleInfo == null || lCounterexampleInfo.isSpurious()) {
                System.out.println("Goal #" + lIndex + " is infeasible!");
                if (lIsCovered) {
                    throw new RuntimeException("Inconsistent result of coverage check and reachability analysis!");
                }
                this.mFeasibilityInformation.setStatus(lIndex, FeasibilityInformation.FeasibilityStatus.INFEASIBLE);
                lResultFactory.addInfeasibleTestCase(lGoal.getPattern());
                lTimeAccu.pause(lInfeasibleTestGoalsTimeSlot);
                continue;
            }
            lTimeCover.proceed();
            TestCase lTestCase = TestCase.fromCounterexample(lCounterexampleInfo, this.mLogManager);
            this.mTestSuite.add(lTestCase);
            if (lTestCase.isPrecise()) {
                boolean lIsPrecise;
                CFAEdge[] lCFAPath;
                block29: {
                    lCFAPath = null;
                    lIsPrecise = true;
                    try {
                        lCFAPath = this.reconstructPath(lTestCase, this.mWrapper.getEntry(), lAutomatonCPA, lPassingCPA, this.mWrapper.getOmegaEdge().getSuccessor());
                    }
                    catch (InvalidConfigurationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (CPAException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ImpreciseExecutionException e) {
                        lIsPrecise = false;
                        lTestCase = e.getTestCase();
                        if (!pPedantic) break block29;
                        throw new RuntimeException(e);
                    }
                }
                if (lIsPrecise) {
                    System.out.println("Goal #" + lIndex + " is feasible!");
                    lResultFactory.addFeasibleTestCase(lGoal.getPattern(), lTestCase);
                    this.mGeneratedTestCases.put(lTestCase, lCFAPath);
                    this.mFeasibilityInformation.setStatus(lIndex, FeasibilityInformation.FeasibilityStatus.FEASIBLE);
                } else {
                    System.err.println("Goal #" + lIndex + " lead to an imprecise execution!");
                    lResultFactory.addImpreciseTestCase(lTestCase);
                    this.mFeasibilityInformation.setStatus(lIndex, FeasibilityInformation.FeasibilityStatus.IMPRECISE);
                }
            } else {
                System.out.println("Goal #" + lIndex + " is imprecise!");
                lResultFactory.addImpreciseTestCase(lTestCase);
                this.mFeasibilityInformation.setStatus(lIndex, FeasibilityInformation.FeasibilityStatus.IMPRECISE);
            }
            lTimeAccu.pause(lFeasibleTestGoalsTimeSlot);
            lTimeCover.pause();
        }
        System.out.println("Number of CFA infeasible test goals: " + lNumberOfCFAInfeasibleGoals);
        System.out.println("Time in reach: " + this.mTimeInReach.getSeconds());
        System.out.println("Mean time of reach: " + this.mTimeInReach.getSeconds() / (double)this.mTimesInReach + " s");
        FShell3Result lResult = lResultFactory.create(lTimeReach.getSeconds(), lTimeCover.getSeconds(), lTimeAccu.getSeconds(lFeasibleTestGoalsTimeSlot), lTimeAccu.getSeconds(lInfeasibleTestGoalsTimeSlot));
        this.printStatistics(lResultFactory, lIndex);
        return lResult;
    }

    private void printStatistics(FShell3Result.Factory pResultFactory, int pNumberOfTestGoals) {
        System.out.println("Generated Test Cases:");
        for (TestCase lTestCase : pResultFactory.getTestCases()) {
            System.out.println(lTestCase);
        }
    }

    private Pair<Set<NondeterministicFiniteAutomaton.Edge>, Set<NondeterministicFiniteAutomaton.Edge>> determineLocalDifference(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pPreviousAutomaton, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pCurrentAutomaton, NondeterministicFiniteAutomaton.State pPreviousState, NondeterministicFiniteAutomaton.State pCurrentState) {
        boolean lFound;
        HashSet<NondeterministicFiniteAutomaton.Edge> lE1 = new HashSet<NondeterministicFiniteAutomaton.Edge>();
        HashSet<NondeterministicFiniteAutomaton.Edge> lE2 = new HashSet<NondeterministicFiniteAutomaton.Edge>();
        for (NondeterministicFiniteAutomaton.Edge lEdge : pPreviousAutomaton.getOutgoingEdges(pPreviousState)) {
            lFound = false;
            if (((GuardedEdgeLabel)lEdge.getLabel()).hasGuards()) {
                throw new RuntimeException("No support for guards!");
            }
            for (NondeterministicFiniteAutomaton.Edge lOtherEdge : pCurrentAutomaton.getOutgoingEdges(pCurrentState)) {
                if (lEdge.getTarget() != lOtherEdge.getTarget() || !((GuardedEdgeLabel)lEdge.getLabel()).equals(lOtherEdge.getLabel())) continue;
                lFound = true;
            }
            if (lFound) continue;
            lE1.add(lEdge);
        }
        for (NondeterministicFiniteAutomaton.Edge lEdge : pCurrentAutomaton.getOutgoingEdges(pCurrentState)) {
            lFound = false;
            if (((GuardedEdgeLabel)lEdge.getLabel()).hasGuards()) {
                throw new RuntimeException("No support for guards!");
            }
            for (NondeterministicFiniteAutomaton.Edge lOtherEdge : pPreviousAutomaton.getOutgoingEdges(pPreviousState)) {
                if (lEdge.getTarget() != lOtherEdge.getTarget() || !((GuardedEdgeLabel)lEdge.getLabel()).equals(lOtherEdge.getLabel())) continue;
                lFound = true;
            }
            if (lFound) continue;
            lE2.add(lEdge);
        }
        return Pair.of(lE1, lE2);
    }

    private Pair<Set<NondeterministicFiniteAutomaton.Edge>, Set<NondeterministicFiniteAutomaton.Edge>> determineFrontier(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pPreviousAutomaton, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pCurrentAutomaton) {
        HashSet lF1 = new HashSet();
        HashSet lF2 = new HashSet();
        LinkedList<Pair> lWorklist = new LinkedList<Pair>();
        if (pPreviousAutomaton.getInitialState() != pCurrentAutomaton.getInitialState()) {
            throw new RuntimeException();
        }
        lWorklist.add(Pair.of((Object)pPreviousAutomaton.getInitialState(), (Object)pCurrentAutomaton.getInitialState()));
        HashSet<Pair> lVisited = new HashSet<Pair>();
        while (!lWorklist.isEmpty()) {
            Pair lCurrentPair = (Pair)lWorklist.removeLast();
            if (lVisited.contains(lCurrentPair)) continue;
            lVisited.add(lCurrentPair);
            Pair<Set<NondeterministicFiniteAutomaton.Edge>, Set<NondeterministicFiniteAutomaton.Edge>> lFrontier = this.determineLocalDifference(pPreviousAutomaton, pCurrentAutomaton, (NondeterministicFiniteAutomaton.State)lCurrentPair.getFirst(), (NondeterministicFiniteAutomaton.State)lCurrentPair.getSecond());
            if (((Set)lFrontier.getFirst()).isEmpty() && ((Set)lFrontier.getSecond()).isEmpty()) {
                for (NondeterministicFiniteAutomaton.Edge lEdge : pPreviousAutomaton.getOutgoingEdges((NondeterministicFiniteAutomaton.State)lCurrentPair.getFirst())) {
                    lWorklist.add(Pair.of((Object)lEdge.getTarget(), (Object)lEdge.getTarget()));
                }
                continue;
            }
            lF1.addAll((Collection)lFrontier.getFirst());
            lF2.addAll((Collection)lFrontier.getSecond());
        }
        return Pair.of(lF1, lF2);
    }

    private CounterexampleInfo reach(ReachedSet pReachedSet, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pPreviousAutomaton, GuardedEdgeAutomatonCPA pAutomatonCPA, CFAFunctionDefinitionNode pEntryNode, GuardedEdgeAutomatonCPA pPassingCPA) {
        ARTStatistics lARTStatistics;
        CEGARAlgorithm lAlgorithm;
        PredicateRefiner lRefiner;
        ARTCPA lARTCPA;
        this.mTimeInReach.proceed();
        ++this.mTimesInReach;
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        lComponentAnalyses.add(this.mCallStackCPA);
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (pPassingCPA != null) {
            lAutomatonCPAs.add(pPassingCPA);
        }
        lAutomatonCPAs.add(pAutomatonCPA);
        int lProductAutomatonIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(ProductAutomatonCPA.create(lAutomatonCPAs, false));
        lComponentAnalyses.add(this.mPredicateCPA);
        lComponentAnalyses.add(this.mAssumeCPA);
        try {
            CPAFactory lCPAFactory = CompositeCPA.factory();
            lCPAFactory.setChildren(lComponentAnalyses);
            lCPAFactory.setConfiguration(this.mConfiguration);
            lCPAFactory.setLogger(this.mLogManager);
            ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
            CPAFactory lARTCPAFactory = ARTCPA.factory();
            lARTCPAFactory.setChild(lCPA);
            lARTCPAFactory.setConfiguration(this.mConfiguration);
            lARTCPAFactory.setLogger(this.mLogManager);
            lARTCPA = (ARTCPA)lARTCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAAlgorithm lBasicAlgorithm = new CPAAlgorithm(lARTCPA, this.mLogManager);
        try {
            lRefiner = PredicateRefiner.create(lARTCPA);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            lAlgorithm = new CEGARAlgorithm((Algorithm)lBasicAlgorithm, lRefiner, this.mConfiguration, this.mLogManager);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        try {
            lARTStatistics = new ARTStatistics(this.mConfiguration, lARTCPA);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        HashSet<Statistics> lStatistics = new HashSet<Statistics>();
        lStatistics.add(lARTStatistics);
        lAlgorithm.collectStatistics(lStatistics);
        if (this.mReuseART) {
            this.modifyReachedSet(pReachedSet, pEntryNode, lARTCPA, lProductAutomatonIndex, pPreviousAutomaton, pAutomatonCPA.getAutomaton());
        } else {
            pReachedSet = new LocationMappedReachedSet(Waitlist.TraversalMethod.TOPSORT);
            AbstractElement lInitialElement = lARTCPA.getInitialElement(pEntryNode);
            Precision lInitialPrecision = lARTCPA.getInitialPrecision(pEntryNode);
            pReachedSet.add(lInitialElement, lInitialPrecision);
        }
        try {
            lAlgorithm.run(pReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.mTimeInReach.pause();
        return lARTCPA.getLastCounterexample();
    }

    private void modifyReachedSet(ReachedSet pReachedSet, CFAFunctionDefinitionNode pEntryNode, ARTCPA pARTCPA, int pProductAutomatonIndex, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pPreviousAutomaton, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pCurrentAutomaton) {
        if (pReachedSet.isEmpty()) {
            AbstractElement lInitialElement = pARTCPA.getInitialElement(pEntryNode);
            Precision lInitialPrecision = pARTCPA.getInitialPrecision(pEntryNode);
            pReachedSet.add(lInitialElement, lInitialPrecision);
        } else {
            if (pPreviousAutomaton == null) {
                throw new RuntimeException();
            }
            this.modifyART(pReachedSet, pARTCPA, pProductAutomatonIndex, pPreviousAutomaton, pCurrentAutomaton);
        }
    }

    private void modifyART(ReachedSet pReachedSet, ARTReachedSet pARTReachedSet, int pProductAutomatonIndex, Set<NondeterministicFiniteAutomaton.Edge> pFrontierEdges) {
        for (NondeterministicFiniteAutomaton.Edge lEdge : pFrontierEdges) {
            GuardedEdgeLabel lLabel = (GuardedEdgeLabel)lEdge.getLabel();
            ECPEdgeSet lEdgeSet = lLabel.getEdgeSet();
            for (CFAEdge lCFAEdge : lEdgeSet) {
                CFANode lCFANode = lCFAEdge.getPredecessor();
                Collection<AbstractElement> lAbstractElements = pReachedSet.getReached(lCFANode);
                LinkedList<AbstractElement> lAbstractElements2 = new LinkedList<AbstractElement>();
                lAbstractElements2.addAll(lAbstractElements);
                for (AbstractElement lAbstractElement : lAbstractElements2) {
                    CompositeElement lCompositeElement;
                    ProductAutomatonElement lProductAutomatonElement;
                    GuardedEdgeAutomatonStateElement lStateElement;
                    ARTElement lARTElement;
                    if (!pReachedSet.contains(lAbstractElement) || AbstractElements.extractLocation(lARTElement = (ARTElement)lAbstractElement) != lCFANode || (lStateElement = (GuardedEdgeAutomatonStateElement)(lProductAutomatonElement = (ProductAutomatonElement)(lCompositeElement = (CompositeElement)lARTElement.getWrappedElement()).get(pProductAutomatonIndex)).get(0)).getAutomatonState() != lEdge.getSource()) continue;
                    if (lARTElement.getChildren().isEmpty()) {
                        pReachedSet.reAddToWaitlist(lARTElement);
                        continue;
                    }
                    while (!lARTElement.getChildren().isEmpty()) {
                        ARTElement lChildElement = lARTElement.getChildren().iterator().next();
                        pARTReachedSet.removeSubtree(lChildElement);
                    }
                }
            }
        }
    }

    private void modifyART(ReachedSet pReachedSet, ARTCPA pARTCPA, int pProductAutomatonIndex, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pPreviousAutomaton, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pCurrentAutomaton) {
        ARTReachedSet lARTReachedSet = new ARTReachedSet(pReachedSet, pARTCPA);
        Pair<Set<NondeterministicFiniteAutomaton.Edge>, Set<NondeterministicFiniteAutomaton.Edge>> lFrontier = this.determineFrontier(pPreviousAutomaton, pCurrentAutomaton);
        this.modifyART(pReachedSet, lARTReachedSet, pProductAutomatonIndex, (Set)lFrontier.getFirst());
        this.modifyART(pReachedSet, lARTReachedSet, pProductAutomatonIndex, (Set)lFrontier.getSecond());
    }

    private boolean checkCoverage(TestCase pTestCase, CFAFunctionDefinitionNode pEntry, GuardedEdgeAutomatonCPA pCoverAutomatonCPA, GuardedEdgeAutomatonCPA pPassingAutomatonCPA, CFANode pEndNode) throws InvalidConfigurationException, CPAException, ImpreciseExecutionException {
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (pPassingAutomatonCPA != null) {
            lAutomatonCPAs.add(pPassingAutomatonCPA);
        }
        lAutomatonCPAs.add(pCoverAutomatonCPA);
        int lProductAutomatonCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(ProductAutomatonCPA.create(lAutomatonCPAs, false));
        lComponentAnalyses.add(this.mCallStackCPA);
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(pTestCase.getInputs());
        lComponentAnalyses.add(lInterpreterCPA);
        lComponentAnalyses.add(this.mAssumeCPA);
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(this.mConfiguration);
        lCPAFactory.setLogger(this.mLogManager);
        ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, this.mLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(pEntry);
        Precision lInitialPrecision = lCPA.getInitialPrecision(pEntry);
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        CompositeElement lEndNode = (CompositeElement)lReachedSet.getLastElement();
        if (lEndNode == null) {
            return false;
        }
        if (((LocationElement)lEndNode.get(0)).getLocationNode().equals(pEndNode)) {
            AbstractElement lProductAutomatonElement = lEndNode.get(lProductAutomatonCPAIndex);
            if (lProductAutomatonElement instanceof Targetable) {
                Targetable lTargetable = (Targetable)((Object)lProductAutomatonElement);
                return lTargetable.isTarget();
            }
            return false;
        }
        return false;
    }

    private CFAEdge[] reconstructPath(TestCase pTestCase, CFAFunctionDefinitionNode pEntry, GuardedEdgeAutomatonCPA pCoverAutomatonCPA, GuardedEdgeAutomatonCPA pPassingAutomatonCPA, CFANode pEndNode) throws InvalidConfigurationException, CPAException, ImpreciseExecutionException {
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (pPassingAutomatonCPA != null) {
            lAutomatonCPAs.add(pPassingAutomatonCPA);
        }
        lAutomatonCPAs.add(pCoverAutomatonCPA);
        int lProductAutomatonCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(ProductAutomatonCPA.create(lAutomatonCPAs, false));
        lComponentAnalyses.add(this.mCallStackCPA);
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(pTestCase.getInputs());
        lComponentAnalyses.add(lInterpreterCPA);
        int lCFAPathCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(this.mCFAPathCPA);
        lComponentAnalyses.add(this.mAssumeCPA);
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(this.mConfiguration);
        lCPAFactory.setLogger(this.mLogManager);
        ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, this.mLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(pEntry);
        Precision lInitialPrecision = lCPA.getInitialPrecision(pEntry);
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        CompositeElement lEndNode = (CompositeElement)lReachedSet.getLastElement();
        if (lEndNode == null) {
            throw new ImpreciseExecutionException(pTestCase, pCoverAutomatonCPA, pPassingAutomatonCPA);
        }
        if (!((LocationElement)lEndNode.get(0)).getLocationNode().equals(pEndNode)) {
            throw new ImpreciseExecutionException(pTestCase, pCoverAutomatonCPA, pPassingAutomatonCPA);
        }
        AbstractElement lProductAutomatonElement = lEndNode.get(lProductAutomatonCPAIndex);
        if (!(lProductAutomatonElement instanceof Targetable)) {
            throw new RuntimeException();
        }
        Targetable lTargetable = (Targetable)((Object)lProductAutomatonElement);
        if (!lTargetable.isTarget()) {
            throw new RuntimeException();
        }
        CFAPathStandardElement lPathElement = (CFAPathStandardElement)lEndNode.get(lCFAPathCPAIndex);
        return lPathElement.toArray();
    }

    private boolean reachGraphSearch(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pPreviousAutomaton, ReachedSet pReachedSet, GuardedEdgeAutomatonCPA pAutomatonCPA, CFAFunctionDefinitionNode pEntryNode, GuardedEdgeAutomatonCPA pPassingCPA) {
        ARTStatistics lARTStatistics;
        ARTCPA lARTCPA;
        this.mTimeInReach.proceed();
        ++this.mTimesInReach;
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        lComponentAnalyses.add(this.mCallStackCPA);
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (pPassingCPA != null) {
            lAutomatonCPAs.add(pPassingCPA);
        }
        lAutomatonCPAs.add(pAutomatonCPA);
        int lProductAutomatonIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(ProductAutomatonCPA.create(lAutomatonCPAs, false));
        lComponentAnalyses.add(this.mAssumeCPA);
        try {
            CPAFactory lCPAFactory = CompositeCPA.factory();
            lCPAFactory.setChildren(lComponentAnalyses);
            lCPAFactory.setConfiguration(this.mConfiguration);
            lCPAFactory.setLogger(this.mLogManager);
            ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
            CPAFactory lARTCPAFactory = ARTCPA.factory();
            lARTCPAFactory.setChild(lCPA);
            lARTCPAFactory.setConfiguration(this.mConfiguration);
            lARTCPAFactory.setLogger(this.mLogManager);
            lARTCPA = (ARTCPA)lARTCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        if (this.mReuseART) {
            this.modifyReachedSet(pReachedSet, pEntryNode, lARTCPA, lProductAutomatonIndex, pPreviousAutomaton, pAutomatonCPA.getAutomaton());
        } else {
            pReachedSet = new LocationMappedReachedSet(Waitlist.TraversalMethod.DFS);
            AbstractElement lInitialElement = lARTCPA.getInitialElement(pEntryNode);
            Precision lInitialPrecision = lARTCPA.getInitialPrecision(pEntryNode);
            pReachedSet.add(lInitialElement, lInitialPrecision);
        }
        CPAAlgorithm lBasicAlgorithm = new CPAAlgorithm(lARTCPA, this.mLogManager);
        try {
            lARTStatistics = new ARTStatistics(this.mConfiguration, lARTCPA);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        HashSet<Statistics> lStatistics = new HashSet<Statistics>();
        lStatistics.add(lARTStatistics);
        lBasicAlgorithm.collectStatistics(lStatistics);
        try {
            lBasicAlgorithm.run(pReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ARTElement lLastARTElement = (ARTElement)pReachedSet.getLastElement();
        CompositeElement lLastElement = (CompositeElement)lLastARTElement.getWrappedElement();
        ProductAutomatonElement lProductAutomatonElement = (ProductAutomatonElement)lLastElement.get(lProductAutomatonIndex);
        this.mTimeInReach.pause();
        return lProductAutomatonElement.isFinalState();
    }
}

