/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.TimeAccumulator;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CEGARAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.art.ARTCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTStatistics;
import org.sosy_lab.cpachecker.cpa.assume.AssumeCPA;
import org.sosy_lab.cpachecker.cpa.cache.CacheCPA;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackCPA;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.progress.ProgressCPA;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateRefiner;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.fshell.AlternatingRefiner;
import org.sosy_lab.cpachecker.fshell.FShell3;
import org.sosy_lab.cpachecker.fshell.FShell3Result;
import org.sosy_lab.cpachecker.fshell.Goal;
import org.sosy_lab.cpachecker.fshell.ThreeValuedAnswer;
import org.sosy_lab.cpachecker.fshell.cfa.Wrapper;
import org.sosy_lab.cpachecker.fshell.fql2.ast.FQLSpecification;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.CoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.IncrementalCoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.interfaces.FQLTestGenerator;
import org.sosy_lab.cpachecker.fshell.testcases.ImpreciseExecutionException;
import org.sosy_lab.cpachecker.fshell.testcases.TestCase;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.InverseGuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.ToGuardedAutomatonTranslator;

public class IncrementalAndAlternatingFQLTestGenerator
implements FQLTestGenerator {
    private final Configuration mConfiguration;
    private final LogManager mLogManager;
    private final Wrapper mWrapper;
    private final CoverageSpecificationTranslator mCoverageSpecificationTranslator;
    private final LocationCPA mLocationCPA;
    private final CallstackCPA mCallStackCPA;
    private final AssumeCPA mAssumeCPA;
    private final CFAPathCPA mCFAPathCPA;
    private final ConfigurableProgramAnalysis mPredicateCPA;
    private final TimeAccumulator mTimeInReach;
    private int mTimesInReach;
    private final GuardedEdgeLabel mAlphaLabel;
    private final GuardedEdgeLabel mOmegaLabel;
    private final GuardedEdgeLabel mInverseAlphaLabel;
    private final Map<TestCase, CFAEdge[]> mGeneratedTestCases;
    private final Map<NondeterministicFiniteAutomaton<GuardedEdgeLabel>, Collection<NondeterministicFiniteAutomaton.State>> mInfeasibleGoals;

    public IncrementalAndAlternatingFQLTestGenerator(String pSourceFileName, String pEntryFunction) {
        CFAFunctionDefinitionNode lMainFunction;
        Map<String, CFAFunctionDefinitionNode> lCFAMap;
        try {
            this.mConfiguration = FShell3.createConfiguration(pSourceFileName, pEntryFunction);
            this.mLogManager = new LogManager(this.mConfiguration);
            lCFAMap = FShell3.getCFAMap(pSourceFileName, this.mConfiguration, this.mLogManager);
            lMainFunction = lCFAMap.get(pEntryFunction);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.mCoverageSpecificationTranslator = new CoverageSpecificationTranslator(lMainFunction);
        this.mWrapper = new Wrapper((FunctionDefinitionNode)lMainFunction, lCFAMap, this.mLogManager);
        try {
            this.mWrapper.toDot("output/wrapper.dot");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mAlphaLabel = new GuardedEdgeLabel(new ECPEdgeSet(this.mWrapper.getAlphaEdge()));
        this.mInverseAlphaLabel = new InverseGuardedEdgeLabel(this.mAlphaLabel);
        this.mOmegaLabel = new GuardedEdgeLabel(new ECPEdgeSet(this.mWrapper.getOmegaEdge()));
        try {
            this.mLocationCPA = (LocationCPA)LocationCPA.factory().createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCallStackCPAFactory = CallstackCPA.factory();
        try {
            this.mCallStackCPA = (CallstackCPA)lCallStackCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        this.mAssumeCPA = AssumeCPA.getCBMCAssume();
        this.mCFAPathCPA = CFAPathCPA.getInstance();
        boolean lUseCache = false;
        CPAFactory lPredicateCPAFactory = PredicateCPA.factory();
        lPredicateCPAFactory.setConfiguration(this.mConfiguration);
        lPredicateCPAFactory.setLogger(this.mLogManager);
        try {
            ConfigurableProgramAnalysis lPredicateCPA = lPredicateCPAFactory.createInstance();
            this.mPredicateCPA = lUseCache ? new CacheCPA(lPredicateCPA) : lPredicateCPA;
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        this.mTimeInReach = new TimeAccumulator();
        this.mTimesInReach = 0;
        this.mGeneratedTestCases = new HashMap<TestCase, CFAEdge[]>();
        this.mInfeasibleGoals = new HashMap<NondeterministicFiniteAutomaton<GuardedEdgeLabel>, Collection<NondeterministicFiniteAutomaton.State>>();
    }

    @Override
    public FShell3Result run(String pFQLSpecification, boolean pApplySubsumptionCheck, boolean pApplyInfeasibilityPropagation, boolean pGenerateTestGoalAutomataInAdvance, boolean pCheckCorrectnessOfCoverageCheck, boolean pPedantic, boolean pAlternating) {
        return this.run(pFQLSpecification, pApplySubsumptionCheck, pApplyInfeasibilityPropagation, pCheckCorrectnessOfCoverageCheck, pPedantic);
    }

    private AlternatingRefiner reach(GuardedEdgeAutomatonCPA pInterpreter_AutomatonCPA, ProgressCPA pSymbolic_AutomatonCPA, CFAFunctionDefinitionNode pEntryNode, GuardedEdgeAutomatonCPA pPassingCPA) {
        ARTStatistics lARTStatistics;
        CEGARAlgorithm lAlgorithm;
        PredicateRefiner lRefiner;
        ARTCPA lARTCPA;
        this.mTimeInReach.proceed();
        ++this.mTimesInReach;
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        lComponentAnalyses.add(this.mCallStackCPA);
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (pPassingCPA != null) {
            lAutomatonCPAs.add(pPassingCPA);
        }
        lAutomatonCPAs.add(pSymbolic_AutomatonCPA);
        lComponentAnalyses.add(ProductAutomatonCPA.create(lAutomatonCPAs, true));
        lComponentAnalyses.add(this.mPredicateCPA);
        lComponentAnalyses.add(this.mAssumeCPA);
        try {
            CPAFactory lCPAFactory = CompositeCPA.factory();
            lCPAFactory.setChildren(lComponentAnalyses);
            lCPAFactory.setConfiguration(this.mConfiguration);
            lCPAFactory.setLogger(this.mLogManager);
            ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
            CPAFactory lARTCPAFactory = ARTCPA.factory();
            lARTCPAFactory.setChild(lCPA);
            lARTCPAFactory.setConfiguration(this.mConfiguration);
            lARTCPAFactory.setLogger(this.mLogManager);
            lARTCPA = (ARTCPA)lARTCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAAlgorithm lBasicAlgorithm = new CPAAlgorithm(lARTCPA, this.mLogManager);
        try {
            lRefiner = PredicateRefiner.create(lARTCPA);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        AlternatingRefiner lAlternatingRefiner = new AlternatingRefiner(pInterpreter_AutomatonCPA, pPassingCPA, this.mLocationCPA, this.mCallStackCPA, this.mAssumeCPA, this.mCFAPathCPA, lARTCPA, pEntryNode, this.mWrapper.getOmegaEdge().getSuccessor(), lRefiner, this.mConfiguration, this.mLogManager);
        try {
            lAlgorithm = new CEGARAlgorithm((Algorithm)lBasicAlgorithm, lAlternatingRefiner, this.mConfiguration, this.mLogManager);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        try {
            lARTStatistics = new ARTStatistics(this.mConfiguration, lARTCPA);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        HashSet<Statistics> lStatistics = new HashSet<Statistics>();
        lStatistics.add(lARTStatistics);
        lAlgorithm.collectStatistics(lStatistics);
        AbstractElement lInitialElement = lARTCPA.getInitialElement(pEntryNode);
        Precision lInitialPrecision = lARTCPA.getInitialPrecision(pEntryNode);
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.mTimeInReach.pause();
        return lAlternatingRefiner;
    }

    private boolean checkCoverage(TestCase pTestCase, CFAFunctionDefinitionNode pEntry, GuardedEdgeAutomatonCPA pCoverAutomatonCPA, GuardedEdgeAutomatonCPA pPassingAutomatonCPA, CFANode pEndNode) throws InvalidConfigurationException, CPAException, ImpreciseExecutionException {
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (pPassingAutomatonCPA != null) {
            lAutomatonCPAs.add(pPassingAutomatonCPA);
        }
        lAutomatonCPAs.add(pCoverAutomatonCPA);
        int lProductAutomatonCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(ProductAutomatonCPA.create(lAutomatonCPAs, false));
        lComponentAnalyses.add(this.mCallStackCPA);
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(pTestCase.getInputs());
        lComponentAnalyses.add(lInterpreterCPA);
        lComponentAnalyses.add(this.mAssumeCPA);
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(this.mConfiguration);
        lCPAFactory.setLogger(this.mLogManager);
        ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, this.mLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(pEntry);
        Precision lInitialPrecision = lCPA.getInitialPrecision(pEntry);
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        CompositeElement lEndNode = (CompositeElement)lReachedSet.getLastElement();
        if (lEndNode == null) {
            return false;
        }
        if (((LocationElement)lEndNode.get(0)).getLocationNode().equals(pEndNode)) {
            AbstractElement lProductAutomatonElement = lEndNode.get(lProductAutomatonCPAIndex);
            if (lProductAutomatonElement instanceof Targetable) {
                Targetable lTargetable = (Targetable)((Object)lProductAutomatonElement);
                return lTargetable.isTarget();
            }
            return false;
        }
        return false;
    }

    private FShell3Result run(String pFQLSpecification, boolean pApplySubsumptionCheck, boolean pApplyInfeasibilityPropagation, boolean pCheckReachWhenCovered, boolean pPedantic) {
        FQLSpecification lFQLSpecification;
        try {
            lFQLSpecification = FQLSpecification.parse(pFQLSpecification);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println("Cache hits (1): " + this.mCoverageSpecificationTranslator.getOverallCacheHits());
        System.out.println("Cache misses (1): " + this.mCoverageSpecificationTranslator.getOverallCacheMisses());
        ElementaryCoveragePattern lPassingClause = null;
        if (lFQLSpecification.hasPassingClause()) {
            lPassingClause = this.mCoverageSpecificationTranslator.mPathPatternTranslator.translate(lFQLSpecification.getPathPattern());
        }
        System.out.println("Cache hits (2): " + this.mCoverageSpecificationTranslator.getOverallCacheHits());
        System.out.println("Cache misses (2): " + this.mCoverageSpecificationTranslator.getOverallCacheMisses());
        FShell3Result.Factory lResultFactory = FShell3Result.factory();
        GuardedEdgeAutomatonCPA lPassingCPA = null;
        if (lPassingClause != null) {
            NondeterministicFiniteAutomaton<GuardedEdgeLabel> lAutomaton = ToGuardedAutomatonTranslator.toAutomaton(lPassingClause, this.mAlphaLabel, this.mInverseAlphaLabel, this.mOmegaLabel);
            lPassingCPA = new GuardedEdgeAutomatonCPA(lAutomaton);
        }
        int lIndex = 0;
        int lFeasibleTestGoalsTimeSlot = 0;
        int lInfeasibleTestGoalsTimeSlot = 1;
        TimeAccumulator lTimeAccu = new TimeAccumulator(2);
        TimeAccumulator lTimeReach = new TimeAccumulator();
        TimeAccumulator lTimeCover = new TimeAccumulator();
        IncrementalCoverageSpecificationTranslator lTranslator = new IncrementalCoverageSpecificationTranslator(this.mCoverageSpecificationTranslator.mPathPatternTranslator);
        int lNumberOfTestGoals = lTranslator.getNumberOfTestGoals(lFQLSpecification.getCoverageSpecification());
        System.out.println("Number of test goals: " + lNumberOfTestGoals);
        Iterator<ElementaryCoveragePattern> lGoalIterator = lTranslator.translate(lFQLSpecification.getCoverageSpecification());
        while (lGoalIterator.hasNext()) {
            ElementaryCoveragePattern lGoalPattern = lGoalIterator.next();
            System.out.println("Processing test goal #" + ++lIndex + " of " + lNumberOfTestGoals + " test goals.");
            lTimeAccu.proceed();
            Goal lGoal = new Goal(lGoalPattern, this.mAlphaLabel, this.mInverseAlphaLabel, this.mOmegaLabel);
            boolean lIsCovered = false;
            if (pApplySubsumptionCheck) {
                for (Map.Entry<TestCase, CFAEdge[]> lGeneratedTestCase : this.mGeneratedTestCases.entrySet()) {
                    TestCase lTestCase = lGeneratedTestCase.getKey();
                    if (!lTestCase.isPrecise()) {
                        throw new RuntimeException();
                    }
                    ThreeValuedAnswer lCoverageAnswer = FShell3.accepts(lGoal.getAutomaton(), lGeneratedTestCase.getValue());
                    if (lCoverageAnswer.equals((Object)ThreeValuedAnswer.ACCEPT)) {
                        lIsCovered = true;
                        lResultFactory.addFeasibleTestCase(lGoal.getPattern(), lTestCase);
                        break;
                    }
                    if (!lCoverageAnswer.equals((Object)ThreeValuedAnswer.UNKNOWN)) continue;
                    GuardedEdgeAutomatonCPA lAutomatonCPA = new GuardedEdgeAutomatonCPA(lGoal.getAutomaton());
                    try {
                        if (!this.checkCoverage(lTestCase, this.mWrapper.getEntry(), lAutomatonCPA, lPassingCPA, this.mWrapper.getOmegaEdge().getSuccessor())) continue;
                        lIsCovered = true;
                        lResultFactory.addFeasibleTestCase(lGoal.getPattern(), lTestCase);
                        break;
                    }
                    catch (InvalidConfigurationException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    catch (CPAException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    catch (ImpreciseExecutionException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            }
            if (lIsCovered) {
                System.out.println("Goal #" + lIndex + " is covered by an existing test case!");
                if (!pCheckReachWhenCovered) {
                    lTimeAccu.pause(lFeasibleTestGoalsTimeSlot);
                    continue;
                }
            }
            GuardedEdgeAutomatonCPA lInterpreter_AutomatonCPA = new GuardedEdgeAutomatonCPA(lGoal.getAutomaton());
            ProgressCPA lSymbolic_AutomatonCPA = new ProgressCPA(lGoal.getAutomaton());
            lTimeReach.proceed();
            AlternatingRefiner lAlternatingRefiner = this.reach(lInterpreter_AutomatonCPA, lSymbolic_AutomatonCPA, this.mWrapper.getEntry(), lPassingCPA);
            lTimeReach.pause();
            System.out.println("INTERMEDIATE TEST SUITE: " + lAlternatingRefiner.getIntermediateTestSuite().size());
            if (!lAlternatingRefiner.hasCoveringTestCase()) {
                System.out.println("Goal #" + lIndex + " is infeasible!");
                if (lIsCovered) {
                    throw new RuntimeException("Inconsistent result of coverage check and reachability analysis!");
                }
                lResultFactory.addInfeasibleTestCase(lGoal.getPattern());
                lTimeAccu.pause(lInfeasibleTestGoalsTimeSlot);
                continue;
            }
            System.out.println("Goal #" + lIndex + " is feasible!");
            lResultFactory.addFeasibleTestCase(lGoal.getPattern(), lAlternatingRefiner.getCoveringTestCase());
            this.mGeneratedTestCases.put(lAlternatingRefiner.getCoveringTestCase(), lAlternatingRefiner.getExecutionPath());
            lTimeAccu.pause(lFeasibleTestGoalsTimeSlot);
        }
        System.out.println("Time in reach: " + this.mTimeInReach.getSeconds());
        System.out.println("Mean time of reach: " + this.mTimeInReach.getSeconds() / (double)this.mTimesInReach + " s");
        FShell3Result lResult = lResultFactory.create(lTimeReach.getSeconds(), lTimeCover.getSeconds(), lTimeAccu.getSeconds(lFeasibleTestGoalsTimeSlot), lTimeAccu.getSeconds(lInfeasibleTestGoalsTimeSlot));
        System.out.println("Generated Test Cases:");
        for (TestCase lTestCase : lResultFactory.getTestCases()) {
            System.out.println(lTestCase);
        }
        System.out.println("Size of infeasibility cache: " + this.mInfeasibleGoals.size());
        return lResult;
    }
}

