/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.sosy_lab.cpachecker.fshell.FeasibilityInformation;

public class LoggingFeasibilityInformation
extends FeasibilityInformation {
    private final FeasibilityInformation mFeasibilityInformation;
    private final PrintWriter mWriter;

    public LoggingFeasibilityInformation(FeasibilityInformation pFeasibilityInformation, String pFeasibilityFilename, boolean pAppend) throws FileNotFoundException {
        this(pFeasibilityInformation, new File(pFeasibilityFilename), pAppend);
    }

    public LoggingFeasibilityInformation(FeasibilityInformation pFeasibilityInformation, File pFeasibilityFile, boolean pAppend) throws FileNotFoundException {
        this.mFeasibilityInformation = pFeasibilityInformation;
        if (!pAppend) {
            this.mFeasibilityInformation.write(pFeasibilityFile);
        }
        this.mWriter = new PrintWriter(new FileOutputStream(pFeasibilityFile, true));
    }

    @Override
    public boolean hasTestsuiteFilename() {
        return this.mFeasibilityInformation.hasTestsuiteFilename();
    }

    @Override
    public String getTestsuiteFilename() {
        return this.mFeasibilityInformation.getTestsuiteFilename();
    }

    @Override
    public void setTestsuiteFilename(String pFilename) {
        this.mFeasibilityInformation.setTestsuiteFilename(pFilename);
    }

    @Override
    public void write(String pFeasibilityFilename) throws FileNotFoundException {
        this.mFeasibilityInformation.write(pFeasibilityFilename);
    }

    @Override
    public void write(File pFeasibilityFile) throws FileNotFoundException {
        this.mFeasibilityInformation.write(pFeasibilityFile);
    }

    @Override
    public boolean isKnown(int pGoalIndex) {
        return this.mFeasibilityInformation.isKnown(pGoalIndex);
    }

    @Override
    public boolean isUnknown(int pGoalIndex) {
        return this.mFeasibilityInformation.isUnknown(pGoalIndex);
    }

    @Override
    public FeasibilityInformation.FeasibilityStatus getStatus(int pGoalIndex) {
        return this.mFeasibilityInformation.getStatus(pGoalIndex);
    }

    @Override
    public void setStatus(int pGoalIndex, FeasibilityInformation.FeasibilityStatus pStatus) {
        switch (pStatus) {
            case FEASIBLE: {
                this.mWriter.println(pGoalIndex + " " + "f");
                this.mWriter.flush();
                break;
            }
            case INFEASIBLE: {
                this.mWriter.println(pGoalIndex + " " + "if");
                this.mWriter.flush();
                break;
            }
            case IMPRECISE: {
                this.mWriter.println(pGoalIndex + " " + "ip");
                this.mWriter.flush();
            }
        }
        this.mFeasibilityInformation.setStatus(pGoalIndex, pStatus);
    }

    public void close() {
        this.mWriter.close();
    }
}

