/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.fshell.FShell3;
import org.sosy_lab.cpachecker.fshell.FShell3Result;
import org.sosy_lab.cpachecker.util.Cilly;

public class Main {
    public static final String STATEMENT_COVERAGE = "COVER \"EDGES(ID)*\".NODES(ID).\"EDGES(ID)*\"";
    public static final String STATEMENT_2_COVERAGE = "COVER \"EDGES(ID)*\".NODES(ID).\"EDGES(ID)*\".NODES(ID).\"EDGES(ID)*\"";
    public static final String STATEMENT_3_COVERAGE = "COVER \"EDGES(ID)*\".NODES(ID).\"EDGES(ID)*\".NODES(ID).\"EDGES(ID)*\".NODES(ID).\"EDGES(ID)*\"";
    public static final String BASIC_BLOCK_COVERAGE = "COVER \"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\"";
    public static final String BASIC_BLOCK_2_COVERAGE = "COVER \"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\"";
    public static final String BASIC_BLOCK_3_COVERAGE = "COVER \"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\"";
    public static final String BASIC_BLOCK_4_COVERAGE = "COVER \"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\"";
    public static final String BASIC_BLOCK_5_COVERAGE = "COVER \"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\"";
    public static final String CONDITION_COVERAGE = "COVER \"EDGES(ID)*\".EDGES(@CONDITIONEDGE).\"EDGES(ID)*\"";
    public static final String BASIC_BLOCK_NODES_COVERAGE = "COVER \"EDGES(ID)*\".NODES(@BASICBLOCKENTRY).\"EDGES(ID)*\"";
    public static final String BASIC_BLOCK_NODES_2_COVERAGE = "COVER \"EDGES(ID)*\".NODES(@BASICBLOCKENTRY).\"EDGES(ID)*\".NODES(@BASICBLOCKENTRY).\"EDGES(ID)*\"";
    public static final String BASIC_BLOCK_NODES_3_COVERAGE = "COVER \"EDGES(ID)*\".NODES(@BASICBLOCKENTRY).\"EDGES(ID)*\".NODES(@BASICBLOCKENTRY).\"EDGES(ID)*\".NODES(@BASICBLOCKENTRY).\"EDGES(ID)*\"";
    public static final String BOUNDED_PATH_1_COVERAGE = "COVER \"EDGES(ID)*\".PATHS(ID, 1).\"EDGES(ID)*\"";
    public static final String BOUNDED_PATH_2_COVERAGE = "COVER \"EDGES(ID)*\".PATHS(ID, 2).\"EDGES(ID)*\"";
    public static final String BOUNDED_PATH_3_COVERAGE = "COVER \"EDGES(ID)*\".PATHS(ID, 3).\"EDGES(ID)*\"";
    public static final String BOUNDED_PATH_4_COVERAGE = "COVER \"EDGES(ID)*\".PATHS(ID, 4).\"EDGES(ID)*\"";
    public static final String BOUNDED_PATH_5_COVERAGE = "COVER \"EDGES(ID)*\".PATHS(ID, 5).\"EDGES(ID)*\"";
    public static final String BOUNDED_PATH_6_COVERAGE = "COVER \"EDGES(ID)*\".PATHS(ID, 6).\"EDGES(ID)*\"";
    public static final String BOUNDED_PATH_7_COVERAGE = "COVER \"EDGES(ID)*\".PATHS(ID, 7).\"EDGES(ID)*\"";
    public static final String BOUNDED_PATH_8_COVERAGE = "COVER \"EDGES(ID)*\".PATHS(ID, 8).\"EDGES(ID)*\"";

    public static void main(String[] pArguments) throws IOException, InvalidConfigurationException {
        FShell3Result lResult = Main.run(pArguments);
        if (lResult.hasFinished()) {
            System.exit(0);
        } else {
            System.exit(-1);
        }
    }

    public static FShell3Result run(String[] pArguments) throws IOException, InvalidConfigurationException {
        Configuration lConfig;
        LogManager lLogger;
        Cilly lCilly;
        assert (pArguments != null);
        assert (pArguments.length > 1);
        System.out.println(pArguments[0]);
        String lFQLSpecificationString = pArguments[0];
        String lSourceFileName = pArguments[1];
        String lEntryFunction = "main";
        if (pArguments.length > 2) {
            lEntryFunction = pArguments[2];
        }
        boolean lCilPreprocessing = true;
        int lMinIndex = 0;
        int lMaxIndex = Integer.MAX_VALUE;
        String lFeasibilityInformationInputFile = null;
        String lFeasibilityInformationOutputFile = null;
        String lTestSuiteOutputFile = null;
        boolean lDoLogging = false;
        boolean lDoAppendingLogging = false;
        boolean lDoRestart = false;
        long lRestartBound = 100000000L;
        for (int lIndex = 3; lIndex < pArguments.length; ++lIndex) {
            String lTmp;
            String lOption = pArguments[lIndex].trim();
            if (lOption.equals("--withoutCilPreprocessing")) {
                lCilPreprocessing = false;
                continue;
            }
            if (lOption.startsWith("--min=")) {
                lTmp = lOption.substring("--min=".length());
                lMinIndex = Integer.valueOf(lTmp);
                continue;
            }
            if (lOption.startsWith("--max=")) {
                lTmp = lOption.substring("--max=".length());
                lMaxIndex = Integer.valueOf(lTmp);
                continue;
            }
            if (lOption.startsWith("--in=")) {
                lFeasibilityInformationInputFile = lOption.substring("--in=".length());
                continue;
            }
            if (lOption.startsWith("--out=")) {
                lFeasibilityInformationOutputFile = lOption.substring("--out=".length());
                continue;
            }
            if (lOption.startsWith("--tout=")) {
                lTestSuiteOutputFile = lOption.substring("--tout=".length());
                continue;
            }
            if (lOption.equals("--logging")) {
                lDoLogging = true;
                continue;
            }
            if (lOption.equals("--append")) {
                lDoAppendingLogging = true;
                continue;
            }
            if (lOption.equals("--restart")) {
                lDoRestart = true;
                continue;
            }
            if (!lOption.startsWith("--restart-bound=")) continue;
            lTmp = lOption.substring("--restart-bound=".length());
            lRestartBound = Long.valueOf(lTmp);
        }
        if (lCilPreprocessing && !(lCilly = new Cilly(lLogger = new LogManager(lConfig = Configuration.defaultConfiguration()))).isCillyInvariant(lSourceFileName)) {
            File lCillyProcessedFile = lCilly.cillyfy(lSourceFileName);
            lSourceFileName = lCillyProcessedFile.getAbsolutePath();
            System.err.println("WARNING: Given source file is not CIL invariant ... did preprocessing!");
        }
        FShell3 lFShell = new FShell3(lSourceFileName, lEntryFunction);
        lFShell.setGoalIndices(lMinIndex, lMaxIndex);
        if (lFeasibilityInformationInputFile != null) {
            lFShell.setFeasibilityInformationInputFile(lFeasibilityInformationInputFile);
        }
        if (lFeasibilityInformationOutputFile != null) {
            lFShell.setFeasibilityInformationOutputFile(lFeasibilityInformationOutputFile);
        }
        if (lTestSuiteOutputFile != null) {
            lFShell.setTestSuiteOutputFile(lTestSuiteOutputFile);
        }
        if (lDoLogging) {
            lFShell.doLogging();
            if (lDoAppendingLogging) {
                lFShell.doAppendingLogging();
            }
        }
        if (lDoRestart) {
            lFShell.doRestart();
            lFShell.setRestartBound(lRestartBound);
        }
        FShell3Result lResult = lFShell.run(lFQLSpecificationString);
        System.out.println("#Goals: " + lResult.getNumberOfTestGoals() + ", #Feasible: " + lResult.getNumberOfFeasibleTestGoals() + ", #Infeasible: " + lResult.getNumberOfInfeasibleTestGoals() + ", #Imprecise: " + lResult.getNumberOfImpreciseTestCases());
        return lResult;
    }

    public static String[] getParameters(String pQuery, String pSource, String pEntryFunction, boolean pDisablePreprocessing) {
        String[] lResult;
        LinkedList<String> lArguments = new LinkedList<String>();
        lArguments.add(pQuery);
        lArguments.add(pSource);
        lArguments.add(pEntryFunction);
        if (pDisablePreprocessing) {
            lArguments.add("--withoutCilPreprocessing");
            lResult = new String[4];
        } else {
            lResult = new String[3];
        }
        return lArguments.toArray(lResult);
    }
}

