/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.fshell.FShell3;
import org.sosy_lab.cpachecker.fshell.FeasibilityInformation;
import org.sosy_lab.cpachecker.fshell.RestartingFShell3;
import org.sosy_lab.cpachecker.fshell.fql2.ast.FQLSpecification;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.CoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.IncrementalCoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.testcases.TestSuite;

public class MultiprocessFShell3 {
    private static synchronized TestSuite readGlobalTestsuite(String pFilename) {
        TestSuite lTestSuite = null;
        try {
            lTestSuite = TestSuite.load(pFilename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lTestSuite;
    }

    private static synchronized void writeGlobalTestsuite(String pLocalTestsuite, String pGlobalTestsuite) throws IOException {
        TestSuite lLocalTestsuite = TestSuite.load(pLocalTestsuite);
        TestSuite lGlobalTestsuite = TestSuite.load(pGlobalTestsuite);
        lGlobalTestsuite.add(lLocalTestsuite);
        lGlobalTestsuite.write(pGlobalTestsuite);
    }

    private static FQLSpecification getFQLSpecification(String pFQLSpecification) {
        FQLSpecification lFQLSpecification;
        try {
            lFQLSpecification = FQLSpecification.parse(pFQLSpecification);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lFQLSpecification;
    }

    private static int getNumberOfTestGoals(String pCoverageSpecification, String pSourceFile, String pEntryFunction) {
        CFAFunctionDefinitionNode lMainFunction;
        try {
            Configuration mConfiguration = FShell3.createConfiguration(pSourceFile, pEntryFunction);
            LogManager mLogManager = new LogManager(mConfiguration);
            Map<String, CFAFunctionDefinitionNode> lCFAMap = FShell3.getCFAMap(pSourceFile, mConfiguration, mLogManager);
            lMainFunction = lCFAMap.get(pEntryFunction);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        CoverageSpecificationTranslator mCoverageSpecificationTranslator = new CoverageSpecificationTranslator(lMainFunction);
        FQLSpecification lFQLSpecification = MultiprocessFShell3.getFQLSpecification(pCoverageSpecification);
        IncrementalCoverageSpecificationTranslator lTranslator = new IncrementalCoverageSpecificationTranslator(mCoverageSpecificationTranslator.mPathPatternTranslator);
        int lNumberOfTestGoals = lTranslator.getNumberOfTestGoals(lFQLSpecification.getCoverageSpecification());
        return lNumberOfTestGoals;
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        String lCoverageSpecification = args[0];
        String lSourceFile = args[1];
        String lEntryFunction = args[2];
        int lNumberOfProcesses = Integer.valueOf(args[3]);
        int lNumberOfTestGoals = MultiprocessFShell3.getNumberOfTestGoals(lCoverageSpecification, lSourceFile, lEntryFunction);
        System.out.println("NUMBER OF TESTGOALS: " + lNumberOfTestGoals);
        int lJobSize = lNumberOfTestGoals / lNumberOfProcesses;
        LinkedList<Pair> lJobs = new LinkedList<Pair>();
        for (int lIndex = 0; lIndex < lNumberOfProcesses - 1; ++lIndex) {
            int lMin = lIndex * lJobSize;
            int lMax = lIndex * lJobSize + lJobSize - 1;
            Pair lJob = Pair.of((Object)lMin, (Object)lMax);
            lJobs.add(lJob);
        }
        int lMin = (lNumberOfProcesses - 1) * lJobSize;
        int lMax = lNumberOfTestGoals;
        Pair lLastJob = Pair.of((Object)lMin, (Object)lMax);
        lJobs.add(lLastJob);
        File lGlobalTestsuiteFile = File.createTempFile("testsuite", ".tst");
        LinkedList<Thread> lThreads = new LinkedList<Thread>();
        for (Pair lJob : lJobs) {
            System.out.println("Starting job [" + lJob.getFirst() + ", " + lJob.getSecond() + "]");
            Thread lThread = new Thread(new CommunicatingJob(lCoverageSpecification, lSourceFile, lEntryFunction, (Integer)lJob.getFirst(), (Integer)lJob.getSecond(), lGlobalTestsuiteFile.getAbsolutePath()));
            lThread.start();
            lThreads.add(lThread);
        }
        for (Thread lThread : lThreads) {
            lThread.join();
        }
    }

    public static class FShell3Runnable
    implements Runnable {
        private final String mCoverageSpecification;
        private final String mSourceFile;
        private final String mEntryFunction;
        private final int mMinGoalIndex;
        private final int mMaxGoalIndex;
        private final String mInitialTestsuite;

        public FShell3Runnable(String pCoverageSpecification, String pSourceFile, String pEntryFunction, int pMinGoalIndex, int pMaxGoalIndex) {
            this(pCoverageSpecification, pSourceFile, pEntryFunction, pMinGoalIndex, pMaxGoalIndex, null);
        }

        public FShell3Runnable(String pCoverageSpecification, String pSourceFile, String pEntryFunction, int pMinGoalIndex, int pMaxGoalIndex, String pInitialTestsuite) {
            this.mCoverageSpecification = pCoverageSpecification;
            this.mSourceFile = pSourceFile;
            this.mEntryFunction = pEntryFunction;
            this.mMinGoalIndex = pMinGoalIndex;
            this.mMaxGoalIndex = pMaxGoalIndex;
            this.mInitialTestsuite = pInitialTestsuite;
        }

        @Override
        public void run() {
            String[] lArguments = this.mInitialTestsuite != null ? new String[6] : new String[]{this.mCoverageSpecification, this.mSourceFile, this.mEntryFunction, "--min=" + this.mMinGoalIndex, "--max=" + this.mMaxGoalIndex};
            if (this.mInitialTestsuite != null) {
                lArguments[5] = "--in=" + this.mInitialTestsuite;
            }
            try {
                RestartingFShell3.main(lArguments);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static class CommunicatingJob
    implements Runnable {
        private final String mCoverageSpecification;
        private final String mSourceFile;
        private final String mEntryFunction;
        private final int mMinGoalIndex;
        private final int mMaxGoalIndex;
        private final String mGlobalTestsuiteFile;

        public CommunicatingJob(String pCoverageSpecification, String pSourceFile, String pEntryFunction, int pMinGoalIndex, int pMaxGoalIndex, String pGlobalTestsuiteFile) {
            this.mCoverageSpecification = pCoverageSpecification;
            this.mSourceFile = pSourceFile;
            this.mEntryFunction = pEntryFunction;
            this.mMinGoalIndex = pMinGoalIndex;
            this.mMaxGoalIndex = pMaxGoalIndex;
            this.mGlobalTestsuiteFile = pGlobalTestsuiteFile;
        }

        @Override
        public void run() {
            LinkedList<Pair> lJobs = new LinkedList<Pair>();
            File lTmpTestsuiteFile = null;
            try {
                lTmpTestsuiteFile = File.createTempFile("testsuite", ".tst");
                lTmpTestsuiteFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            File lTmpFeasibilityFile = null;
            try {
                lTmpFeasibilityFile = File.createTempFile("testsuite", ".tst");
                lTmpFeasibilityFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FeasibilityInformation lFeasibilityInformation = new FeasibilityInformation();
            try {
                lFeasibilityInformation.setTestsuiteFilename(lTmpTestsuiteFile.getCanonicalPath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                lFeasibilityInformation.write(lTmpFeasibilityFile.getCanonicalPath());
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            int lNumberOfTestGoals = this.mMaxGoalIndex - this.mMinGoalIndex + 1;
            int lSize = 1000;
            if (lNumberOfTestGoals > lSize) {
                int lMinIndex;
                for (lMinIndex = this.mMinGoalIndex; lMinIndex < this.mMaxGoalIndex; lMinIndex += lSize) {
                    Pair lJob = Pair.of((Object)lMinIndex, (Object)(lMinIndex + lSize - 1));
                    lJobs.add(lJob);
                }
                Pair lLastJob = Pair.of((Object)lMinIndex, (Object)this.mMaxGoalIndex);
                lJobs.add(lLastJob);
            } else {
                Pair lJob = Pair.of((Object)this.mMinGoalIndex, (Object)this.mMaxGoalIndex);
                lJobs.add(lJob);
            }
            for (Pair lJob : lJobs) {
                TestSuite lGlobalTestsuite = MultiprocessFShell3.readGlobalTestsuite(this.mGlobalTestsuiteFile);
                if (lGlobalTestsuite != null) {
                    try {
                        lGlobalTestsuite.write(lTmpTestsuiteFile);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                String[] lArguments = new String[6];
                lArguments[0] = this.mCoverageSpecification;
                lArguments[1] = this.mSourceFile;
                lArguments[2] = this.mEntryFunction;
                lArguments[3] = "--min=" + lJob.getFirst();
                lArguments[4] = "--max=" + lJob.getSecond();
                try {
                    lArguments[5] = "--in=" + lTmpFeasibilityFile.getCanonicalPath();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    RestartingFShell3.main(lArguments);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    MultiprocessFShell3.writeGlobalTestsuite(lTmpTestsuiteFile.getAbsolutePath(), this.mGlobalTestsuiteFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

