/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.TimeAccumulator;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CEGARAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.art.ARTCPA;
import org.sosy_lab.cpachecker.cpa.art.ARTStatistics;
import org.sosy_lab.cpachecker.cpa.assume.AssumeCPA;
import org.sosy_lab.cpachecker.cpa.cache.CacheCPA;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackCPA;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathCPA;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathStandardElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateRefiner;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.fshell.FShell3;
import org.sosy_lab.cpachecker.fshell.FShell3Result;
import org.sosy_lab.cpachecker.fshell.Goal;
import org.sosy_lab.cpachecker.fshell.Task;
import org.sosy_lab.cpachecker.fshell.ThreeValuedAnswer;
import org.sosy_lab.cpachecker.fshell.cfa.Wrapper;
import org.sosy_lab.cpachecker.fshell.fql2.ast.FQLSpecification;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.CoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.interfaces.FQLTestGenerator;
import org.sosy_lab.cpachecker.fshell.testcases.ImpreciseExecutionException;
import org.sosy_lab.cpachecker.fshell.testcases.TestCase;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.InverseGuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.ToGuardedAutomatonTranslator;

public class NonincrementalFQLTestGenerator
implements FQLTestGenerator {
    private final Configuration mConfiguration;
    private final LogManager mLogManager;
    private final Wrapper mWrapper;
    private final CoverageSpecificationTranslator mCoverageSpecificationTranslator;
    private final LocationCPA mLocationCPA;
    private final CallstackCPA mCallStackCPA;
    private final AssumeCPA mAssumeCPA;
    private final CFAPathCPA mCFAPathCPA;
    private final ConfigurableProgramAnalysis mPredicateCPA;
    private final TimeAccumulator mTimeInReach;
    private int mTimesInReach;
    private final GuardedEdgeLabel mAlphaLabel;
    private final GuardedEdgeLabel mOmegaLabel;
    private final GuardedEdgeLabel mInverseAlphaLabel;

    public NonincrementalFQLTestGenerator(String pSourceFileName, String pEntryFunction) {
        CFAFunctionDefinitionNode lMainFunction;
        Map<String, CFAFunctionDefinitionNode> lCFAMap;
        try {
            this.mConfiguration = FShell3.createConfiguration(pSourceFileName, pEntryFunction);
            this.mLogManager = new LogManager(this.mConfiguration);
            lCFAMap = FShell3.getCFAMap(pSourceFileName, this.mConfiguration, this.mLogManager);
            lMainFunction = lCFAMap.get(pEntryFunction);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.mCoverageSpecificationTranslator = new CoverageSpecificationTranslator(lMainFunction);
        this.mWrapper = new Wrapper((FunctionDefinitionNode)lMainFunction, lCFAMap, this.mLogManager);
        try {
            this.mWrapper.toDot("output/wrapper.dot");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mAlphaLabel = new GuardedEdgeLabel(new ECPEdgeSet(this.mWrapper.getAlphaEdge()));
        this.mInverseAlphaLabel = new InverseGuardedEdgeLabel(this.mAlphaLabel);
        this.mOmegaLabel = new GuardedEdgeLabel(new ECPEdgeSet(this.mWrapper.getOmegaEdge()));
        try {
            this.mLocationCPA = (LocationCPA)LocationCPA.factory().createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCallStackCPAFactory = CallstackCPA.factory();
        try {
            this.mCallStackCPA = (CallstackCPA)lCallStackCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        this.mAssumeCPA = AssumeCPA.getCBMCAssume();
        this.mCFAPathCPA = CFAPathCPA.getInstance();
        boolean lUseCache = false;
        CPAFactory lPredicateCPAFactory = PredicateCPA.factory();
        lPredicateCPAFactory.setConfiguration(this.mConfiguration);
        lPredicateCPAFactory.setLogger(this.mLogManager);
        try {
            ConfigurableProgramAnalysis lPredicateCPA = lPredicateCPAFactory.createInstance();
            this.mPredicateCPA = lUseCache ? new CacheCPA(lPredicateCPA) : lPredicateCPA;
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        this.mTimeInReach = new TimeAccumulator();
        this.mTimesInReach = 0;
    }

    @Override
    public FShell3Result run(String pFQLSpecification, boolean pApplySubsumptionCheck, boolean pApplyInfeasibilityPropagation, boolean pGenerateTestGoalAutomataInAdvance, boolean pCheckCorrectnessOfCoverageCheck, boolean pPedantic, boolean pAlternating) {
        return this.run(pFQLSpecification, pApplySubsumptionCheck, pApplyInfeasibilityPropagation);
    }

    private FShell3Result run(String pFQLSpecification, boolean pApplySubsumptionCheck, boolean pApplyInfeasibilityPropagation) {
        FQLSpecification lFQLSpecification;
        try {
            lFQLSpecification = FQLSpecification.parse(pFQLSpecification);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println("Cache hits (1): " + this.mCoverageSpecificationTranslator.getOverallCacheHits());
        System.out.println("Cache misses (1): " + this.mCoverageSpecificationTranslator.getOverallCacheMisses());
        Task lTask = Task.create(lFQLSpecification, this.mCoverageSpecificationTranslator);
        System.out.println("Cache hits (2): " + this.mCoverageSpecificationTranslator.getOverallCacheHits());
        System.out.println("Cache misses (2): " + this.mCoverageSpecificationTranslator.getOverallCacheMisses());
        System.out.println("Number of test goals: " + lTask.getNumberOfTestGoals());
        FShell3Result.Factory lResultFactory = FShell3Result.factory();
        GuardedEdgeAutomatonCPA lPassingCPA = null;
        if (lTask.hasPassingClause()) {
            NondeterministicFiniteAutomaton<GuardedEdgeLabel> lAutomaton = ToGuardedAutomatonTranslator.toAutomaton(lTask.getPassingClause(), this.mAlphaLabel, this.mInverseAlphaLabel, this.mOmegaLabel);
            lPassingCPA = new GuardedEdgeAutomatonCPA(lAutomaton);
        }
        TimeAccumulator lToGoalsTime = new TimeAccumulator();
        lToGoalsTime.proceed();
        Deque<Goal> lGoals = lTask.toGoals(this.mAlphaLabel, this.mInverseAlphaLabel, this.mOmegaLabel);
        lToGoalsTime.pause();
        System.out.println("Time for creating goals: " + lToGoalsTime.getSeconds() + " s");
        int lIndex = 0;
        int lFeasibleTestGoalsTimeSlot = 0;
        int lInfeasibleTestGoalsTimeSlot = 1;
        TimeAccumulator lTimeAccu = new TimeAccumulator(2);
        TimeAccumulator lTimeReach = new TimeAccumulator();
        TimeAccumulator lTimeCover = new TimeAccumulator();
        while (!lGoals.isEmpty()) {
            boolean lIsFeasible;
            lTimeAccu.proceed();
            Goal lGoal = lGoals.poll();
            int lCurrentGoalNumber = ++lIndex;
            System.out.println("Goal #" + lCurrentGoalNumber);
            HashSet<NondeterministicFiniteAutomaton.State> mReachedAutomatonStates = new HashSet<NondeterministicFiniteAutomaton.State>();
            GuardedEdgeAutomatonCPA lAutomatonCPA = new GuardedEdgeAutomatonCPA(lGoal.getAutomaton());
            lTimeReach.proceed();
            CounterexampleInfo lCounterexampleInfo = this.reach2(lAutomatonCPA, this.mWrapper.getEntry(), lPassingCPA);
            lTimeReach.pause();
            if (lCounterexampleInfo == null || lCounterexampleInfo.isSpurious()) {
                lIsFeasible = false;
                lResultFactory.addInfeasibleTestCase(lGoal.getPattern());
                System.out.println("Goal #" + lCurrentGoalNumber + " is infeasible!");
                if (pApplyInfeasibilityPropagation) {
                    this.removeTransitiveInfeasibleGoals(lGoal.getAutomaton(), lGoals, mReachedAutomatonStates);
                }
            } else {
                lTimeCover.proceed();
                lIsFeasible = true;
                TestCase lTestCase = TestCase.fromCounterexample(lCounterexampleInfo, this.mLogManager);
                if (lTestCase.isPrecise()) {
                    lResultFactory.addFeasibleTestCase(lGoal.getPattern(), lTestCase);
                    System.out.println("Goal #" + lCurrentGoalNumber + " is feasible!");
                    if (pApplySubsumptionCheck) {
                        try {
                            this.removeCoveredGoals(lGoals, lResultFactory, lTestCase, this.mWrapper, lAutomatonCPA, lPassingCPA);
                        }
                        catch (ImpreciseExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                } else {
                    lResultFactory.addImpreciseTestCase(lTestCase);
                }
                lTimeCover.pause();
            }
            if (lIsFeasible) {
                lTimeAccu.pause(lFeasibleTestGoalsTimeSlot);
                continue;
            }
            lTimeAccu.pause(lInfeasibleTestGoalsTimeSlot);
        }
        System.out.println("Time in reach: " + this.mTimeInReach.getSeconds());
        System.out.println("Mean time of reach: " + this.mTimeInReach.getSeconds() / (double)this.mTimesInReach + " s");
        return lResultFactory.create(lTimeReach.getSeconds(), lTimeCover.getSeconds(), lTimeAccu.getSeconds(lFeasibleTestGoalsTimeSlot), lTimeAccu.getSeconds(lInfeasibleTestGoalsTimeSlot));
    }

    private CounterexampleInfo reach2(GuardedEdgeAutomatonCPA pAutomatonCPA, CFAFunctionDefinitionNode pEntryNode, GuardedEdgeAutomatonCPA pPassingCPA) {
        ARTStatistics lARTStatistics;
        CEGARAlgorithm lAlgorithm;
        PredicateRefiner lRefiner;
        ARTCPA lARTCPA;
        this.mTimeInReach.proceed();
        ++this.mTimesInReach;
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        lComponentAnalyses.add(this.mCallStackCPA);
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (pPassingCPA != null) {
            lAutomatonCPAs.add(pPassingCPA);
        }
        lAutomatonCPAs.add(pAutomatonCPA);
        lComponentAnalyses.add(ProductAutomatonCPA.create(lAutomatonCPAs, false));
        lComponentAnalyses.add(this.mPredicateCPA);
        lComponentAnalyses.add(this.mAssumeCPA);
        try {
            CPAFactory lCPAFactory = CompositeCPA.factory();
            lCPAFactory.setChildren(lComponentAnalyses);
            lCPAFactory.setConfiguration(this.mConfiguration);
            lCPAFactory.setLogger(this.mLogManager);
            ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
            CPAFactory lARTCPAFactory = ARTCPA.factory();
            lARTCPAFactory.setChild(lCPA);
            lARTCPAFactory.setConfiguration(this.mConfiguration);
            lARTCPAFactory.setLogger(this.mLogManager);
            lARTCPA = (ARTCPA)lARTCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAAlgorithm lBasicAlgorithm = new CPAAlgorithm(lARTCPA, this.mLogManager);
        try {
            lRefiner = PredicateRefiner.create(lARTCPA);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            lAlgorithm = new CEGARAlgorithm((Algorithm)lBasicAlgorithm, lRefiner, this.mConfiguration, this.mLogManager);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        try {
            lARTStatistics = new ARTStatistics(this.mConfiguration, lARTCPA);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        HashSet<Statistics> lStatistics = new HashSet<Statistics>();
        lStatistics.add(lARTStatistics);
        lAlgorithm.collectStatistics(lStatistics);
        AbstractElement lInitialElement = lARTCPA.getInitialElement(pEntryNode);
        Precision lInitialPrecision = lARTCPA.getInitialPrecision(pEntryNode);
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.mTimeInReach.pause();
        return lARTCPA.getLastCounterexample();
    }

    private void removeCoveredGoals(Deque<Goal> pGoals, FShell3Result.Factory pResultFactory, TestCase pTestCase, Wrapper pWrapper, GuardedEdgeAutomatonCPA pAutomatonCPA, GuardedEdgeAutomatonCPA pPassingCPA) throws ImpreciseExecutionException {
        CFAEdge[] lCFAPath;
        try {
            lCFAPath = this.reconstructPath(pTestCase, this.mWrapper.getEntry(), pAutomatonCPA, pPassingCPA, this.mWrapper.getOmegaEdge().getSuccessor());
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        HashSet<Goal> lSubsumedGoals = new HashSet<Goal>();
        for (Goal lOpenGoal : pGoals) {
            ThreeValuedAnswer lAcceptanceAnswer = FShell3.accepts(lOpenGoal.getAutomaton(), lCFAPath);
            if (lAcceptanceAnswer == ThreeValuedAnswer.ACCEPT) {
                lSubsumedGoals.add(lOpenGoal);
                pResultFactory.addFeasibleTestCase(lOpenGoal.getPattern(), pTestCase);
                continue;
            }
            if (lAcceptanceAnswer != ThreeValuedAnswer.UNKNOWN) continue;
            throw new RuntimeException();
        }
        System.out.println("#COVERED GOALS: " + lSubsumedGoals.size());
        pGoals.removeAll(lSubsumedGoals);
    }

    private CFAEdge[] reconstructPath(TestCase pTestCase, CFAFunctionDefinitionNode pEntry, GuardedEdgeAutomatonCPA pCoverAutomatonCPA, GuardedEdgeAutomatonCPA pPassingAutomatonCPA, CFANode pEndNode) throws InvalidConfigurationException, CPAException, ImpreciseExecutionException {
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (pPassingAutomatonCPA != null) {
            lAutomatonCPAs.add(pPassingAutomatonCPA);
        }
        lAutomatonCPAs.add(pCoverAutomatonCPA);
        int lProductAutomatonCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(ProductAutomatonCPA.create(lAutomatonCPAs, false));
        lComponentAnalyses.add(this.mCallStackCPA);
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(pTestCase.getInputs());
        lComponentAnalyses.add(lInterpreterCPA);
        int lCFAPathCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(this.mCFAPathCPA);
        lComponentAnalyses.add(this.mAssumeCPA);
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(this.mConfiguration);
        lCPAFactory.setLogger(this.mLogManager);
        ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, this.mLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(pEntry);
        Precision lInitialPrecision = lCPA.getInitialPrecision(pEntry);
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        CompositeElement lEndNode = (CompositeElement)lReachedSet.getLastElement();
        if (lEndNode == null) {
            throw new ImpreciseExecutionException(pTestCase, pCoverAutomatonCPA, pPassingAutomatonCPA);
        }
        if (!((LocationElement)lEndNode.get(0)).getLocationNode().equals(pEndNode)) {
            throw new ImpreciseExecutionException(pTestCase, pCoverAutomatonCPA, pPassingAutomatonCPA);
        }
        AbstractElement lProductAutomatonElement = lEndNode.get(lProductAutomatonCPAIndex);
        if (!(lProductAutomatonElement instanceof Targetable)) {
            throw new RuntimeException();
        }
        Targetable lTargetable = (Targetable)((Object)lProductAutomatonElement);
        if (!lTargetable.isTarget()) {
            throw new RuntimeException();
        }
        CFAPathStandardElement lPathElement = (CFAPathStandardElement)lEndNode.get(lCFAPathCPAIndex);
        return lPathElement.toArray();
    }

    private boolean isTransitivelyInfeasible(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pInfeasibleAutomaton, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pOtherAutomaton, Collection<NondeterministicFiniteAutomaton.State> pReachedAutomatonStates) {
        return this.getSimilarStates(pInfeasibleAutomaton, pOtherAutomaton).containsAll(pReachedAutomatonStates);
    }

    private Collection<NondeterministicFiniteAutomaton.State> getSimilarStates(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pInfeasibleAutomaton, NondeterministicFiniteAutomaton<GuardedEdgeLabel> pOtherAutomaton) {
        Pair lInitialPair = Pair.of((Object)pInfeasibleAutomaton.getInitialState(), (Object)pOtherAutomaton.getInitialState());
        LinkedList<Object> lWorklist = new LinkedList<Object>();
        lWorklist.add(lInitialPair);
        HashMultimap lCore = HashMultimap.create();
        HashMultimap lFrontier = HashMultimap.create();
        while (!lWorklist.isEmpty()) {
            boolean lOneDirectionSimilar;
            Pair lCurrentPair = (Pair)lWorklist.removeFirst();
            if (lCore.containsEntry(lCurrentPair.getFirst(), lCurrentPair.getSecond()) || lFrontier.containsEntry(lCurrentPair.getFirst(), lCurrentPair.getSecond())) continue;
            boolean lSimilar = true;
            HashSet<Pair> lPotentialWork = new HashSet<Pair>();
            for (NondeterministicFiniteAutomaton.Edge lOutgoingEdge : pInfeasibleAutomaton.getOutgoingEdges((NondeterministicFiniteAutomaton.State)lCurrentPair.getFirst())) {
                lOneDirectionSimilar = false;
                for (NondeterministicFiniteAutomaton.Edge lOutgoingEdge2 : pOtherAutomaton.getOutgoingEdges((NondeterministicFiniteAutomaton.State)lCurrentPair.getSecond())) {
                    if (!((GuardedEdgeLabel)lOutgoingEdge.getLabel()).equals(lOutgoingEdge2.getLabel())) continue;
                    lPotentialWork.add(Pair.of((Object)lOutgoingEdge.getTarget(), (Object)lOutgoingEdge2.getTarget()));
                    lOneDirectionSimilar = true;
                }
                if (lOneDirectionSimilar) continue;
                lSimilar = false;
            }
            for (NondeterministicFiniteAutomaton.Edge lOutgoingEdge : pOtherAutomaton.getOutgoingEdges((NondeterministicFiniteAutomaton.State)lCurrentPair.getSecond())) {
                lOneDirectionSimilar = false;
                for (NondeterministicFiniteAutomaton.Edge lOutgoingEdge2 : pInfeasibleAutomaton.getOutgoingEdges((NondeterministicFiniteAutomaton.State)lCurrentPair.getFirst())) {
                    if (!((GuardedEdgeLabel)lOutgoingEdge.getLabel()).equals(lOutgoingEdge2.getLabel())) continue;
                    lPotentialWork.add(Pair.of((Object)lOutgoingEdge2.getTarget(), (Object)lOutgoingEdge.getTarget()));
                    lOneDirectionSimilar = true;
                }
                if (lOneDirectionSimilar) continue;
                lSimilar = false;
            }
            if (lSimilar) {
                lCore.put(lCurrentPair.getFirst(), lCurrentPair.getSecond());
                lWorklist.addAll(lPotentialWork);
                continue;
            }
            lFrontier.put(lCurrentPair.getFirst(), lCurrentPair.getSecond());
        }
        return lCore.keySet();
    }

    private void removeTransitiveInfeasibleGoals(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pInfeasibleAutomaton, Deque<Goal> pGoals, Collection<NondeterministicFiniteAutomaton.State> pReachedAutomatonStates) {
        HashSet<Goal> lSubsumedGoals = new HashSet<Goal>();
        if (pReachedAutomatonStates.size() <= 3) {
            System.out.println(pInfeasibleAutomaton.toString());
            System.out.println("---");
            System.out.println(pReachedAutomatonStates);
            System.out.println("---");
            throw new RuntimeException();
        }
        for (Goal lOpenGoal : pGoals) {
            if (!this.isTransitivelyInfeasible(pInfeasibleAutomaton, lOpenGoal.getAutomaton(), pReachedAutomatonStates)) continue;
            lSubsumedGoals.add(lOpenGoal);
        }
        System.out.println("Removing " + lSubsumedGoals.size() + " many infeasible test goals!");
        pGoals.removeAll(lSubsumedGoals);
    }
}

