/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.assume.AssumeCPA;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackCPA;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathCPA;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathStandardElement;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeElement;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.GuardedEdgeAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.guardededgeautomaton.productautomaton.ProductAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.interpreter.InterpreterCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.fshell.FShell3;
import org.sosy_lab.cpachecker.fshell.Goal;
import org.sosy_lab.cpachecker.fshell.ThreeValuedAnswer;
import org.sosy_lab.cpachecker.fshell.cfa.Wrapper;
import org.sosy_lab.cpachecker.fshell.fql2.ast.FQLSpecification;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.CoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.IncrementalCoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.interfaces.FQLCoverageAnalyser;
import org.sosy_lab.cpachecker.fshell.testcases.ImpreciseExecutionException;
import org.sosy_lab.cpachecker.fshell.testcases.TestCase;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.InverseGuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.ToGuardedAutomatonTranslator;

public class StandardFQLCoverageAnalyser
implements FQLCoverageAnalyser {
    private final Configuration mConfiguration;
    private final LogManager mLogManager;
    private final Wrapper mWrapper;
    private final CoverageSpecificationTranslator mCoverageSpecificationTranslator;
    private final LocationCPA mLocationCPA;
    private final CallstackCPA mCallStackCPA;
    private final AssumeCPA mAssumeCPA;
    private final CFAPathCPA mCFAPathCPA;
    private final GuardedEdgeLabel mAlphaLabel;
    private final GuardedEdgeLabel mOmegaLabel;
    private final GuardedEdgeLabel mInverseAlphaLabel;

    public StandardFQLCoverageAnalyser(String pSourceFileName, String pEntryFunction) {
        CFAFunctionDefinitionNode lMainFunction;
        Map<String, CFAFunctionDefinitionNode> lCFAMap;
        try {
            this.mConfiguration = FShell3.createConfiguration(pSourceFileName, pEntryFunction);
            this.mLogManager = new LogManager(this.mConfiguration);
            lCFAMap = FShell3.getCFAMap(pSourceFileName, this.mConfiguration, this.mLogManager);
            lMainFunction = lCFAMap.get(pEntryFunction);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.mCoverageSpecificationTranslator = new CoverageSpecificationTranslator(lMainFunction);
        this.mWrapper = new Wrapper((FunctionDefinitionNode)lMainFunction, lCFAMap, this.mLogManager);
        try {
            this.mWrapper.toDot("output/wrapper.dot");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mAlphaLabel = new GuardedEdgeLabel(new ECPEdgeSet(this.mWrapper.getAlphaEdge()));
        this.mInverseAlphaLabel = new InverseGuardedEdgeLabel(this.mAlphaLabel);
        this.mOmegaLabel = new GuardedEdgeLabel(new ECPEdgeSet(this.mWrapper.getOmegaEdge()));
        try {
            this.mLocationCPA = (LocationCPA)LocationCPA.factory().createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        CPAFactory lCallStackCPAFactory = CallstackCPA.factory();
        try {
            this.mCallStackCPA = (CallstackCPA)lCallStackCPAFactory.createInstance();
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        this.mAssumeCPA = AssumeCPA.getCBMCAssume();
        this.mCFAPathCPA = CFAPathCPA.getInstance();
    }

    @Override
    public void checkCoverage(String pFQLSpecification, Collection<TestCase> pTestSuite, boolean pPedantic) {
        FQLSpecification lFQLSpecification;
        try {
            lFQLSpecification = FQLSpecification.parse(pFQLSpecification);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.checkCoverage(lFQLSpecification, pTestSuite, pPedantic);
    }

    private void checkCoverage(FQLSpecification pFQLSpecification, Collection<TestCase> pTestSuite, boolean pPedantic) {
        FQLSpecification lIdStarFQLSpecification;
        GuardedEdgeAutomatonCPA lPassingCPA = null;
        if (pFQLSpecification.hasPassingClause()) {
            ElementaryCoveragePattern lPassingClause = this.mCoverageSpecificationTranslator.mPathPatternTranslator.translate(pFQLSpecification.getPathPattern());
            NondeterministicFiniteAutomaton<GuardedEdgeLabel> lAutomaton = ToGuardedAutomatonTranslator.toAutomaton(lPassingClause, this.mAlphaLabel, this.mInverseAlphaLabel, this.mOmegaLabel);
            lPassingCPA = new GuardedEdgeAutomatonCPA(lAutomaton);
        }
        IncrementalCoverageSpecificationTranslator lTranslator = new IncrementalCoverageSpecificationTranslator(this.mCoverageSpecificationTranslator.mPathPatternTranslator);
        int lNumberOfTestGoals = lTranslator.getNumberOfTestGoals(pFQLSpecification.getCoverageSpecification());
        System.out.println("Number of test goals: " + lNumberOfTestGoals);
        Iterator<ElementaryCoveragePattern> lGoalIterator = lTranslator.translate(pFQLSpecification.getCoverageSpecification());
        int lIndex = 0;
        int lNumberOfCoveredTestGoals = 0;
        HashMap<TestCase, CFAEdge[]> mPathCache = new HashMap<TestCase, CFAEdge[]>();
        try {
            lIdStarFQLSpecification = FQLSpecification.parse("COVER \"EDGES(ID)*\" PASSING EDGES(ID)*");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        ElementaryCoveragePattern lIdStarPattern = this.mCoverageSpecificationTranslator.mPathPatternTranslator.translate(lIdStarFQLSpecification.getPathPattern());
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lAutomaton = ToGuardedAutomatonTranslator.toAutomaton(lIdStarPattern, this.mAlphaLabel, this.mInverseAlphaLabel, this.mOmegaLabel);
        GuardedEdgeAutomatonCPA lIdStarCPA = new GuardedEdgeAutomatonCPA(lAutomaton);
        while (lGoalIterator.hasNext()) {
            ElementaryCoveragePattern lGoalPattern = lGoalIterator.next();
            System.out.println("Processing test goal #" + ++lIndex + " of " + lNumberOfTestGoals + " test goals.");
            Goal lGoal = new Goal(lGoalPattern, this.mAlphaLabel, this.mInverseAlphaLabel, this.mOmegaLabel);
            GuardedEdgeAutomatonCPA lAutomatonCPA = new GuardedEdgeAutomatonCPA(lGoal.getAutomaton());
            boolean lIsCovered = false;
            for (TestCase lTestCase : pTestSuite) {
                ThreeValuedAnswer lCoverageAnswer;
                if (!lTestCase.isPrecise()) {
                    throw new RuntimeException();
                }
                CFAEdge[] lCFAPath = (CFAEdge[])mPathCache.get(lTestCase);
                boolean lIsPrecise = true;
                if (lCFAPath == null) {
                    block17: {
                        try {
                            lCFAPath = this.reconstructPath(lTestCase, this.mWrapper.getEntry(), lIdStarCPA, null, this.mWrapper.getOmegaEdge().getSuccessor());
                        }
                        catch (InvalidConfigurationException e) {
                            throw new RuntimeException(e);
                        }
                        catch (CPAException e) {
                            throw new RuntimeException(e);
                        }
                        catch (ImpreciseExecutionException e) {
                            lIsPrecise = false;
                            lTestCase = e.getTestCase();
                            if (!pPedantic) break block17;
                            throw new RuntimeException(e);
                        }
                    }
                    if (lIsPrecise) {
                        mPathCache.put(lTestCase, lCFAPath);
                    }
                }
                if ((lCoverageAnswer = FShell3.accepts(lGoal.getAutomaton(), lCFAPath)).equals((Object)ThreeValuedAnswer.ACCEPT)) {
                    lIsCovered = true;
                    break;
                }
                if (!lCoverageAnswer.equals((Object)ThreeValuedAnswer.UNKNOWN)) continue;
                try {
                    if (!this.checkCoverage(lTestCase, this.mWrapper.getEntry(), lAutomatonCPA, lPassingCPA, this.mWrapper.getOmegaEdge().getSuccessor())) continue;
                    lIsCovered = true;
                    break;
                }
                catch (InvalidConfigurationException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                catch (CPAException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                catch (ImpreciseExecutionException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            if (!lIsCovered) continue;
            System.out.println("COVERED");
            ++lNumberOfCoveredTestGoals;
        }
        System.out.println("Coverage: " + (double)lNumberOfCoveredTestGoals / (double)lIndex);
    }

    private boolean checkCoverage(TestCase pTestCase, CFAFunctionDefinitionNode pEntry, GuardedEdgeAutomatonCPA pCoverAutomatonCPA, GuardedEdgeAutomatonCPA pPassingAutomatonCPA, CFANode pEndNode) throws InvalidConfigurationException, CPAException, ImpreciseExecutionException {
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (pPassingAutomatonCPA != null) {
            lAutomatonCPAs.add(pPassingAutomatonCPA);
        }
        lAutomatonCPAs.add(pCoverAutomatonCPA);
        int lProductAutomatonCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(ProductAutomatonCPA.create(lAutomatonCPAs, false));
        lComponentAnalyses.add(this.mCallStackCPA);
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(pTestCase.getInputs());
        lComponentAnalyses.add(lInterpreterCPA);
        lComponentAnalyses.add(this.mAssumeCPA);
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(this.mConfiguration);
        lCPAFactory.setLogger(this.mLogManager);
        ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, this.mLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(pEntry);
        Precision lInitialPrecision = lCPA.getInitialPrecision(pEntry);
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        CompositeElement lEndNode = (CompositeElement)lReachedSet.getLastElement();
        if (lEndNode == null) {
            return false;
        }
        if (((LocationElement)lEndNode.get(0)).getLocationNode().equals(pEndNode)) {
            AbstractElement lProductAutomatonElement = lEndNode.get(lProductAutomatonCPAIndex);
            if (lProductAutomatonElement instanceof Targetable) {
                Targetable lTargetable = (Targetable)((Object)lProductAutomatonElement);
                return lTargetable.isTarget();
            }
            return false;
        }
        return false;
    }

    private CFAEdge[] reconstructPath(TestCase pTestCase, CFAFunctionDefinitionNode pEntry, GuardedEdgeAutomatonCPA pCoverAutomatonCPA, GuardedEdgeAutomatonCPA pPassingAutomatonCPA, CFANode pEndNode) throws InvalidConfigurationException, CPAException, ImpreciseExecutionException {
        LinkedList<ConfigurableProgramAnalysis> lComponentAnalyses = new LinkedList<ConfigurableProgramAnalysis>();
        lComponentAnalyses.add(this.mLocationCPA);
        ArrayList<ConfigurableProgramAnalysis> lAutomatonCPAs = new ArrayList<ConfigurableProgramAnalysis>(2);
        if (pPassingAutomatonCPA != null) {
            lAutomatonCPAs.add(pPassingAutomatonCPA);
        }
        lAutomatonCPAs.add(pCoverAutomatonCPA);
        int lProductAutomatonCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(ProductAutomatonCPA.create(lAutomatonCPAs, false));
        lComponentAnalyses.add(this.mCallStackCPA);
        InterpreterCPA lInterpreterCPA = new InterpreterCPA(pTestCase.getInputs());
        lComponentAnalyses.add(lInterpreterCPA);
        int lCFAPathCPAIndex = lComponentAnalyses.size();
        lComponentAnalyses.add(this.mCFAPathCPA);
        lComponentAnalyses.add(this.mAssumeCPA);
        CPAFactory lCPAFactory = CompositeCPA.factory();
        lCPAFactory.setChildren(lComponentAnalyses);
        lCPAFactory.setConfiguration(this.mConfiguration);
        lCPAFactory.setLogger(this.mLogManager);
        ConfigurableProgramAnalysis lCPA = lCPAFactory.createInstance();
        CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCPA, this.mLogManager);
        AbstractElement lInitialElement = lCPA.getInitialElement(pEntry);
        Precision lInitialPrecision = lCPA.getInitialPrecision(pEntry);
        PartitionedReachedSet lReachedSet = new PartitionedReachedSet(Waitlist.TraversalMethod.TOPSORT);
        lReachedSet.add(lInitialElement, lInitialPrecision);
        try {
            lAlgorithm.run(lReachedSet);
        }
        catch (CPAException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        CompositeElement lEndNode = (CompositeElement)lReachedSet.getLastElement();
        if (lEndNode == null) {
            throw new ImpreciseExecutionException(pTestCase, pCoverAutomatonCPA, pPassingAutomatonCPA);
        }
        if (!((LocationElement)lEndNode.get(0)).getLocationNode().equals(pEndNode)) {
            throw new ImpreciseExecutionException(pTestCase, pCoverAutomatonCPA, pPassingAutomatonCPA);
        }
        AbstractElement lProductAutomatonElement = lEndNode.get(lProductAutomatonCPAIndex);
        if (!(lProductAutomatonElement instanceof Targetable)) {
            throw new RuntimeException();
        }
        Targetable lTargetable = (Targetable)((Object)lProductAutomatonElement);
        if (!lTargetable.isTarget()) {
            throw new RuntimeException();
        }
        CFAPathStandardElement lPathElement = (CFAPathStandardElement)lEndNode.get(lCFAPathCPAIndex);
        return lPathElement.toArray();
    }
}

