/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.cfa;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.CFASecondPassBuilder;
import org.sosy_lab.cpachecker.cfa.CFATopologicalSort;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.exceptions.ParserException;

class TranslationUnit {
    private final Map<String, CFAFunctionDefinitionNode> mCFAs = new HashMap<String, CFAFunctionDefinitionNode>();
    private final List<Pair<IASTDeclaration, String>> mGlobalDeclarations = Lists.newLinkedList();

    public TranslationUnit() {
    }

    private TranslationUnit(Map<String, CFAFunctionDefinitionNode> pCFAs, List<Pair<IASTDeclaration, String>> pGlobalDeclarations) {
        assert (pCFAs != null);
        this.mCFAs.putAll(pCFAs);
        this.mGlobalDeclarations.addAll(pGlobalDeclarations);
    }

    public void add(TranslationUnit pTranslationUnit) {
        this.add(pTranslationUnit.mCFAs);
        this.mGlobalDeclarations.addAll(pTranslationUnit.mGlobalDeclarations);
    }

    public void add(Map<String, CFAFunctionDefinitionNode> pCFAs) {
        if (pCFAs == null) {
            throw new IllegalArgumentException();
        }
        for (String lFunctionName : pCFAs.keySet()) {
            if (!this.mCFAs.containsKey(lFunctionName)) continue;
            throw new IllegalArgumentException("Function " + lFunctionName + " is already defined!");
        }
        this.mCFAs.putAll(pCFAs);
    }

    public CFAFunctionDefinitionNode getFunction(String pFunctionName) {
        if (!this.mCFAs.containsKey(pFunctionName)) {
            throw new IllegalArgumentException("Function " + pFunctionName + " not present!");
        }
        return this.mCFAs.get(pFunctionName);
    }

    public Iterable<String> functionNames() {
        return this.mCFAs.keySet();
    }

    public List<Pair<IASTDeclaration, String>> getGlobalDeclarations() {
        return this.mGlobalDeclarations;
    }

    public static TranslationUnit parseString(String pSource, LogManager pLogManager) {
        ParseResult c;
        try {
            CParser parser = CParser.Factory.getParser(pLogManager, CParser.Factory.getDefaultOptions());
            c = parser.parseString(pSource);
        }
        catch (ParserException e) {
            throw new RuntimeException("Error during parsing C code \"" + pSource + "\": " + e.getMessage());
        }
        Map<String, CFAFunctionDefinitionNode> cfas = c.getFunctions();
        for (CFAFunctionDefinitionNode cfa : cfas.values()) {
            CFATopologicalSort topSort = new CFATopologicalSort();
            topSort.topologicalSort(cfa);
        }
        TranslationUnit lTranslationUnit = new TranslationUnit(cfas, c.getGlobalDeclarations());
        return lTranslationUnit;
    }

    public void insertCallEdgesRecursively(String pEntryFunction) {
        CFASecondPassBuilder lBuilder = new CFASecondPassBuilder(this.mCFAs);
        try {
            lBuilder.insertCallEdgesRecursively();
        }
        catch (ParserException e) {
            throw new RuntimeException("Error during parsing C code \"" + pEntryFunction + "\": " + e.getMessage());
        }
    }

    public void toDot(String pFunction, File pFile) throws IOException {
        CFAFunctionDefinitionNode lEntry = this.getFunction(pFunction);
        Files.writeFile((File)pFile, (Object)DOTBuilder.generateDOT(this.mCFAs.values(), lEntry));
    }
}

